/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;

public class TypeScriptInversifyClientCodegen
extends AbstractTypeScriptClientCodegen {
    private static final SimpleDateFormat SNAPSHOT_SUFFIX_FORMAT = new SimpleDateFormat("yyyyMMddHHmm", Locale.ROOT);
    private static final String X_DISCRIMINATOR_TYPE = "x-discriminator-value";
    public static final String NPM_NAME = "npmName";
    public static final String NPM_VERSION = "npmVersion";
    public static final String NPM_REPOSITORY = "npmRepository";
    public static final String SNAPSHOT = "snapshot";
    public static final String WITH_INTERFACES = "withInterfaces";
    public static final String USE_PROMISE = "usePromise";
    public static final String TAGGED_UNIONS = "taggedUnions";
    protected String npmVersion = null;
    protected String npmName = null;
    protected String npmRepository = null;
    private boolean taggedUnions = false;

    public TypeScriptInversifyClientCodegen() {
        this.outputFolder = "generated-code/typescript-inversify";
        this.templateDir = "typescript-inversify";
        this.embeddedTemplateDir = "typescript-inversify";
        this.modelTemplateFiles.put("model.mustache", ".ts");
        this.apiTemplateFiles.put("api.service.mustache", ".ts");
        this.languageSpecificPrimitives.add("Blob");
        this.typeMapping.put("file", "Blob");
        this.apiPackage = "api";
        this.modelPackage = "model";
        this.cliOptions.add(new CliOption(NPM_NAME, "The name under which you want to publish generated npm package"));
        this.cliOptions.add(new CliOption(NPM_VERSION, "The version of your npm package"));
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
        this.cliOptions.add(new CliOption(SNAPSHOT, "When setting this property to true the version will be suffixed with -SNAPSHOT.yyyyMMddHHmm", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(WITH_INTERFACES, "Setting this property to true will generate interfaces next to the default class implementations.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(USE_PROMISE, "Setting this property to use promise instead of observable inside every service.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(TAGGED_UNIONS, "Use discriminators to create tagged unions instead of extending interfaces.", "boolean").defaultValue(Boolean.FALSE.toString()));
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        codegenModel.additionalPropertiesType = this.getTypeDeclaration(ModelUtils.getAdditionalProperties(schema));
        this.addImport(codegenModel, codegenModel.additionalPropertiesType);
    }

    @Override
    public String getName() {
        return "typescript-inversify";
    }

    @Override
    public String getHelp() {
        return "Generates Typescript services using Inversify IOC";
    }

    @Override
    public void processOpts() {
        boolean withInterfaces;
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("IHttpClient.mustache", this.getIndexDirectory(), "IHttpClient.ts"));
        this.supportingFiles.add(new SupportingFile("IAPIConfiguration.mustache", this.getIndexDirectory(), "IAPIConfiguration.ts"));
        this.supportingFiles.add(new SupportingFile("HttpClient.mustache", this.getIndexDirectory(), "HttpClient.ts"));
        this.supportingFiles.add(new SupportingFile("HttpResponse.mustache", this.getIndexDirectory(), "HttpResponse.ts"));
        this.supportingFiles.add(new SupportingFile("Headers.mustache", this.getIndexDirectory(), "Headers.ts"));
        this.supportingFiles.add(new SupportingFile("ApiServiceBinder.mustache", this.getIndexDirectory(), "ApiServiceBinder.ts"));
        this.supportingFiles.add(new SupportingFile("variables.mustache", this.getIndexDirectory(), "variables.ts"));
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.addNpmPackageGeneration();
        }
        if (this.additionalProperties.containsKey(WITH_INTERFACES) && (withInterfaces = Boolean.parseBoolean(this.additionalProperties.get(WITH_INTERFACES).toString()))) {
            this.apiTemplateFiles.put("apiInterface.mustache", "Interface.ts");
        }
        if (this.additionalProperties.containsKey(TAGGED_UNIONS)) {
            this.taggedUnions = Boolean.parseBoolean(this.additionalProperties.get(TAGGED_UNIONS).toString());
        }
    }

    private void addNpmPackageGeneration() {
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.setNpmName(this.additionalProperties.get(NPM_NAME).toString());
        }
        if (this.additionalProperties.containsKey(NPM_VERSION)) {
            this.setNpmVersion(this.additionalProperties.get(NPM_VERSION).toString());
        }
        if (this.additionalProperties.containsKey(SNAPSHOT) && Boolean.valueOf(this.additionalProperties.get(SNAPSHOT).toString()).booleanValue()) {
            this.setNpmVersion(this.npmVersion + "-SNAPSHOT." + SNAPSHOT_SUFFIX_FORMAT.format(new Date()));
        }
        this.additionalProperties.put(NPM_VERSION, this.npmVersion);
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
        this.supportingFiles.add(new SupportingFile("models.mustache", this.modelPackage().replace('.', File.separatorChar), "models.ts"));
        this.supportingFiles.add(new SupportingFile("apis.mustache", this.apiPackage().replace('.', File.separatorChar), "api.ts"));
        this.supportingFiles.add(new SupportingFile("index.mustache", this.getIndexDirectory(), "index.ts"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("README.mustache", this.getIndexDirectory(), "README.md"));
        this.supportingFiles.add(new SupportingFile("package.mustache", this.getIndexDirectory(), "package.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.mustache", this.getIndexDirectory(), "tsconfig.json"));
    }

    private String getIndexDirectory() {
        String indexPackage = this.modelPackage.substring(0, Math.max(0, this.modelPackage.lastIndexOf(46)));
        return indexPackage.replace('.', File.separatorChar);
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return dataType != null && dataType.equals("Blob");
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (p instanceof FileSchema || p instanceof BinarySchema) {
            return "Blob";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        if (this.isLanguagePrimitive(openAPIType) || this.isLanguageGenericType(openAPIType)) {
            return openAPIType;
        }
        this.applyLocalTypeMapping(openAPIType);
        return openAPIType;
    }

    private String applyLocalTypeMapping(String type) {
        if (this.typeMapping.containsKey(type)) {
            type = (String)this.typeMapping.get(type);
        }
        return type;
    }

    private boolean isLanguagePrimitive(String type) {
        return this.languageSpecificPrimitives.contains(type);
    }

    private boolean isLanguageGenericType(String type) {
        for (String genericType : this.languageGenericTypes) {
            if (!type.startsWith(genericType + "<")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        parameter.dataType = this.applyLocalTypeMapping(parameter.dataType);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> operations, List<Object> allModels) {
        Map objs = (Map)operations.get("operations");
        objs.put("apiFilename", this.getApiFilenameFromClassname(objs.get("classname").toString()));
        List ops = (List)objs.get("operation");
        for (CodegenOperation op : ops) {
            StringBuilder pathBuffer = new StringBuilder();
            StringBuilder parameterName = new StringBuilder();
            int insideCurly = 0;
            op.httpMethod = op.httpMethod.toLowerCase(Locale.ROOT);
            block5: for (int i = 0; i < op.path.length(); ++i) {
                switch (op.path.charAt(i)) {
                    case '{': {
                        ++insideCurly;
                        pathBuffer.append("${encodeURIComponent(String(");
                        continue block5;
                    }
                    case '}': {
                        --insideCurly;
                        pathBuffer.append(this.toVarName(parameterName.toString()));
                        pathBuffer.append("))}");
                        parameterName.setLength(0);
                        continue block5;
                    }
                    default: {
                        if (insideCurly > 0) {
                            parameterName.append(op.path.charAt(i));
                            continue block5;
                        }
                        pathBuffer.append(op.path.charAt(i));
                    }
                }
            }
            op.path = pathBuffer.toString();
        }
        List imports = (List)operations.get("imports");
        for (Map im : imports) {
            im.put("filename", im.get("import"));
            im.put("classname", this.getModelnameFromModelFilename(im.get("filename").toString()));
        }
        return operations;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        Map<String, Object> result = super.postProcessModels(objs);
        return this.postProcessModelsEnum(result);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> result = super.postProcessAllModels(objs);
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                if (this.taggedUnions) {
                    mo.put(TAGGED_UNIONS, true);
                    if (cm.discriminator != null && cm.children != null) {
                        for (CodegenModel child : cm.children) {
                            cm.imports.add(child.classname);
                        }
                    }
                    if (cm.parent != null) {
                        cm.imports.remove(cm.parent);
                    }
                }
                mo.put("tsImports", this.toTsImports(cm, cm.imports));
            }
        }
        return result;
    }

    private List<Map<String, String>> toTsImports(CodegenModel cm, Set<String> imports) {
        ArrayList<Map<String, String>> tsImports = new ArrayList<Map<String, String>>();
        for (String im : imports) {
            if (im.equals(cm.classname)) continue;
            HashMap<String, String> tsImport = new HashMap<String, String>();
            tsImport.put("classname", im);
            tsImport.put("filename", this.toModelFilename(im));
            tsImports.add(tsImport);
        }
        return tsImports;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultService";
        }
        return this.initialCaps(name) + "Service";
    }

    @Override
    public String toApiFilename(String name) {
        if (name.length() == 0) {
            return "default.service";
        }
        return StringUtils.camelize(name, true) + ".service";
    }

    @Override
    public String toApiImport(String name) {
        return this.apiPackage() + "/" + this.toApiFilename(name);
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.camelize(this.toModelName(name), true);
    }

    @Override
    public String toModelImport(String name) {
        return this.modelPackage() + "/" + this.toModelFilename(name);
    }

    public String getNpmName() {
        return this.npmName;
    }

    public void setNpmName(String npmName) {
        this.npmName = npmName;
    }

    public String getNpmVersion() {
        return this.npmVersion;
    }

    public void setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }

    private String getApiFilenameFromClassname(String classname) {
        String name = classname.substring(0, classname.length() - "Service".length());
        return this.toApiFilename(name);
    }

    private String getModelnameFromModelFilename(String filename) {
        String name = filename.substring((this.modelPackage() + "/").length());
        return StringUtils.camelize(name);
    }
}

