/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.SemVer;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeScriptAngularClientCodegen
extends AbstractTypeScriptClientCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeScriptAngularClientCodegen.class);
    private static final SimpleDateFormat SNAPSHOT_SUFFIX_FORMAT = new SimpleDateFormat("yyyyMMddHHmm", Locale.ROOT);
    private static final String X_DISCRIMINATOR_TYPE = "x-discriminator-value";
    private static String CLASS_NAME_SUFFIX_PATTERN = "^[a-zA-Z0-9]*$";
    private static String FILE_NAME_SUFFIX_PATTERN = "^[a-zA-Z0-9.-]*$";
    public static final String NPM_NAME = "npmName";
    public static final String NPM_VERSION = "npmVersion";
    public static final String NPM_REPOSITORY = "npmRepository";
    public static final String SNAPSHOT = "snapshot";
    public static final String WITH_INTERFACES = "withInterfaces";
    public static final String TAGGED_UNIONS = "taggedUnions";
    public static final String NG_VERSION = "ngVersion";
    public static final String PROVIDED_IN_ROOT = "providedInRoot";
    public static final String SERVICE_SUFFIX = "serviceSuffix";
    public static final String SERVICE_FILE_SUFFIX = "serviceFileSuffix";
    public static final String MODEL_SUFFIX = "modelSuffix";
    public static final String MODEL_FILE_SUFFIX = "modelFileSuffix";
    protected String npmName = null;
    protected String npmVersion = "1.0.0";
    protected String npmRepository = null;
    protected String serviceSuffix = "Service";
    protected String serviceFileSuffix = ".service";
    protected String modelSuffix = "";
    protected String modelFileSuffix = "";
    private boolean taggedUnions = false;

    public TypeScriptAngularClientCodegen() {
        this.outputFolder = "generated-code/typescript-angular";
        this.templateDir = "typescript-angular";
        this.embeddedTemplateDir = "typescript-angular";
        this.modelTemplateFiles.put("model.mustache", ".ts");
        this.apiTemplateFiles.put("api.service.mustache", ".ts");
        this.languageSpecificPrimitives.add("Blob");
        this.typeMapping.put("file", "Blob");
        this.apiPackage = "api";
        this.modelPackage = "model";
        this.cliOptions.add(new CliOption(NPM_NAME, "The name under which you want to publish generated npm package. Required to generate a full angular package"));
        this.cliOptions.add(new CliOption(NPM_VERSION, "The version of your npm package. Default is '1.0.0'"));
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
        this.cliOptions.add(new CliOption(SNAPSHOT, "When setting this property to true the version will be suffixed with -SNAPSHOT.yyyyMMddHHmm", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(WITH_INTERFACES, "Setting this property to true will generate interfaces next to the default class implementations.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(TAGGED_UNIONS, "Use discriminators to create tagged unions instead of extending interfaces.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(PROVIDED_IN_ROOT, "Use this property to provide Injectables in root (it is only valid in angular version greater or equal to 6.0.0).", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(NG_VERSION, "The version of Angular. Default is '4.3'"));
        this.cliOptions.add(new CliOption(SERVICE_SUFFIX, "The suffix of the generated service. Default is 'Service'."));
        this.cliOptions.add(new CliOption(SERVICE_FILE_SUFFIX, "The suffix of the file of the generated service (service<suffix>.ts). Default is '.service'."));
        this.cliOptions.add(new CliOption(MODEL_SUFFIX, "The suffix of the generated model. Default is ''."));
        this.cliOptions.add(new CliOption(MODEL_FILE_SUFFIX, "The suffix of the file of the generated model (model<suffix>.ts). Default is ''."));
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        codegenModel.additionalPropertiesType = this.getTypeDeclaration(ModelUtils.getAdditionalProperties(schema));
        this.addImport(codegenModel, codegenModel.additionalPropertiesType);
    }

    @Override
    public String getName() {
        return "typescript-angular";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript Angular (2.x - 5.x) client library.";
    }

    @Override
    public void processOpts() {
        boolean withInterfaces;
        SemVer ngVersion;
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("models.mustache", this.modelPackage().replace('.', File.separatorChar), "models.ts"));
        this.supportingFiles.add(new SupportingFile("apis.mustache", this.apiPackage().replace('.', File.separatorChar), "api.ts"));
        this.supportingFiles.add(new SupportingFile("index.mustache", this.getIndexDirectory(), "index.ts"));
        this.supportingFiles.add(new SupportingFile("api.module.mustache", this.getIndexDirectory(), "api.module.ts"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", this.getIndexDirectory(), "configuration.ts"));
        this.supportingFiles.add(new SupportingFile("variables.mustache", this.getIndexDirectory(), "variables.ts"));
        this.supportingFiles.add(new SupportingFile("encoder.mustache", this.getIndexDirectory(), "encoder.ts"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("README.mustache", this.getIndexDirectory(), "README.md"));
        if (this.additionalProperties.containsKey(NG_VERSION)) {
            ngVersion = new SemVer(this.additionalProperties.get(NG_VERSION).toString());
        } else {
            ngVersion = new SemVer("4.3.0");
            LOGGER.info("generating code for Angular {} ...", (Object)ngVersion);
            LOGGER.info("  (you can select the angular version by setting the additionalProperty ngVersion)");
        }
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.addNpmPackageGeneration(ngVersion);
        }
        if (this.additionalProperties.containsKey(WITH_INTERFACES) && (withInterfaces = Boolean.parseBoolean(this.additionalProperties.get(WITH_INTERFACES).toString()))) {
            this.apiTemplateFiles.put("apiInterface.mustache", "Interface.ts");
        }
        if (this.additionalProperties.containsKey(TAGGED_UNIONS)) {
            this.taggedUnions = Boolean.parseBoolean(this.additionalProperties.get(TAGGED_UNIONS).toString());
        }
        if (ngVersion.atLeast("6.0.0")) {
            if (!this.additionalProperties.containsKey(PROVIDED_IN_ROOT)) {
                this.additionalProperties.put(PROVIDED_IN_ROOT, true);
            } else {
                this.additionalProperties.put(PROVIDED_IN_ROOT, Boolean.valueOf((String)this.additionalProperties.get(PROVIDED_IN_ROOT)));
            }
        } else {
            this.additionalProperties.put(PROVIDED_IN_ROOT, false);
        }
        this.additionalProperties.put(NG_VERSION, ngVersion);
        this.additionalProperties.put("injectionToken", ngVersion.atLeast("4.0.0") ? "InjectionToken" : "OpaqueToken");
        this.additionalProperties.put("injectionTokenTyped", ngVersion.atLeast("4.0.0"));
        this.additionalProperties.put("useHttpClient", ngVersion.atLeast("4.3.0"));
        this.additionalProperties.put("useRxJS6", ngVersion.atLeast("6.0.0"));
        if (!ngVersion.atLeast("4.3.0")) {
            this.supportingFiles.add(new SupportingFile("rxjs-operators.mustache", this.getIndexDirectory(), "rxjs-operators.ts"));
        }
        if (this.additionalProperties.containsKey(SERVICE_SUFFIX)) {
            this.serviceSuffix = this.additionalProperties.get(SERVICE_SUFFIX).toString();
            this.validateClassSuffixArgument("Service", this.serviceSuffix);
        }
        if (this.additionalProperties.containsKey(SERVICE_FILE_SUFFIX)) {
            this.serviceFileSuffix = this.additionalProperties.get(SERVICE_FILE_SUFFIX).toString();
            this.validateFileSuffixArgument("Service", this.serviceFileSuffix);
        }
        if (this.additionalProperties.containsKey(MODEL_SUFFIX)) {
            this.modelSuffix = this.additionalProperties.get(MODEL_SUFFIX).toString();
            this.validateClassSuffixArgument("Model", this.modelSuffix);
        }
        if (this.additionalProperties.containsKey(MODEL_FILE_SUFFIX)) {
            this.modelFileSuffix = this.additionalProperties.get(MODEL_FILE_SUFFIX).toString();
            this.validateFileSuffixArgument("Model", this.modelFileSuffix);
        }
    }

    private void addNpmPackageGeneration(SemVer ngVersion) {
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.setNpmName(this.additionalProperties.get(NPM_NAME).toString());
        }
        if (this.additionalProperties.containsKey(NPM_VERSION)) {
            this.setNpmVersion(this.additionalProperties.get(NPM_VERSION).toString());
        }
        if (this.additionalProperties.containsKey(SNAPSHOT) && Boolean.valueOf(this.additionalProperties.get(SNAPSHOT).toString()).booleanValue()) {
            this.setNpmVersion(this.npmVersion + "-SNAPSHOT." + SNAPSHOT_SUFFIX_FORMAT.format(new Date()));
        }
        this.additionalProperties.put(NPM_VERSION, this.npmVersion);
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
        if (!ngVersion.atLeast("4.0.0")) {
            LOGGER.warn("Please update your legacy Angular " + ngVersion + " project to benefit from 'Angular Package Format' support.");
            this.additionalProperties.put("useNgPackagr", false);
        } else {
            this.additionalProperties.put("useNgPackagr", true);
            this.supportingFiles.add(new SupportingFile("ng-package.mustache", this.getIndexDirectory(), "ng-package.json"));
        }
        this.additionalProperties.put("useOldNgPackagr", !ngVersion.atLeast("5.0.0"));
        this.supportingFiles.add(new SupportingFile("package.mustache", this.getIndexDirectory(), "package.json"));
        this.supportingFiles.add(new SupportingFile("typings.mustache", this.getIndexDirectory(), "typings.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.mustache", this.getIndexDirectory(), "tsconfig.json"));
    }

    private String getIndexDirectory() {
        String indexPackage = this.modelPackage.substring(0, Math.max(0, this.modelPackage.lastIndexOf(46)));
        return indexPackage.replace('.', File.separatorChar);
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return dataType != null && dataType.equals("Blob");
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isFileSchema(p)) {
            return "Blob";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        if (this.isLanguagePrimitive(openAPIType) || this.isLanguageGenericType(openAPIType)) {
            return openAPIType;
        }
        this.applyLocalTypeMapping(openAPIType);
        return openAPIType;
    }

    private String applyLocalTypeMapping(String type) {
        if (this.typeMapping.containsKey(type)) {
            type = (String)this.typeMapping.get(type);
        }
        return type;
    }

    private boolean isLanguagePrimitive(String type) {
        return this.languageSpecificPrimitives.contains(type);
    }

    private boolean isLanguageGenericType(String type) {
        for (String genericType : this.languageGenericTypes) {
            if (!type.startsWith(genericType + "<")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        parameter.dataType = this.applyLocalTypeMapping(parameter.dataType);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> operations, List<Object> allModels) {
        Map objs = (Map)operations.get("operations");
        objs.put("apiFilename", this.getApiFilenameFromClassname(objs.get("classname").toString()));
        List ops = (List)objs.get("operation");
        for (CodegenOperation op : ops) {
            if (((Boolean)this.additionalProperties.get("useHttpClient")).booleanValue()) {
                op.httpMethod = op.httpMethod.toLowerCase(Locale.ENGLISH);
            } else {
                switch (op.httpMethod) {
                    case "GET": {
                        op.httpMethod = "RequestMethod.Get";
                        break;
                    }
                    case "POST": {
                        op.httpMethod = "RequestMethod.Post";
                        break;
                    }
                    case "PUT": {
                        op.httpMethod = "RequestMethod.Put";
                        break;
                    }
                    case "DELETE": {
                        op.httpMethod = "RequestMethod.Delete";
                        break;
                    }
                    case "OPTIONS": {
                        op.httpMethod = "RequestMethod.Options";
                        break;
                    }
                    case "HEAD": {
                        op.httpMethod = "RequestMethod.Head";
                        break;
                    }
                    case "PATCH": {
                        op.httpMethod = "RequestMethod.Patch";
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown HTTP Method " + op.httpMethod + " not allowed");
                    }
                }
            }
            StringBuilder pathBuffer = new StringBuilder();
            StringBuilder parameterName = new StringBuilder();
            int insideCurly = 0;
            block23: for (int i = 0; i < op.path.length(); ++i) {
                switch (op.path.charAt(i)) {
                    case '{': {
                        ++insideCurly;
                        pathBuffer.append("${encodeURIComponent(String(");
                        continue block23;
                    }
                    case '}': {
                        --insideCurly;
                        CodegenParameter parameter = this.findPathParameterByName(op, parameterName.toString());
                        pathBuffer.append(this.toVarName(parameterName.toString()));
                        if (parameter != null && parameter.isDateTime) {
                            pathBuffer.append(".toISOString()");
                        }
                        pathBuffer.append("))}");
                        parameterName.setLength(0);
                        continue block23;
                    }
                    default: {
                        char nextChar = op.path.charAt(i);
                        if (insideCurly > 0) {
                            parameterName.append(nextChar);
                            continue block23;
                        }
                        pathBuffer.append(nextChar);
                    }
                }
            }
            op.path = pathBuffer.toString();
        }
        List imports = (List)operations.get("imports");
        for (Map im : imports) {
            im.put("filename", im.get("import"));
            im.put("classname", this.getModelnameFromModelFilename(im.get("filename").toString()));
        }
        return operations;
    }

    private CodegenParameter findPathParameterByName(CodegenOperation operation, String parameterName) {
        for (CodegenParameter param : operation.pathParams) {
            if (!param.baseName.equals(parameterName)) continue;
            return param;
        }
        return null;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        Map<String, Object> result = super.postProcessModels(objs);
        return this.postProcessModelsEnum(result);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> result = super.postProcessAllModels(objs);
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                if (this.taggedUnions) {
                    mo.put(TAGGED_UNIONS, true);
                    if (cm.discriminator != null && cm.children != null) {
                        for (CodegenModel child : cm.children) {
                            cm.imports.add(child.classname);
                        }
                    }
                    if (cm.parent != null) {
                        cm.imports.remove(cm.parent);
                    }
                }
                mo.put("tsImports", this.toTsImports(cm, cm.imports));
            }
        }
        return result;
    }

    private List<Map<String, String>> toTsImports(CodegenModel cm, Set<String> imports) {
        ArrayList<Map<String, String>> tsImports = new ArrayList<Map<String, String>>();
        for (String im : imports) {
            if (im.equals(cm.classname)) continue;
            HashMap<String, String> tsImport = new HashMap<String, String>();
            tsImport.put("classname", im);
            tsImport.put("filename", this.toModelFilename(this.removeModelSuffixIfNecessary(im)));
            tsImports.add(tsImport);
        }
        return tsImports;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultService";
        }
        return this.initialCaps(name) + this.serviceSuffix;
    }

    @Override
    public String toApiFilename(String name) {
        if (name.length() == 0) {
            return "default.service";
        }
        return StringUtils.camelize(this.removeModelSuffixIfNecessary(name), true) + this.serviceFileSuffix;
    }

    @Override
    public String toApiImport(String name) {
        return this.apiPackage() + "/" + this.toApiFilename(name);
    }

    @Override
    public String toModelFilename(String name) {
        String modelName = this.toModelName(name);
        return StringUtils.camelize(this.removeModelSuffixIfNecessary(modelName), true) + this.modelFileSuffix;
    }

    @Override
    public String toModelImport(String name) {
        return this.modelPackage() + "/" + this.toModelFilename(name);
    }

    public String getNpmName() {
        return this.npmName;
    }

    public void setNpmName(String npmName) {
        this.npmName = npmName;
    }

    public String getNpmVersion() {
        return this.npmVersion;
    }

    public void setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }

    private String getApiFilenameFromClassname(String classname) {
        String name = classname.substring(0, classname.length() - this.serviceSuffix.length());
        return this.toApiFilename(name);
    }

    private String getModelnameFromModelFilename(String filename) {
        String name = filename.substring((this.modelPackage() + "/").length());
        if (this.modelFileSuffix.length() > 0) {
            name = name.substring(0, name.length() - this.modelFileSuffix.length());
        }
        return StringUtils.camelize(name) + this.modelSuffix;
    }

    @Override
    public String toModelName(String name) {
        String modelName = super.toModelName(name);
        if (this.modelSuffix.length() == 0 || modelName.endsWith(this.modelSuffix)) {
            return modelName;
        }
        return modelName + this.modelSuffix;
    }

    private String removeModelSuffixIfNecessary(String name) {
        if (this.modelSuffix.length() == 0 || !name.endsWith(this.modelSuffix)) {
            return name;
        }
        return name.substring(0, name.length() - this.modelSuffix.length());
    }

    private void validateFileSuffixArgument(String argument, String value) {
        if (!value.matches(FILE_NAME_SUFFIX_PATTERN)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s file suffix only allows '.', '-' and alphanumeric characters.", argument));
        }
    }

    private void validateClassSuffixArgument(String argument, String value) {
        if (!value.matches(CLASS_NAME_SUFFIX_PATTERN)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s class suffix only allows alphanumeric characters.", argument));
        }
    }
}

