/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPhpCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpClientCodegen
extends AbstractPhpCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhpClientCodegen.class);
    public static final String COMPOSER_VENDOR_NAME = "composerVendorName";
    public static final String COMPOSER_PROJECT_NAME = "composerProjectName";
    protected String composerVendorName = null;
    protected String composerProjectName = null;

    public PhpClientCodegen() {
        this.importMapping.clear();
        this.setInvokerPackage("OpenAPI\\Client");
        this.setApiPackage(this.getInvokerPackage() + "\\" + this.apiDirName);
        this.setModelPackage(this.getInvokerPackage() + "\\" + this.modelDirName);
        this.setPackagePath("OpenAPIClient-php");
        this.supportsInheritance = true;
        this.setOutputDir("generated-code" + File.separator + "php");
        this.modelTestTemplateFiles.put("model_test.mustache", ".php");
        this.templateDir = "php";
        this.embeddedTemplateDir = "php";
        this.hideGenerationTimestamp = Boolean.TRUE;
        ArrayList sortedLanguageSpecificPrimitives = new ArrayList(this.languageSpecificPrimitives);
        Collections.sort(sortedLanguageSpecificPrimitives);
        String primitives = "'" + StringUtils.join(sortedLanguageSpecificPrimitives, (String)"', '") + "'";
        this.additionalProperties.put("primitives", primitives);
        this.cliOptions.add(new CliOption(COMPOSER_VENDOR_NAME, "The vendor name used in the composer package name. The template uses {{composerVendorName}}/{{composerProjectName}} for the composer package name. e.g. yaypets. IMPORTANT NOTE (2016/03): composerVendorName will be deprecated and replaced by gitUserId in the next openapi-generator release"));
        this.cliOptions.add(new CliOption(COMPOSER_PROJECT_NAME, "The project name used in the composer package name. The template uses {{composerVendorName}}/{{composerProjectName}} for the composer package name. e.g. petstore-client. IMPORTANT NOTE (2016/03): composerProjectName will be deprecated and replaced by gitRepoId in the next openapi-generator release"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "boolean, toggles whether unicode identifiers are allowed in names or not, default is false").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "php";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP client library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(COMPOSER_PROJECT_NAME)) {
            this.setComposerProjectName((String)this.additionalProperties.get(COMPOSER_PROJECT_NAME));
        } else {
            this.additionalProperties.put(COMPOSER_PROJECT_NAME, this.composerProjectName);
        }
        if (this.additionalProperties.containsKey(COMPOSER_VENDOR_NAME)) {
            this.setComposerVendorName((String)this.additionalProperties.get(COMPOSER_VENDOR_NAME));
        } else {
            this.additionalProperties.put(COMPOSER_VENDOR_NAME, this.composerVendorName);
        }
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", this.toPackagePath(this.invokerPackage, this.srcBasePath), "ApiException.php"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", this.toPackagePath(this.invokerPackage, this.srcBasePath), "Configuration.php"));
        this.supportingFiles.add(new SupportingFile("ObjectSerializer.mustache", this.toPackagePath(this.invokerPackage, this.srcBasePath), "ObjectSerializer.php"));
        this.supportingFiles.add(new SupportingFile("ModelInterface.mustache", this.toPackagePath(this.modelPackage, this.srcBasePath), "ModelInterface.php"));
        this.supportingFiles.add(new SupportingFile("HeaderSelector.mustache", this.toPackagePath(this.invokerPackage, this.srcBasePath), "HeaderSelector.php"));
        this.supportingFiles.add(new SupportingFile("composer.mustache", this.getPackagePath(), "composer.json"));
        this.supportingFiles.add(new SupportingFile("README.mustache", this.getPackagePath(), "README.md"));
        this.supportingFiles.add(new SupportingFile("phpunit.xml.mustache", this.getPackagePath(), "phpunit.xml.dist"));
        this.supportingFiles.add(new SupportingFile(".travis.yml", this.getPackagePath(), ".travis.yml"));
        this.supportingFiles.add(new SupportingFile(".php_cs", this.getPackagePath(), ".php_cs"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", this.getPackagePath(), "git_push.sh"));
    }

    public void setComposerVendorName(String composerVendorName) {
        this.composerVendorName = composerVendorName;
    }

    public void setComposerProjectName(String composerProjectName) {
        this.composerProjectName = composerProjectName;
    }
}

