/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Escapers;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScalaCodegen
extends DefaultCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractScalaCodegen.class);
    protected String modelPropertyNaming = "camelCase";
    protected String invokerPackage = "org.openapitools.client";
    protected String sourceFolder = "src/main/scala";
    protected boolean stripPackageName = true;

    public AbstractScalaCodegen() {
        this.languageSpecificPrimitives.addAll(Arrays.asList("String", "boolean", "Boolean", "Double", "Int", "Long", "Float", "Object", "Any", "List", "Seq", "Map", "Array"));
        this.reservedWords.addAll(Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"));
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        if (this.additionalProperties.containsKey("stripPackageName") && "false".equalsIgnoreCase(this.additionalProperties.get("stripPackageName").toString())) {
            this.stripPackageName = false;
            this.additionalProperties.put("stripPackageName", false);
            LOGGER.warn("stripPackageName=false. Compilation errors may occur if API type names clash with types in the default imports");
        }
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "`" + name + "`";
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        Mustache.Escaper SCALA = new Mustache.Escaper(){

            public String escape(String text) {
                if (text.startsWith("`") && text.endsWith("`")) {
                    String unescaped = text.substring(1, text.length() - 1);
                    return "`" + Escapers.HTML.escape(unescaped) + "`";
                }
                return Escapers.HTML.escape(text);
            }
        };
        return compiler.withEscaper(SCALA);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = (Schema)p.getAdditionalProperties();
            return this.getSchemaType(p) + "[String, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isMapSchema(p)) {
            String inner = this.getSchemaType((Schema)p.getAdditionalProperties());
            return (String)this.instantiationTypes.get("map") + "[String, " + inner + "]";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            return (String)this.instantiationTypes.get("array") + "[" + inner + "]";
        }
        return null;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (p.getDefault() != null) {
            return p.getDefault().toString();
        }
        if (ModelUtils.isBooleanSchema(p)) {
            return null;
        }
        if (ModelUtils.isDateSchema(p)) {
            return null;
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return null;
        }
        if (ModelUtils.isNumberSchema(p)) {
            return null;
        }
        if (ModelUtils.isIntegerSchema(p)) {
            return null;
        }
        if (ModelUtils.isMapSchema(p)) {
            String inner = this.getSchemaType((Schema)p.getAdditionalProperties());
            return "new HashMap[String, " + inner + "]() ";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            return "new ListBuffer[" + inner + "]() ";
        }
        if (ModelUtils.isStringSchema(p)) {
            return null;
        }
        return null;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List imports = (List)objs.get("imports");
        String prefix = this.modelPackage() + ".";
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = (String)((Map)iterator.next()).get("import");
            if (!_import.startsWith(prefix)) continue;
            iterator.remove();
        }
        return objs;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    protected String formatIdentifier(String name, boolean capitalized) {
        String identifier = AbstractScalaCodegen.camelize(this.sanitizeName(name), true);
        if (capitalized) {
            identifier = StringUtils.capitalize((String)identifier);
        }
        if (identifier.matches("[a-zA-Z_$][\\w_$]+") && !this.isReservedWord(identifier)) {
            return identifier;
        }
        return this.escapeReservedWord(identifier);
    }

    protected String stripPackageName(String input) {
        if (!this.stripPackageName || StringUtils.isEmpty((CharSequence)input) || input.lastIndexOf(".") < 0) {
            return input;
        }
        int lastIndexOfDot = input.lastIndexOf(".");
        return input.substring(lastIndexOfDot + 1);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }
}

