/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.plugin;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.config.CodegenConfigurator;
import org.openapitools.codegen.config.CodegenConfiguratorUtils;
import org.openapitools.codegen.config.GeneratorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class CodeGenMojo
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeGenMojo.class);
    @Component
    private BuildContext buildContext = new DefaultBuildContext();
    @Parameter(name="validateSpec", required=false, defaultValue="true")
    private Boolean validateSpec;
    @Parameter(name="verbose", required=false, defaultValue="false")
    private boolean verbose;
    @Parameter(name="language")
    private String language;
    @Parameter(name="generatorName")
    private String generatorName;
    @Parameter(name="output", property="openapi.generator.maven.plugin.output", defaultValue="${project.build.directory}/generated-sources/openapi")
    private File output;
    @Parameter(name="inputSpec", required=true)
    private String inputSpec;
    @Parameter(name="gitUserId", required=false)
    private String gitUserId;
    @Parameter(name="gitRepoId", required=false)
    private String gitRepoId;
    @Parameter(name="templateDirectory")
    private File templateDirectory;
    @Parameter(name="auth")
    private String auth;
    @Parameter(name="configurationFile", required=false)
    private String configurationFile;
    @Parameter(name="skipOverwrite", required=false)
    private Boolean skipOverwrite;
    @Parameter(name="removeOperationIdPrefix", required=false)
    private Boolean removeOperationIdPrefix;
    @Parameter(name="apiPackage")
    private String apiPackage;
    @Parameter(name="modelPackage")
    private String modelPackage;
    @Parameter(name="invokerPackage")
    private String invokerPackage;
    @Parameter(name="groupId")
    private String groupId;
    @Parameter(name="artifactId")
    private String artifactId;
    @Parameter(name="artifactVersion")
    private String artifactVersion;
    @Parameter(name="library", required=false)
    private String library;
    @Parameter(name="modelNamePrefix", required=false)
    private String modelNamePrefix;
    @Parameter(name="modelNameSuffix", required=false)
    private String modelNameSuffix;
    @Parameter(name="ignoreFileOverride", required=false)
    private String ignoreFileOverride;
    @Parameter(name="configOptions")
    private Map<?, ?> configOptions;
    @Parameter(name="instantiationTypes")
    private List<String> instantiationTypes;
    @Parameter(name="importMappings")
    private List<String> importMappings;
    @Parameter(name="typeMappings")
    private List<String> typeMappings;
    @Parameter(name="languageSpecificPrimitives")
    private List<String> languageSpecificPrimitives;
    @Parameter(name="additionalProperties")
    private List<String> additionalProperties;
    @Parameter(name="reservedWordsMappings")
    private List<String> reservedWordsMappings;
    @Parameter(name="generateApis", required=false)
    private Boolean generateApis = true;
    @Parameter(name="generateModels", required=false)
    private Boolean generateModels = true;
    @Parameter(name="modelsToGenerate", required=false)
    private String modelsToGenerate = "";
    @Parameter(name="generateSupportingFiles", required=false)
    private Boolean generateSupportingFiles = true;
    @Parameter(name="supportingFilesToGenerate", required=false)
    private String supportingFilesToGenerate = "";
    @Parameter(name="generateModelTests", required=false)
    private Boolean generateModelTests = true;
    @Parameter(name="generateModelDocumentation", required=false)
    private Boolean generateModelDocumentation = true;
    @Parameter(name="generateApiTests", required=false)
    private Boolean generateApiTests = true;
    @Parameter(name="generateApiDocumentation", required=false)
    private Boolean generateApiDocumentation = true;
    @Parameter(name="withXml", required=false)
    private Boolean withXml = false;
    @Parameter(name="skip", property="codegen.skip", required=false, defaultValue="false")
    private Boolean skip;
    @Parameter(name="skipIfSpecIsUnchanged", property="codegen.skipIfSpecIsUnchanged", required=false, defaultValue="false")
    private Boolean skipIfSpecIsUnchanged;
    @Parameter(defaultValue="true")
    private boolean addCompileSourceRoot = true;
    @Parameter
    protected Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> originalEnvironmentVariables = new HashMap<String, String>();
    @Parameter
    private boolean configHelp = false;
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject project;

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void execute() throws MojoExecutionException {
        File inputSpecFile = new File(this.inputSpec);
        this.addCompileSourceRootIfConfigured();
        try {
            String storedInputSpecHash;
            Object inputSpecHash;
            File storedInputSpecHashFile;
            if (this.skip.booleanValue()) {
                this.getLog().info((CharSequence)"Code generation is skipped.");
                return;
            }
            if (this.buildContext != null && this.buildContext.isIncremental() && this.inputSpec != null && inputSpecFile.exists() && !this.buildContext.hasDelta(inputSpecFile)) {
                this.getLog().info((CharSequence)"Code generation is skipped in delta-build because source-json was not modified.");
                return;
            }
            if (this.skipIfSpecIsUnchanged.booleanValue() && inputSpecFile.exists() && (storedInputSpecHashFile = this.getHashFile(inputSpecFile)).exists() && ((String)(inputSpecHash = Files.asByteSource((File)inputSpecFile).hash(Hashing.sha256()).toString())).equals(storedInputSpecHash = Files.asCharSource((File)storedInputSpecHashFile, (Charset)Charsets.UTF_8).read())) {
                this.getLog().info((CharSequence)"Code generation is skipped because input was unchanged");
                return;
            }
            CodegenConfigurator configurator = CodegenConfigurator.fromFile((String)this.configurationFile);
            if (configurator == null) {
                configurator = new CodegenConfigurator();
            }
            configurator.setVerbose(this.verbose);
            if (this.validateSpec != null) {
                configurator.setValidateSpec(this.validateSpec.booleanValue());
            }
            if (this.skipOverwrite != null) {
                configurator.setSkipOverwrite(this.skipOverwrite.booleanValue());
            }
            if (this.removeOperationIdPrefix != null) {
                configurator.setRemoveOperationIdPrefix(this.removeOperationIdPrefix.booleanValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.inputSpec)) {
                configurator.setInputSpec(this.inputSpec);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.gitUserId)) {
                configurator.setGitUserId(this.gitUserId);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.gitRepoId)) {
                configurator.setGitRepoId(this.gitRepoId);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.ignoreFileOverride)) {
                configurator.setIgnoreFileOverride(this.ignoreFileOverride);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.generatorName)) {
                configurator.setGeneratorName(this.generatorName);
                if (StringUtils.isNotEmpty((CharSequence)this.language)) {
                    LOGGER.warn("The 'language' option is deprecated and was replaced by 'generatorName'. Both can not be set together");
                    throw new MojoExecutionException("Illegal configuration: 'language' and  'generatorName' can not be set both, remove 'language' from your configuration");
                }
            } else if (StringUtils.isNotEmpty((CharSequence)this.language)) {
                LOGGER.warn("The 'language' option is deprecated and may reference language names only in the next major release (4.0). Please use 'generatorName' instead.");
                configurator.setGeneratorName(this.language);
            } else {
                LOGGER.error("A generator name (generatorName) is required.");
                throw new MojoExecutionException("The generator requires 'generatorName'. Refer to documentation for a list of options.");
            }
            configurator.setOutputDir(this.output.getAbsolutePath());
            if (StringUtils.isNotEmpty((CharSequence)this.auth)) {
                configurator.setAuth(this.auth);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.apiPackage)) {
                configurator.setApiPackage(this.apiPackage);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.modelPackage)) {
                configurator.setModelPackage(this.modelPackage);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.invokerPackage)) {
                configurator.setInvokerPackage(this.invokerPackage);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.groupId)) {
                configurator.setGroupId(this.groupId);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.artifactId)) {
                configurator.setArtifactId(this.artifactId);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.artifactVersion)) {
                configurator.setArtifactVersion(this.artifactVersion);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.library)) {
                configurator.setLibrary(this.library);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.modelNamePrefix)) {
                configurator.setModelNamePrefix(this.modelNamePrefix);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.modelNameSuffix)) {
                configurator.setModelNameSuffix(this.modelNameSuffix);
            }
            if (null != this.templateDirectory) {
                configurator.setTemplateDir(this.templateDirectory.getAbsolutePath());
            }
            if (null != this.generateApis && this.generateApis.booleanValue()) {
                GeneratorProperties.setProperty((String)"apis", (String)"");
            } else {
                GeneratorProperties.clearProperty((String)"apis");
            }
            if (null != this.generateModels && this.generateModels.booleanValue()) {
                GeneratorProperties.setProperty((String)"models", (String)this.modelsToGenerate);
            } else {
                GeneratorProperties.clearProperty((String)"models");
            }
            if (null != this.generateSupportingFiles && this.generateSupportingFiles.booleanValue()) {
                GeneratorProperties.setProperty((String)"supportingFiles", (String)this.supportingFilesToGenerate);
            } else {
                GeneratorProperties.clearProperty((String)"supportingFiles");
            }
            GeneratorProperties.setProperty((String)"modelTests", (String)this.generateModelTests.toString());
            GeneratorProperties.setProperty((String)"modelDocs", (String)this.generateModelDocumentation.toString());
            GeneratorProperties.setProperty((String)"apiTests", (String)this.generateApiTests.toString());
            GeneratorProperties.setProperty((String)"apiDocs", (String)this.generateApiDocumentation.toString());
            GeneratorProperties.setProperty((String)"withXml", (String)this.withXml.toString());
            if (this.configOptions != null) {
                if (this.instantiationTypes == null && this.configOptions.containsKey("instantiation-types")) {
                    CodegenConfiguratorUtils.applyInstantiationTypesKvp((String)this.configOptions.get("instantiation-types").toString(), (CodegenConfigurator)configurator);
                }
                if (this.importMappings == null && this.configOptions.containsKey("import-mappings")) {
                    CodegenConfiguratorUtils.applyImportMappingsKvp((String)this.configOptions.get("import-mappings").toString(), (CodegenConfigurator)configurator);
                }
                if (this.typeMappings == null && this.configOptions.containsKey("type-mappings")) {
                    CodegenConfiguratorUtils.applyTypeMappingsKvp((String)this.configOptions.get("type-mappings").toString(), (CodegenConfigurator)configurator);
                }
                if (this.languageSpecificPrimitives == null && this.configOptions.containsKey("language-specific-primitives")) {
                    CodegenConfiguratorUtils.applyLanguageSpecificPrimitivesCsv((String)this.configOptions.get("language-specific-primitives").toString(), (CodegenConfigurator)configurator);
                }
                if (this.additionalProperties == null && this.configOptions.containsKey("additional-properties")) {
                    CodegenConfiguratorUtils.applyAdditionalPropertiesKvp((String)this.configOptions.get("additional-properties").toString(), (CodegenConfigurator)configurator);
                }
                if (this.reservedWordsMappings == null && this.configOptions.containsKey("reserved-words-mappings")) {
                    CodegenConfiguratorUtils.applyReservedWordsMappingsKvp((String)this.configOptions.get("reserved-words-mappings").toString(), (CodegenConfigurator)configurator);
                }
            }
            if (!(this.instantiationTypes == null || this.configOptions != null && this.configOptions.containsKey("instantiation-types"))) {
                CodegenConfiguratorUtils.applyInstantiationTypesKvpList(this.instantiationTypes, (CodegenConfigurator)configurator);
            }
            if (!(this.importMappings == null || this.configOptions != null && this.configOptions.containsKey("import-mappings"))) {
                CodegenConfiguratorUtils.applyImportMappingsKvpList(this.importMappings, (CodegenConfigurator)configurator);
            }
            if (!(this.typeMappings == null || this.configOptions != null && this.configOptions.containsKey("type-mappings"))) {
                CodegenConfiguratorUtils.applyTypeMappingsKvpList(this.typeMappings, (CodegenConfigurator)configurator);
            }
            if (!(this.languageSpecificPrimitives == null || this.configOptions != null && this.configOptions.containsKey("language-specific-primitives"))) {
                CodegenConfiguratorUtils.applyLanguageSpecificPrimitivesCsvList(this.languageSpecificPrimitives, (CodegenConfigurator)configurator);
            }
            if (!(this.additionalProperties == null || this.configOptions != null && this.configOptions.containsKey("additional-properties"))) {
                CodegenConfiguratorUtils.applyAdditionalPropertiesKvpList(this.additionalProperties, (CodegenConfigurator)configurator);
            }
            if (!(this.reservedWordsMappings == null || this.configOptions != null && this.configOptions.containsKey("reserved-words-mappings"))) {
                CodegenConfiguratorUtils.applyReservedWordsMappingsKvpList(this.reservedWordsMappings, (CodegenConfigurator)configurator);
            }
            if (this.environmentVariables != null) {
                for (String key : this.environmentVariables.keySet()) {
                    this.originalEnvironmentVariables.put(key, GeneratorProperties.getProperty((String)key));
                    Object value = this.environmentVariables.get(key);
                    if (value == null) {
                        value = "";
                    }
                    GeneratorProperties.setProperty((String)key, (String)value);
                    configurator.addSystemProperty(key, (String)value);
                }
            }
            ClientOptInput input = configurator.toClientOptInput();
            CodegenConfig config = input.getConfig();
            if (this.configOptions != null) {
                for (CliOption langCliOption : config.cliOptions()) {
                    if (!this.configOptions.containsKey(langCliOption.getOpt())) continue;
                    input.getConfig().additionalProperties().put(langCliOption.getOpt(), this.configOptions.get(langCliOption.getOpt()));
                }
            }
            if (this.configHelp) {
                for (CliOption langCliOption : config.cliOptions()) {
                    System.out.println("\t" + langCliOption.getOpt());
                    System.out.println("\t    " + langCliOption.getOptionHelp().replaceAll("\n", "\n\t    "));
                    System.out.println();
                }
                return;
            }
            this.adjustAdditionalProperties(config);
            new DefaultGenerator().opts(input).generate();
            if (this.buildContext != null) {
                this.buildContext.refresh(new File(this.getCompileSourceRoot()));
            }
            File storedInputSpecHashFile2 = this.getHashFile(inputSpecFile);
            String inputSpecHash2 = Files.asByteSource((File)inputSpecFile).hash(Hashing.sha256()).toString();
            if (storedInputSpecHashFile2.getParent() != null && !new File(storedInputSpecHashFile2.getParent()).exists()) {
                File parent = new File(storedInputSpecHashFile2.getParent());
                parent.mkdirs();
            }
            Files.asCharSink((File)storedInputSpecHashFile2, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)inputSpecHash2);
        }
        catch (Exception e) {
            if (this.buildContext != null) {
                this.buildContext.addError(inputSpecFile, 0, 0, "unexpected error in Open-API generation", (Throwable)e);
            }
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Code generation failed. See above for the full exception.");
        }
    }

    private File getHashFile(File inputSpecFile) {
        return new File(this.output.getPath() + File.separator + ".openapi-generator" + File.separator + inputSpecFile.getName() + ".sha256");
    }

    private String getCompileSourceRoot() {
        Object sourceFolderObject = this.configOptions == null ? null : (Object)this.configOptions.get("sourceFolder");
        String sourceFolder = sourceFolderObject == null ? "src/main/java" : sourceFolderObject.toString();
        String sourceJavaFolder = this.output.toString() + "/" + sourceFolder;
        return sourceJavaFolder;
    }

    private void addCompileSourceRootIfConfigured() {
        if (this.addCompileSourceRoot) {
            this.project.addCompileSourceRoot(this.getCompileSourceRoot());
        }
        for (Map.Entry<String, String> entry : this.originalEnvironmentVariables.entrySet()) {
            if (entry.getValue() == null) {
                GeneratorProperties.clearProperty((String)entry.getKey());
                continue;
            }
            GeneratorProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void adjustAdditionalProperties(CodegenConfig config) {
        Map configAdditionalProperties = config.additionalProperties();
        Set keySet = configAdditionalProperties.keySet();
        for (String key : keySet) {
            Object value = configAdditionalProperties.get(key);
            if (value != null) {
                if (!(value instanceof String)) continue;
                String stringValue = (String)value;
                if (stringValue.equalsIgnoreCase("true")) {
                    configAdditionalProperties.put(key, Boolean.TRUE);
                    continue;
                }
                if (!stringValue.equalsIgnoreCase("false")) continue;
                configAdditionalProperties.put(key, Boolean.FALSE);
                continue;
            }
            configAdditionalProperties.put(key, Boolean.FALSE);
        }
    }
}

