/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.DiscriminatorValidator;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class AnyOfValidator
extends DiscriminatorValidator {
    private static final ValidationResult ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1001), "Schema description is erroneous. anyOf should have at least 1 element.");
    private static final ValidationResults.CrumbInfo CRUMB_INFO = new ValidationResults.CrumbInfo("anyOf", true);

    AnyOfValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema, "anyOf");
    }

    @Override
    void validateWithoutDiscriminator(JsonNode valueNode, ValidationData<?> validation) {
        if (this.validators.isEmpty()) {
            validation.add(CRUMB_INFO, ERR, new Object[0]);
            return;
        }
        ArrayList<ValidationResults> resultsOnError = new ArrayList<ValidationResults>();
        for (SchemaValidator validator : this.validators) {
            ValidationData schemaValidation = new ValidationData(validation.delegate());
            validator.validate(valueNode, schemaValidation);
            if (schemaValidation.isValid()) {
                validation.add((Collection<ValidationResults.CrumbInfo>)validation.results().crumbs(), schemaValidation.results());
                return;
            }
            resultsOnError.add(schemaValidation.results());
        }
        for (ValidationResults results : resultsOnError) {
            validation.add((Collection<ValidationResults.CrumbInfo>)validation.results().crumbs(), results.items(ValidationSeverity.ERROR));
        }
    }
}

