/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openapi4j.core.exception.EncodeException;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.parser.model.OpenApiSchema;
import org.openapi4j.parser.model.SerializationFlag;

public abstract class AbsOpenApiSchema<M extends OpenApiSchema<M>>
implements OpenApiSchema<M> {
    @Override
    public JsonNode toNode() throws EncodeException {
        try {
            byte[] content = TreeUtil.json.writerWithView(Views.Public.class).writeValueAsBytes((Object)this);
            return TreeUtil.json.readTree(content);
        }
        catch (Exception e) {
            throw new EncodeException(String.format("Failed to encode: %s", e.getMessage()));
        }
    }

    @Override
    public String toString(EnumSet<SerializationFlag> flags) throws EncodeException {
        ObjectMapper mapper = flags.contains((Object)SerializationFlag.OUT_AS_YAML) ? TreeUtil.yaml : TreeUtil.json;
        try {
            return mapper.writerWithView(Views.Public.class).writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new EncodeException(String.format("Failed to encode: %s", e.getMessage()));
        }
    }

    protected <T extends OpenApiSchema<T>> T copyField(T original) {
        if (original != null) {
            return (T)((OpenApiSchema)original.copy());
        }
        return null;
    }

    protected <K, T extends OpenApiSchema<T>> Map<K, T> copyMap(Map<K, T> original) {
        if (original != null) {
            LinkedHashMap<K, OpenApiSchema> copy = new LinkedHashMap<K, OpenApiSchema>(original.size());
            for (Map.Entry<K, T> element : original.entrySet()) {
                OpenApiSchema schema = (OpenApiSchema)element.getValue();
                if (schema != null) {
                    copy.put(element.getKey(), (OpenApiSchema)schema.copy());
                    continue;
                }
                copy.put(element.getKey(), null);
            }
            return copy;
        }
        return null;
    }

    protected <K, T> Map<K, T> copySimpleMap(Map<K, T> original) {
        if (original != null) {
            return new LinkedHashMap<K, T>(original);
        }
        return null;
    }

    protected <K, V> Map<K, V> mapPut(Map<K, V> map, K key, V value) {
        if (map == null) {
            map = new LinkedHashMap();
        }
        map.put(key, value);
        return map;
    }

    protected <K, V> boolean mapHas(Map<K, V> map, K key) {
        return map != null && map.containsKey(key);
    }

    protected <K, V> V mapGet(Map<K, V> map, K key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    protected <K, V> void mapRemove(Map<K, V> map, K key) {
        if (map != null) {
            map.remove(key);
        }
    }

    protected <T extends OpenApiSchema<T>> List<T> copyList(List<T> original) {
        if (original != null) {
            ArrayList<OpenApiSchema> copy = new ArrayList<OpenApiSchema>(original.size());
            for (OpenApiSchema element : original) {
                copy.add((OpenApiSchema)element.copy());
            }
            return copy;
        }
        return null;
    }

    protected <T> List<T> copySimpleList(List<T> original) {
        if (original != null) {
            return new ArrayList<T>(original);
        }
        return null;
    }

    protected <K> List<K> listAdd(List<K> list, K value) {
        if (list == null) {
            list = new ArrayList<K>();
        }
        list.add(value);
        return list;
    }

    protected <K> List<K> listAdd(List<K> list, int index, K value) {
        if (list == null) {
            list = new ArrayList<K>();
        }
        list.add(index, value);
        return list;
    }

    protected <K> boolean listRemove(List<K> list, K value) {
        if (list == null) {
            return false;
        }
        return list.remove(value);
    }

    protected static class Views {
        private Views() {
        }

        public static class Internal
        extends Public {
            private Internal() {
            }
        }

        public static class Public {
            private Public() {
            }
        }
    }
}

