/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapi4j.parser.model.AbsOpenApiSchema;

public class SecurityRequirement
extends AbsOpenApiSchema<SecurityRequirement> {
    private Map<String, List<String>> requirements;

    @JsonAnyGetter
    public Map<String, List<String>> getRequirements() {
        return this.requirements;
    }

    public SecurityRequirement setRequirements(Map<String, List<String>> requirements) {
        this.requirements = requirements;
        return this;
    }

    public boolean hasRequirement(String name) {
        return this.mapHas(this.requirements, name);
    }

    public boolean hasRequirementScopes(String name) {
        List<String> scopes = this.mapGet(this.requirements, name);
        return scopes != null && !scopes.isEmpty();
    }

    public List<String> getRequirement(String name) {
        return this.mapGet(this.requirements, name);
    }

    @JsonAnySetter
    public SecurityRequirement setRequirement(String name, List<String> scopes) {
        if (this.requirements == null) {
            this.requirements = new HashMap<String, List<String>>();
        }
        this.requirements.put(name, scopes);
        return this;
    }

    public SecurityRequirement removeRequirement(String name) {
        this.mapRemove(this.requirements, name);
        return this;
    }

    @Override
    public SecurityRequirement copy() {
        SecurityRequirement copy = new SecurityRequirement();
        copy.setRequirements(this.copySimpleMap(this.getRequirements()));
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityRequirement that = (SecurityRequirement)o;
        return Objects.equals(this.requirements, that.requirements);
    }

    public int hashCode() {
        return this.requirements != null ? this.requirements.hashCode() : 0;
    }
}

