/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.parser.model.v3.AbsExtendedOpenApiSchema;
import org.openapi4j.parser.model.v3.Callback;
import org.openapi4j.parser.model.v3.ExternalDocs;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.model.v3.ParameterUtil;
import org.openapi4j.parser.model.v3.RequestBody;
import org.openapi4j.parser.model.v3.Response;
import org.openapi4j.parser.model.v3.SecurityRequirement;
import org.openapi4j.parser.model.v3.Server;

public class Operation
extends AbsExtendedOpenApiSchema<Operation> {
    private List<String> tags;
    private String summary;
    private String description;
    private ExternalDocs externalDocs;
    private String operationId;
    private List<Parameter> parameters;
    private RequestBody requestBody;
    private Map<String, Response> responses;
    private Map<String, Callback> callbacks;
    private Boolean deprecated;
    @JsonProperty(value="security")
    private List<SecurityRequirement> securityRequirements;
    private List<Server> servers;

    public List<String> getTags() {
        return this.tags;
    }

    public Operation setTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public boolean hasTags() {
        return this.tags != null;
    }

    public Operation addTag(String tag) {
        this.tags = this.listAdd(this.tags, tag);
        return this;
    }

    public Operation insertTag(int index, String tag) {
        this.tags = this.listAdd(this.tags, index, tag);
        return this;
    }

    public Operation removeTag(String tag) {
        this.listRemove(this.tags, tag);
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public Operation setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Operation setDescription(String description) {
        this.description = description;
        return this;
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public Operation setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public Operation setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Operation setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public boolean hasParameters() {
        return this.parameters != null;
    }

    public Operation addParameter(Parameter parameter) {
        this.parameters = this.listAdd(this.parameters, parameter);
        return this;
    }

    public Operation insertParameter(int index, Parameter parameter) {
        this.parameters = this.listAdd(this.parameters, index, parameter);
        return this;
    }

    public Operation removeParameter(Parameter parameter) {
        this.listRemove(this.parameters, parameter);
        return this;
    }

    public List<Parameter> getParametersIn(OAIContext context, String in) {
        return ParameterUtil.getIn(context, this.parameters, in);
    }

    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    public Operation setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public Map<String, Response> getResponses() {
        return this.responses;
    }

    public Operation setResponses(Map<String, Response> responses) {
        this.responses = responses;
        return this;
    }

    public boolean hasResponse(String name) {
        return this.mapHas(this.responses, name);
    }

    public Response getResponse(String name) {
        return this.mapGet(this.responses, name);
    }

    public Operation setResponse(String name, Response response) {
        if (this.responses == null) {
            this.responses = new HashMap<String, Response>();
        }
        this.responses.put(name, response);
        return this;
    }

    public Operation removeResponse(String name) {
        this.mapRemove(this.responses, name);
        return this;
    }

    public Map<String, Callback> getCallbacks() {
        return this.callbacks;
    }

    public Operation setCallbacks(Map<String, Callback> callbacks) {
        this.callbacks = callbacks;
        return this;
    }

    public boolean hasCallback(String name) {
        return this.mapHas(this.callbacks, name);
    }

    public Callback getCallback(String name) {
        return this.mapGet(this.callbacks, name);
    }

    public Operation setCallback(String name, Callback callback) {
        if (this.callbacks == null) {
            this.callbacks = new HashMap<String, Callback>();
        }
        this.callbacks.put(name, callback);
        return this;
    }

    public Operation removeCallback(String name) {
        this.mapRemove(this.callbacks, name);
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public boolean isDeprecated() {
        return Boolean.TRUE.equals(this.deprecated);
    }

    public Operation setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public List<SecurityRequirement> getSecurityRequirements() {
        return this.securityRequirements;
    }

    public Operation setSecurityRequirements(List<SecurityRequirement> securityRequirements) {
        this.securityRequirements = securityRequirements;
        return this;
    }

    public boolean hasSecurityRequirements() {
        return this.securityRequirements != null;
    }

    public Operation addSecurityRequirement(SecurityRequirement securityRequirement) {
        this.securityRequirements = this.listAdd(this.securityRequirements, securityRequirement);
        return this;
    }

    public Operation insertSecurityRequirement(int index, SecurityRequirement securityRequirement) {
        this.securityRequirements = this.listAdd(this.securityRequirements, index, securityRequirement);
        return this;
    }

    public Operation removeSecurityRequirement(SecurityRequirement securityRequirement) {
        this.listRemove(this.securityRequirements, securityRequirement);
        return this;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public Operation setServers(List<Server> servers) {
        this.servers = servers;
        return this;
    }

    public boolean hasServers() {
        return this.servers != null;
    }

    public Operation addServer(Server server) {
        this.servers = this.listAdd(this.servers, server);
        return this;
    }

    public Operation insertServer(int index, Server server) {
        this.servers = this.listAdd(this.servers, index, server);
        return this;
    }

    public Operation removeServer(Server server) {
        this.listRemove(this.servers, server);
        return this;
    }

    @Override
    public Operation copy() {
        Operation copy = new Operation();
        copy.setSummary(this.getSummary());
        copy.setTags(this.copySimpleList(this.getTags()));
        copy.setDescription(this.getDescription());
        copy.setExternalDocs(this.copyField(this.getExternalDocs()));
        copy.setOperationId(this.getOperationId());
        copy.setParameters(this.copyList(this.getParameters()));
        copy.setRequestBody(this.copyField(this.getRequestBody()));
        copy.setResponses(this.copyMap(this.getResponses()));
        copy.setCallbacks(this.copyMap(this.getCallbacks()));
        copy.setDeprecated(this.getDeprecated());
        copy.setSecurityRequirements(this.copyList(this.getSecurityRequirements()));
        copy.setServers(this.copyList(this.getServers()));
        copy.setExtensions(this.copySimpleMap(this.getExtensions()));
        return copy;
    }
}

