/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.MediaTypeValidator;
import org.openapi4j.parser.validation.v3.OAI3Keywords;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.SchemaValidator;
import org.openapi4j.parser.validation.v3.Validator3Base;

class ParameterValidator
extends Validator3Base<OpenApi3, Parameter> {
    private static final ValidationResult ALLOWED_RESERVED_IGNORED = new ValidationResult(ValidationSeverity.WARNING, Integer.valueOf(125), "AllowReserved is ignored for non-query parameter '%s'");
    private static final ValidationResult STYLE_ONLY_IN = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(126), "Style '%s' is only allowed in %s");
    private static final ValidationResult STYLE_ONLY_IN_AND = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(127), "Style '%s' is only allowed in %s and %s");
    private static final ValidationResult CONTENT_ONY_ONE_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(128), "content can only contain one media type.");
    private static final ValidationResult CONTENT_SCHEMA_EXCLUSIVE_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(129), "Content and schema are mutually exclusive.");
    private static final ValidationResult STYLE_UNKNOWN = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(130), "Style '%s' is unknown.");
    private static final Validator<OpenApi3, Parameter> INSTANCE = new ParameterValidator();

    private ParameterValidator() {
    }

    public static Validator<OpenApi3, Parameter> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationContext<OpenApi3> context, OpenApi3 api, Parameter parameter, ValidationResults results) {
        if (parameter.isRef()) {
            this.validateReference(context, api, parameter, results, OAI3Keywords.CRUMB_$REF, ParameterValidator.instance(), Parameter.class);
        } else {
            this.validateString(parameter.getName(), results, true, OAI3Keywords.CRUMB_NAME);
            this.validateString(parameter.getIn(), results, true, Regexes.PARAM_IN_REGEX, OAI3Keywords.CRUMB_IN);
            this.validateString(parameter.getStyle(), results, false, Regexes.STYLE_REGEX, OAI3Keywords.CRUMB_STYLE);
            this.checkStyleValues(parameter, results);
            this.checkAllowReserved(parameter, results);
            this.validateField(context, api, parameter.getSchema(), results, false, OAI3Keywords.CRUMB_SCHEMA, SchemaValidator.instance());
            this.validateMap(context, api, parameter.getContentMediaTypes(), results, false, OAI3Keywords.CRUMB_CONTENT, Regexes.NOEXT_REGEX, MediaTypeValidator.instance());
            this.validateMap(context, api, parameter.getExtensions(), results, false, OAI3Keywords.CRUMB_EXTENSIONS, Regexes.EXT_REGEX, null);
            if (parameter.getContentMediaTypes() != null && parameter.getSchema() != null) {
                results.add(CONTENT_SCHEMA_EXCLUSIVE_ERR, new Object[0]);
            }
            if (parameter.getContentMediaTypes() != null && parameter.getContentMediaTypes().size() > 1) {
                results.add(CONTENT_ONY_ONE_ERR, new Object[0]);
            }
        }
    }

    private void checkAllowReserved(Parameter parameter, ValidationResults results) {
        if (parameter.isAllowReserved() && !"query".equals(parameter.getIn())) {
            results.add(OAI3Keywords.CRUMB_ALLOWRESERVED, ALLOWED_RESERVED_IGNORED, new Object[]{parameter.getName()});
        }
    }

    private void checkStyleValues(Parameter parameter, ValidationResults results) {
        String style = parameter.getStyle();
        if (style == null) {
            return;
        }
        String in = parameter.getIn();
        switch (style) {
            case "matrix": 
            case "label": {
                if ("path".equals(in)) break;
                results.add(OAI3Keywords.CRUMB_STYLE, STYLE_ONLY_IN, new Object[]{style, "path"});
                break;
            }
            case "form": {
                if ("query".equals(in) || "cookie".equals(in)) break;
                results.add(OAI3Keywords.CRUMB_STYLE, STYLE_ONLY_IN_AND, new Object[]{style, "query", "cookie"});
                break;
            }
            case "simple": {
                if ("path".equals(in) || "header".equals(in)) break;
                results.add(OAI3Keywords.CRUMB_STYLE, STYLE_ONLY_IN_AND, new Object[]{style, "path", "header"});
                break;
            }
            case "spaceDelimited": 
            case "pipeDelimited": 
            case "deepObject": {
                if ("query".equals(in)) break;
                results.add(OAI3Keywords.CRUMB_STYLE, STYLE_ONLY_IN, new Object[]{style, "query"});
                break;
            }
            default: {
                results.add(OAI3Keywords.CRUMB_STYLE, STYLE_UNKNOWN, new Object[]{style});
            }
        }
    }
}

