/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.validation;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.operation.validator.model.Request;
import org.openapi4j.operation.validator.model.Response;
import org.openapi4j.operation.validator.model.impl.RequestParameters;
import org.openapi4j.operation.validator.util.PathResolver;
import org.openapi4j.operation.validator.validation.OperationValidator;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Path;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;

public class RequestValidator {
    private static final String OAI_REQUIRED_ERR_MSG = "OpenAPI is required.";
    private static final String VALIDATION_CTX_REQUIRED_ERR_MSG = "Validation context is required.";
    private static final String PATHS_REQUIRED_ERR_MSG = "Paths Object is required in Document Description.";
    private static final String PATH_REQUIRED_ERR_MSG = "Path is required.";
    private static final String OPERATION_REQUIRED_ERR_MSG = "Operation is required.";
    private static final String REQUEST_REQUIRED_ERR_MSG = "Request is required.";
    private static final String RESPONSE_REQUIRED_ERR_MSG = "Response is required.";
    private static final String INVALID_REQUEST_ERR_MSG = "Invalid request.";
    private static final String INVALID_RESPONSE_ERR_MSG = "Invalid response.";
    private static final String INVALID_OP_ERR_MSG = "Operation not found from URL '%s' with method '%s'.";
    private static final String INVALID_OP_PATH_ERR_MSG = "Operation path not found from URL '%s'.";
    private final OpenApi3 openApi;
    private final ValidationContext<OAI3> context;
    private final Map<Operation, OperationValidator> operationValidators;
    private final Map<Pattern, Path> pathPatterns;

    public RequestValidator(OpenApi3 openApi) {
        this((ValidationContext<OAI3>)new ValidationContext(openApi.getContext()), openApi);
    }

    public RequestValidator(ValidationContext<OAI3> context, OpenApi3 openApi) {
        Objects.requireNonNull(openApi, OAI_REQUIRED_ERR_MSG);
        Objects.requireNonNull(context, VALIDATION_CTX_REQUIRED_ERR_MSG);
        Objects.requireNonNull(openApi.getPaths(), PATHS_REQUIRED_ERR_MSG);
        this.openApi = openApi;
        this.context = context;
        this.operationValidators = new ConcurrentHashMap<Operation, OperationValidator>();
        this.pathPatterns = this.buildPathPatterns();
    }

    public OperationValidator getValidator(Request request) throws ValidationException {
        Objects.requireNonNull(request, REQUEST_REQUIRED_ERR_MSG);
        Pattern pathPattern = this.getRequiredPathPattern(request);
        Path path = this.pathPatterns.get(pathPattern);
        Operation operation = this.getRequiredOperation(request, path);
        return this.getValidator(path, operation);
    }

    public OperationValidator getValidator(Path path, Operation operation) {
        Objects.requireNonNull(path, PATH_REQUIRED_ERR_MSG);
        Objects.requireNonNull(operation, OPERATION_REQUIRED_ERR_MSG);
        return this.operationValidators.computeIfAbsent(operation, op -> {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (Map.Entry<Pattern, Path> patternPathEntry : this.pathPatterns.entrySet()) {
                if (!patternPathEntry.getValue().equals(path)) continue;
                patterns.add(patternPathEntry.getKey());
            }
            return new OperationValidator(this.context, (List<Pattern>)patterns, this.openApi, path, (Operation)op);
        });
    }

    public RequestParameters validate(Request request) throws ValidationException {
        return this.validate(request, new ValidationData());
    }

    public void validate(Response response, Request request) throws ValidationException {
        Objects.requireNonNull(response, RESPONSE_REQUIRED_ERR_MSG);
        OperationValidator validator = this.getValidator(request);
        ValidationData validation = new ValidationData();
        this.validateResponse(response, validator, validation);
    }

    public RequestParameters validate(Request request, ValidationData<?> validation) throws ValidationException {
        Pattern pathPattern = this.getRequiredPathPattern(request);
        Path path = this.pathPatterns.get(pathPattern);
        Operation operation = this.getRequiredOperation(request, path);
        return this.validate(request, pathPattern, path, operation, validation);
    }

    public RequestParameters validate(Request request, Path path, Operation operation) throws ValidationException {
        return this.validate(request, path, operation, new ValidationData());
    }

    public RequestParameters validate(Request request, Path path, Operation operation, ValidationData<?> validation) throws ValidationException {
        return this.validate(request, null, path, operation, validation);
    }

    public void validate(Response response, Path path, Operation operation) throws ValidationException {
        this.validate(response, path, operation, new ValidationData());
    }

    public void validate(Response response, Path path, Operation operation, ValidationData<?> validation) throws ValidationException {
        Objects.requireNonNull(response, RESPONSE_REQUIRED_ERR_MSG);
        OperationValidator opValidator = this.getValidator(path, operation);
        this.validateResponse(response, opValidator, validation);
    }

    private RequestParameters validate(Request request, Pattern pathPattern, Path path, Operation operation, ValidationData<?> validation) throws ValidationException {
        Objects.requireNonNull(request, REQUEST_REQUIRED_ERR_MSG);
        OperationValidator opValidator = this.getValidator(path, operation);
        Map<String, JsonNode> pathParameters = pathPattern != null ? opValidator.validatePath(request, pathPattern, validation) : opValidator.validatePath(request, validation);
        Map<String, JsonNode> queryParameters = opValidator.validateQuery(request, validation);
        Map<String, JsonNode> headerParameters = opValidator.validateHeaders(request, validation);
        Map<String, JsonNode> cookieParameters = opValidator.validateCookies(request, validation);
        opValidator.validateBody(request, validation);
        if (!validation.isValid()) {
            throw new ValidationException(INVALID_REQUEST_ERR_MSG, validation.results());
        }
        return new RequestParameters(pathParameters, queryParameters, headerParameters, cookieParameters);
    }

    private Operation getRequiredOperation(Request request, Path path) throws ValidationException {
        Operation operation = path.getOperation(request.getMethod().name().toLowerCase());
        if (operation == null) {
            throw new ValidationException(String.format(INVALID_OP_ERR_MSG, request.getURL(), request.getMethod().name()));
        }
        return operation;
    }

    private Pattern getRequiredPathPattern(Request request) throws ValidationException {
        Pattern pathPattern = PathResolver.instance().findPathPattern(this.pathPatterns.keySet(), request.getPath());
        if (pathPattern == null) {
            throw new ValidationException(String.format(INVALID_OP_PATH_ERR_MSG, request.getURL()));
        }
        return pathPattern;
    }

    private void validateResponse(Response response, OperationValidator opValidator, ValidationData<?> validation) throws ValidationException {
        opValidator.validateResponse(response, validation);
        if (!validation.isValid()) {
            throw new ValidationException(INVALID_RESPONSE_ERR_MSG, validation.results());
        }
    }

    private Map<Pattern, Path> buildPathPatterns() {
        HashMap<Pattern, Path> patterns = new HashMap<Pattern, Path>();
        for (Map.Entry pathEntry : this.openApi.getPaths().entrySet()) {
            List<Pattern> builtPathPatterns = PathResolver.instance().buildPathPatterns(this.openApi.getContext(), this.openApi.getServers(), (String)pathEntry.getKey());
            for (Pattern pathPattern : builtPathPatterns) {
                patterns.put(pathPattern, (Path)pathEntry.getValue());
            }
        }
        return patterns;
    }
}

