/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.convert.style;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.operation.validator.util.convert.style.StyleConverter;
import org.openapi4j.parser.model.v3.AbsParameter;

abstract class FlatStyleConverter
implements StyleConverter {
    FlatStyleConverter() {
    }

    Map<String, Object> getParameterValues(OAIContext context, AbsParameter<?> param, String paramName, String rawValue, String splitPattern) {
        if (rawValue == null) {
            return null;
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        param.setSchema(param.getSchema().getFlatSchema(context));
        if ("object".equals(param.getSchema().getSupposedType(context))) {
            if (param.isExplode()) {
                this.handleExplodedObject(param, splitPattern, rawValue, values);
            } else {
                this.handleNotExplodedObject(param, splitPattern, rawValue, values);
            }
        } else if ("array".equals(param.getSchema().getSupposedType(context))) {
            values.put(paramName, Arrays.asList(rawValue.split(splitPattern)));
        } else {
            values.put(paramName, rawValue);
        }
        return values;
    }

    private void handleExplodedObject(AbsParameter<?> param, String splitPattern, String rawValue, Map<String, Object> values) {
        Scanner scanner = new Scanner(rawValue);
        scanner.useDelimiter(splitPattern);
        while (scanner.hasNext()) {
            String[] propEntry = scanner.next().split("=");
            if (propEntry.length != 2 || !param.getSchema().hasProperty(propEntry[0])) continue;
            values.put(propEntry[0], propEntry[1]);
        }
        scanner.close();
    }

    private void handleNotExplodedObject(AbsParameter<?> param, String splitPattern, String rawValue, Map<String, Object> values) {
        String[] splitValues = rawValue.split(splitPattern);
        if (splitValues.length % 2 == 0) {
            int i = 0;
            while (i < splitValues.length) {
                if (param.getSchema().hasProperty(splitValues[i])) {
                    values.put(splitValues[i++], splitValues[i++]);
                    continue;
                }
                i += 2;
            }
        }
    }
}

