/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.adapters.server.restassured;

import io.restassured.http.Header;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.openapi4j.operation.validator.model.impl.Body;

public class RestAssuredResponse
implements org.openapi4j.operation.validator.model.Response {
    private final Response response;
    private final String rawResponseBody;

    RestAssuredResponse(Response response) {
        this.response = response;
        this.rawResponseBody = new String(response.body().asByteArray());
    }

    public int getStatus() {
        return this.response.statusCode();
    }

    public Body getBody() {
        return Body.from((String)this.rawResponseBody);
    }

    public Map<String, Collection<String>> getHeaders() {
        HashMap<String, Collection<String>> rval = new HashMap<String, Collection<String>>();
        this.response.headers().asList().forEach(header -> rval.computeIfAbsent(header.getName(), __ -> new ArrayList(1)).add(header.getValue()));
        return rval;
    }

    public Collection<String> getHeaderValues(String s) {
        return this.response.headers().asList().stream().filter(h -> s.equals(h.getName())).map(Header::getValue).collect(Collectors.toList());
    }

    public String toString() {
        return this.rawResponseBody;
    }
}

