/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.adapters.server.restassured;

import io.restassured.specification.FilterableRequestSpecification;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.openapi4j.operation.validator.model.Request;
import org.openapi4j.operation.validator.model.impl.Body;

public class RestAssuredRequest
implements Request {
    private final FilterableRequestSpecification requestSpec;

    public RestAssuredRequest(FilterableRequestSpecification requestSpec) {
        this.requestSpec = requestSpec;
    }

    public String getURL() {
        return this.requestSpec.getURI();
    }

    public String getPath() {
        return this.requestSpec.getUserDefinedPath();
    }

    public Request.Method getMethod() {
        return Request.Method.getMethod((String)this.requestSpec.getMethod());
    }

    public Body getBody() {
        return Body.from((String)this.requestSpec.getBody().toString());
    }

    public String getQuery() {
        return this.requestSpec.getQueryParams().entrySet().stream().map(entry -> URLEncoder.encode((String)entry.getKey()) + "=" + URLEncoder.encode((String)entry.getValue())).collect(Collectors.joining("&"));
    }

    public Map<String, String> getCookies() {
        HashMap<String, String> rval = new HashMap<String, String>();
        this.requestSpec.getCookies().asList().forEach(cookie -> rval.put(cookie.getName(), cookie.getValue()));
        return rval;
    }

    public Map<String, Collection<String>> getHeaders() {
        HashMap<String, Collection<String>> rval = new HashMap<String, Collection<String>>(this.requestSpec.getHeaders().size());
        this.requestSpec.getHeaders().forEach(header -> rval.computeIfAbsent(header.getName(), __ -> new ArrayList(1)).add(header.getValue()));
        return rval;
    }

    public Collection<String> getHeaderValues(String s) {
        return this.requestSpec.getHeaders().getValues(s);
    }
}

