/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.field;

import org.odftoolkit.odfdom.dom.element.text.TextPageNumberElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.common.field.Field;
import org.odftoolkit.simple.style.NumberFormat;
import org.w3c.dom.Node;

public class PageNumberField
extends Field {
    private TextPageNumberElement pageNumberElement;
    private DisplayType type;

    PageNumberField(OdfElement odfElement) {
        TextSpanElement spanElement = (TextSpanElement)((OdfFileDom)odfElement.getOwnerDocument()).newOdfElement(TextSpanElement.class);
        odfElement.appendChild((Node)spanElement);
        this.pageNumberElement = spanElement.newTextPageNumberElement(null);
        this.setDisplayPage(DisplayType.CURRENT_PAGE);
    }

    public void setDisplayPage(DisplayType type) {
        this.pageNumberElement.setTextSelectPageAttribute(type.toString());
        this.type = type;
    }

    public void setNumberFormat(NumberFormat format) {
        this.pageNumberElement.setStyleNumFormatAttribute(format.toString());
    }

    public TextPageNumberElement getOdfElement() {
        return this.pageNumberElement;
    }

    public Field.FieldType getFieldType() {
        switch (this.type) {
            case PREVIOUS_PAGE: {
                return Field.FieldType.PREVIOUS_PAGE_NUMBER_FIELD;
            }
            case CURRENT_PAGE: {
                return Field.FieldType.CURRENT_PAGE_NUMBER_FIELD;
            }
            case NEXT_PAGE: {
                return Field.FieldType.NEXT_PAGE_NUMBER_FIELD;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayType {
        PREVIOUS_PAGE("previous"),
        CURRENT_PAGE("current"),
        NEXT_PAGE("next");

        private final String displayType;

        private DisplayType(String type) {
            this.displayType = type;
        }

        public String toString() {
            return this.displayType;
        }
    }
}

