/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.field;

import org.odftoolkit.odfdom.dom.element.text.TextChapterElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.common.field.Field;
import org.w3c.dom.Node;

public class ChapterField
extends Field {
    private TextChapterElement chapterElement;

    ChapterField(OdfElement odfElement) {
        TextSpanElement spanElement = (TextSpanElement)((OdfFileDom)odfElement.getOwnerDocument()).newOdfElement(TextSpanElement.class);
        odfElement.appendChild((Node)spanElement);
        this.chapterElement = spanElement.newTextChapterElement(null, 1);
        this.setDisplayPage(DisplayType.NUMBER_AND_NAME);
    }

    public void setDisplayPage(DisplayType type) {
        this.chapterElement.setTextDisplayAttribute(type.toString());
    }

    public void setOutlineLevel(int level) {
        this.chapterElement.setTextOutlineLevelAttribute(Integer.valueOf(level));
    }

    public TextChapterElement getOdfElement() {
        return this.chapterElement;
    }

    public Field.FieldType getFieldType() {
        return Field.FieldType.CHAPTER_FIELD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayType {
        NAME("name"),
        NUMBER("number"),
        NUMBER_AND_NAME("number-and-name"),
        PLAIN_NUMBER("plain-number"),
        PLAIN_NUMBER_AND_NAME("plain-number-and-name");

        private final String displayType;

        private DisplayType(String type) {
            this.displayType = type;
        }

        public String toString() {
            return this.displayType;
        }
    }
}

