/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfMetaDom;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.draw.DrawObjectElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentMetaElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMetaElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextTrackedChangesElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.common.TextExtractor;
import org.odftoolkit.simple.table.Row;
import org.odftoolkit.simple.table.Table;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EditableTextExtractor
extends TextExtractor {
    Document mDocument = null;
    boolean mIsDocumentExtractor = false;

    public static EditableTextExtractor newOdfEditableTextExtractor(Document doc) {
        return new EditableTextExtractor(doc);
    }

    public static EditableTextExtractor newOdfEditableTextExtractor(OdfElement element) {
        return new EditableTextExtractor(element);
    }

    public static synchronized String getText(OdfElement ele) {
        EditableTextExtractor extractor = EditableTextExtractor.newOdfEditableTextExtractor(ele);
        return extractor.getText();
    }

    public static synchronized String getText(Document doc) {
        EditableTextExtractor extractor = EditableTextExtractor.newOdfEditableTextExtractor(doc);
        return extractor.getText();
    }

    public String getText() {
        if (this.mIsDocumentExtractor) {
            return this.getDocumentText();
        }
        this.visit(this.mElement);
        return this.mTextBuilder.toString();
    }

    private EditableTextExtractor(Document doc) {
        this.mDocument = doc;
        this.mIsDocumentExtractor = true;
    }

    private EditableTextExtractor(OdfElement element) {
        super(element);
        this.mIsDocumentExtractor = false;
    }

    public void visit(DrawObjectElement element) {
        String embedDocPath = element.getXlinkHrefAttribute();
        Document embedDoc = ((Document)((OdfContentDom)element.getOwnerDocument()).getDocument()).getEmbeddedDocument(embedDocPath);
        if (embedDoc != null) {
            try {
                this.mTextBuilder.append(EditableTextExtractor.newOdfEditableTextExtractor(embedDoc).getText());
            }
            catch (Exception e) {
                Logger.getLogger(EditableTextExtractor.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    public void visit(TextTrackedChangesElement ele) {
    }

    public void visit(TextAElement ele) {
        String link = ele.getXlinkHrefAttribute();
        this.mTextBuilder.append(link);
        this.appendElementText((OdfElement)ele);
    }

    public void visit(TableTableElement ele) {
        Table table = Table.getInstance(ele);
        List<Row> rowlist = table.getRowList();
        int column = table.getColumnCount();
        for (int i = 0; i < rowlist.size(); ++i) {
            Row row = rowlist.get(i);
            for (int j = 0; j < column; ++j) {
                this.mTextBuilder.append(row.getCellByIndex(j).getDisplayText());
                this.mTextBuilder.append('\t');
            }
            this.mTextBuilder.appendLine();
        }
    }

    private String getDocumentText() {
        StringBuilder builder = new StringBuilder();
        try {
            OfficeDocumentMetaElement root;
            OfficeMetaElement officemeta;
            OdfMetaDom metaDom;
            EditableTextExtractor contentDomExtractor = EditableTextExtractor.newOdfEditableTextExtractor(this.mDocument.getContentRoot());
            builder.append(contentDomExtractor.getText());
            OdfStylesDom styleDom = this.mDocument.getStylesDom();
            if (styleDom != null) {
                StyleMasterPageElement masterpage = null;
                NodeList list = styleDom.getElementsByTagName("style:master-page");
                if (list.getLength() > 0) {
                    masterpage = (StyleMasterPageElement)list.item(0);
                }
                if (masterpage != null) {
                    builder.append(EditableTextExtractor.newOdfEditableTextExtractor((OdfElement)masterpage).getText());
                }
            }
            if ((metaDom = this.mDocument.getMetaDom()) != null && (officemeta = (OfficeMetaElement)OdfElement.findFirstChildNode(OfficeMetaElement.class, (Node)(root = metaDom.getRootElement()))) != null) {
                builder.append(EditableTextExtractor.newOdfEditableTextExtractor((OdfElement)officemeta).getText());
            }
            return builder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.getLogger(EditableTextExtractor.class.getName()).severe(e.getMessage());
            return builder.toString();
        }
    }
}

