/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.presentation;

import java.util.IdentityHashMap;
import java.util.Iterator;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawTextBoxElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationNotesElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.PresentationDocument;
import org.odftoolkit.simple.text.list.AbstractListContainer;
import org.odftoolkit.simple.text.list.List;
import org.odftoolkit.simple.text.list.ListContainer;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Notes
implements ListContainer {
    PresentationNotesElement maNoteElement;
    private ListContainerImpl listContainerImpl;

    private Notes(PresentationNotesElement noteElement) {
        this.maNoteElement = noteElement;
    }

    public static Notes getInstance(PresentationNotesElement noteElement) {
        PresentationDocument ownerDocument = (PresentationDocument)((OdfFileDom)noteElement.getOwnerDocument()).getDocument();
        return ownerDocument.getNotesBuilder().getNotesInstance(noteElement);
    }

    public PresentationNotesElement getOdfElement() {
        return this.maNoteElement;
    }

    public void addText(String text) {
        DrawFrameElement frame;
        NodeList textBoxList;
        NodeList frameList = this.maNoteElement.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "frame");
        if (frameList.getLength() > 0 && (textBoxList = (frame = (DrawFrameElement)frameList.item(0)).getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "text-box")).getLength() > 0) {
            DrawTextBoxElement textBox = (DrawTextBoxElement)textBoxList.item(0);
            TextPElement newPara = textBox.newTextPElement();
            newPara.setTextContent(text);
        }
    }

    @Override
    public OdfElement getListContainerElement() {
        return this.getListContainerImpl().getListContainerElement();
    }

    @Override
    public List addList() {
        return this.getListContainerImpl().addList();
    }

    @Override
    public List addList(ListDecorator decorator) {
        return this.getListContainerImpl().addList(decorator);
    }

    @Override
    public void clearList() {
        this.getListContainerImpl().clearList();
    }

    @Override
    public Iterator<List> getListIterator() {
        return this.getListContainerImpl().getListIterator();
    }

    @Override
    public boolean removeList(List list) {
        return this.getListContainerImpl().removeList(list);
    }

    private ListContainerImpl getListContainerImpl() {
        if (this.listContainerImpl == null) {
            this.listContainerImpl = new ListContainerImpl();
        }
        return this.listContainerImpl;
    }

    private class ListContainerImpl
    extends AbstractListContainer {
        private ListContainerImpl() {
        }

        public OdfElement getListContainerElement() {
            DrawFrameElement frame = null;
            DrawTextBoxElement textBox = null;
            NodeList frameList = Notes.this.maNoteElement.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "frame");
            frame = frameList.getLength() <= 0 ? Notes.this.maNoteElement.newDrawFrameElement() : (DrawFrameElement)frameList.item(frameList.getLength() - 1);
            NodeList textBoxList = frame.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "text-box");
            textBox = textBoxList.getLength() <= 0 ? frame.newDrawTextBoxElement() : (DrawTextBoxElement)textBoxList.item(textBoxList.getLength() - 1);
            return textBox;
        }
    }

    public static class NotesBuilder {
        private final IdentityHashMap<PresentationNotesElement, Notes> maNotesRepository = new IdentityHashMap();

        public NotesBuilder(PresentationDocument doc) {
            if (doc.getNotesBuilder() != null) {
                throw new IllegalStateException("NotesBuilder only can be created in owner PresentationDocument constructor.");
            }
        }

        public synchronized Notes getNotesInstance(PresentationNotesElement noteElement) {
            if (this.maNotesRepository.containsKey(noteElement)) {
                return this.maNotesRepository.get(noteElement);
            }
            Notes newNotes = new Notes(noteElement);
            this.maNotesRepository.put(noteElement, newNotes);
            return newNotes;
        }
    }
}

