/*
 * Decompiled with CFR 0.152.
 */
package schema2template.example.odf;

import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitor;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.msv.grammar.NameClassVisitor;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.trex.ng.RELAXNGReader;
import com.sun.msv.reader.util.IgnoreController;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.SAXParserFactory;
import schema2template.model.MSVExpressionInformation;
import schema2template.model.MSVExpressionType;
import schema2template.model.MSVExpressionVisitorType;
import schema2template.model.MSVNameClassVisitorList;
import schema2template.model.PuzzlePiece;
import schema2template.model.PuzzlePieceSet;

public class PathPrinter {
    public static final String EXAMPLE_PARENT = "table:table";
    public static final String EXAMPLE_CHILD = "table:table-row";
    PuzzlePiece mParent;
    MSVExpressionInformation mInfo;
    public static final String ODF_RESOURCE_DIR = "target" + File.separator + "classes" + File.separator + "examples" + File.separator + "odf";

    PathPrinter(PuzzlePiece parent) {
        this.mParent = parent;
        this.mInfo = new MSVExpressionInformation(parent.getExpression());
    }

    static Map<String, SortedSet<PuzzlePiece>> createDefinitionMap(Set<PuzzlePiece> definitions) {
        HashMap<String, SortedSet<PuzzlePiece>> retval = new HashMap<String, SortedSet<PuzzlePiece>>();
        for (PuzzlePiece def : definitions) {
            TreeSet<PuzzlePiece> multiples = (TreeSet<PuzzlePiece>)retval.get(def.getQName());
            if (multiples == null) {
                multiples = new TreeSet<PuzzlePiece>();
                retval.put(def.getQName(), multiples);
            }
            multiples.add(def);
        }
        return retval;
    }

    List<String> printPathsToChild(PuzzlePiece child) {
        MSVExpressionVisitorType typeVisitor = new MSVExpressionVisitorType();
        List<List<Expression>> paths = null;
        paths = child != null ? this.mInfo.getPathsContaining(child.getExpression()) : this.mInfo.getPathsContaining(this.mParent.getExpression());
        if (paths == null) {
            return null;
        }
        MSVNameClassVisitorList nameVisitor = new MSVNameClassVisitorList();
        ArrayList<String> retval = new ArrayList<String>(paths.size());
        for (List<Expression> path : paths) {
            boolean first = true;
            String wayString = "";
            for (Expression step : path) {
                List names;
                MSVExpressionType type = (MSVExpressionType)((Object)step.visit((ExpressionVisitor)typeVisitor));
                if (type == MSVExpressionType.REF) continue;
                String name = type.toString();
                String qname = "";
                if (step instanceof NameClassAndExpression && (names = (List)((NameClassAndExpression)step).getNameClass().visit((NameClassVisitor)nameVisitor)) != null) {
                    boolean firstQ = true;
                    for (String singleQ : names) {
                        if (firstQ) {
                            firstQ = false;
                            qname = singleQ;
                            continue;
                        }
                        qname = qname + "," + singleQ;
                    }
                }
                if (first) {
                    first = false;
                    wayString = name + " " + qname;
                    continue;
                }
                if (step instanceof NameClassAndExpression) {
                    name = name + " " + qname;
                }
                wayString = wayString.concat(" -> " + name);
            }
            retval.add(wayString);
        }
        return retval;
    }

    private static Expression parseOdfSchema(File rngFile) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        Expression root = RELAXNGReader.parse((String)rngFile.getAbsolutePath(), (SAXParserFactory)factory, (GrammarReaderController)new IgnoreController()).getTopLevel();
        if (root == null) {
            throw new Exception("Schema could not be parsed.");
        }
        return root;
    }

    public static void main(String[] args) throws Exception {
        Expression root = PathPrinter.parseOdfSchema(new File(ODF_RESOURCE_DIR + File.separator + "OpenDocument-v1.2-os-schema.rng"));
        PuzzlePieceSet elements = new PuzzlePieceSet();
        PuzzlePieceSet attributes = new PuzzlePieceSet();
        PuzzlePiece.extractPuzzlePieces(root, elements, attributes);
        Map<String, SortedSet<PuzzlePiece>> nameToDefinition = PathPrinter.createDefinitionMap(new TreeSet<PuzzlePiece>(elements));
        System.out.println("Print all paths from parent element (e.g. \"text:p\") to direct child element (e.g. \"text:span\")");
        SortedSet<PuzzlePiece> pieces = nameToDefinition.get(EXAMPLE_PARENT);
        if (pieces == null) {
            System.out.println("No parent element found by the given name: table:table");
        }
        PuzzlePiece parent = pieces.first();
        pieces = nameToDefinition.get(EXAMPLE_CHILD);
        if (pieces == null) {
            System.out.println("No child element found by the given name: table:table-row");
        }
        PuzzlePiece child = pieces.first();
        if (pieces.size() > 1) {
            System.out.println("There were more than one element by this name. Dropped all instances but one.");
        }
        System.out.println();
        System.out.println("PATHS from " + parent.getQName() + " to " + child.getQName() + ": ");
        System.out.println("---------------------------------------------------------");
        List<String> paths = new PathPrinter(parent).printPathsToChild(child);
        if (paths == null) {
            System.out.println("No Path found.");
        } else {
            for (String s : paths) {
                System.out.println(s);
            }
        }
    }
}

