/*
 * Decompiled with CFR 0.152.
 */
package schema2template.example.odf;

import com.sun.msv.grammar.Expression;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.trex.ng.RELAXNGReader;
import com.sun.msv.reader.util.IgnoreController;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import schema2template.OutputFileListEntry;
import schema2template.OutputFileListHandler;
import schema2template.example.odf.OdfConfigFileHandler;
import schema2template.example.odf.OdfModel;
import schema2template.example.odf.SourceCodeModel;
import schema2template.model.XMLModel;

public class OdfHelper {
    private static final Logger LOG = Logger.getLogger(OdfHelper.class.getName());
    public static final Boolean DEBUG = Boolean.FALSE;
    public static final int ODF11_ELEMENT_NUMBER = 525;
    public static final int ODF12_ELEMENT_NUMBER = 598;
    public static final int ODF11_ATTRIBUTE_NUMBER = 1162;
    public static final int ODF12_ATTRIBUTE_NUMBER = 1300;
    private static String odfDomResourceDir;
    private static String odfPkgResourceDir;
    private static String odfPythonResourceDir;
    private static String odfReferenceResourceDir;
    private static String odfSchemaResourceDir;
    private static String outputRoot;
    public static final String INPUT_ROOT;
    public static final String TEST_REFERENCE_DIR;
    public static final String TEST_INPUT_ROOT;
    public static final String ODF10_RNG_FILE_NAME = "OpenDocument-strict-schema-v1.0-os.rng";
    public static final String ODF11_RNG_FILE_NAME = "OpenDocument-strict-schema-v1.1.rng";
    public static final String ODF12_RNG_FILE_NAME = "OpenDocument-v1.2-os-schema.rng";
    public static final String ODF12_SIGNATURE_RNG_FILE_NAME = "OpenDocument-v1.2-os-dsig-schema.rng";
    public static final String ODF12_MANIFEST_RNG_FILE_NAME = "OpenDocument-v1.2-os-manifest-schema.rng";
    static String odf12RngFile;
    static String odf12SignatureRngFile;
    static String odf12ManifestRngFile;
    static String odf11RngFile;
    static String odf10RngFile;
    private static String mConfigFile;
    private static final String REFERENCE_OUTPUT_FILES_TEMPLATE = "dom-output-files.vm";
    private static final String REFERENCE_OUTPUT_FILES;
    private static final String PYTHON_OUTPUT_FILES_TEMPLATE = "dom-output-files.vm";
    private static final String PYTHON_OUTPUT_FILES;
    private static final String DOM_OUTPUT_FILES_TEMPLATE = "dom-output-files.vm";
    private static final String DOM_OUTPUT_FILES;
    private static final String PKG_MANIFEST_OUTPUT_FILES_TEMPLATE = "pkg-manifest-output-files.vm";
    private static final String PKG_MANIFEST_OUTPUT_FILES;
    private static final String PKG_DSIG_OUTPUT_FILES_TEMPLATE = "pkg-dsig-output-files.vm";
    private static final String PKG_DSIG_OUTPUT_FILES;
    private static XMLModel mOdf12SignatureSchemaModel;
    private static XMLModel mOdf12ManifestSchemaModel;
    private static XMLModel mOdf12SchemaModel;
    private static XMLModel mOdf11SchemaModel;
    private static OdfModel mOdfModel;
    private static SourceCodeModel mJavaModel;
    private static Expression mOdf12SignatureRoot;
    private static Expression mOdf12ManifestRoot;
    private static Expression mOdf12Root;
    private static Expression mOdf11Root;

    public OdfHelper(String domResourceRoot, String odf12SchemaFile, String odf11SchemaFile, String pkgResourceRoot, String odf12SignatureSchemaFile, String odf12ManifestSchemaFile, String targetRoot, String configFile) {
        odfDomResourceDir = domResourceRoot;
        odf12RngFile = odf12SchemaFile;
        odf11RngFile = odf11SchemaFile;
        odfPkgResourceDir = pkgResourceRoot;
        odf12SignatureRngFile = odf12SignatureSchemaFile;
        odf12ManifestRngFile = odf12ManifestSchemaFile;
        outputRoot = targetRoot;
        mConfigFile = configFile;
    }

    public void start() throws Exception {
        LOG.info("Starting code generation:");
        OdfHelper.initialize();
        OdfHelper.fillTemplates(odfDomResourceDir, mOdf12Root, "dom-output-files.vm", DOM_OUTPUT_FILES, mOdf12SchemaModel);
        OdfHelper.fillTemplates(odfPkgResourceDir, mOdf12ManifestRoot, PKG_MANIFEST_OUTPUT_FILES_TEMPLATE, PKG_MANIFEST_OUTPUT_FILES, mOdf12ManifestSchemaModel);
        OdfHelper.fillTemplates(odfPkgResourceDir, mOdf12SignatureRoot, PKG_DSIG_OUTPUT_FILES_TEMPLATE, PKG_DSIG_OUTPUT_FILES, mOdf12SignatureSchemaModel);
    }

    public static void main(String[] args) throws Exception {
        LOG.info("Starting code generation:");
        OdfHelper.initialize();
        OdfHelper.fillTemplates(odfReferenceResourceDir, mOdf12Root, "dom-output-files.vm", REFERENCE_OUTPUT_FILES, mOdf12SchemaModel);
        OdfHelper.fillTemplates(odfPythonResourceDir, mOdf12Root, "dom-output-files.vm", PYTHON_OUTPUT_FILES, mOdf12SchemaModel);
        OdfHelper.fillTemplates(odfDomResourceDir, mOdf12Root, "dom-output-files.vm", DOM_OUTPUT_FILES, mOdf12SchemaModel);
        OdfHelper.fillTemplates(odfPkgResourceDir, mOdf12ManifestRoot, PKG_MANIFEST_OUTPUT_FILES_TEMPLATE, PKG_MANIFEST_OUTPUT_FILES, mOdf12ManifestSchemaModel);
        OdfHelper.fillTemplates(odfPkgResourceDir, mOdf12SignatureRoot, PKG_DSIG_OUTPUT_FILES_TEMPLATE, PKG_DSIG_OUTPUT_FILES, mOdf12SignatureSchemaModel);
    }

    private static void initialize() throws Exception {
        LOG.info("Starting initilization..");
        mOdf12SignatureRoot = OdfHelper.loadSchema(new File(odf12SignatureRngFile));
        mOdf12ManifestRoot = OdfHelper.loadSchema(new File(odf12ManifestRngFile));
        mOdf12Root = OdfHelper.loadSchema(new File(odf12RngFile));
        mOdf11Root = OdfHelper.loadSchema(new File(odf11RngFile));
        HashMap<String, String> elementToBaseNameMap = new HashMap<String, String>();
        HashMap<String, List<String>> elementStyleFamiliesMap = new HashMap<String, List<String>>();
        HashMap<String, String[]> datatypeValueAndConversionMap = new HashMap<String, String[]>();
        HashMap<String, OdfModel.AttributeDefaults> attributeDefaultMap = new HashMap<String, OdfModel.AttributeDefaults>();
        OdfConfigFileHandler.readConfigFile(new File(mConfigFile), elementToBaseNameMap, attributeDefaultMap, elementStyleFamiliesMap, datatypeValueAndConversionMap);
        mOdf12SignatureSchemaModel = new XMLModel(mOdf12SignatureRoot);
        mOdf12ManifestSchemaModel = new XMLModel(mOdf12ManifestRoot);
        mOdf12SchemaModel = new XMLModel(mOdf12Root);
        mOdf11SchemaModel = new XMLModel(mOdf11Root);
        mOdfModel = new OdfModel(elementStyleFamiliesMap, attributeDefaultMap);
        mJavaModel = new SourceCodeModel(mOdf12SchemaModel, mOdf12SignatureSchemaModel, mOdf12ManifestSchemaModel, mOdfModel, elementToBaseNameMap, datatypeValueAndConversionMap);
        LOG.info("Finished initilization..");
    }

    private static void fillTemplates(String sourceDir, Expression root, String outputRuleTemplate, String outputRuleFile, XMLModel model) throws Exception {
        Properties props = new Properties();
        props.setProperty("file.resource.loader.path", sourceDir);
        VelocityEngine ve = new VelocityEngine(props);
        ve.init();
        OdfHelper.createOutputFileList(ve, outputRuleTemplate, outputRuleFile, model);
        LOG.info("output-files.xml created done.");
        LOG.fine("Processing output files... ");
        OdfHelper.processFileList(ve, root, outputRuleFile, model);
        LOG.fine("DONE.\n");
    }

    public static Expression loadSchemaODF10() throws Exception {
        return OdfHelper.loadSchema(new File(odf10RngFile));
    }

    public static Expression loadSchemaODF11() throws Exception {
        return OdfHelper.loadSchema(new File(odf11RngFile));
    }

    public static Expression loadSchemaODF12() throws Exception {
        return OdfHelper.loadSchema(new File(odf12RngFile));
    }

    public static Expression loadSchema(File rngFile) throws Exception {
        SAXParserFactoryImpl saxFactory = new SAXParserFactoryImpl();
        saxFactory.setNamespaceAware(true);
        saxFactory.setValidating(false);
        try {
            saxFactory.setXIncludeAware(false);
            saxFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception ex) {
            Logger.getLogger(OdfHelper.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException();
        }
        String absolutePath = rngFile.getAbsolutePath();
        IgnoreController ignoreController = new IgnoreController();
        Expression root = RELAXNGReader.parse((String)absolutePath, (SAXParserFactory)saxFactory, (GrammarReaderController)ignoreController).getTopLevel();
        if (root == null) {
            throw new Exception("Schema could not be parsed.");
        }
        return root;
    }

    private static VelocityContext getContext(String contextStr, String param) {
        VelocityContext context = new VelocityContext();
        context.put("oldmodel", (Object)mOdf11SchemaModel);
        context.put("odfmodel", (Object)mOdfModel);
        context.put("javamodel", (Object)mJavaModel);
        context.put("context", (Object)contextStr);
        context.put("param", (Object)param);
        return context;
    }

    private static void createOutputFileList(VelocityEngine ve, String template, String output, XMLModel model) throws Exception {
        VelocityContext context = OdfHelper.getContext(null, null);
        context.put("model", (Object)model);
        File parentPatch = new File(output).getParentFile();
        if (!parentPatch.exists()) {
            parentPatch.mkdirs();
        }
        FileWriter listout = new FileWriter(new File(output));
        String encoding = "utf-8";
        ve.mergeTemplate(template, encoding, (Context)context, (Writer)listout);
        listout.close();
    }

    private static String generateFilename(String rawName) {
        String retFilePath = null;
        StringTokenizer toktok = new StringTokenizer(rawName.replaceAll(":", "_"), "/");
        if (toktok.hasMoreTokens()) {
            File retfile = null;
            retfile = new File(toktok.nextToken());
            while (toktok.hasMoreTokens()) {
                retfile = new File(retfile, toktok.nextToken());
            }
            retFilePath = retfile.getPath();
        }
        return retFilePath;
    }

    private static void ensureParentFolders(File newFile) {
        File parent = newFile.getParentFile();
        if (parent != null && !parent.exists()) {
            try {
                parent.mkdirs();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not create parent directory {0}", parent.getAbsolutePath());
            }
        }
    }

    public static void processFileList(VelocityEngine ve, Expression root, String outputRuleFile, XMLModel model) throws Exception {
        File outputFiles = new File(outputRuleFile);
        List<OutputFileListEntry> fl = OutputFileListHandler.readFileListFile(outputFiles);
        for (OutputFileListEntry f : fl) {
            switch (f.getType()) {
                case PATH: {
                    break;
                }
                case FILE: {
                    LOG.log(Level.INFO, "Processing line {0}: Generating file {1}\n", new Object[]{f.getLineNumber(), OdfHelper.generateFilename(f.getAttribute("path"))});
                    String odfContextStr = f.getAttribute("context");
                    String param = f.getAttribute("param");
                    VelocityContext context = OdfHelper.getContext(odfContextStr, param);
                    if (context == null) {
                        throw new RuntimeException("Error in output-files.xml, line " + f.getLineNumber() + ": no or invalid odf-scope");
                    }
                    context.put("model", (Object)model);
                    File out = new File(outputRoot + File.separator + OdfHelper.generateFilename(f.getAttribute("path"))).getCanonicalFile();
                    LOG.info("Absolute path of generated file: " + out.getAbsolutePath());
                    OdfHelper.ensureParentFolders(out);
                    FileWriter fileout = new FileWriter(out);
                    String encoding = "utf-8";
                    ve.mergeTemplate(f.getAttribute("template"), encoding, (Context)context, (Writer)fileout);
                    fileout.close();
                }
            }
        }
    }

    static {
        INPUT_ROOT = "target" + File.separator + "odf-schemas";
        TEST_REFERENCE_DIR = "target" + File.separator + "test-classes" + File.separator + "examples" + File.separator + "odf";
        TEST_INPUT_ROOT = "target" + File.separator + "classes" + File.separator + "examples" + File.separator + "odf";
        REFERENCE_OUTPUT_FILES = "target" + File.separator + "reference-output-files.xml";
        PYTHON_OUTPUT_FILES = "target" + File.separator + "python-output-files.xml";
        DOM_OUTPUT_FILES = "target" + File.separator + "dom-output-files.xml";
        PKG_MANIFEST_OUTPUT_FILES = "target" + File.separator + "pkg-manifest-output-files.xml";
        PKG_DSIG_OUTPUT_FILES = "target" + File.separator + "pkg-dsig-output-files.xml";
        odfDomResourceDir = TEST_INPUT_ROOT + File.separator + "odfdom-java" + File.separator + "dom";
        odfPkgResourceDir = TEST_INPUT_ROOT + File.separator + "odfdom-java" + File.separator + "pkg";
        odfPythonResourceDir = TEST_INPUT_ROOT + File.separator + "odfdom-python";
        odfReferenceResourceDir = TEST_INPUT_ROOT + File.separator + "odf-reference";
        odfSchemaResourceDir = TEST_INPUT_ROOT + File.separator + "odf-schemas";
        odf12SignatureRngFile = odfSchemaResourceDir + File.separator + ODF12_SIGNATURE_RNG_FILE_NAME;
        odf12ManifestRngFile = odfSchemaResourceDir + File.separator + ODF12_MANIFEST_RNG_FILE_NAME;
        odf12RngFile = odfSchemaResourceDir + File.separator + ODF12_RNG_FILE_NAME;
        odf11RngFile = odfSchemaResourceDir + File.separator + ODF11_RNG_FILE_NAME;
        odf10RngFile = odfSchemaResourceDir + File.separator + ODF10_RNG_FILE_NAME;
        outputRoot = "target";
        mConfigFile = TEST_INPUT_ROOT + File.separator + "config.xml";
    }
}

