/*
 * Decompiled with CFR 0.152.
 */
package schema2template.model;

import com.sun.msv.grammar.Expression;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import schema2template.model.PuzzlePiece;
import schema2template.model.PuzzlePieceSet;
import schema2template.model.QNamed;
import schema2template.model.QNamedPuzzleComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLModel {
    PuzzlePieceSet mElements = new PuzzlePieceSet();
    PuzzlePieceSet mAttributes = new PuzzlePieceSet();
    Map<String, PuzzlePiece> mNameElementMap;
    Map<String, PuzzlePiece> mNameAttributeMap;

    public XMLModel(Expression root) {
        PuzzlePiece.extractPuzzlePieces(root, this.mElements, this.mAttributes);
        this.mElements.makeImmutable();
        this.mAttributes.makeImmutable();
        this.mNameElementMap = XMLModel.createMap(this.mElements);
        this.mNameAttributeMap = XMLModel.createMap(this.mAttributes);
    }

    private static Map<String, PuzzlePiece> createMap(Collection<PuzzlePiece> definitions) {
        HashMap<String, PuzzlePiece> retval = new HashMap<String, PuzzlePiece>();
        for (PuzzlePiece def : definitions) {
            retval.put(def.getQName(), def);
        }
        return retval;
    }

    public PuzzlePieceSet getElements() {
        return this.mElements;
    }

    public PuzzlePieceSet getAttributes() {
        return this.mAttributes;
    }

    public QNamedPuzzleComponent getElement(String name) {
        PuzzlePiece element = this.mNameElementMap.get(name);
        if (element == null) {
            return null;
        }
        return element.withMultiples();
    }

    public PuzzlePiece getElement(String name, int hashCode) {
        PuzzlePiece element = this.mNameElementMap.get(name);
        if (element == null) {
            return null;
        }
        for (PuzzlePiece def : element.withMultiples()) {
            if (def.hashCode() != hashCode) continue;
            return def;
        }
        return null;
    }

    public QNamedPuzzleComponent getAttribute(String name) {
        PuzzlePiece attribute = this.mNameAttributeMap.get(name);
        if (attribute == null) {
            return null;
        }
        return attribute.withMultiples();
    }

    public PuzzlePiece getAttribute(String name, int hashCode) {
        PuzzlePiece attribute = this.mNameAttributeMap.get(name);
        if (attribute == null) {
            return null;
        }
        for (PuzzlePiece def : attribute.withMultiples()) {
            if (def.hashCode() != hashCode) continue;
            return def;
        }
        return null;
    }

    public static String camelCase(String raw) {
        StringTokenizer tok = new StringTokenizer(raw, "-:/ _.,");
        String retval = "";
        while (tok.hasMoreElements()) {
            String word = tok.nextToken();
            if (word.equals("")) continue;
            retval = retval + word.substring(0, 1).toUpperCase() + word.substring(1);
        }
        return retval;
    }

    public static String camelCase(QNamed def) {
        return XMLModel.camelCase(def.getQName());
    }

    public static String javaCase(String raw) {
        String retval = XMLModel.camelCase(raw);
        if (retval.length() > 0) {
            retval = retval.substring(0, 1).toLowerCase().concat(retval.substring(1));
        }
        return retval;
    }

    public static String javaCase(QNamed def) {
        return XMLModel.javaCase(def.getQName());
    }

    public static String constantCase(String raw) {
        StringTokenizer tok = new StringTokenizer(raw, "-:/ _.,");
        String retval = "";
        String separator = "";
        while (tok.hasMoreElements()) {
            String word = tok.nextToken();
            if (word.equals("")) continue;
            retval = retval + separator + word.toUpperCase();
            separator = "_";
        }
        return retval;
    }

    public static String constantCase(QNamed def) {
        return XMLModel.constantCase(def.getQName());
    }

    public static String firstWord(String raw) {
        StringTokenizer tok = new StringTokenizer(raw, "-:/ _.,");
        if (tok.hasMoreElements()) {
            return tok.nextToken();
        }
        return null;
    }

    public static String firstWord(QNamed def) {
        return XMLModel.firstWord(def.getQName());
    }

    public static String lastWord(String raw) {
        StringTokenizer tok = new StringTokenizer(raw, "-:/ _.,");
        String retval = null;
        while (tok.hasMoreElements()) {
            retval = tok.nextToken();
        }
        return retval;
    }

    public static String lastWord(QNamed def) {
        return XMLModel.lastWord(def.getQName());
    }

    public static String escapeKeyword(QNamed in) {
        return XMLModel.escapeKeyword(in.getQName());
    }

    public static String escapeKeyword(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        String out = in;
        if (out.substring(0, 1).matches("^\\p{Digit}")) {
            out = "_" + out;
        }
        return out;
    }

    public static String escapeLiteral(QNamed in) {
        return XMLModel.escapeLiteral(in.getQName());
    }

    public static String escapeLiteral(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        String out = in;
        out = out.replaceAll("\"", "\\\\\"");
        return out;
    }

    public static String extractNamespace(String name) {
        int pos = name.lastIndexOf(":");
        if (pos > 0 && pos < name.length() - 1) {
            return name.substring(0, pos);
        }
        return null;
    }

    public static String extractNamespace(QNamed def) {
        return XMLModel.extractNamespace(def.getQName());
    }

    public static String extractLocalname(String name) {
        int pos = name.lastIndexOf(":");
        if (pos > 0 && pos < name.length() - 1) {
            return name.substring(pos + 1);
        }
        return null;
    }

    public static String extractLocalname(QNamed def) {
        return XMLModel.extractLocalname(def.getQName());
    }
}

