/*
 * Decompiled with CFR 0.152.
 */
package schema2template.example.odf;

import com.sun.msv.grammar.Expression;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.trex.ng.RELAXNGReader;
import com.sun.msv.reader.util.IgnoreController;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import schema2template.OutputFileListEntry;
import schema2template.OutputFileListHandler;
import schema2template.example.odf.OdfConfigFileHandler;
import schema2template.example.odf.OdfModel;
import schema2template.example.odf.SourceCodeModel;
import schema2template.model.XMLModel;

public class OdfCodegen {
    private static final Logger mLog = Logger.getLogger(OdfCodegen.class.getName());
    private final String odfResourceDir;
    private final String sourceCodeRoot;
    private final String odf12RngFile;
    private final String odf11RngFile;
    private final String configFile;
    private static final String OUTPUT_FILES_TEMPLATE = "output-files.vm";
    private static final String OUTPUT_FILES = "target" + File.separator + "output-files.xml";
    private XMLModel mOdf12SchemaModel;
    private XMLModel mOdf11SchemaModel;
    private OdfModel mOdfModel;
    private SourceCodeModel mJavaModel;

    public OdfCodegen(String resourceRoot, String targetRoot, String odf12SchemaFile, String odf11SchemaFile, String configFile) {
        this.odfResourceDir = resourceRoot;
        this.sourceCodeRoot = targetRoot;
        this.odf12RngFile = odf12SchemaFile;
        this.odf11RngFile = odf11SchemaFile;
        this.configFile = configFile;
    }

    public OdfCodegen() {
        this.odfResourceDir = "target" + File.separator + "classes" + File.separator + "examples" + File.separator + "odf" + File.separator + "odfdom-java";
        this.odf12RngFile = "target" + File.separator + "classes" + File.separator + "examples" + File.separator + "odf" + File.separator + "OpenDocument-schema-v1.2-cd04.rng";
        this.odf11RngFile = "target" + File.separator + "classes" + File.separator + "examples" + File.separator + "odf" + File.separator + "OpenDocument-schema-v1.1.rng";
        this.configFile = "target" + File.separator + "classes" + File.separator + "examples" + File.separator + "odf" + File.separator + "config.xml";
        this.sourceCodeRoot = this.odfResourceDir;
    }

    public static void main(String[] args) throws Exception {
        new OdfCodegen().start();
    }

    public void start() throws Exception {
        Expression odf12Root = this.loadSchema(new File(this.odf12RngFile));
        Expression odf11Root = this.loadSchema(new File(this.odf11RngFile));
        HashMap<String, String> elementToBaseNameMap = new HashMap<String, String>();
        HashMap<String, List<String>> elementStyleFamiliesMap = new HashMap<String, List<String>>();
        HashMap<String, String[]> datatypeValueAndConversionMap = new HashMap<String, String[]>();
        HashMap<String, OdfModel.AttributeDefaults> attributeDefaultMap = new HashMap<String, OdfModel.AttributeDefaults>();
        OdfConfigFileHandler.readConfigFile(new File(this.configFile), elementToBaseNameMap, attributeDefaultMap, elementStyleFamiliesMap, datatypeValueAndConversionMap);
        this.mOdf12SchemaModel = new XMLModel(odf12Root);
        this.mOdf11SchemaModel = new XMLModel(odf11Root);
        this.mOdfModel = new OdfModel(elementStyleFamiliesMap, attributeDefaultMap);
        this.mJavaModel = new SourceCodeModel(this.mOdf12SchemaModel, this.mOdfModel, elementToBaseNameMap, datatypeValueAndConversionMap);
        this.fillTemplates(this.odfResourceDir, odf12Root);
    }

    private void fillTemplates(String sourceDir, Expression root) throws Exception {
        Properties props = new Properties();
        props.setProperty("file.resource.loader.path", sourceDir);
        VelocityEngine ve = new VelocityEngine(props);
        ve.init();
        this.createOutputFileList(ve, root);
        mLog.info("DONE.\n");
        mLog.fine("Processing output files... ");
        this.processFileList(ve, root);
        mLog.fine("DONE.\n");
    }

    public Expression loadSchema(File rngFile) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        Expression root = RELAXNGReader.parse((String)rngFile.getAbsolutePath(), (SAXParserFactory)factory, (GrammarReaderController)new IgnoreController()).getTopLevel();
        if (root == null) {
            throw new Exception("Schema could not be parsed.");
        }
        return root;
    }

    private VelocityContext getContext(String contextStr, String param) {
        VelocityContext context = new VelocityContext();
        context.put("model", (Object)this.mOdf12SchemaModel);
        context.put("oldmodel", (Object)this.mOdf11SchemaModel);
        context.put("odfmodel", (Object)this.mOdfModel);
        context.put("javamodel", (Object)this.mJavaModel);
        context.put("context", (Object)contextStr);
        context.put("param", (Object)param);
        return context;
    }

    private void createOutputFileList(VelocityEngine ve, Expression root) throws Exception {
        VelocityContext context = this.getContext(null, null);
        File parentPatch = new File(OUTPUT_FILES).getParentFile();
        if (!parentPatch.exists()) {
            parentPatch.mkdirs();
        }
        FileWriter listout = new FileWriter(new File(OUTPUT_FILES));
        String encoding = "utf-8";
        ve.mergeTemplate(OUTPUT_FILES_TEMPLATE, encoding, (Context)context, (Writer)listout);
        listout.close();
    }

    private String generateFilename(String rawName) {
        File retfile = new File(".");
        StringTokenizer toktok = new StringTokenizer(rawName.replaceAll(":", "_"), "/");
        while (toktok.hasMoreTokens()) {
            retfile = new File(retfile, toktok.nextToken());
        }
        return retfile.getPath();
    }

    private void ensureParentFolders(File newFile) {
        File parent = newFile.getParentFile();
        if (parent != null && !parent.exists()) {
            try {
                parent.mkdirs();
            }
            catch (Exception e) {
                mLog.log(Level.WARNING, "Could not create parent directory {0}", parent.getAbsolutePath());
            }
        }
    }

    public void processFileList(VelocityEngine ve, Expression root) throws Exception {
        File outputFiles = new File(OUTPUT_FILES);
        List<OutputFileListEntry> fl = OutputFileListHandler.readFileListFile(outputFiles);
        for (OutputFileListEntry f : fl) {
            switch (f.getType()) {
                case PATH: {
                    break;
                }
                case FILE: {
                    mLog.log(Level.INFO, "Processing line{0}: Generating file {1}\n", new Object[]{f.getLineNumber(), this.generateFilename(f.getAttribute("path"))});
                    String odfContextStr = f.getAttribute("context");
                    String param = f.getAttribute("param");
                    VelocityContext context = this.getContext(odfContextStr, param);
                    if (context == null) {
                        throw new RuntimeException("Error in output-files.xml, line " + f.getLineNumber() + ": no or invalid odf-scope");
                    }
                    File out = new File(this.sourceCodeRoot + this.generateFilename(f.getAttribute("path"))).getCanonicalFile();
                    this.ensureParentFolders(out);
                    FileWriter fileout = new FileWriter(out);
                    String encoding = "utf-8";
                    ve.mergeTemplate(f.getAttribute("template"), encoding, (Context)context, (Writer)fileout);
                    fileout.close();
                }
            }
        }
    }
}

