/*
 * Decompiled with CFR 0.152.
 */
package schema2template.template;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import schema2template.template.FileCreationListEntry;

public class FileCreationListHandler
extends DefaultHandler {
    List<FileCreationListEntry> mFilelist;
    boolean mOpenFlTag = false;
    boolean mOpenFileTag = false;
    Locator mLocator;

    FileCreationListHandler(List<FileCreationListEntry> fl) {
        this.mFilelist = fl;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.mLocator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("file-creation-list") && !this.mOpenFlTag) {
            this.mOpenFlTag = true;
            return;
        }
        if (qName.equals("file") && this.mOpenFlTag && !this.mOpenFileTag) {
            this.mOpenFileTag = true;
            FileCreationListEntry entry = new FileCreationListEntry(FileCreationListEntry.EntryType.FILE, this.mLocator.getLineNumber());
            String mandatoryPath = attributes.getValue("path");
            if (mandatoryPath == null) {
                throw new SAXException("Mandatory attribute path is missing for file element in line " + this.mLocator.getLineNumber() + ".");
            }
            entry.setAttribute("path", mandatoryPath);
            entry.setAttribute("contextNode", attributes.getValue("contextNode"));
            entry.setAttribute("param", attributes.getValue("param"));
            entry.setAttribute("template", attributes.getValue("template"));
            this.mFilelist.add(entry);
            return;
        }
        throw new SAXException("Malformed file-creation-list");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("file-creation-list") && this.mOpenFlTag && !this.mOpenFileTag) {
            this.mOpenFlTag = false;
            return;
        }
        if (qName.equals("file") && this.mOpenFlTag && this.mOpenFileTag) {
            this.mOpenFileTag = false;
            return;
        }
        throw new SAXException("Malformed file-creation-list");
    }

    public static List<FileCreationListEntry> readFileListFile(File flf) throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        ArrayList<FileCreationListEntry> retval = new ArrayList<FileCreationListEntry>();
        parser.parse(flf, (DefaultHandler)new FileCreationListHandler(retval));
        return retval;
    }
}

