/*
 * Decompiled with CFR 0.152.
 */
package schema2template.grammar;

import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.grammar.trex.TREXGrammar;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.trex.ng.RELAXNGReader;
import com.sun.msv.reader.util.IgnoreController;
import com.sun.msv.reader.xmlschema.XMLSchemaReader;
import com.sun.msv.writer.relaxng.RELAXNGWriter;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import schema2template.grammar.PuzzleComponent;
import schema2template.grammar.PuzzlePiece;
import schema2template.grammar.PuzzlePieceSet;

public class XMLModel {
    private static final Logger LOG = Logger.getLogger(XMLModel.class.getName());
    PuzzlePieceSet mElements = new PuzzlePieceSet();
    PuzzlePieceSet mAttributes = new PuzzlePieceSet();
    private Map<String, SortedSet<PuzzlePiece>> elementNameToPuzzlePieces;
    private Map<String, SortedSet<PuzzlePiece>> attributeNameToPuzzlePieces;
    Map<String, PuzzlePiece> mNameElementMap;
    Map<String, PuzzlePiece> mNameAttributeMap;
    public Expression mRootExpression;
    private Grammar mGrammar;
    public String mLastSchemaFileName;
    private String mGrammarID;
    private String mGrammarVersion;

    public XMLModel(File schemaFile) {
        this(schemaFile, null, null);
    }

    public XMLModel(File schemaFile, String grammarVersion, String grammarID) {
        this.mGrammarVersion = grammarVersion;
        this.mGrammarID = grammarID;
        this.mGrammar = XMLModel.loadSchema(schemaFile);
        this.mRootExpression = this.mGrammar.getTopLevel();
        String absolutePath = schemaFile.getAbsolutePath();
        this.mLastSchemaFileName = absolutePath.substring(absolutePath.lastIndexOf(File.separatorChar) + 1, absolutePath.length());
        PuzzlePiece.extractPuzzlePieces(this.mGrammar, this.mElements, this.mAttributes, this.mLastSchemaFileName);
        this.mElements.makeImmutable();
        this.mAttributes.makeImmutable();
        this.mNameElementMap = XMLModel.createMap(this.mElements);
        this.mNameAttributeMap = XMLModel.createMap(this.mAttributes);
    }

    public SortedSet<PuzzlePiece> getElements(String qName) {
        if (this.elementNameToPuzzlePieces == null) {
            this.elementNameToPuzzlePieces = XMLModel.createMapQNameToPuzzlePiece(new TreeSet<PuzzlePiece>(this.getElements()));
        }
        return this.elementNameToPuzzlePieces.get(qName);
    }

    public SortedSet<PuzzlePiece> getAttributes(String qName) {
        if (this.attributeNameToPuzzlePieces == null) {
            this.attributeNameToPuzzlePieces = XMLModel.createMapQNameToPuzzlePiece(new TreeSet<PuzzlePiece>(this.getElements()));
        }
        return this.attributeNameToPuzzlePieces.get(qName);
    }

    private static Map<String, SortedSet<PuzzlePiece>> createMapQNameToPuzzlePiece(Set<PuzzlePiece> definitions) {
        HashMap<String, SortedSet<PuzzlePiece>> retval = new HashMap<String, SortedSet<PuzzlePiece>>();
        for (PuzzlePiece def : definitions) {
            SortedSet multiples = retval.computeIfAbsent(def.getQName(), k -> new TreeSet());
            multiples.add(def);
        }
        return retval;
    }

    public Grammar getGrammar() {
        return this.mGrammar;
    }

    public String getGrammarVersion() {
        return this.mGrammarVersion;
    }

    public String getGrammarID() {
        return this.mGrammarID;
    }

    private static Map<String, PuzzlePiece> createMap(Collection<PuzzlePiece> definitions) {
        HashMap<String, PuzzlePiece> retval = new HashMap<String, PuzzlePiece>();
        for (PuzzlePiece def : definitions) {
            retval.put(def.getQName(), def);
        }
        return retval;
    }

    static Map<String, SortedSet<PuzzlePiece>> createDefinitionMap(Collection<PuzzlePiece> definitions) {
        HashMap<String, SortedSet<PuzzlePiece>> retval = new HashMap<String, SortedSet<PuzzlePiece>>();
        for (PuzzlePiece def : definitions) {
            SortedSet multiples = retval.computeIfAbsent(def.getQName(), k -> new TreeSet());
            multiples.add(def);
        }
        return retval;
    }

    public static Grammar loadSchema(File rngFile) {
        return XMLModel.loadSchema(rngFile.getAbsolutePath());
    }

    public static Grammar loadSchema(String rngFilePath) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        IgnoreController ignoreController = new IgnoreController();
        TREXGrammar grammar = null;
        if (rngFilePath.endsWith(".rng")) {
            try {
                grammar = RELAXNGReader.parse((String)rngFilePath, (SAXParserFactory)factory, (GrammarReaderController)ignoreController);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        } else if (rngFilePath.endsWith(".xsd")) {
            grammar = XMLSchemaReader.parse((String)rngFilePath, (SAXParserFactory)factory, (GrammarReaderController)ignoreController);
        } else {
            throw new RuntimeException("Reader not chosen for given schema suffix!");
        }
        if (grammar == null) {
            throw new RuntimeException("Schema could not be parsed.");
        }
        return grammar;
    }

    public static void writeGrammar(Grammar g, OutputStream out) throws SAXException {
        RELAXNGWriter writer = new RELAXNGWriter();
        writer.setDocumentHandler((DocumentHandler)new XMLSerializer(out, new OutputFormat("xml", null, true)));
        writer.write(g);
    }

    public PuzzlePieceSet getElements() {
        return this.mElements;
    }

    public PuzzlePieceSet getAttributes() {
        return this.mAttributes;
    }

    public PuzzleComponent getElement(String name) {
        PuzzlePiece element = this.mNameElementMap.get(name);
        if (element == null) {
            return null;
        }
        return element.withMultiples();
    }

    public PuzzlePiece getElement(String name, int hashCode) {
        PuzzlePiece element = this.mNameElementMap.get(name);
        if (element == null) {
            return null;
        }
        for (PuzzlePiece def : element.withMultiples()) {
            if (def.hashCode() != hashCode) continue;
            return def;
        }
        return null;
    }

    public PuzzleComponent getAttribute(String name) {
        PuzzlePiece attribute = this.mNameAttributeMap.get(name);
        if (attribute == null) {
            return null;
        }
        return attribute.withMultiples();
    }

    public PuzzlePiece getAttribute(String name, int hashCode) {
        PuzzlePiece attribute = this.mNameAttributeMap.get(name);
        if (attribute == null) {
            return null;
        }
        for (PuzzlePiece def : attribute.withMultiples()) {
            if (def.hashCode() != hashCode) continue;
            return def;
        }
        return null;
    }

    public static String camelCase(String raw) {
        StringTokenizer tok = new StringTokenizer(raw, "-:/ _.,");
        Object retval = "";
        while (tok.hasMoreElements()) {
            String word = tok.nextToken();
            if (word.equals("")) continue;
            retval = (String)retval + word.substring(0, 1).toUpperCase() + word.substring(1);
        }
        return retval;
    }

    public static String camelCase(PuzzleComponent def) {
        return XMLModel.camelCase(def.getQName());
    }

    public static String javaCase(String raw) {
        String retval = XMLModel.camelCase(raw);
        if (retval.length() > 0) {
            retval = retval.substring(0, 1).toLowerCase().concat(retval.substring(1));
        }
        return retval;
    }

    public static String javaCase(PuzzleComponent def) {
        return XMLModel.javaCase(def.getQName());
    }

    public static String constantCase(String raw) {
        StringTokenizer tok = new StringTokenizer(raw, "-:/ _.,");
        Object retval = "";
        String separator = "";
        while (tok.hasMoreElements()) {
            String word = tok.nextToken();
            if (word.equals("")) continue;
            retval = (String)retval + separator + word.toUpperCase();
            separator = "_";
        }
        return retval;
    }

    public static String constantCase(PuzzleComponent def) {
        return XMLModel.constantCase(def.getQName());
    }

    public static String firstWord(String raw) {
        StringTokenizer tok = new StringTokenizer(raw, "-:/ _.,");
        if (tok.hasMoreElements()) {
            return tok.nextToken();
        }
        return null;
    }

    public static String firstWord(PuzzleComponent def) {
        return XMLModel.firstWord(def.getQName());
    }

    public static String lastWord(String raw) {
        StringTokenizer tok = new StringTokenizer(raw, "-:/ _.,");
        String retval = null;
        while (tok.hasMoreElements()) {
            retval = tok.nextToken();
        }
        return retval;
    }

    public static String lastWord(PuzzleComponent def) {
        return XMLModel.lastWord(def.getQName());
    }

    public static String escapeKeyword(PuzzleComponent in) {
        return XMLModel.escapeKeyword(in.getQName());
    }

    public static String escapeKeyword(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        Object out = in;
        if (((String)out).substring(0, 1).matches("^\\p{Digit}")) {
            out = "_" + (String)out;
        }
        return out;
    }

    public static String escapeLiteral(PuzzleComponent in) {
        return XMLModel.escapeLiteral(in.getQName());
    }

    public static String escapeLiteral(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        String out = in;
        out = out.replaceAll("\"", "\\\\\"");
        return out;
    }

    public static String extractNamespacePrefix(String name) {
        int pos = name.lastIndexOf(":");
        if (pos > 0 && pos < name.length() - 1) {
            return name.substring(0, pos);
        }
        return null;
    }

    public static String extractNamespacePrefix(PuzzleComponent def) {
        return XMLModel.extractNamespacePrefix(def.getQName());
    }

    public static String extractLocalName(String name) {
        int pos = name.lastIndexOf(":");
        if (pos > 0 && pos < name.length() - 1) {
            return name.substring(pos + 1);
        }
        if (pos < 0 && name.length() > 0) {
            return name;
        }
        return null;
    }

    public static String extractLocalName(PuzzleComponent def) {
        return XMLModel.extractLocalName(def.getQName());
    }
}

