/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.odftoolkit.odfdom.changes.CachedComponent;
import org.odftoolkit.odfdom.changes.ChangesFileSaxHandler;
import org.odftoolkit.odfdom.changes.ShapeType;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;

public class ShapeProperties
extends CachedComponent {
    private static final long serialVersionUID = 1L;
    DrawFrameElement mDrawFrameElement = null;
    public List<Integer> mShapePosition = null;
    public Map<String, Object> mShapeHardFormatations = null;
    List<OdfElement> mFrameChildren = null;
    int mFrameChildrenNumber = 0;
    boolean mIsImageFrame = false;
    boolean mIsGroup = false;
    public Integer mVertOffsetMin = null;
    public Integer mHoriOffsetMin = null;
    public Integer mVertOffsetMax = null;
    public Integer mHoriOffsetMax = null;
    public Node mOwnNode = null;
    public String mDescription = null;
    public String mContext = null;

    public DrawFrameElement getDrawFrameElement() {
        return this.mDrawFrameElement;
    }

    public ShapeProperties(List<Integer> start, Map<String, Object> hardFormatations) {
        this.mShapePosition = new LinkedList<Integer>(start);
        if (hardFormatations != null) {
            this.mShapeHardFormatations = new HashMap<String, Object>();
            this.mShapeHardFormatations.putAll(hardFormatations);
            JSONObject originalDrawingProps = (JSONObject)hardFormatations.get("drawing");
            JSONObject newDrawingProps = new JSONObject();
            if (originalDrawingProps != null) {
                for (String key : originalDrawingProps.keySet()) {
                    try {
                        newDrawingProps.put(key, originalDrawingProps.get(key));
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(ShapeProperties.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.mShapeHardFormatations.put("drawing", newDrawingProps);
            }
            JSONObject originalImageProps = (JSONObject)hardFormatations.get("image");
            JSONObject newImageProps = new JSONObject();
            if (originalImageProps != null) {
                for (String key : originalImageProps.keySet()) {
                    try {
                        newImageProps.put(key, originalImageProps.get(key));
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(ShapeProperties.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.mShapeHardFormatations.put("image", newImageProps);
            }
        }
    }

    public void createShapeOperation(ChangesFileSaxHandler saxHandler, Stack<CachedComponent> mComponentStack, String desc, ShapeType shapeType, String context) {
        CachedComponent parentComponent;
        JSONObject drawingProps;
        if (desc != null && !desc.isEmpty()) {
            JSONObject drawingProps2 = (JSONObject)this.mShapeHardFormatations.get("drawing");
            try {
                drawingProps2.put("description", (Object)desc);
            }
            catch (JSONException ex) {
                Logger.getLogger(ShapeProperties.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.isGroupShape()) {
            try {
                drawingProps = (JSONObject)this.mShapeHardFormatations.get("drawing");
                if (this.mVertOffsetMin != null) {
                    drawingProps.put("anchorVertOffset", (Object)this.mVertOffsetMin);
                    if (this.mVertOffsetMax != null) {
                        drawingProps.put("height", this.mVertOffsetMax - this.mVertOffsetMin);
                    }
                }
                if (this.mHoriOffsetMin != null) {
                    drawingProps.put("anchorHorOffset", (Object)this.mHoriOffsetMin);
                    if (this.mHoriOffsetMax != null) {
                        drawingProps.put("width", this.mHoriOffsetMax - this.mHoriOffsetMin);
                    }
                }
            }
            catch (JSONException ex) {
                Logger.getLogger(ShapeProperties.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!mComponentStack.empty() && (parentComponent = mComponentStack.peek()) instanceof ShapeProperties && ((ShapeProperties)parentComponent).isGroupShape()) {
            drawingProps = (JSONObject)this.mShapeHardFormatations.get("drawing");
            ((ShapeProperties)parentComponent).addMemberPosSize(drawingProps.opt("anchorHorOffset"), drawingProps.opt("anchorVertOffset"), drawingProps.opt("width"), drawingProps.opt("height"));
        }
        if (this.getDrawFrameElement() != null) {
            Object fill = this.mShapeHardFormatations.get("fill");
            try {
                if (fill == null) {
                    fill = new JSONObject((Object)1);
                    this.mShapeHardFormatations.put("fill", fill);
                    ((JSONObject)fill).put("color", (Object)"ffffff");
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        switch (shapeType) {
            case ImageShape: {
                saxHandler.cacheOperation(false, "Image", this.mShapePosition, false, this.mShapeHardFormatations, context);
                break;
            }
            case NormalShape: {
                if (this.mShapeHardFormatations.get("styleId") == null) {
                    Object lineObject = this.mShapeHardFormatations.get("line");
                    try {
                        if (lineObject == null) {
                            lineObject = new JSONObject((Object)1);
                            this.mShapeHardFormatations.put("line", lineObject);
                        }
                        if (!((JSONObject)lineObject).has("style")) {
                            ((JSONObject)lineObject).put("type", (Object)"solid");
                            ((JSONObject)lineObject).put("width", 1);
                            ((JSONObject)lineObject).put("style", (Object)"solid");
                        }
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                saxHandler.cacheOperation(false, "Shape", this.mShapePosition, false, this.mShapeHardFormatations, context);
                break;
            }
            case GroupShape: {
                saxHandler.cacheOperation(false, "Group", this.mShapePosition, false, this.mShapeHardFormatations, context);
            }
        }
    }

    public void setDrawFrameElement(DrawFrameElement drawFrameElement) {
        this.mDrawFrameElement = drawFrameElement;
    }

    public Map<String, Object> getShapeHardFormatting() {
        return this.mShapeHardFormatations;
    }

    public boolean hasImageSibling() {
        return this.mIsImageFrame;
    }

    public void declareImage() {
        this.mIsImageFrame = true;
    }

    public void setGroupShape() {
        this.mIsGroup = true;
    }

    public boolean isGroupShape() {
        return this.mIsGroup;
    }

    public void addMemberPosSize(Object horiOffset, Object vertOffset, Object width, Object height) {
        if (vertOffset != null) {
            this.mVertOffsetMin = this.mVertOffsetMin == null ? (Integer)vertOffset : Integer.valueOf(Math.min(this.mVertOffsetMin, (Integer)vertOffset));
        }
        if (horiOffset != null) {
            this.mHoriOffsetMin = this.mHoriOffsetMin == null ? (Integer)horiOffset : Integer.valueOf(Math.min(this.mHoriOffsetMin, (Integer)horiOffset));
        }
        if (width != null) {
            Integer maxHori = (Integer)width;
            if (horiOffset != null) {
                maxHori = maxHori + (Integer)horiOffset;
            }
            this.mHoriOffsetMax = this.mHoriOffsetMax == null ? maxHori : Integer.valueOf(Math.max(this.mHoriOffsetMax, maxHori));
        }
        if (height != null) {
            Integer maxVert = (Integer)height;
            if (vertOffset != null) {
                maxVert = maxVert + (Integer)vertOffset;
            }
            this.mVertOffsetMax = this.mVertOffsetMax == null ? maxVert : Integer.valueOf(Math.max(this.mVertOffsetMax, maxVert));
        }
    }

    public int incrementChildNumber() {
        return ++this.mFrameChildrenNumber;
    }

    public int decrementChildNumber() {
        return --this.mFrameChildrenNumber;
    }

    public int getChildNumber() {
        return this.mFrameChildrenNumber;
    }
}

