/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeMimetypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeVersionAttribute;
import org.odftoolkit.odfdom.dom.attribute.grddl.GrddlTransformationAttribute;

import org.odftoolkit.odfdom.dom.element.meta.MetaGeneratorElement;
import org.odftoolkit.odfdom.dom.element.dc.DcTitleElement;
import org.odftoolkit.odfdom.dom.element.dc.DcDescriptionElement;
import org.odftoolkit.odfdom.dom.element.dc.DcSubjectElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaKeywordElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaInitialCreatorElement;
import org.odftoolkit.odfdom.dom.element.dc.DcCreatorElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaPrintedByElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaCreationDateElement;
import org.odftoolkit.odfdom.dom.element.dc.DcDateElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaPrintDateElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaTemplateElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaAutoReloadElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaHyperlinkBehaviourElement;
import org.odftoolkit.odfdom.dom.element.dc.DcLanguageElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaEditingCyclesElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaEditingDurationElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaDocumentStatisticElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaUserDefinedElement;
import org.odftoolkit.odfdom.dom.element.config.ConfigConfigItemSetElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFontFaceElement;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.element.text.TextListStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberCurrencyStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberPercentageStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberDateStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTimeStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberBooleanStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleDefaultStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleDefaultPageLayoutElement;
import org.odftoolkit.odfdom.dom.element.text.TextOutlineStyleElement;
import org.odftoolkit.odfdom.dom.element.text.TextNotesConfigurationElement;
import org.odftoolkit.odfdom.dom.element.text.TextBibliographyConfigurationElement;
import org.odftoolkit.odfdom.dom.element.text.TextLinenumberingConfigurationElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawGradientElement;
import org.odftoolkit.odfdom.dom.element.svg.SvgLinearGradientElement;
import org.odftoolkit.odfdom.dom.element.svg.SvgRadialGradientElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawHatchElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawFillImageElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawMarkerElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawStrokeDashElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawOpacityElement;
import org.odftoolkit.odfdom.dom.element.style.StylePresentationPageLayoutElement;
import org.odftoolkit.odfdom.dom.element.style.StylePageLayoutElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHandoutMasterElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawLayerSetElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableTemplateElement;

/**
 * DOM implementation of OpenDocument element  {@odf.element office:document}.
 *
 */
public class OfficeDocumentElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.OFFICE, "document" );


	/**
	 * Create the instance of <code>OfficeDocumentElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public OfficeDocumentElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element office:document}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

	/**
	 * Initialization of the mandatory attributes of {@link  OfficeDocumentElement}
	 *
     * @param officeMimetypeAttributeValue  The mandatory attribute {@odf.attribute  office:mimetype}"
     * @param officeVersionAttributeValue  The mandatory attribute {@odf.attribute  office:version}"
     *
	 */
	public void init(String officeMimetypeAttributeValue, String officeVersionAttributeValue)
	{
		setOfficeMimetypeAttribute( officeMimetypeAttributeValue );
		setOfficeVersionAttribute( officeVersionAttributeValue );
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>OfficeMimetypeAttribute</code> , See {@odf.attribute office:mimetype}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getOfficeMimetypeAttribute()
	{
		OfficeMimetypeAttribute attr = (OfficeMimetypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.OFFICE), "mimetype" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>OfficeMimetypeAttribute</code> , See {@odf.attribute office:mimetype}
	 *
	 * @param officeMimetypeValue   The type is <code>String</code>
	 */
	public void setOfficeMimetypeAttribute( String officeMimetypeValue )
	{
		OfficeMimetypeAttribute attr =  new OfficeMimetypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( officeMimetypeValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>OfficeVersionAttribute</code> , See {@odf.attribute office:version}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getOfficeVersionAttribute()
	{
		OfficeVersionAttribute attr = (OfficeVersionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.OFFICE), "version" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>OfficeVersionAttribute</code> , See {@odf.attribute office:version}
	 *
	 * @param officeVersionValue   The type is <code>String</code>
	 */
	public void setOfficeVersionAttribute( String officeVersionValue )
	{
		OfficeVersionAttribute attr =  new OfficeVersionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( officeVersionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>GrddlTransformationAttribute</code> , See {@odf.attribute grddl:transformation}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getGrddlTransformationAttribute()
	{
		GrddlTransformationAttribute attr = (GrddlTransformationAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.GRDDL), "transformation" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>GrddlTransformationAttribute</code> , See {@odf.attribute grddl:transformation}
	 *
	 * @param grddlTransformationValue   The type is <code>String</code>
	 */
	public void setGrddlTransformationAttribute( String grddlTransformationValue )
	{
		GrddlTransformationAttribute attr =  new GrddlTransformationAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( grddlTransformationValue );
	}

	/**
	 * Create child element {@odf.element meta:generator}.
	 *
	 * @return   return  the element {@odf.element meta:generator}
	 * DifferentQName 
	 */
	public MetaGeneratorElement newMetaGeneratorElement()
	{
		MetaGeneratorElement  metaGenerator = ((OdfFileDom)this.ownerDocument).newOdfElement(MetaGeneratorElement.class);
		this.appendChild( metaGenerator);
		return  metaGenerator;
	}                   
               
	/**
	 * Create child element {@odf.element dc:title}.
	 *
	 * @return   return  the element {@odf.element dc:title}
	 * DifferentQName 
	 */
	public DcTitleElement newDcTitleElement()
	{
		DcTitleElement  dcTitle = ((OdfFileDom)this.ownerDocument).newOdfElement(DcTitleElement.class);
		this.appendChild( dcTitle);
		return  dcTitle;
	}                   
               
	/**
	 * Create child element {@odf.element dc:description}.
	 *
	 * @return   return  the element {@odf.element dc:description}
	 * DifferentQName 
	 */
	public DcDescriptionElement newDcDescriptionElement()
	{
		DcDescriptionElement  dcDescription = ((OdfFileDom)this.ownerDocument).newOdfElement(DcDescriptionElement.class);
		this.appendChild( dcDescription);
		return  dcDescription;
	}                   
               
	/**
	 * Create child element {@odf.element dc:subject}.
	 *
	 * @return   return  the element {@odf.element dc:subject}
	 * DifferentQName 
	 */
	public DcSubjectElement newDcSubjectElement()
	{
		DcSubjectElement  dcSubject = ((OdfFileDom)this.ownerDocument).newOdfElement(DcSubjectElement.class);
		this.appendChild( dcSubject);
		return  dcSubject;
	}                   
               
	/**
	 * Create child element {@odf.element meta:keyword}.
	 *
	 * @return   return  the element {@odf.element meta:keyword}
	 * DifferentQName 
	 */
	public MetaKeywordElement newMetaKeywordElement()
	{
		MetaKeywordElement  metaKeyword = ((OdfFileDom)this.ownerDocument).newOdfElement(MetaKeywordElement.class);
		this.appendChild( metaKeyword);
		return  metaKeyword;
	}                   
               
	/**
	 * Create child element {@odf.element meta:initial-creator}.
	 *
	 * @return   return  the element {@odf.element meta:initial-creator}
	 * DifferentQName 
	 */
	public MetaInitialCreatorElement newMetaInitialCreatorElement()
	{
		MetaInitialCreatorElement  metaInitialCreator = ((OdfFileDom)this.ownerDocument).newOdfElement(MetaInitialCreatorElement.class);
		this.appendChild( metaInitialCreator);
		return  metaInitialCreator;
	}                   
               
	/**
	 * Create child element {@odf.element dc:creator}.
	 *
	 * @return   return  the element {@odf.element dc:creator}
	 * DifferentQName 
	 */
	public DcCreatorElement newDcCreatorElement()
	{
		DcCreatorElement  dcCreator = ((OdfFileDom)this.ownerDocument).newOdfElement(DcCreatorElement.class);
		this.appendChild( dcCreator);
		return  dcCreator;
	}                   
               
	/**
	 * Create child element {@odf.element meta:printed-by}.
	 *
	 * @return   return  the element {@odf.element meta:printed-by}
	 * DifferentQName 
	 */
	public MetaPrintedByElement newMetaPrintedByElement()
	{
		MetaPrintedByElement  metaPrintedBy = ((OdfFileDom)this.ownerDocument).newOdfElement(MetaPrintedByElement.class);
		this.appendChild( metaPrintedBy);
		return  metaPrintedBy;
	}                   
               
	/**
	 * Create child element {@odf.element meta:creation-date}.
	 *
	 * @return   return  the element {@odf.element meta:creation-date}
	 * DifferentQName 
	 */
	public MetaCreationDateElement newMetaCreationDateElement()
	{
		MetaCreationDateElement  metaCreationDate = ((OdfFileDom)this.ownerDocument).newOdfElement(MetaCreationDateElement.class);
		this.appendChild( metaCreationDate);
		return  metaCreationDate;
	}                   
               
	/**
	 * Create child element {@odf.element dc:date}.
	 *
	 * @return   return  the element {@odf.element dc:date}
	 * DifferentQName 
	 */
	public DcDateElement newDcDateElement()
	{
		DcDateElement  dcDate = ((OdfFileDom)this.ownerDocument).newOdfElement(DcDateElement.class);
		this.appendChild( dcDate);
		return  dcDate;
	}                   
               
	/**
	 * Create child element {@odf.element meta:print-date}.
	 *
	 * @return   return  the element {@odf.element meta:print-date}
	 * DifferentQName 
	 */
	public MetaPrintDateElement newMetaPrintDateElement()
	{
		MetaPrintDateElement  metaPrintDate = ((OdfFileDom)this.ownerDocument).newOdfElement(MetaPrintDateElement.class);
		this.appendChild( metaPrintDate);
		return  metaPrintDate;
	}                   
               
	/**
	 * Create child element {@odf.element meta:template}.
	 *
     * @param xlinkHrefAttributeValue  the <code>String</code> value of <code>XlinkHrefAttribute</code>, see {@odf.attribute  xlink:href} at specification
	 * @param xlinkTypeAttributeValue  the <code>String</code> value of <code>XlinkTypeAttribute</code>, see {@odf.attribute  xlink:type} at specification
	 * @return   return  the element {@odf.element meta:template}
	 * DifferentQName 
	 */
    
	public MetaTemplateElement newMetaTemplateElement(String xlinkHrefAttributeValue, String xlinkTypeAttributeValue)
	{
		MetaTemplateElement  metaTemplate = ((OdfFileDom)this.ownerDocument).newOdfElement(MetaTemplateElement.class);
		metaTemplate.setXlinkHrefAttribute( xlinkHrefAttributeValue );
		metaTemplate.setXlinkTypeAttribute( xlinkTypeAttributeValue );
		this.appendChild( metaTemplate);
		return  metaTemplate;      
	}
    
	/**
	 * Create child element {@odf.element meta:auto-reload}.
	 *
	 * @return   return  the element {@odf.element meta:auto-reload}
	 * DifferentQName 
	 */
	public MetaAutoReloadElement newMetaAutoReloadElement()
	{
		MetaAutoReloadElement  metaAutoReload = ((OdfFileDom)this.ownerDocument).newOdfElement(MetaAutoReloadElement.class);
		this.appendChild( metaAutoReload);
		return  metaAutoReload;
	}                   
               
	/**
	 * Create child element {@odf.element meta:hyperlink-behaviour}.
	 *
	 * @return   return  the element {@odf.element meta:hyperlink-behaviour}
	 * DifferentQName 
	 */
	public MetaHyperlinkBehaviourElement newMetaHyperlinkBehaviourElement()
	{
		MetaHyperlinkBehaviourElement  metaHyperlinkBehaviour = ((OdfFileDom)this.ownerDocument).newOdfElement(MetaHyperlinkBehaviourElement.class);
		this.appendChild( metaHyperlinkBehaviour);
		return  metaHyperlinkBehaviour;
	}                   
               
	/**
	 * Create child element {@odf.element dc:language}.
	 *
	 * @return   return  the element {@odf.element dc:language}
	 * DifferentQName 
	 */
	public DcLanguageElement newDcLanguageElement()
	{
		DcLanguageElement  dcLanguage = ((OdfFileDom)this.ownerDocument).newOdfElement(DcLanguageElement.class);
		this.appendChild( dcLanguage);
		return  dcLanguage;
	}                   
               
	/**
	 * Create child element {@odf.element meta:editing-cycles}.
	 *
	 * @return   return  the element {@odf.element meta:editing-cycles}
	 * DifferentQName 
	 */
	public MetaEditingCyclesElement newMetaEditingCyclesElement()
	{
		MetaEditingCyclesElement  metaEditingCycles = ((OdfFileDom)this.ownerDocument).newOdfElement(MetaEditingCyclesElement.class);
		this.appendChild( metaEditingCycles);
		return  metaEditingCycles;
	}                   
               
	/**
	 * Create child element {@odf.element meta:editing-duration}.
	 *
	 * @return   return  the element {@odf.element meta:editing-duration}
	 * DifferentQName 
	 */
	public MetaEditingDurationElement newMetaEditingDurationElement()
	{
		MetaEditingDurationElement  metaEditingDuration = ((OdfFileDom)this.ownerDocument).newOdfElement(MetaEditingDurationElement.class);
		this.appendChild( metaEditingDuration);
		return  metaEditingDuration;
	}                   
               
	/**
	 * Create child element {@odf.element meta:document-statistic}.
	 *
	 * @return   return  the element {@odf.element meta:document-statistic}
	 * DifferentQName 
	 */
	public MetaDocumentStatisticElement newMetaDocumentStatisticElement()
	{
		MetaDocumentStatisticElement  metaDocumentStatistic = ((OdfFileDom)this.ownerDocument).newOdfElement(MetaDocumentStatisticElement.class);
		this.appendChild( metaDocumentStatistic);
		return  metaDocumentStatistic;
	}                   
               
	/**
	 * Create child element {@odf.element meta:user-defined}.
	 *
     * @param metaNameAttributeValue  the <code>String</code> value of <code>MetaNameAttribute</code>, see {@odf.attribute  meta:name} at specification
	 * @param metaValueTypeAttributeValue  the <code>String</code> value of <code>MetaValueTypeAttribute</code>, see {@odf.attribute  meta:value-type} at specification
	 * @return   return  the element {@odf.element meta:user-defined}
	 * DifferentQName 
	 */
    
	public MetaUserDefinedElement newMetaUserDefinedElement(String metaNameAttributeValue, String metaValueTypeAttributeValue)
	{
		MetaUserDefinedElement  metaUserDefined = ((OdfFileDom)this.ownerDocument).newOdfElement(MetaUserDefinedElement.class);
		metaUserDefined.setMetaNameAttribute( metaNameAttributeValue );
		metaUserDefined.setMetaValueTypeAttribute( metaValueTypeAttributeValue );
		this.appendChild( metaUserDefined);
		return  metaUserDefined;      
	}
    
	/**
	 * Create child element {@odf.element config:config-item-set}.
	 *
     * @param configNameAttributeValue  the <code>String</code> value of <code>ConfigNameAttribute</code>, see {@odf.attribute  config:name} at specification
	 * @return   return  the element {@odf.element config:config-item-set}
	 * DifferentQName 
	 */
    
	public ConfigConfigItemSetElement newConfigConfigItemSetElement(String configNameAttributeValue)
	{
		ConfigConfigItemSetElement  configConfigItemSet = ((OdfFileDom)this.ownerDocument).newOdfElement(ConfigConfigItemSetElement.class);
		configConfigItemSet.setConfigNameAttribute( configNameAttributeValue );
		this.appendChild( configConfigItemSet);
		return  configConfigItemSet;      
	}
    
	/**
	 * Create child element {@odf.element office:script}.
	 *
     * @param scriptLanguageAttributeValue  the <code>String</code> value of <code>ScriptLanguageAttribute</code>, see {@odf.attribute  script:language} at specification
	 * @return   return  the element {@odf.element office:script}
	 * DifferentQName 
	 */
    
	public OfficeScriptElement newOfficeScriptElement(String scriptLanguageAttributeValue)
	{
		OfficeScriptElement  officeScript = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeScriptElement.class);
		officeScript.setScriptLanguageAttribute( scriptLanguageAttributeValue );
		this.appendChild( officeScript);
		return  officeScript;      
	}
    
	/**
	 * Create child element {@odf.element office:event-listeners}.
	 *
	 * @return   return  the element {@odf.element office:event-listeners}
	 * DifferentQName 
	 */
	public OfficeEventListenersElement newOfficeEventListenersElement()
	{
		OfficeEventListenersElement  officeEventListeners = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeEventListenersElement.class);
		this.appendChild( officeEventListeners);
		return  officeEventListeners;
	}                   
               
	/**
	 * Create child element {@odf.element style:font-face}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element style:font-face}
	 * DifferentQName 
	 */
    
	public StyleFontFaceElement newStyleFontFaceElement(String styleNameAttributeValue)
	{
		StyleFontFaceElement  styleFontFace = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleFontFaceElement.class);
		styleFontFace.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( styleFontFace);
		return  styleFontFace;      
	}
    
	/**
	 * Create child element {@odf.element style:style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element style:style}
	 * DifferentQName 
	 */
    
	public StyleStyleElement newStyleStyleElement(String styleNameAttributeValue)
	{
		StyleStyleElement  styleStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleStyleElement.class);
		styleStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( styleStyle);
		return  styleStyle;      
	}
    
	/**
	 * Create child element {@odf.element text:list-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element text:list-style}
	 * DifferentQName 
	 */
    
	public TextListStyleElement newTextListStyleElement(String styleNameAttributeValue)
	{
		TextListStyleElement  textListStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(TextListStyleElement.class);
		textListStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( textListStyle);
		return  textListStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:number-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:number-style}
	 * DifferentQName 
	 */
    
	public NumberNumberStyleElement newNumberNumberStyleElement(String styleNameAttributeValue)
	{
		NumberNumberStyleElement  numberNumberStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberNumberStyleElement.class);
		numberNumberStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberNumberStyle);
		return  numberNumberStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:currency-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:currency-style}
	 * DifferentQName 
	 */
    
	public NumberCurrencyStyleElement newNumberCurrencyStyleElement(String styleNameAttributeValue)
	{
		NumberCurrencyStyleElement  numberCurrencyStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberCurrencyStyleElement.class);
		numberCurrencyStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberCurrencyStyle);
		return  numberCurrencyStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:percentage-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:percentage-style}
	 * DifferentQName 
	 */
    
	public NumberPercentageStyleElement newNumberPercentageStyleElement(String styleNameAttributeValue)
	{
		NumberPercentageStyleElement  numberPercentageStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberPercentageStyleElement.class);
		numberPercentageStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberPercentageStyle);
		return  numberPercentageStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:date-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:date-style}
	 * DifferentQName 
	 */
    
	public NumberDateStyleElement newNumberDateStyleElement(String styleNameAttributeValue)
	{
		NumberDateStyleElement  numberDateStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberDateStyleElement.class);
		numberDateStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberDateStyle);
		return  numberDateStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:time-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:time-style}
	 * DifferentQName 
	 */
    
	public NumberTimeStyleElement newNumberTimeStyleElement(String styleNameAttributeValue)
	{
		NumberTimeStyleElement  numberTimeStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberTimeStyleElement.class);
		numberTimeStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberTimeStyle);
		return  numberTimeStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:boolean-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:boolean-style}
	 * DifferentQName 
	 */
    
	public NumberBooleanStyleElement newNumberBooleanStyleElement(String styleNameAttributeValue)
	{
		NumberBooleanStyleElement  numberBooleanStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberBooleanStyleElement.class);
		numberBooleanStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberBooleanStyle);
		return  numberBooleanStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:text-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:text-style}
	 * DifferentQName 
	 */
    
	public NumberTextStyleElement newNumberTextStyleElement(String styleNameAttributeValue)
	{
		NumberTextStyleElement  numberTextStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberTextStyleElement.class);
		numberTextStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberTextStyle);
		return  numberTextStyle;      
	}
    
	/**
	 * Create child element {@odf.element style:default-style}.
	 *
	 * @return   return  the element {@odf.element style:default-style}
	 * DifferentQName 
	 */
	public StyleDefaultStyleElement newStyleDefaultStyleElement()
	{
		StyleDefaultStyleElement  styleDefaultStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleDefaultStyleElement.class);
		this.appendChild( styleDefaultStyle);
		return  styleDefaultStyle;
	}                   
               
	/**
	 * Create child element {@odf.element style:default-page-layout}.
	 *
	 * @return   return  the element {@odf.element style:default-page-layout}
	 * DifferentQName 
	 */
	public StyleDefaultPageLayoutElement newStyleDefaultPageLayoutElement()
	{
		StyleDefaultPageLayoutElement  styleDefaultPageLayout = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleDefaultPageLayoutElement.class);
		this.appendChild( styleDefaultPageLayout);
		return  styleDefaultPageLayout;
	}                   
               
	/**
	 * Create child element {@odf.element text:outline-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element text:outline-style}
	 * DifferentQName 
	 */
    
	public TextOutlineStyleElement newTextOutlineStyleElement(String styleNameAttributeValue)
	{
		TextOutlineStyleElement  textOutlineStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(TextOutlineStyleElement.class);
		textOutlineStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( textOutlineStyle);
		return  textOutlineStyle;      
	}
    
	/**
	 * Create child element {@odf.element text:notes-configuration}.
	 *
     * @param textNoteClassAttributeValue  the <code>String</code> value of <code>TextNoteClassAttribute</code>, see {@odf.attribute  text:note-class} at specification
	 * @return   return  the element {@odf.element text:notes-configuration}
	 * DifferentQName 
	 */
    
	public TextNotesConfigurationElement newTextNotesConfigurationElement(String textNoteClassAttributeValue)
	{
		TextNotesConfigurationElement  textNotesConfiguration = ((OdfFileDom)this.ownerDocument).newOdfElement(TextNotesConfigurationElement.class);
		textNotesConfiguration.setTextNoteClassAttribute( textNoteClassAttributeValue );
		this.appendChild( textNotesConfiguration);
		return  textNotesConfiguration;      
	}
    
	/**
	 * Create child element {@odf.element text:bibliography-configuration}.
	 *
	 * @return   return  the element {@odf.element text:bibliography-configuration}
	 * DifferentQName 
	 */
	public TextBibliographyConfigurationElement newTextBibliographyConfigurationElement()
	{
		TextBibliographyConfigurationElement  textBibliographyConfiguration = ((OdfFileDom)this.ownerDocument).newOdfElement(TextBibliographyConfigurationElement.class);
		this.appendChild( textBibliographyConfiguration);
		return  textBibliographyConfiguration;
	}                   
               
	/**
	 * Create child element {@odf.element text:linenumbering-configuration}.
	 *
	 * @return   return  the element {@odf.element text:linenumbering-configuration}
	 * DifferentQName 
	 */
	public TextLinenumberingConfigurationElement newTextLinenumberingConfigurationElement()
	{
		TextLinenumberingConfigurationElement  textLinenumberingConfiguration = ((OdfFileDom)this.ownerDocument).newOdfElement(TextLinenumberingConfigurationElement.class);
		this.appendChild( textLinenumberingConfiguration);
		return  textLinenumberingConfiguration;
	}                   
               
	/**
	 * Create child element {@odf.element draw:gradient}.
	 *
     * @param drawStyleAttributeValue  the <code>String</code> value of <code>DrawStyleAttribute</code>, see {@odf.attribute  draw:style} at specification
	 * @return   return  the element {@odf.element draw:gradient}
	 * DifferentQName 
	 */
    
	public DrawGradientElement newDrawGradientElement(String drawStyleAttributeValue)
	{
		DrawGradientElement  drawGradient = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawGradientElement.class);
		drawGradient.setDrawStyleAttribute( drawStyleAttributeValue );
		this.appendChild( drawGradient);
		return  drawGradient;      
	}
    
	/**
	 * Create child element {@odf.element svg:linearGradient}.
	 *
     * @param drawNameAttributeValue  the <code>String</code> value of <code>DrawNameAttribute</code>, see {@odf.attribute  draw:name} at specification
	 * @return   return  the element {@odf.element svg:linearGradient}
	 * DifferentQName 
	 */
    
	public SvgLinearGradientElement newSvgLinearGradientElement(String drawNameAttributeValue)
	{
		SvgLinearGradientElement  svgLinearGradient = ((OdfFileDom)this.ownerDocument).newOdfElement(SvgLinearGradientElement.class);
		svgLinearGradient.setDrawNameAttribute( drawNameAttributeValue );
		this.appendChild( svgLinearGradient);
		return  svgLinearGradient;      
	}
    
	/**
	 * Create child element {@odf.element svg:radialGradient}.
	 *
     * @param drawNameAttributeValue  the <code>String</code> value of <code>DrawNameAttribute</code>, see {@odf.attribute  draw:name} at specification
	 * @return   return  the element {@odf.element svg:radialGradient}
	 * DifferentQName 
	 */
    
	public SvgRadialGradientElement newSvgRadialGradientElement(String drawNameAttributeValue)
	{
		SvgRadialGradientElement  svgRadialGradient = ((OdfFileDom)this.ownerDocument).newOdfElement(SvgRadialGradientElement.class);
		svgRadialGradient.setDrawNameAttribute( drawNameAttributeValue );
		this.appendChild( svgRadialGradient);
		return  svgRadialGradient;      
	}
    
	/**
	 * Create child element {@odf.element draw:hatch}.
	 *
     * @param drawNameAttributeValue  the <code>String</code> value of <code>DrawNameAttribute</code>, see {@odf.attribute  draw:name} at specification
	 * @param drawStyleAttributeValue  the <code>String</code> value of <code>DrawStyleAttribute</code>, see {@odf.attribute  draw:style} at specification
	 * @return   return  the element {@odf.element draw:hatch}
	 * DifferentQName 
	 */
    
	public DrawHatchElement newDrawHatchElement(String drawNameAttributeValue, String drawStyleAttributeValue)
	{
		DrawHatchElement  drawHatch = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawHatchElement.class);
		drawHatch.setDrawNameAttribute( drawNameAttributeValue );
		drawHatch.setDrawStyleAttribute( drawStyleAttributeValue );
		this.appendChild( drawHatch);
		return  drawHatch;      
	}
    
	/**
	 * Create child element {@odf.element draw:fill-image}.
	 *
     * @param drawNameAttributeValue  the <code>String</code> value of <code>DrawNameAttribute</code>, see {@odf.attribute  draw:name} at specification
	 * @param xlinkHrefAttributeValue  the <code>String</code> value of <code>XlinkHrefAttribute</code>, see {@odf.attribute  xlink:href} at specification
	 * @param xlinkTypeAttributeValue  the <code>String</code> value of <code>XlinkTypeAttribute</code>, see {@odf.attribute  xlink:type} at specification
	 * @return   return  the element {@odf.element draw:fill-image}
	 * DifferentQName 
	 */
    
	public DrawFillImageElement newDrawFillImageElement(String drawNameAttributeValue, String xlinkHrefAttributeValue, String xlinkTypeAttributeValue)
	{
		DrawFillImageElement  drawFillImage = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawFillImageElement.class);
		drawFillImage.setDrawNameAttribute( drawNameAttributeValue );
		drawFillImage.setXlinkHrefAttribute( xlinkHrefAttributeValue );
		drawFillImage.setXlinkTypeAttribute( xlinkTypeAttributeValue );
		this.appendChild( drawFillImage);
		return  drawFillImage;      
	}
    
	/**
	 * Create child element {@odf.element draw:marker}.
	 *
     * @param drawNameAttributeValue  the <code>String</code> value of <code>DrawNameAttribute</code>, see {@odf.attribute  draw:name} at specification
	 * @param svgDAttributeValue  the <code>String</code> value of <code>SvgDAttribute</code>, see {@odf.attribute  svg:d} at specification
	 * @param svgViewBoxAttributeValue  the <code>String</code> value of <code>SvgViewBoxAttribute</code>, see {@odf.attribute  svg:viewBox} at specification
	 * @return   return  the element {@odf.element draw:marker}
	 * DifferentQName 
	 */
    
	public DrawMarkerElement newDrawMarkerElement(String drawNameAttributeValue, String svgDAttributeValue, String svgViewBoxAttributeValue)
	{
		DrawMarkerElement  drawMarker = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawMarkerElement.class);
		drawMarker.setDrawNameAttribute( drawNameAttributeValue );
		drawMarker.setSvgDAttribute( svgDAttributeValue );
		drawMarker.setSvgViewBoxAttribute( svgViewBoxAttributeValue );
		this.appendChild( drawMarker);
		return  drawMarker;      
	}
    
	/**
	 * Create child element {@odf.element draw:stroke-dash}.
	 *
     * @param drawNameAttributeValue  the <code>String</code> value of <code>DrawNameAttribute</code>, see {@odf.attribute  draw:name} at specification
	 * @return   return  the element {@odf.element draw:stroke-dash}
	 * DifferentQName 
	 */
    
	public DrawStrokeDashElement newDrawStrokeDashElement(String drawNameAttributeValue)
	{
		DrawStrokeDashElement  drawStrokeDash = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawStrokeDashElement.class);
		drawStrokeDash.setDrawNameAttribute( drawNameAttributeValue );
		this.appendChild( drawStrokeDash);
		return  drawStrokeDash;      
	}
    
	/**
	 * Create child element {@odf.element draw:opacity}.
	 *
     * @param drawStyleAttributeValue  the <code>String</code> value of <code>DrawStyleAttribute</code>, see {@odf.attribute  draw:style} at specification
	 * @return   return  the element {@odf.element draw:opacity}
	 * DifferentQName 
	 */
    
	public DrawOpacityElement newDrawOpacityElement(String drawStyleAttributeValue)
	{
		DrawOpacityElement  drawOpacity = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawOpacityElement.class);
		drawOpacity.setDrawStyleAttribute( drawStyleAttributeValue );
		this.appendChild( drawOpacity);
		return  drawOpacity;      
	}
    
	/**
	 * Create child element {@odf.element style:presentation-page-layout}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element style:presentation-page-layout}
	 * DifferentQName 
	 */
    
	public StylePresentationPageLayoutElement newStylePresentationPageLayoutElement(String styleNameAttributeValue)
	{
		StylePresentationPageLayoutElement  stylePresentationPageLayout = ((OdfFileDom)this.ownerDocument).newOdfElement(StylePresentationPageLayoutElement.class);
		stylePresentationPageLayout.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( stylePresentationPageLayout);
		return  stylePresentationPageLayout;      
	}
    
	/**
	 * Create child element {@odf.element style:page-layout}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element style:page-layout}
	 * DifferentQName 
	 */
    
	public StylePageLayoutElement newStylePageLayoutElement(String styleNameAttributeValue)
	{
		StylePageLayoutElement  stylePageLayout = ((OdfFileDom)this.ownerDocument).newOdfElement(StylePageLayoutElement.class);
		stylePageLayout.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( stylePageLayout);
		return  stylePageLayout;      
	}
    
	/**
	 * Create child element {@odf.element style:master-page}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @param stylePageLayoutNameAttributeValue  the <code>String</code> value of <code>StylePageLayoutNameAttribute</code>, see {@odf.attribute  style:page-layout-name} at specification
	 * @return   return  the element {@odf.element style:master-page}
	 * DifferentQName 
	 */
    
	public StyleMasterPageElement newStyleMasterPageElement(String styleNameAttributeValue, String stylePageLayoutNameAttributeValue)
	{
		StyleMasterPageElement  styleMasterPage = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleMasterPageElement.class);
		styleMasterPage.setStyleNameAttribute( styleNameAttributeValue );
		styleMasterPage.setStylePageLayoutNameAttribute( stylePageLayoutNameAttributeValue );
		this.appendChild( styleMasterPage);
		return  styleMasterPage;      
	}
    
	/**
	 * Create child element {@odf.element style:handout-master}.
	 *
     * @param stylePageLayoutNameAttributeValue  the <code>String</code> value of <code>StylePageLayoutNameAttribute</code>, see {@odf.attribute  style:page-layout-name} at specification
	 * @return   return  the element {@odf.element style:handout-master}
	 * DifferentQName 
	 */
    
	public StyleHandoutMasterElement newStyleHandoutMasterElement(String stylePageLayoutNameAttributeValue)
	{
		StyleHandoutMasterElement  styleHandoutMaster = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleHandoutMasterElement.class);
		styleHandoutMaster.setStylePageLayoutNameAttribute( stylePageLayoutNameAttributeValue );
		this.appendChild( styleHandoutMaster);
		return  styleHandoutMaster;      
	}
    
	/**
	 * Create child element {@odf.element draw:layer-set}.
	 *
	 * @return   return  the element {@odf.element draw:layer-set}
	 * DifferentQName 
	 */
	public DrawLayerSetElement newDrawLayerSetElement()
	{
		DrawLayerSetElement  drawLayerSet = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawLayerSetElement.class);
		this.appendChild( drawLayerSet);
		return  drawLayerSet;
	}                   
               
	/**
	 * Create child element {@odf.element table:table-template}.
	 *
     * @param tableFirstRowEndColumnAttributeValue  the <code>String</code> value of <code>TableFirstRowEndColumnAttribute</code>, see {@odf.attribute  table:first-row-end-column} at specification
	 * @param tableFirstRowStartColumnAttributeValue  the <code>String</code> value of <code>TableFirstRowStartColumnAttribute</code>, see {@odf.attribute  table:first-row-start-column} at specification
	 * @param tableLastRowEndColumnAttributeValue  the <code>String</code> value of <code>TableLastRowEndColumnAttribute</code>, see {@odf.attribute  table:last-row-end-column} at specification
	 * @param tableLastRowStartColumnAttributeValue  the <code>String</code> value of <code>TableLastRowStartColumnAttribute</code>, see {@odf.attribute  table:last-row-start-column} at specification
	 * @param tableNameAttributeValue  the <code>String</code> value of <code>TableNameAttribute</code>, see {@odf.attribute  table:name} at specification
	 * @return   return  the element {@odf.element table:table-template}
	 * DifferentQName 
	 */
    
	public TableTableTemplateElement newTableTableTemplateElement(String tableFirstRowEndColumnAttributeValue, String tableFirstRowStartColumnAttributeValue, String tableLastRowEndColumnAttributeValue, String tableLastRowStartColumnAttributeValue, String tableNameAttributeValue)
	{
		TableTableTemplateElement  tableTableTemplate = ((OdfFileDom)this.ownerDocument).newOdfElement(TableTableTemplateElement.class);
		tableTableTemplate.setTableFirstRowEndColumnAttribute( tableFirstRowEndColumnAttributeValue );
		tableTableTemplate.setTableFirstRowStartColumnAttribute( tableFirstRowStartColumnAttributeValue );
		tableTableTemplate.setTableLastRowEndColumnAttribute( tableLastRowEndColumnAttributeValue );
		tableTableTemplate.setTableLastRowStartColumnAttribute( tableLastRowStartColumnAttributeValue );
		tableTableTemplate.setTableNameAttribute( tableNameAttributeValue );
		this.appendChild( tableTableTemplate);
		return  tableTableTemplate;      
	}
    
	/**
	 * Create child element {@odf.element office:body}.
	 *
	 * @return   return  the element {@odf.element office:body}
	 * DifferentQName 
	 */
	public OfficeBodyElement newOfficeBodyElement()
	{
		OfficeBodyElement  officeBody = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeBodyElement.class);
		this.appendChild( officeBody);
		return  officeBody;
	}                   
               
}
