/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeVersionAttribute;
import org.odftoolkit.odfdom.dom.attribute.grddl.GrddlTransformationAttribute;

import org.odftoolkit.odfdom.dom.element.style.StyleFontFaceElement;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.element.text.TextListStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberCurrencyStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberPercentageStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberDateStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTimeStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberBooleanStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StylePageLayoutElement;

/**
 * DOM implementation of OpenDocument element  {@odf.element office:document-content}.
 *
 */
public class OfficeDocumentContentElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.OFFICE, "document-content" );


	/**
	 * Create the instance of <code>OfficeDocumentContentElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public OfficeDocumentContentElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element office:document-content}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

	/**
	 * Initialization of the mandatory attributes of {@link  OfficeDocumentContentElement}
	 *
     * @param officeVersionAttributeValue  The mandatory attribute {@odf.attribute  office:version}"
     *
	 */
	public void init(String officeVersionAttributeValue)
	{
		setOfficeVersionAttribute( officeVersionAttributeValue );
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>OfficeVersionAttribute</code> , See {@odf.attribute office:version}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getOfficeVersionAttribute()
	{
		OfficeVersionAttribute attr = (OfficeVersionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.OFFICE), "version" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>OfficeVersionAttribute</code> , See {@odf.attribute office:version}
	 *
	 * @param officeVersionValue   The type is <code>String</code>
	 */
	public void setOfficeVersionAttribute( String officeVersionValue )
	{
		OfficeVersionAttribute attr =  new OfficeVersionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( officeVersionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>GrddlTransformationAttribute</code> , See {@odf.attribute grddl:transformation}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getGrddlTransformationAttribute()
	{
		GrddlTransformationAttribute attr = (GrddlTransformationAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.GRDDL), "transformation" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>GrddlTransformationAttribute</code> , See {@odf.attribute grddl:transformation}
	 *
	 * @param grddlTransformationValue   The type is <code>String</code>
	 */
	public void setGrddlTransformationAttribute( String grddlTransformationValue )
	{
		GrddlTransformationAttribute attr =  new GrddlTransformationAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( grddlTransformationValue );
	}

	/**
	 * Create child element {@odf.element office:script}.
	 *
     * @param scriptLanguageAttributeValue  the <code>String</code> value of <code>ScriptLanguageAttribute</code>, see {@odf.attribute  script:language} at specification
	 * @return   return  the element {@odf.element office:script}
	 * DifferentQName 
	 */
    
	public OfficeScriptElement newOfficeScriptElement(String scriptLanguageAttributeValue)
	{
		OfficeScriptElement  officeScript = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeScriptElement.class);
		officeScript.setScriptLanguageAttribute( scriptLanguageAttributeValue );
		this.appendChild( officeScript);
		return  officeScript;      
	}
    
	/**
	 * Create child element {@odf.element office:event-listeners}.
	 *
	 * @return   return  the element {@odf.element office:event-listeners}
	 * DifferentQName 
	 */
	public OfficeEventListenersElement newOfficeEventListenersElement()
	{
		OfficeEventListenersElement  officeEventListeners = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeEventListenersElement.class);
		this.appendChild( officeEventListeners);
		return  officeEventListeners;
	}                   
               
	/**
	 * Create child element {@odf.element style:font-face}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element style:font-face}
	 * DifferentQName 
	 */
    
	public StyleFontFaceElement newStyleFontFaceElement(String styleNameAttributeValue)
	{
		StyleFontFaceElement  styleFontFace = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleFontFaceElement.class);
		styleFontFace.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( styleFontFace);
		return  styleFontFace;      
	}
    
	/**
	 * Create child element {@odf.element style:style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element style:style}
	 * DifferentQName 
	 */
    
	public StyleStyleElement newStyleStyleElement(String styleNameAttributeValue)
	{
		StyleStyleElement  styleStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleStyleElement.class);
		styleStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( styleStyle);
		return  styleStyle;      
	}
    
	/**
	 * Create child element {@odf.element text:list-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element text:list-style}
	 * DifferentQName 
	 */
    
	public TextListStyleElement newTextListStyleElement(String styleNameAttributeValue)
	{
		TextListStyleElement  textListStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(TextListStyleElement.class);
		textListStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( textListStyle);
		return  textListStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:number-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:number-style}
	 * DifferentQName 
	 */
    
	public NumberNumberStyleElement newNumberNumberStyleElement(String styleNameAttributeValue)
	{
		NumberNumberStyleElement  numberNumberStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberNumberStyleElement.class);
		numberNumberStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberNumberStyle);
		return  numberNumberStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:currency-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:currency-style}
	 * DifferentQName 
	 */
    
	public NumberCurrencyStyleElement newNumberCurrencyStyleElement(String styleNameAttributeValue)
	{
		NumberCurrencyStyleElement  numberCurrencyStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberCurrencyStyleElement.class);
		numberCurrencyStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberCurrencyStyle);
		return  numberCurrencyStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:percentage-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:percentage-style}
	 * DifferentQName 
	 */
    
	public NumberPercentageStyleElement newNumberPercentageStyleElement(String styleNameAttributeValue)
	{
		NumberPercentageStyleElement  numberPercentageStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberPercentageStyleElement.class);
		numberPercentageStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberPercentageStyle);
		return  numberPercentageStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:date-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:date-style}
	 * DifferentQName 
	 */
    
	public NumberDateStyleElement newNumberDateStyleElement(String styleNameAttributeValue)
	{
		NumberDateStyleElement  numberDateStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberDateStyleElement.class);
		numberDateStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberDateStyle);
		return  numberDateStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:time-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:time-style}
	 * DifferentQName 
	 */
    
	public NumberTimeStyleElement newNumberTimeStyleElement(String styleNameAttributeValue)
	{
		NumberTimeStyleElement  numberTimeStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberTimeStyleElement.class);
		numberTimeStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberTimeStyle);
		return  numberTimeStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:boolean-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:boolean-style}
	 * DifferentQName 
	 */
    
	public NumberBooleanStyleElement newNumberBooleanStyleElement(String styleNameAttributeValue)
	{
		NumberBooleanStyleElement  numberBooleanStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberBooleanStyleElement.class);
		numberBooleanStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberBooleanStyle);
		return  numberBooleanStyle;      
	}
    
	/**
	 * Create child element {@odf.element number:text-style}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element number:text-style}
	 * DifferentQName 
	 */
    
	public NumberTextStyleElement newNumberTextStyleElement(String styleNameAttributeValue)
	{
		NumberTextStyleElement  numberTextStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberTextStyleElement.class);
		numberTextStyle.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( numberTextStyle);
		return  numberTextStyle;      
	}
    
	/**
	 * Create child element {@odf.element style:page-layout}.
	 *
     * @param styleNameAttributeValue  the <code>String</code> value of <code>StyleNameAttribute</code>, see {@odf.attribute  style:name} at specification
	 * @return   return  the element {@odf.element style:page-layout}
	 * DifferentQName 
	 */
    
	public StylePageLayoutElement newStylePageLayoutElement(String styleNameAttributeValue)
	{
		StylePageLayoutElement  stylePageLayout = ((OdfFileDom)this.ownerDocument).newOdfElement(StylePageLayoutElement.class);
		stylePageLayout.setStyleNameAttribute( styleNameAttributeValue );
		this.appendChild( stylePageLayout);
		return  stylePageLayout;      
	}
    
	/**
	 * Create child element {@odf.element office:body}.
	 *
	 * @return   return  the element {@odf.element office:body}
	 * DifferentQName 
	 */
	public OfficeBodyElement newOfficeBodyElement()
	{
		OfficeBodyElement  officeBody = ((OdfFileDom)this.ownerDocument).newOdfElement(OfficeBodyElement.class);
		this.appendChild( officeBody);
		return  officeBody;
	}                   
               
}
