/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.number;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.number.NumberLanguageAttribute;
import org.odftoolkit.odfdom.dom.attribute.number.NumberCountryAttribute;
import org.odftoolkit.odfdom.dom.attribute.number.NumberScriptAttribute;
import org.odftoolkit.odfdom.dom.attribute.number.NumberRfcLanguageTagAttribute;


/**
 * DOM implementation of OpenDocument element  {@odf.element number:currency-symbol}.
 *
 */
public class NumberCurrencySymbolElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.NUMBER, "currency-symbol" );


	/**
	 * Create the instance of <code>NumberCurrencySymbolElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public NumberCurrencySymbolElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element number:currency-symbol}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}



	/**
	 * Receives the value of the ODFDOM attribute representation <code>NumberLanguageAttribute</code> , See {@odf.attribute number:language}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getNumberLanguageAttribute()
	{
		NumberLanguageAttribute attr = (NumberLanguageAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.NUMBER), "language" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>NumberLanguageAttribute</code> , See {@odf.attribute number:language}
	 *
	 * @param numberLanguageValue   The type is <code>String</code>
	 */
	public void setNumberLanguageAttribute( String numberLanguageValue )
	{
		NumberLanguageAttribute attr =  new NumberLanguageAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( numberLanguageValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>NumberCountryAttribute</code> , See {@odf.attribute number:country}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getNumberCountryAttribute()
	{
		NumberCountryAttribute attr = (NumberCountryAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.NUMBER), "country" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>NumberCountryAttribute</code> , See {@odf.attribute number:country}
	 *
	 * @param numberCountryValue   The type is <code>String</code>
	 */
	public void setNumberCountryAttribute( String numberCountryValue )
	{
		NumberCountryAttribute attr =  new NumberCountryAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( numberCountryValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>NumberScriptAttribute</code> , See {@odf.attribute number:script}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getNumberScriptAttribute()
	{
		NumberScriptAttribute attr = (NumberScriptAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.NUMBER), "script" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>NumberScriptAttribute</code> , See {@odf.attribute number:script}
	 *
	 * @param numberScriptValue   The type is <code>String</code>
	 */
	public void setNumberScriptAttribute( String numberScriptValue )
	{
		NumberScriptAttribute attr =  new NumberScriptAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( numberScriptValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>NumberRfcLanguageTagAttribute</code> , See {@odf.attribute number:rfc-language-tag}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getNumberRfcLanguageTagAttribute()
	{
		NumberRfcLanguageTagAttribute attr = (NumberRfcLanguageTagAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.NUMBER), "rfc-language-tag" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>NumberRfcLanguageTagAttribute</code> , See {@odf.attribute number:rfc-language-tag}
	 *
	 * @param numberRfcLanguageTagValue   The type is <code>String</code>
	 */
	public void setNumberRfcLanguageTagAttribute( String numberRfcLanguageTagValue )
	{
		NumberRfcLanguageTagAttribute attr =  new NumberRfcLanguageTagAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( numberRfcLanguageTagValue );
	}

}
