/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.form;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;


/**
 * DOM implementation of OpenDocument element  {@odf.element form:properties}.
 *
 */
public class FormPropertiesElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.FORM, "properties" );


	/**
	 * Create the instance of <code>FormPropertiesElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public FormPropertiesElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element form:properties}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}


	/**
	 * Create child element {@odf.element form:property}.
	 *
     * @param formPropertyNameAttributeValue  the <code>String</code> value of <code>FormPropertyNameAttribute</code>, see {@odf.attribute  form:property-name} at specification
	 * @param officeValueTypeAttributeValue  the <code>String</code> value of <code>OfficeValueTypeAttribute</code>, see {@odf.attribute  office:value-type} at specification
	 * @return   return  the element {@odf.element form:property}
	 * DifferentQName 
	 */
    
	public FormPropertyElement newFormPropertyElement(String formPropertyNameAttributeValue, String officeValueTypeAttributeValue)
	{
		FormPropertyElement  formProperty = ((OdfFileDom)this.ownerDocument).newOdfElement(FormPropertyElement.class);
		formProperty.setFormPropertyNameAttribute( formPropertyNameAttributeValue );
		formProperty.setOfficeValueTypeAttribute( officeValueTypeAttributeValue );
		this.appendChild( formProperty);
		return  formProperty;      
	}
    
	/**
	 * Create child element {@odf.element form:list-property}.
	 *
     * @param formPropertyNameAttributeValue  the <code>String</code> value of <code>FormPropertyNameAttribute</code>, see {@odf.attribute  form:property-name} at specification
	 * @param officeValueTypeAttributeValue  the <code>String</code> value of <code>OfficeValueTypeAttribute</code>, see {@odf.attribute  office:value-type} at specification
	 * @return   return  the element {@odf.element form:list-property}
	 * DifferentQName 
	 */
    
	public FormListPropertyElement newFormListPropertyElement(String formPropertyNameAttributeValue, String officeValueTypeAttributeValue)
	{
		FormListPropertyElement  formListProperty = ((OdfFileDom)this.ownerDocument).newOdfElement(FormListPropertyElement.class);
		formListProperty.setFormPropertyNameAttribute( formPropertyNameAttributeValue );
		formListProperty.setOfficeValueTypeAttribute( officeValueTypeAttributeValue );
		this.appendChild( formListProperty);
		return  formListProperty;      
	}
    
}
