/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.db.DbNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbCatalogNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbSchemaNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbTypeAttribute;


/**
 * DOM implementation of OpenDocument element  {@odf.element db:table-definition}.
 *
 */
public class DbTableDefinitionElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.DB, "table-definition" );


	/**
	 * Create the instance of <code>DbTableDefinitionElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public DbTableDefinitionElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element db:table-definition}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

	/**
	 * Initialization of the mandatory attributes of {@link  DbTableDefinitionElement}
	 *
     * @param dbNameAttributeValue  The mandatory attribute {@odf.attribute  db:name}"
     *
	 */
	public void init(String dbNameAttributeValue)
	{
		setDbNameAttribute( dbNameAttributeValue );
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>DbNameAttribute</code> , See {@odf.attribute db:name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDbNameAttribute()
	{
		DbNameAttribute attr = (DbNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DB), "name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DbNameAttribute</code> , See {@odf.attribute db:name}
	 *
	 * @param dbNameValue   The type is <code>String</code>
	 */
	public void setDbNameAttribute( String dbNameValue )
	{
		DbNameAttribute attr =  new DbNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dbNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DbCatalogNameAttribute</code> , See {@odf.attribute db:catalog-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDbCatalogNameAttribute()
	{
		DbCatalogNameAttribute attr = (DbCatalogNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DB), "catalog-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DbCatalogNameAttribute</code> , See {@odf.attribute db:catalog-name}
	 *
	 * @param dbCatalogNameValue   The type is <code>String</code>
	 */
	public void setDbCatalogNameAttribute( String dbCatalogNameValue )
	{
		DbCatalogNameAttribute attr =  new DbCatalogNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dbCatalogNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DbSchemaNameAttribute</code> , See {@odf.attribute db:schema-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDbSchemaNameAttribute()
	{
		DbSchemaNameAttribute attr = (DbSchemaNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DB), "schema-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DbSchemaNameAttribute</code> , See {@odf.attribute db:schema-name}
	 *
	 * @param dbSchemaNameValue   The type is <code>String</code>
	 */
	public void setDbSchemaNameAttribute( String dbSchemaNameValue )
	{
		DbSchemaNameAttribute attr =  new DbSchemaNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dbSchemaNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>DbTypeAttribute</code> , See {@odf.attribute db:type}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getDbTypeAttribute()
	{
		DbTypeAttribute attr = (DbTypeAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.DB), "type" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>DbTypeAttribute</code> , See {@odf.attribute db:type}
	 *
	 * @param dbTypeValue   The type is <code>String</code>
	 */
	public void setDbTypeAttribute( String dbTypeValue )
	{
		DbTypeAttribute attr =  new DbTypeAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( dbTypeValue );
	}

	/**
	 * Create child element {@odf.element db:column-definitions}.
	 *
	 * @return   return  the element {@odf.element db:column-definitions}
	 * DifferentQName 
	 */
	public DbColumnDefinitionsElement newDbColumnDefinitionsElement()
	{
		DbColumnDefinitionsElement  dbColumnDefinitions = ((OdfFileDom)this.ownerDocument).newOdfElement(DbColumnDefinitionsElement.class);
		this.appendChild( dbColumnDefinitions);
		return  dbColumnDefinitions;
	}                   
               
	/**
	 * Create child element {@odf.element db:keys}.
	 *
	 * @return   return  the element {@odf.element db:keys}
	 * DifferentQName 
	 */
	public DbKeysElement newDbKeysElement()
	{
		DbKeysElement  dbKeys = ((OdfFileDom)this.ownerDocument).newOdfElement(DbKeysElement.class);
		this.appendChild( dbKeys);
		return  dbKeys;
	}                   
               
	/**
	 * Create child element {@odf.element db:indices}.
	 *
	 * @return   return  the element {@odf.element db:indices}
	 * DifferentQName 
	 */
	public DbIndicesElement newDbIndicesElement()
	{
		DbIndicesElement  dbIndices = ((OdfFileDom)this.ownerDocument).newOdfElement(DbIndicesElement.class);
		this.appendChild( dbIndices);
		return  dbIndices;
	}                   
               
}
