/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.chart;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartDimensionAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartStyleNameAttribute;


/**
 * DOM implementation of OpenDocument element  {@odf.element chart:axis}.
 *
 */
public class ChartAxisElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.CHART, "axis" );


	/**
	 * Create the instance of <code>ChartAxisElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public ChartAxisElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME, OdfStyleFamily.Chart, OdfName.newName(OdfNamespaceNames.CHART, "style-name" )	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element chart:axis}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

	/**
	 * Initialization of the mandatory attributes of {@link  ChartAxisElement}
	 *
     * @param chartDimensionAttributeValue  The mandatory attribute {@odf.attribute  chart:dimension}"
     *
	 */
	public void init(String chartDimensionAttributeValue)
	{
		setChartDimensionAttribute( chartDimensionAttributeValue );
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartDimensionAttribute</code> , See {@odf.attribute chart:dimension}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartDimensionAttribute()
	{
		ChartDimensionAttribute attr = (ChartDimensionAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.CHART), "dimension" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartDimensionAttribute</code> , See {@odf.attribute chart:dimension}
	 *
	 * @param chartDimensionValue   The type is <code>String</code>
	 */
	public void setChartDimensionAttribute( String chartDimensionValue )
	{
		ChartDimensionAttribute attr =  new ChartDimensionAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( chartDimensionValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartNameAttribute</code> , See {@odf.attribute chart:name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartNameAttribute()
	{
		ChartNameAttribute attr = (ChartNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.CHART), "name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartNameAttribute</code> , See {@odf.attribute chart:name}
	 *
	 * @param chartNameValue   The type is <code>String</code>
	 */
	public void setChartNameAttribute( String chartNameValue )
	{
		ChartNameAttribute attr =  new ChartNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( chartNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartStyleNameAttribute</code> , See {@odf.attribute chart:style-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartStyleNameAttribute()
	{
		ChartStyleNameAttribute attr = (ChartStyleNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.CHART), "style-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartStyleNameAttribute</code> , See {@odf.attribute chart:style-name}
	 *
	 * @param chartStyleNameValue   The type is <code>String</code>
	 */
	public void setChartStyleNameAttribute( String chartStyleNameValue )
	{
		ChartStyleNameAttribute attr =  new ChartStyleNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( chartStyleNameValue );
	}

	/**
	 * Create child element {@odf.element chart:title}.
	 *
	 * @return   return  the element {@odf.element chart:title}
	 * DifferentQName 
	 */
	public ChartTitleElement newChartTitleElement()
	{
		ChartTitleElement  chartTitle = ((OdfFileDom)this.ownerDocument).newOdfElement(ChartTitleElement.class);
		this.appendChild( chartTitle);
		return  chartTitle;
	}                   
               
	/**
	 * Create child element {@odf.element chart:categories}.
	 *
	 * @return   return  the element {@odf.element chart:categories}
	 * DifferentQName 
	 */
	public ChartCategoriesElement newChartCategoriesElement()
	{
		ChartCategoriesElement  chartCategories = ((OdfFileDom)this.ownerDocument).newOdfElement(ChartCategoriesElement.class);
		this.appendChild( chartCategories);
		return  chartCategories;
	}                   
               
	/**
	 * Create child element {@odf.element chart:grid}.
	 *
	 * @return   return  the element {@odf.element chart:grid}
	 * DifferentQName 
	 */
	public ChartGridElement newChartGridElement()
	{
		ChartGridElement  chartGrid = ((OdfFileDom)this.ownerDocument).newOdfElement(ChartGridElement.class);
		this.appendChild( chartGrid);
		return  chartGrid;
	}                   
               
}
