/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.odftoolkit.odfdom.type.OdfDataType;
import org.odftoolkit.odfdom.type.StyleName;
import org.odftoolkit.odfdom.type.StyleNameRef;

public class StyleNameRefs
implements OdfDataType {
    private String mStyleNames;

    public StyleNameRefs(List<StyleName> styleNames) throws IllegalArgumentException {
        if (styleNames == null) {
            throw new IllegalArgumentException("parameter can not be null for StyleNameRefs");
        }
        this.mStyleNames = styleNames.stream().map(StyleName::toString).collect(Collectors.joining(" "));
    }

    public String toString() {
        return this.mStyleNames;
    }

    public static StyleNameRefs valueOf(String stringValue) throws IllegalArgumentException {
        if (stringValue == null) {
            throw new IllegalArgumentException("parameter is invalid for datatype StyleNameRefs");
        }
        ArrayList<StyleName> aRet = new ArrayList<StyleName>();
        if (stringValue.length() > 0) {
            String[] names;
            for (String name : names = stringValue.split(" ")) {
                aRet.add(new StyleName(name));
            }
        }
        return new StyleNameRefs(aRet);
    }

    public List<StyleName> getStyleNameRefList() {
        ArrayList<StyleName> aRet = new ArrayList<StyleName>();
        if (this.mStyleNames.length() > 0) {
            String[] names;
            for (String name : names = this.mStyleNames.split(" ")) {
                aRet.add(new StyleName(name));
            }
        }
        return aRet;
    }

    public static boolean isValid(String stringValue) {
        String[] names;
        if (stringValue == null) {
            return false;
        }
        if (stringValue.length() == 0) {
            return true;
        }
        for (String name : names = stringValue.split(" ")) {
            if (StyleNameRef.isValid(name)) continue;
            return false;
        }
        return true;
    }
}

