/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.odftoolkit.odfdom.type.CURIE;
import org.odftoolkit.odfdom.type.OdfDataType;

public class CURIEs
implements OdfDataType {
    private String mCURIEs;

    public CURIEs(List<CURIE> curies) throws IllegalArgumentException {
        if (curies == null || curies.size() == 0) {
            throw new IllegalArgumentException("parameter can not be null for CURIEs");
        }
        this.mCURIEs = curies.stream().map(CURIE::toString).collect(Collectors.joining(" "));
    }

    public String toString() {
        return this.mCURIEs;
    }

    public static CURIEs valueOf(String stringValue) throws IllegalArgumentException {
        String[] names;
        if (stringValue == null || stringValue.length() == 0) {
            throw new IllegalArgumentException("parameter is invalid for datatype CURIEs");
        }
        ArrayList<CURIE> aRet = new ArrayList<CURIE>();
        for (String name : names = stringValue.split(" ")) {
            aRet.add(new CURIE(name));
        }
        return new CURIEs(aRet);
    }

    public List<CURIE> getCURIEList() {
        String[] names;
        ArrayList<CURIE> aRet = new ArrayList<CURIE>();
        for (String name : names = this.mCURIEs.split(" ")) {
            aRet.add(new CURIE(name));
        }
        return aRet;
    }

    public static boolean isValid(String stringValue) {
        String[] names;
        if (stringValue == null) {
            return false;
        }
        if (stringValue.length() == 0) {
            return false;
        }
        for (String name : names = stringValue.split(" ")) {
            if (CURIE.isValid(name)) continue;
            return false;
        }
        return true;
    }
}

