/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg.rdfa;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.rootdev.javardfa.Constants;
import net.rootdev.javardfa.Parser;
import net.rootdev.javardfa.Resolver;
import net.rootdev.javardfa.Setting;
import net.rootdev.javardfa.StatementSink;
import net.rootdev.javardfa.literal.LiteralCollector;
import net.rootdev.javardfa.uri.IRIResolver;
import net.rootdev.javardfa.uri.URIExtractor10;
import org.odftoolkit.odfdom.pkg.rdfa.EvalContext;
import org.odftoolkit.odfdom.pkg.rdfa.JenaSink;
import org.odftoolkit.odfdom.pkg.rdfa.URIExtractor;
import org.odftoolkit.odfdom.pkg.rdfa.Util;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

class RDFaParser
extends Parser {
    boolean ignore = false;
    protected XMLEventFactory eventFactory;
    protected JenaSink sink;
    protected Set<Setting> settings;
    protected LiteralCollector literalCollector;
    protected URIExtractor extractor;
    protected Locator locator;
    protected EvalContext context;
    int bnodeId = 0;

    protected RDFaParser(JenaSink sink, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, URIExtractor extractor) {
        super((StatementSink)sink, outputFactory, eventFactory, (net.rootdev.javardfa.uri.URIExtractor)new URIExtractor10((Resolver)new IRIResolver()));
        this.sink = sink;
        this.eventFactory = eventFactory;
        this.settings = EnumSet.noneOf(Setting.class);
        this.extractor = extractor;
        this.literalCollector = new LiteralCollector((Parser)this, eventFactory, outputFactory);
        extractor.setSettings(this.settings);
        outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }

    protected void beginRDFaElement(String arg0, String localname, String qname, Attributes arg3) {
        if (localname.equals("bookmark-start")) {
            this.ignore = true;
            return;
        }
        try {
            String prefix;
            if (this.context == null) {
                this.setBase(this.locator.getSystemId());
            }
            String string = prefix = qname.indexOf(58) == -1 ? "" : qname.substring(0, qname.indexOf(58));
            if (this.settings.contains(Setting.ManualNamespaces)) {
                this.getNamespaces(arg3);
                if (prefix.length() != 0) {
                    arg0 = this.context.getNamespaceURI(prefix);
                    localname = localname.substring(prefix.length() + 1);
                }
            }
            StartElement e = this.eventFactory.createStartElement(prefix, arg0, localname, this.fromAttributes(arg3), null, this.context);
            if (this.literalCollector.isCollecting()) {
                this.literalCollector.handleEvent((XMLEvent)e);
            }
            if (!this.literalCollector.isCollectingXML()) {
                this.context = this.parse(this.context, e);
            }
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Streaming issue", ex);
        }
    }

    protected void endRDFaElement(String arg0, String localname, String qname) {
        if (localname.equals("bookmark-start")) {
            this.ignore = false;
            return;
        }
        if (this.literalCollector.isCollecting()) {
            String prefix = localname.equals(qname) ? "" : qname.substring(0, qname.indexOf(58));
            EndElement e = this.eventFactory.createEndElement(prefix, arg0, localname);
            this.literalCollector.handleEvent((XMLEvent)e);
        }
        if (!this.literalCollector.isCollectingXML()) {
            this.context = this.context.parent;
        }
    }

    protected void writeCharacters(String value) {
        if (!this.ignore && this.literalCollector.isCollecting()) {
            Characters e = this.eventFactory.createCharacters(value);
            this.literalCollector.handleEvent((XMLEvent)e);
        }
    }

    public void setBase(String base) {
        this.context = new EvalContext(base);
        this.sink.setBase(this.context.getBase());
    }

    protected EvalContext parse(EvalContext context, StartElement element) throws XMLStreamException {
        Attribute nSubj;
        boolean skipElement = false;
        String newSubject = null;
        String currentObject = null;
        ArrayList<String> forwardProperties = new ArrayList<String>();
        ArrayList<String> backwardProperties = new ArrayList<String>();
        String currentLanguage = context.language;
        if (this.settings.contains(Setting.OnePointOne)) {
            if (this.getAttributeByName(element, Constants.vocab) != null) {
                context.vocab = this.getAttributeByName(element, Constants.vocab).getValue().trim();
            }
            if (this.getAttributeByName(element, Constants.prefix) != null) {
                this.parsePrefixes(this.getAttributeByName(element, Constants.prefix).getValue(), context);
            }
        }
        if (this.settings.contains(Setting.ManualNamespaces)) {
            if (this.getAttributeByName(element, Constants.xmllang) != null) {
                currentLanguage = this.getAttributeByName(element, Constants.xmllang).getValue();
                if (currentLanguage.length() == 0) {
                    currentLanguage = null;
                }
            } else if (this.getAttributeByName(element, Constants.lang) != null && (currentLanguage = this.getAttributeByName(element, Constants.lang).getValue()).length() == 0) {
                currentLanguage = null;
            }
        } else if (this.getAttributeByName(element, Constants.xmllangNS) != null && (currentLanguage = this.getAttributeByName(element, Constants.xmllangNS).getValue()).length() == 0) {
            currentLanguage = null;
        }
        if (Constants.base.equals(element.getName()) && this.getAttributeByName(element, Constants.href) != null) {
            context.setBase(this.getAttributeByName(element, Constants.href).getValue());
            this.sink.setBase(context.getBase());
        }
        if (this.getAttributeByName(element, Constants.rev) == null && this.getAttributeByName(element, Constants.rel) == null) {
            nSubj = this.findAttribute(element, Constants.about);
            if (nSubj != null) {
                newSubject = this.extractor.getURI(element, nSubj, context);
            }
            if (newSubject == null) {
                if (Constants.body.equals(element.getName()) || Constants.head.equals(element.getName())) {
                    newSubject = context.base;
                } else if (this.getAttributeByName(element, Constants.typeof) != null) {
                    newSubject = this.createBNode();
                } else {
                    if (context.parentObject != null) {
                        newSubject = context.parentObject;
                    }
                    if (this.getAttributeByName(element, Constants.property) == null) {
                        skipElement = true;
                    }
                }
            }
        } else {
            Object cObj;
            nSubj = this.findAttribute(element, Constants.about, Constants.src);
            if (nSubj != null) {
                newSubject = this.extractor.getURI(element, nSubj, context);
            }
            if (newSubject == null) {
                if (Constants.head.equals(element.getName()) || Constants.body.equals(element.getName())) {
                    newSubject = context.base;
                } else if (this.getAttributeByName(element, Constants.typeof) != null) {
                    newSubject = this.createBNode();
                } else if (context.parentObject != null) {
                    newSubject = context.parentObject;
                }
            }
            if ((cObj = this.findAttribute(element, Constants.resource, Constants.href)) != null) {
                currentObject = this.extractor.getURI(element, (Attribute)cObj, context);
            }
        }
        if (newSubject != null && this.getAttributeByName(element, Constants.typeof) != null) {
            List<String> types = this.extractor.getURIs(element, this.getAttributeByName(element, Constants.typeof), context);
            for (String type : types) {
                this.emitTriples(newSubject, Constants.rdfType, type);
            }
        }
        if (currentObject != null) {
            if (this.getAttributeByName(element, Constants.rel) != null) {
                this.emitTriples(newSubject, this.extractor.getURIs(element, this.getAttributeByName(element, Constants.rel), context), currentObject);
            }
            if (this.getAttributeByName(element, Constants.rev) != null) {
                this.emitTriples(currentObject, this.extractor.getURIs(element, this.getAttributeByName(element, Constants.rev), context), newSubject);
            }
        } else {
            if (this.getAttributeByName(element, Constants.rel) != null) {
                forwardProperties.addAll(this.extractor.getURIs(element, this.getAttributeByName(element, Constants.rel), context));
            }
            if (this.getAttributeByName(element, Constants.rev) != null) {
                backwardProperties.addAll(this.extractor.getURIs(element, this.getAttributeByName(element, Constants.rev), context));
            }
            if (!forwardProperties.isEmpty() || !backwardProperties.isEmpty()) {
                currentObject = this.createBNode();
            }
        }
        if (this.getAttributeByName(element, Constants.property) != null) {
            List<String> props = this.extractor.getURIs(element, this.getAttributeByName(element, Constants.property), context);
            String dt = this.getDatatype(element);
            if (this.getAttributeByName(element, Constants.content) != null) {
                String lex = this.getAttributeByName(element, Constants.content).getValue();
                if (dt == null || dt.length() == 0) {
                    this.emitTriplesPlainLiteral(newSubject, props, lex, currentLanguage);
                } else {
                    this.emitTriplesDatatypeLiteral(newSubject, props, lex, dt);
                }
            } else {
                this.literalCollector.collect(newSubject, props, dt, currentLanguage);
            }
        }
        if (!skipElement && newSubject != null) {
            this.emitTriples(context.parentSubject, context.forwardProperties, newSubject);
            this.emitTriples(newSubject, context.backwardProperties, context.parentSubject);
        }
        EvalContext ec = new EvalContext(context);
        if (skipElement) {
            ec.language = currentLanguage;
        } else {
            ec.parentSubject = newSubject != null ? newSubject : context.parentSubject;
            ec.parentObject = currentObject != null ? currentObject : (newSubject != null ? newSubject : context.parentSubject);
            ec.language = currentLanguage;
            ec.forwardProperties = forwardProperties;
            ec.backwardProperties = backwardProperties;
        }
        return ec;
    }

    private void getNamespaces(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String qname = attrs.getQName(i);
            String prefix = this.getPrefix(qname);
            if (!"xmlns".equals(prefix)) continue;
            String pre = this.getLocal(prefix, qname);
            String uri = attrs.getValue(i);
            if (!this.settings.contains(Setting.ManualNamespaces) && pre.contains("_")) continue;
            this.context.setNamespaceURI(pre, uri);
            this.extractor.setNamespaceURI(pre, uri);
            this.sink.addPrefix(pre, uri);
        }
    }

    private String getPrefix(String qname) {
        if (!qname.contains(":")) {
            return "";
        }
        return qname.substring(0, qname.indexOf(":"));
    }

    private String getLocal(String prefix, String qname) {
        if (prefix.length() == 0) {
            return qname;
        }
        return qname.substring(prefix.length() + 1);
    }

    private Iterator<Attribute> fromAttributes(Attributes attributes) {
        ArrayList<Attribute> toReturn = new ArrayList<Attribute>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qname = attributes.getQName(i);
            String prefix = qname.contains(":") ? qname.substring(0, qname.indexOf(":")) : "";
            Attribute attr = this.eventFactory.createAttribute(prefix, attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
            if (qname.equals("xmlns") || qname.startsWith("xmlns:")) continue;
            toReturn.add(attr);
        }
        return toReturn.iterator();
    }

    private Attribute findAttribute(StartElement element, QName ... names) {
        for (QName aName : names) {
            Attribute a = this.getAttributeByName(element, aName);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    private void parsePrefixes(String value, EvalContext context) {
        String[] parts = value.split("\\s+");
        for (int i = 0; i < parts.length; i += 2) {
            String prefix = parts[i];
            if (i + 1 >= parts.length || !prefix.endsWith(":")) continue;
            String prefixFix = prefix.substring(0, prefix.length() - 1);
            context.setPrefix(prefixFix, parts[i + 1]);
            this.sink.addPrefix(prefixFix, parts[i + 1]);
        }
    }

    private Attribute getAttributeByName(StartElement element, QName name) {
        if (name == null || element == null) {
            return null;
        }
        Iterator<Attribute> it = element.getAttributes();
        while (it.hasNext()) {
            Attribute at = it.next();
            if (!Util.qNameEquals(at.getName(), name)) continue;
            return at;
        }
        return null;
    }

    private String createBNode() {
        return "_:node" + this.bnodeId++;
    }

    private String getDatatype(StartElement element) {
        Attribute de = this.getAttributeByName(element, Constants.datatype);
        if (de == null) {
            return null;
        }
        String dt = de.getValue();
        if (dt.length() == 0) {
            return dt;
        }
        return this.extractor.expandCURIE(element, dt, this.context);
    }
}

