/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageConstraint;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

class ZipHelper {
    private ZipFile mZipFile = null;
    private byte[] mZipBuffer = null;
    private OdfPackage mPackage = null;

    public ZipHelper(OdfPackage pkg, ZipFile zipFile) {
        this.mZipFile = zipFile;
        this.mZipBuffer = null;
        this.mPackage = pkg;
    }

    public ZipHelper(OdfPackage pkg, byte[] buffer) throws IOException {
        this.mZipBuffer = buffer;
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.mZipBuffer);
        this.mZipFile = new ZipFile.Builder().setSeekableByteChannel((SeekableByteChannel)c).setUseUnicodeExtraFields(false).get();
        this.mPackage = pkg;
    }

    String entriesToMap(Map<String, ZipArchiveEntry> zipEntries) throws IOException, SAXException {
        ZipArchiveEntry zipEntry;
        Enumeration entries;
        String firstEntryName = null;
        if (this.mZipFile != null && (entries = this.mZipFile.getEntries()).hasMoreElements() && (zipEntry = (ZipArchiveEntry)entries.nextElement()) != null) {
            firstEntryName = zipEntry.getName();
            this.addZipEntry(zipEntry, zipEntries);
            while (entries.hasMoreElements()) {
                zipEntry = (ZipArchiveEntry)entries.nextElement();
                this.addZipEntry(zipEntry, zipEntries);
            }
        }
        return firstEntryName;
    }

    private boolean isValidZipEntryFileName(String filePath) {
        if (filePath.length() == 0) {
            return false;
        }
        if (1 < filePath.length() && filePath.charAt(1) == ':') {
            return false;
        }
        int dots = 0;
        block5: for (int i = 0; i < filePath.length(); ++i) {
            char c = filePath.charAt(i);
            switch (c) {
                case '\\': {
                    return false;
                }
                case '.': {
                    if (dots == -1) continue block5;
                    ++dots;
                    continue block5;
                }
                case '/': {
                    if (dots == 1 || dots == 2 || i == 0) {
                        return false;
                    }
                    dots = 0;
                    continue block5;
                }
                default: {
                    dots = -1;
                    if (c >= ' ' && ('\ud800' > c || c > '\udffff')) continue block5;
                    return false;
                }
            }
        }
        return dots != 1 && dots != 2;
    }

    private void addZipEntry(ZipArchiveEntry zipEntry, Map<String, ZipArchiveEntry> zipEntries) throws SAXException {
        String filePath = zipEntry.getName();
        ErrorHandler errorHandler = this.mPackage.getErrorHandler();
        int zipMethod = zipEntry.getMethod();
        if (zipMethod != 0 && zipMethod != 8 && errorHandler != null) {
            errorHandler.error(new OdfValidationException((ValidationConstraint)OdfPackageConstraint.PACKAGE_ENTRY_USING_INVALID_COMPRESSION, this.mPackage.getBaseURI(), filePath));
        }
        if (!this.isValidZipEntryFileName(filePath)) {
            OdfValidationException e = new OdfValidationException((ValidationConstraint)OdfPackageConstraint.PACKAGE_ENTRY_INVALID_FILE_NAME, this.mPackage.getBaseURI(), filePath);
            if (errorHandler != null) {
                errorHandler.fatalError(e);
            }
            throw e;
        }
        if (zipEntries.containsKey(filePath)) {
            OdfValidationException e = new OdfValidationException((ValidationConstraint)OdfPackageConstraint.PACKAGE_ENTRY_DUPLICATE, this.mPackage.getBaseURI(), filePath);
            if (errorHandler != null) {
                errorHandler.fatalError(e);
            }
            throw e;
        }
        zipEntries.put(filePath, zipEntry);
    }

    InputStream getInputStream(ZipArchiveEntry entry) throws IOException {
        if (this.mZipFile != null) {
            return this.mZipFile.getInputStream(entry);
        }
        return null;
    }

    void close() throws IOException {
        if (this.mZipFile != null) {
            this.mZipFile.close();
            this.mZipFile = null;
        }
        this.mZipBuffer = null;
    }
}

