/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfNamespace;

public final class OdfName
implements Comparable<OdfName> {
    private static final Map<String, OdfName> mOdfNames = new ConcurrentHashMap<String, OdfName>();
    private final OdfNamespace mNS;
    private final String mLocalName;
    private final String mQName;
    private final String mExpandedName;

    private OdfName(OdfNamespace ns, String localname, String expandedName) {
        this.mNS = ns;
        this.mLocalName = localname;
        this.mQName = this.mNS != null ? (this.mNS.getPrefix() + ":" + this.mLocalName).intern() : this.mLocalName;
        this.mExpandedName = expandedName;
    }

    public static OdfName newName(String name) {
        return OdfName.createName(null, name);
    }

    public static OdfName newName(OdfNamespace odfNamespace, String name) {
        return OdfName.createName(odfNamespace, name);
    }

    public static OdfName newName(NamespaceName namespaceNamed, String name) {
        return OdfName.createName(OdfNamespace.newNamespace(namespaceNamed), name);
    }

    public static OdfName newName(String uri, String qname) {
        String prefix = OdfNamespace.getPrefixPart(qname);
        String localName = OdfNamespace.getLocalPart(qname);
        OdfNamespace ns = OdfNamespace.newNamespace(prefix, uri);
        return OdfName.createName(ns, localName);
    }

    private static OdfName createName(OdfNamespace odfNamespace, String name) {
        int i = 0;
        i = name.indexOf(58);
        if (i >= 0) {
            name = name.substring(i + 1);
        }
        return OdfName.getOdfName(odfNamespace, name);
    }

    public static OdfName getOdfName(OdfNamespace odfNamespace, String localName) {
        String expandedName = null;
        expandedName = odfNamespace != null ? OdfName.createExpandedName(odfNamespace.toString(), localName) : localName;
        return mOdfNames.computeIfAbsent(expandedName, k -> new OdfName(odfNamespace, localName, (String)k));
    }

    private static String createExpandedName(String nsUri, String localName) {
        StringBuilder mSB = new StringBuilder();
        mSB.append('{');
        mSB.append(nsUri);
        mSB.append('}');
        mSB.append(localName);
        return mSB.toString();
    }

    public String getUri() {
        if (this.mNS == null) {
            return null;
        }
        return this.mNS.getUri();
    }

    public String getLocalName() {
        return this.mLocalName;
    }

    public String getPrefix() {
        String prefix = null;
        if (this.mNS != null) {
            prefix = this.mNS.getPrefix();
        }
        return prefix;
    }

    public String getQName() {
        return this.mQName;
    }

    public String toString() {
        return this.mExpandedName;
    }

    public boolean equals(Object obj) {
        return obj instanceof OdfName && this.toString().equals(obj.toString());
    }

    public boolean equals(String namespaceUri, String name) {
        if (!this.mNS.getUri().equals(namespaceUri)) {
            return false;
        }
        int beginIndex = name.indexOf(58);
        if (beginIndex >= 0) {
            return this.mLocalName.equals(name.substring(beginIndex + 1));
        }
        return this.mLocalName.equals(name);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(OdfName o) {
        return this.toString().compareTo(o.toString());
    }
}

