/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.odftoolkit.odfdom.changes.Cell;
import org.odftoolkit.odfdom.changes.CollabTextDocument;
import org.odftoolkit.odfdom.changes.Component;
import org.odftoolkit.odfdom.changes.FieldMap;
import org.odftoolkit.odfdom.changes.MapHelper;
import org.odftoolkit.odfdom.changes.PageArea;
import org.odftoolkit.odfdom.changes.Row;
import org.odftoolkit.odfdom.changes.Table;
import org.odftoolkit.odfdom.changes.TextContainer;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfSchemaConstraint;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRunThroughAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableDefaultCellStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStyleNameAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.dc.DcCreatorElement;
import org.odftoolkit.odfdom.dom.element.dc.DcDateElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawGElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawImageElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawShapeElementBase;
import org.odftoolkit.odfdom.dom.element.draw.DrawTextBoxElement;
import org.odftoolkit.odfdom.dom.element.number.NumberDataStyleElementBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationEndElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeFontFaceDeclsElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMasterStylesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleChartPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleDefaultStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleDrawingPagePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFontFaceElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderFooterPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleListLevelLabelAlignmentElement;
import org.odftoolkit.odfdom.dom.element.style.StyleListLevelPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.style.StylePageLayoutPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleRubyPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleSectionPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTabStopElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTabStopsElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableColumnPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElementBase;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextLineBreakElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextListHeaderElement;
import org.odftoolkit.odfdom.dom.element.text.TextListItemElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleImageElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.element.text.TextTabElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfGraphicProperties;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.incubator.doc.draw.OdfDrawImage;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberDateStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberTimeStyle;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfDefaultStyle;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStylePageLayout;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextListStyle;
import org.odftoolkit.odfdom.pkg.OdfAttribute;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.odftoolkit.odfdom.type.Base64Binary;
import org.odftoolkit.odfdom.type.StyleName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class JsonOperationConsumer {
    private static final Logger LOG = Logger.getLogger(JsonOperationConsumer.class.getName());
    private static JSONObject CELL_WITH_BORDER_ATTRS = null;
    private static final String INSERT_BEFORE = "before";
    private static final String INSERT_AFTER = "after";
    private static final String HUNDRED_PERCENT = "100%";
    private static final int NO_OUTLINE_LEVEL = -2;

    public static int applyOperations(CollabTextDocument opsDoc, JSONArray ops) throws Exception {
        LOG.log(Level.FINEST, "*************** INCOMING OPERATIONS **********\n{0}", ops);
        int acceptedOpCount = 0;
        OdfTextDocument doc = opsDoc.getDocument();
        OdfStylesDom stylesDom = doc.getStylesDom();
        OdfContentDom contentDom = doc.getContentDom();
        Component rootComponent = null;
        JSONObject op = null;
        try {
            for (int i = 0; i < ops.length(); ++i) {
                String representation;
                String styleName;
                String styleId;
                String type;
                String id;
                String type2;
                String id2;
                JSONArray start;
                JSONObject attrs;
                JSONObject attrs2;
                JSONArray start2;
                opsDoc.setAppliedChangesCount(i);
                op = (JSONObject)ops.get(i);
                String opName = op.getString("name");
                String context = op.optString("context");
                if (context == null || context.isEmpty()) {
                    rootComponent = doc.getRootComponent();
                } else {
                    String masterPageName = null;
                    PageArea pageArea = null;
                    OdfElement targetElement = null;
                    if (context.startsWith("header")) {
                        if (context.startsWith(PageArea.HEADER_DEFAULT.getPageAreaName())) {
                            masterPageName = context.substring(PageArea.HEADER_DEFAULT.getPageAreaName().length() + 1, context.length());
                            pageArea = PageArea.HEADER_DEFAULT;
                        } else if (context.startsWith(PageArea.HEADER_FIRST.getPageAreaName())) {
                            masterPageName = context.substring(PageArea.HEADER_FIRST.getPageAreaName().length() + 1, context.length());
                            pageArea = PageArea.HEADER_FIRST;
                        } else if (context.startsWith(PageArea.HEADER_EVEN.getPageAreaName())) {
                            masterPageName = context.substring(PageArea.HEADER_EVEN.getPageAreaName().length() + 1, context.length());
                            pageArea = PageArea.HEADER_EVEN;
                        }
                        targetElement = doc.getRootComponentElement(masterPageName, pageArea, false);
                    } else if (context.startsWith("footer")) {
                        if (context.startsWith(PageArea.FOOTER_DEFAULT.getPageAreaName())) {
                            masterPageName = context.substring(PageArea.FOOTER_DEFAULT.getPageAreaName().length() + 1, context.length());
                            pageArea = PageArea.FOOTER_DEFAULT;
                        } else if (context.startsWith(PageArea.FOOTER_FIRST.getPageAreaName())) {
                            masterPageName = context.substring(PageArea.FOOTER_FIRST.getPageAreaName().length() + 1, context.length());
                            pageArea = PageArea.FOOTER_FIRST;
                        } else if (context.startsWith(PageArea.FOOTER_EVEN.getPageAreaName())) {
                            masterPageName = context.substring(PageArea.FOOTER_EVEN.getPageAreaName().length() + 1, context.length());
                            pageArea = PageArea.FOOTER_EVEN;
                        }
                        targetElement = doc.getRootComponentElement(masterPageName, pageArea, false);
                    } else if (context.startsWith("cmt")) {
                        doc.getRootComponent();
                        targetElement = opsDoc.getDocument().getAnnotation(context.substring("cmt".length()));
                    }
                    rootComponent = targetElement.getComponent();
                    if (rootComponent == null) {
                        rootComponent = new Component(targetElement);
                    }
                }
                if (opName.equals("addParagraph")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    attrs2 = op.optJSONObject("attrs");
                    JsonOperationConsumer.addParagraph(rootComponent, start2, attrs2);
                    continue;
                }
                if (opName.equals("delete")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    JSONArray end = JsonOperationConsumer.decrementAll(op.optJSONArray("end"));
                    JsonOperationConsumer.delete(rootComponent, start2, end);
                    continue;
                }
                if (opName.equals("addText")) {
                    ++acceptedOpCount;
                    attrs = op.optJSONObject("attrs");
                    start = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    String text = op.getString("text");
                    JsonOperationConsumer.addText(rootComponent, start, attrs, text);
                    continue;
                }
                if (opName.equals("addTable")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    attrs2 = op.optJSONObject("attrs");
                    JSONObject sizeExceeded = op.optJSONObject("sizeExceeded");
                    JsonOperationConsumer.addTable(rootComponent, start2, attrs2, sizeExceeded, null);
                    continue;
                }
                if (opName.equals("addRows")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    attrs2 = op.optJSONObject("attrs");
                    int count = op.optInt("count", 1);
                    boolean addDefaultCells = op.optBoolean("addDefaultCells");
                    int referenceRow = op.optInt("referenceRow", -1);
                    JsonOperationConsumer.addRows(rootComponent, start2, attrs2, count, addDefaultCells, referenceRow, true);
                    continue;
                }
                if (opName.equals("addCells")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    attrs2 = op.optJSONObject("attrs");
                    int count = op.optInt("count", 1);
                    JsonOperationConsumer.addCells(rootComponent, start2, attrs2, count, null, null, true);
                    continue;
                }
                if (opName.equals("addColumn")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    Integer gridPosition = op.getInt("gridPosition");
                    JSONArray tableGrid = op.getJSONArray("tableGrid");
                    String insertMode = op.optString("insertMode");
                    JsonOperationConsumer.addColumns(rootComponent, start2, tableGrid, gridPosition, insertMode);
                    continue;
                }
                if (opName.equals("deleteColumns")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    Integer startGrid = op.getInt("startGrid");
                    Integer endGrid = op.optInt("endGrid");
                    JsonOperationConsumer.deleteColumns(rootComponent, start2, startGrid, endGrid);
                    continue;
                }
                if (opName.equalsIgnoreCase("addNote")) {
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    id2 = op.getString("id");
                    String author = op.optString("author");
                    String date = op.optString("date");
                    JSONObject attrs3 = op.optJSONObject("attrs");
                    JsonOperationConsumer.addAnnotation(rootComponent, start2, attrs3, id2, author, date);
                    continue;
                }
                if (opName.equalsIgnoreCase("addNoteSelection")) {
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    id2 = op.getString("id");
                    type2 = op.optString("type");
                    String position = op.optString("position");
                    JSONObject attrs4 = op.optJSONObject("attrs");
                    JsonOperationConsumer.addNoteSelection(rootComponent, start2, type2, position, attrs4, id2);
                    continue;
                }
                if (opName.equalsIgnoreCase("addHeaderFooter")) {
                    id = op.getString("id");
                    JsonOperationConsumer.addDeleteHeaderFooter(doc, true, id);
                    continue;
                }
                if (opName.equalsIgnoreCase("deleteHeaderFooterContent")) {
                    id = op.getString("id");
                    JsonOperationConsumer.addDeleteHeaderFooter(doc, false, id);
                    continue;
                }
                if (opName.equalsIgnoreCase("documentLayout")) {
                    attrs = op.optJSONObject("attrs");
                    JsonOperationConsumer.modifyPages(doc, attrs);
                    continue;
                }
                if (opName.equals("format")) {
                    ++acceptedOpCount;
                    attrs = op.optJSONObject("attrs");
                    start = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    JSONArray end = JsonOperationConsumer.decrementAll(op.optJSONArray("end"));
                    JsonOperationConsumer.format(rootComponent, start, end, attrs);
                    continue;
                }
                if (opName.equals("mergeParagraph")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    JsonOperationConsumer.mergeParagraph(rootComponent, start2);
                    continue;
                }
                if (opName.equals("splitParagraph")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    JsonOperationConsumer.splitParagraph(rootComponent, start2);
                    continue;
                }
                if (opName.equals("addStyle")) {
                    ++acceptedOpCount;
                    type = op.getString("type");
                    styleId = op.getString("styleId");
                    styleName = op.optString("styleName");
                    JSONObject attrs5 = op.optJSONObject("attrs");
                    String parent = op.optString("parent");
                    Boolean hidden = op.optBoolean("hidden");
                    Boolean custom = op.optBoolean("custom");
                    JsonOperationConsumer.addStyles(doc, type, styleId, styleName, attrs5, parent, hidden, custom);
                    continue;
                }
                if (opName.equals("changeStyle")) {
                    ++acceptedOpCount;
                    type = op.getString("type");
                    styleId = op.getString("styleId");
                    styleName = op.optString("styleName");
                    JSONObject attrs6 = op.optJSONObject("attrs");
                    JsonOperationConsumer.changeStyle(doc, type, styleId, styleName, attrs6);
                    continue;
                }
                if (opName.equals("deleteStyle")) {
                    ++acceptedOpCount;
                    type = op.getString("type");
                    styleId = op.getString("styleId");
                    JsonOperationConsumer.deleteStyle(doc, styleId, type);
                    continue;
                }
                if (opName.equals("addFontDecl")) {
                    ++acceptedOpCount;
                    attrs = op.getJSONObject("attrs");
                    JSONArray panose1 = attrs.optJSONArray("panose1");
                    String panose1Value = null;
                    if (panose1 != null) {
                        panose1Value = panose1.toString();
                    }
                    String fontName = op.getString("fontName");
                    String[] altNames = (String[])attrs.opt("altNames");
                    String family = attrs.optString("family");
                    String familyGeneric = attrs.optString("familyGeneric");
                    String pitch = attrs.optString("pitch");
                    JsonOperationConsumer.addFontData(doc, fontName, altNames, family, familyGeneric, pitch, panose1Value);
                    continue;
                }
                if (opName.equals("addTab")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    attrs2 = op.optJSONObject("attrs");
                    JsonOperationConsumer.addTab(rootComponent, start2, attrs2);
                    continue;
                }
                if (opName.equals("addLineBreak")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    attrs2 = op.optJSONObject("attrs");
                    JsonOperationConsumer.addLineBreak(rootComponent, start2, attrs2);
                    continue;
                }
                if (opName.equals("addDrawing")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    String type3 = op.optString("type");
                    JSONObject attrs7 = op.optJSONObject("attrs");
                    JsonOperationConsumer.addDrawing(rootComponent, start2, attrs7, type3, opsDoc);
                    continue;
                }
                if (opName.equals("addField")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    representation = op.optString("representation");
                    type2 = op.optString("type");
                    JSONObject attrs8 = op.optJSONObject("attrs");
                    JsonOperationConsumer.addField(rootComponent, opsDoc.getDocument().getContentDom(), start2, type2, representation, attrs8);
                    continue;
                }
                if (opName.equals("updateField")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    representation = op.optString("representation");
                    type2 = op.optString("type");
                    JSONObject attrs9 = op.optJSONObject("attrs");
                    JsonOperationConsumer.changeField(rootComponent, opsDoc.getDocument().getContentDom(), start2, type2, representation, attrs9);
                    continue;
                }
                if (opName.equals("move")) {
                    ++acceptedOpCount;
                    start2 = JsonOperationConsumer.decrementAll(op.getJSONArray("start"));
                    JSONArray to = JsonOperationConsumer.decrementAll(op.getJSONArray("to"));
                    JsonOperationConsumer.move(rootComponent, start2, to);
                    continue;
                }
                if (opName.equals("addListStyle")) {
                    ++acceptedOpCount;
                    String listStyle = op.optString("listStyleId");
                    JSONObject listDefinition = op.optJSONObject("listDefinition");
                    JsonOperationConsumer.addListStyle(listStyle, listDefinition, doc);
                    continue;
                }
                if (opName.equals("createError")) {
                    throw new Exception("ERROR_SIMULATED");
                }
                LOG.log(Level.FINEST, "Operation is unknown: {0}", opName);
            }
            opsDoc.setAppliedChangesCount(ops.length());
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "An error occurred in the operation number {0}{1}", new Object[]{acceptedOpCount, 1});
            LOG.severe("The operation was: " + String.valueOf(op));
            throw e;
        }
        return acceptedOpCount;
    }

    public static void addParagraph(Component rootComponent, JSONArray start, JSONObject attrs) throws IndexOutOfBoundsException {
        Component parentComponent = rootComponent.getParentOf(start);
        if (parentComponent == null) {
            LOG.log(Level.SEVERE, "The parent component of the table should exist at position {0}", start);
        } else {
            int newPosition = start.optInt(start.length() - 1);
            JsonOperationConsumer.addParagraph(parentComponent, newPosition, attrs);
        }
    }

    public static TextParagraphElementBase addParagraph(Component parentComponent, int newPosition, JSONObject attrs) throws IndexOutOfBoundsException {
        TextParagraphElementBase paragraphBaseElement;
        OdfFileDom xmlDoc = (OdfFileDom)((Object)parentComponent.getOwnerDocument());
        JSONObject paraProps = null;
        if (attrs != null) {
            paraProps = attrs.optJSONObject("paragraph");
            if (paraProps != null) {
                int outlineLevel = paraProps.optInt("outlineLevel");
                if (outlineLevel != 0) {
                    paragraphBaseElement = new TextHElement(xmlDoc);
                    ((TextHElement)paragraphBaseElement).setTextOutlineLevelAttribute(outlineLevel);
                } else {
                    paragraphBaseElement = new TextPElement(xmlDoc);
                }
            } else {
                paragraphBaseElement = new TextPElement(xmlDoc);
            }
        } else {
            paragraphBaseElement = new TextPElement(xmlDoc);
        }
        JsonOperationConsumer.addElementAsComponent(parentComponent, paragraphBaseElement, newPosition);
        StyleStyleElement autoStyle = JsonOperationConsumer.addStyle(attrs, paragraphBaseElement, xmlDoc);
        if (paraProps != null && paraProps.has("listLevel")) {
            int newListLevel;
            String listStyleId;
            if (paraProps.has("listStyleId") && (listStyleId = paraProps.optString("listStyleId")) != null && !listStyleId.isEmpty()) {
                autoStyle.setStyleListStyleNameAttribute(listStyleId);
            }
            int listLevel = JsonOperationConsumer.getListLevel(paragraphBaseElement);
            if (paraProps.isNull("listLevel")) {
                newListLevel = -1;
            } else {
                newListLevel = paraProps.optInt("listLevel", -2);
                if (newListLevel == -2) {
                    newListLevel = listLevel;
                }
            }
            String currentListStyleName = null;
            TextListElement rootListElement = JsonOperationConsumer.getListRootElement(paragraphBaseElement);
            if (rootListElement != null) {
                currentListStyleName = rootListElement.getTextStyleNameAttribute();
            }
            JsonOperationConsumer.setParagraphListProperties(paragraphBaseElement, paraProps, xmlDoc, listLevel, newListLevel, currentListStyleName);
        }
        return paragraphBaseElement;
    }

    public static void addTab(Component rootComponent, JSONArray start, JSONObject attrs) throws IndexOutOfBoundsException {
        Component parentComponent = rootComponent.getParentOf(start);
        if (parentComponent == null) {
            LOG.log(Level.SEVERE, "The parent component of the table should exist at position {0}", start);
        } else {
            OdfFileDom xmlDoc = (OdfFileDom)((Object)parentComponent.getOwnerDocument());
            OdfElement newElement = new TextTabElement(xmlDoc);
            if (attrs != null) {
                TextSpanElement newSpanElement = new TextSpanElement(xmlDoc);
                JsonOperationConsumer.addStyle(attrs, newSpanElement, xmlDoc);
                newSpanElement.appendChild((Node)((Object)newElement));
                newElement = newSpanElement;
            }
            try {
                JsonOperationConsumer.addElementAsComponent(parentComponent, newElement, start.getInt(start.length() - 1));
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void addLineBreak(Component rootComponent, JSONArray start, JSONObject attrs) throws IndexOutOfBoundsException {
        Component parentComponent = rootComponent.getParentOf(start);
        if (parentComponent == null) {
            LOG.log(Level.SEVERE, "The parent component of the table should exist at position {0}", start);
        } else {
            OdfFileDom xmlDoc = (OdfFileDom)((Object)parentComponent.getOwnerDocument());
            OdfElement newElement = new TextLineBreakElement(xmlDoc);
            if (attrs != null) {
                TextSpanElement newSpanElement = new TextSpanElement(xmlDoc);
                JsonOperationConsumer.addStyle(attrs, newSpanElement, xmlDoc);
                newSpanElement.appendChild((Node)((Object)newElement));
                newElement = newSpanElement;
            }
            try {
                JsonOperationConsumer.addElementAsComponent(parentComponent, newElement, start.getInt(start.length() - 1));
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    public static StyleStyleElement addStyle(JSONObject attrs, OdfStylableElement newElement, OdfFileDom ownerDocument) {
        StyleStyleElement autoStyle = null;
        OdfDocument doc = (OdfDocument)ownerDocument.getDocument();
        if (attrs != null) {
            String styleName;
            OdfStyleFamily styleFamily = newElement.getStyleFamily();
            boolean hasHardFormatting = JsonOperationConsumer.hasHardProperties(attrs, styleFamily);
            if (attrs.has("styleId") && !attrs.isNull("styleId")) {
                styleName = attrs.optString("styleId");
                if (!hasHardFormatting) {
                    JsonOperationConsumer.addStyleNameAttribute(newElement, styleFamily, ownerDocument, styleName);
                } else {
                    autoStyle = newElement.getOrCreateUnqiueAutomaticStyle();
                    JsonOperationConsumer.modifyListStyleName(attrs, autoStyle);
                    JsonOperationConsumer.addStyleNameAttribute(newElement, styleFamily, ownerDocument, autoStyle.getStyleNameAttribute());
                    autoStyle.setStyleParentStyleNameAttribute(styleName);
                    JsonOperationConsumer.mapProperties(styleFamily, attrs, autoStyle, doc);
                }
            } else {
                styleName = newElement.getStyleName();
                if (styleName != null) {
                    if (styleName.isEmpty() && !hasHardFormatting) {
                        newElement.removeAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "style-name");
                    } else {
                        boolean removeTemplateStyle;
                        boolean bl = removeTemplateStyle = attrs.has("styleId") && attrs.isNull("styleId");
                        if (newElement instanceof TableTableColumnElement) {
                            if (removeTemplateStyle) {
                                autoStyle = newElement.getOrCreateUnqiueAutomaticStyle();
                                autoStyle.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "parent-style-name");
                            }
                            if (attrs.has("column")) {
                                if (autoStyle == null) {
                                    autoStyle = newElement.getOrCreateUnqiueAutomaticStyle();
                                }
                                JsonOperationConsumer.mapProperties(styleFamily, attrs, autoStyle, doc);
                                if (removeTemplateStyle) {
                                    JsonOperationConsumer.addStyleNameAttribute(newElement, styleFamily, ownerDocument, autoStyle.getStyleNameAttribute());
                                }
                            }
                            if (attrs.has("cell") || attrs.has("paragraph") || attrs.has("text")) {
                                autoStyle = newElement.getOrCreateUnqiueAutomaticStyle(false, OdfStyleFamily.TableCell);
                                JsonOperationConsumer.mapProperties(OdfStyleFamily.TableCell, attrs, autoStyle, doc);
                                TableDefaultCellStyleNameAttribute attr = new TableDefaultCellStyleNameAttribute(ownerDocument);
                                newElement.setOdfAttribute(attr);
                                attr.setValue(autoStyle.getStyleNameAttribute());
                            }
                        } else {
                            autoStyle = newElement.getOrCreateUnqiueAutomaticStyle();
                            JsonOperationConsumer.modifyListStyleName(attrs, autoStyle);
                            try {
                                JSONObject paragraphAttr = null;
                                if (newElement instanceof TextPElement && styleFamily.equals(OdfStyleFamily.Paragraph) && attrs.has("paragraph") && ((paragraphAttr = attrs.getJSONObject("paragraph")).has("pageBreakBefore") || paragraphAttr.has("pageBreakAfter"))) {
                                    OdfStylableElement tableElement = null;
                                    for (Node parent = newElement.getParentNode(); parent != null && !(parent instanceof DrawFrameElement); parent = parent.getParentNode()) {
                                        if (!(parent instanceof TableTableElement)) continue;
                                        tableElement = (TableTableElement)((Object)parent);
                                    }
                                    if (tableElement != null) {
                                        OdfStyle tableStyle = tableElement.getAutomaticStyle();
                                        OdfStylePropertiesBase propsElement = tableStyle.getOrCreatePropertiesElement(OdfStylePropertiesSet.TableProperties);
                                        JSONObject paraAttrs = attrs.getJSONObject("paragraph");
                                        boolean isBefore = paragraphAttr.has("pageBreakBefore");
                                        String attrName = isBefore ? "pageBreakBefore" : "pageBreakAfter";
                                        boolean breakValue = !paraAttrs.isNull(attrName) && paraAttrs.getBoolean(attrName);
                                        paraAttrs.remove(attrName);
                                        if (breakValue) {
                                            propsElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), isBefore ? "fo:break-before" : "fo:break-after", "page");
                                            propsElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), isBefore ? "break-after" : "break-before");
                                        } else {
                                            propsElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), isBefore ? "break-before" : "break-after");
                                        }
                                    }
                                }
                            }
                            catch (JSONException paragraphAttr) {
                                // empty catch block
                            }
                            JsonOperationConsumer.mapProperties(styleFamily, attrs, autoStyle, doc);
                            if (removeTemplateStyle) {
                                autoStyle.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "parent-style-name");
                                JsonOperationConsumer.addStyleNameAttribute(newElement, styleFamily, ownerDocument, autoStyle.getStyleNameAttribute());
                            }
                        }
                    }
                }
            }
            JSONObject cellAttrs = attrs.optJSONObject("cell");
            if (cellAttrs != null) {
                String formatCode = cellAttrs.optString("formatCode");
                if (!formatCode.isEmpty()) {
                    String dataStyleName = MapHelper.findOrCreateDataStyle(formatCode, cellAttrs.optLong("formatId", -1L), ownerDocument);
                    autoStyle.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:data-style-name", dataStyleName);
                } else {
                    autoStyle.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "data-style-name");
                }
            }
        }
        return autoStyle;
    }

    public static void modifyListStyleName(JSONObject attrs, OdfStyleBase autoStyle) {
        if (attrs.has("paragraph")) {
            JSONObject paraProps = attrs.optJSONObject("paragraph");
            String listStyleName = paraProps.optString("listStyleId");
            if (listStyleName == null) {
                autoStyle.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "list-style-name");
            } else if (!listStyleName.isEmpty()) {
                autoStyle.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:list-style-name", listStyleName);
            }
        }
    }

    public static void modifyListStyleName(JSONObject attrs, TextListElement rootListElement) {
        if (rootListElement != null && attrs.has("paragraph")) {
            JSONObject paraProps = attrs.optJSONObject("paragraph");
            String listStyleName = paraProps.optString("listStyleId");
            if (listStyleName == null) {
                rootListElement.removeAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "style-name");
            } else if (!listStyleName.isEmpty()) {
                rootListElement.setAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "text:style-name", listStyleName);
            }
        }
    }

    public static void addStyleNameAttribute(OdfElement newElement, OdfStyleFamily styleFamily, OdfFileDom ownerDocument, String styleName) {
        OdfAttribute attr;
        String attributeName = null;
        if (styleFamily.getName().equals("paragraph") || styleFamily.getName().equals("text")) {
            attr = new TextStyleNameAttribute(ownerDocument);
            newElement.setOdfAttribute(attr);
            attr.setValue(styleName);
            attributeName = "text:style-name";
        } else if (styleFamily.getName().equals("table") || styleFamily.getName().equals("table-column") || styleFamily.getName().equals("table-row") || styleFamily.getName().equals("table-cell")) {
            attr = new TableStyleNameAttribute(ownerDocument);
            newElement.setOdfAttribute(attr);
            attr.setValue(styleName);
            attributeName = "table:style-name";
        } else if (styleFamily.getName().equals("graphic")) {
            attr = new DrawStyleNameAttribute(ownerDocument);
            newElement.setOdfAttribute(attr);
            attr.setValue(styleName);
            attributeName = "draw:style-name";
        }
        ErrorHandler errorHandler = ownerDocument.getDocument().getPackage().getErrorHandler();
        if (errorHandler != null && attributeName != null && !StyleName.isValid(styleName)) {
            try {
                errorHandler.error(new OdfValidationException((ValidationConstraint)OdfSchemaConstraint.DOCUMENT_XML_INVALID_ATTRIBUTE_VALUE, styleName, attributeName));
            }
            catch (SAXException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void move(Component rootComponent, JSONArray start, JSONArray to) {
        try {
            Component parentSourceComponent = rootComponent.getParentOf(start);
            OdfElement movedNode = (OdfElement)((Object)parentSourceComponent.remove(start.getInt(start.length() - 1)));
            JsonOperationConsumer.insert(rootComponent, movedNode, to);
        }
        catch (JSONException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    static OdfElement copy(Component rootComponent, JSONArray start, JSONArray to) {
        Component sourceComponent = rootComponent.get(start);
        OdfElement source = (OdfElement)((Object)sourceComponent.getRootElement().cloneNode(true));
        JsonOperationConsumer.insert(rootComponent, source, to);
        return source;
    }

    private static void insert(Component rootComponent, OdfElement rootElement, JSONArray to) {
        if (rootElement != null) {
            try {
                Component parentTargetComponent = rootComponent.getParentOf(to);
                parentTargetComponent.getRootElement().insert((Node)((Object)rootElement), to.getInt(to.length() - 1));
                if (rootElement instanceof OdfElement) {
                    parentTargetComponent.addChild(to.getInt(to.length() - 1), rootElement.getComponent());
                }
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    private static void deleteComponents(Component rootComponent, JSONArray start, JSONArray end) throws IndexOutOfBoundsException {
        Component parentComponent = rootComponent.getParentOf(start);
        OdfElement parentComponentElement = parentComponent.getRootElement();
        if (parentComponent instanceof TextContainer) {
            int pos = start.optInt(start.length() - 1);
            ((TextContainer)parentComponent).removeText(pos, pos + 1);
        } else {
            try {
                int endPos;
                int startPos = start.getInt(start.length() - 1);
                OdfElement targetElement = null;
                int deletionCount = 1;
                if (end != null) {
                    endPos = end.getInt(start.length() - 1);
                    deletionCount += endPos - startPos;
                } else {
                    endPos = startPos;
                }
                while (deletionCount > 0 && (targetElement = (OdfElement)((Object)parentComponent.getChildNode(endPos))) != null) {
                    int repetition = targetElement.getRepetition();
                    if (targetElement instanceof TableTableCellElement) {
                        Component tableComponent = parentComponent.getParent();
                        TableTableElement tableElement = (TableTableElement)tableComponent.mRootElement;
                        if (((Table)tableElement.getComponent()).isWidthChangeRequired()) {
                            OdfTable table = OdfTable.getInstance(tableElement);
                            table.removeColumnsByIndex(endPos, deletionCount - 1 + endPos, true);
                            ((Table)tableElement.getComponent()).hasChangedWidth();
                        }
                    }
                    if (repetition > 1) {
                        if (targetElement instanceof TableTableRowElement) {
                            if (deletionCount - repetition > 1) {
                                targetElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-repeated");
                                continue;
                            }
                            targetElement.setAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "table:number-rows-repeated", String.valueOf(repetition - deletionCount));
                            continue;
                        }
                        if (!(targetElement instanceof TableTableCellElement)) continue;
                        if (deletionCount - repetition > 1) {
                            targetElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
                            continue;
                        }
                        targetElement.setAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "table:number-columns-repeated", String.valueOf(repetition - deletionCount));
                        continue;
                    }
                    OdfElement targetParent = (OdfElement)((Object)targetElement.getParentNode());
                    if (targetParent.equals((Object)parentComponentElement)) {
                        parentComponentElement.removeChild((Node)((Object)targetElement));
                    } else if (targetParent instanceof DrawTextBoxElement) {
                        targetParent.removeChild((Node)((Object)targetElement));
                    } else {
                        JsonOperationConsumer.removeComponentElementAndInbetweenBoilerplate(parentComponentElement, targetElement);
                    }
                    if (!(parentComponent instanceof Table || parentComponent instanceof Row || parentComponent instanceof Cell)) {
                        try {
                            parentComponent.remove(start.getInt(start.length() - 1));
                        }
                        catch (JSONException ex) {
                            LOG.log(Level.SEVERE, null, ex);
                        }
                    }
                    --deletionCount;
                    --endPos;
                }
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    private static boolean removeComponentElementAndInbetweenBoilerplate(OdfElement parentComponentElement, OdfElement targetElement) {
        OdfElement targetParent = (OdfElement)((Object)targetElement.getParentNode());
        if (targetParent instanceof TextListItemElement) {
            OdfElement previousSibling = OdfElement.getPreviousSiblingElement((Node)((Object)targetElement));
            if (previousSibling == null) {
                OdfElement nextSibling = OdfElement.getNextSiblingElement((Node)((Object)targetElement));
                if (nextSibling != null) {
                    targetParent.removeChild((Node)((Object)targetElement));
                    TextListHeaderElement listHeader = new TextListHeaderElement((OdfFileDom)((Object)targetParent.getOwnerDocument()));
                    targetParent.moveChildrenTo((Element)((Object)listHeader));
                    OdfElement grandParent = (OdfElement)((Object)targetParent.getParentNode());
                    grandParent.replaceChild((Node)((Object)listHeader), (Node)((Object)targetParent));
                    targetParent = listHeader;
                } else {
                    targetParent.removeChild((Node)((Object)targetElement));
                }
            } else {
                targetParent.removeChild((Node)((Object)targetElement));
            }
        } else {
            targetParent.removeChild((Node)((Object)targetElement));
        }
        return JsonOperationConsumer.removeComponentElementAndEmptyBoilerplate(parentComponentElement, targetParent, targetParent.countDescendantComponents()) == 0;
    }

    private static int removeComponentElementAndEmptyBoilerplate(OdfElement componentParent, OdfElement targetElement, int descendantCount) {
        OdfElement targetParent = (OdfElement)((Object)targetElement.getParentNode());
        if (descendantCount == 0) {
            targetParent.removeChild((Node)((Object)targetElement));
        }
        if (!targetParent.equals((Object)componentParent)) {
            JsonOperationConsumer.removeComponentElementAndEmptyBoilerplate(componentParent, targetParent, targetParent.countDescendantComponents());
        }
        return descendantCount;
    }

    public static void addText(Component rootComponent, JSONArray start, JSONObject attrs, String newText) throws IndexOutOfBoundsException {
        Component parentComponent = rootComponent.getParentOf(start);
        if (parentComponent != null && start != null) {
            try {
                JsonOperationConsumer.addText((TextParagraphElementBase)parentComponent.getRootElement(), start.getInt(start.length() - 1), attrs, newText);
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        } else {
            LOG.log(Level.SEVERE, "Could not add text as no container (e.g. paragraph) was found at position: {0}", start);
        }
    }

    public static void addText(TextParagraphElementBase paragraphElementBase, int startPos, JSONObject attrs, String newText) throws IndexOutOfBoundsException {
        int endPos = startPos + newText.length() - 1;
        paragraphElementBase.insert(newText, startPos);
        OdfElement parentElement = (OdfElement)((Object)paragraphElementBase.getParentNode());
        if (parentElement instanceof TableTableCellElement) {
            ((TableTableCellElement)parentElement).removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "value");
            ((TableTableCellElement)parentElement).removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "value-type");
        }
        if (attrs != null && attrs.length() > 0) {
            JsonOperationConsumer.applyStyleOnText(paragraphElementBase, startPos, endPos, attrs);
        }
    }

    private static void applyStyleOnText(OdfElement parentElement, Integer startPos, Integer endPos, JSONObject attrs) {
        if (parentElement != null && attrs.has("character")) {
            JSONObject chars = attrs.optJSONObject("character");
            String url = chars.optString("url");
            if (url != null && !url.isEmpty()) {
                chars.remove(url);
                chars.put("url", (Object)url);
                attrs.put("character", (Object)chars);
            }
            parentElement.markText(startPos, endPos, attrs);
        }
    }

    private static boolean hasHardProperties(JSONObject attrs, OdfStyleFamily styleFamily) {
        int attrsLength = attrs.length();
        if (attrs.has("styleId") && !attrs.isNull("styleId")) {
            --attrsLength;
        }
        if (attrs.has("changes")) {
            --attrsLength;
        }
        Map<String, OdfStylePropertiesSet> elementProps = Component.getAllStyleGroupingIdProperties(styleFamily);
        for (String propertyId : elementProps.keySet()) {
            if (!attrs.has(propertyId)) continue;
            JSONObject newProps = attrs.optJSONObject(propertyId);
            if (newProps != null) {
                String key;
                int propsLength = newProps.length();
                Iterator keys = newProps.keys();
                while (keys.hasNext() && (newProps.has(key = (String)keys.next()) && newProps.isNull(key) || key.equals("url"))) {
                    --propsLength;
                }
                if (propsLength != 0) break;
                --attrsLength;
                continue;
            }
            attrs.remove(propertyId);
        }
        return attrsLength != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void mergeParagraph(Component rootComponent, JSONArray start) throws IndexOutOfBoundsException {
        Component firstComponent = rootComponent.get(start);
        TextParagraphElementBase firstParagraph = null;
        if (firstComponent == null) throw new IndexOutOfBoundsException("There was no component for " + String.valueOf(start) + " accessible.");
        firstParagraph = (TextParagraphElementBase)firstComponent.getRootElement();
        if (firstParagraph == null) {
            throw new IndexOutOfBoundsException("There was no component for " + String.valueOf(start) + " accessible.");
        }
        Component secondComponent = rootComponent.getNextSiblingOf(start);
        if (secondComponent != null) {
            TextParagraphElementBase secondParagraph = (TextParagraphElementBase)secondComponent.getRootElement();
            if (secondParagraph == null) throw new IndexOutOfBoundsException("There was no sibling for " + String.valueOf(start) + " accessible.");
            try {
                secondParagraph.moveChildrenTo((Element)((Object)firstParagraph));
                secondParagraph.getParentNode().removeChild((Node)((Object)secondParagraph));
                secondComponent.getParent().remove(start.getInt(start.length() - 1) + 1);
                return;
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            return;
        } else {
            LOG.log(Level.SEVERE, "Could not fine second Paragraph to merge. Position: {0}", start);
        }
    }

    public static void delete(Component rootComponent, JSONArray start, JSONArray end) throws IndexOutOfBoundsException {
        Component parentComponent = rootComponent.getParentOf(start);
        if (parentComponent != null) {
            if (parentComponent instanceof TextContainer) {
                JsonOperationConsumer.deleteText(rootComponent, start, end);
            } else {
                JsonOperationConsumer.deleteComponents(rootComponent, start, end);
            }
        }
    }

    public static void deleteColumns(Component rootComponent, JSONArray start, Integer startGrid, Integer endGrid) {
        Component parentComponent = rootComponent.get(start);
        if (parentComponent == null) {
            LOG.log(Level.SEVERE, "The table parent component of the column should exist at position {0}", start);
        } else {
            TableTableElement tableElement = (TableTableElement)parentComponent.getRootElement();
            OdfTable table = OdfTable.getInstance(tableElement);
            if (!((Table)tableElement.getComponent()).isWidthChangeRequired()) {
                Table.stashColumnWidths(tableElement);
            }
            table.removeColumnsByIndex(startGrid, endGrid - startGrid + 1);
            if (((Table)tableElement.getComponent()).isWidthChangeRequired()) {
                JsonOperationConsumer.setColumnsWidth(tableElement.getComponent(), ((Table)tableElement.getComponent()).getPosition(), ((Table)tableElement.getComponent()).popTableGrid(), true);
            }
        }
    }

    public static void deleteStyle(OdfDocument doc, String styleId, String type) {
        OdfOfficeStyles styles = doc.getDocumentStyles();
        OdfStyle oldStyle = styles.getStyle(styleId, Component.getFamily(type));
        if (oldStyle != null) {
            styles.removeChild((Node)((Object)oldStyle));
        } else {
            OdfDefaultStyle oldDefaultStyle = styles.getDefaultStyle(Component.getFamily(type));
            if (oldDefaultStyle != null) {
                styles.removeChild((Node)((Object)oldDefaultStyle));
            }
        }
    }

    public static void changeStyle(OdfDocument doc, String type, String styleId, String styleName, JSONObject attrs) {
        OdfOfficeStyles styles = doc.getDocumentStyles();
        OdfStyleFamily styleFamily = Component.getFamily(type);
        OdfStyle style = styles.getStyle(styleId, styleFamily);
        if (styleName != null && !styleName.isEmpty()) {
            style.setStyleDisplayNameAttribute(styleName);
        }
        if (attrs != null) {
            if (type.equals("table")) {
                style.removeProperty(OdfStyleProperty.get(OdfStylePropertiesSet.TableProperties, StyleTablePropertiesElement.ELEMENT_NAME));
                JsonOperationConsumer.mapProperties(styleFamily, attrs.optJSONObject("wholetable"), style, doc);
            } else {
                style.removeProperty(OdfStyleProperty.get(OdfStylePropertiesSet.ParagraphProperties, StyleParagraphPropertiesElement.ELEMENT_NAME));
                style.removeProperty(OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, StyleTextPropertiesElement.ELEMENT_NAME));
                JsonOperationConsumer.mapProperties(styleFamily, attrs, style, doc);
            }
            if (styleFamily.equals(OdfStyleFamily.Paragraph)) {
                JsonOperationConsumer.handleParaOutline(style, attrs);
            }
        }
    }

    public static void addStyles(OdfDocument doc, String type, String styleId, String styleName, JSONObject attrs, String parent, Boolean hidden, Boolean custom) {
        OdfOfficeStyles styles = null;
        try {
            styles = doc.getStylesDom().getOrCreateOfficeStyles();
        }
        catch (IOException | SAXException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        if (attrs != null) {
            OdfStyleFamily styleFamily = Component.getFamily(type);
            if (hidden.booleanValue()) {
                OdfDefaultStyle oldDefaultStyle = styles.getDefaultStyle(styleFamily);
                if (oldDefaultStyle != null) {
                    styles.removeChild((Node)((Object)oldDefaultStyle));
                }
                StyleDefaultStyleElement defaultStyleElement = styles.newStyleDefaultStyleElement(styleFamily.getName());
                JsonOperationConsumer.mapProperties(styleFamily, attrs, defaultStyleElement, doc);
            } else {
                String testName;
                OdfStyle oldStyle = styles.getStyle(styleName, styleFamily);
                if (oldStyle != null) {
                    styles.removeChild((Node)((Object)oldStyle));
                } else if (styleName != null && styleName.contains(" ") && (oldStyle = styles.getStyle(testName = styleName.replace(" ", "_20_"), styleFamily)) != null) {
                    styles.removeChild((Node)((Object)oldStyle));
                }
                OdfStyle style = styles.newStyle(styleId, styleFamily);
                if (parent != null && !parent.isEmpty()) {
                    style.setStyleParentStyleNameAttribute(parent);
                }
                if (styleName != null && !styleName.isEmpty()) {
                    style.setStyleDisplayNameAttribute(styleName);
                }
                if (type.equals("table")) {
                    JsonOperationConsumer.mapProperties(styleFamily, attrs.optJSONObject("wholetable"), style, doc);
                } else {
                    JsonOperationConsumer.mapProperties(styleFamily, attrs, style, doc);
                }
                if (styleFamily.equals(OdfStyleFamily.Paragraph)) {
                    JsonOperationConsumer.handleParaOutline(style, attrs);
                }
                if (null != custom && custom.booleanValue()) {
                    style.setAttribute("custom", "true");
                }
            }
        }
    }

    public static void handleParaOutline(StyleStyleElement style, JSONObject attrs) {
        JSONObject props;
        if (attrs != null && (props = attrs.optJSONObject("paragraph")) != null) {
            String nextStyleId;
            if (props.has("outlineLevel")) {
                if (!props.get("outlineLevel").equals(JSONObject.NULL)) {
                    int outlineLevel = props.optInt("outlineLevel");
                    if (outlineLevel >= 1) {
                        style.setStyleDefaultOutlineLevelAttribute(outlineLevel);
                    } else {
                        style.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "default-outline-level");
                    }
                } else {
                    style.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "default-outline-level");
                }
            }
            if ((nextStyleId = props.optString("nextStyleId")) != null && !nextStyleId.isEmpty()) {
                style.setStyleNextStyleNameAttribute(nextStyleId);
            }
        }
    }

    public static void format(Component rootComponent, JSONArray start, JSONArray end, JSONObject attrs) {
        if (rootComponent != null && start != null && attrs != null && attrs.length() != 0) {
            Component parentComponent = rootComponent.getParentOf(start);
            if (parentComponent != null) {
                Node targetNode;
                int startPos = start.optInt(start.length() - 1);
                if (end == null) {
                    targetNode = parentComponent.getChildNode(startPos);
                } else {
                    int targetPos = -1;
                    if (start.length() == end.length() && start.optInt(start.length() - 2) == end.optInt(end.length() - 2)) {
                        targetPos = end.optInt(end.length() - 1);
                    }
                    targetNode = parentComponent.getChildNode(startPos, targetPos);
                }
                JsonOperationConsumer.format(parentComponent.mRootElement, targetNode, start, end, attrs, false);
            } else {
                LOG.log(Level.SEVERE, "No parent component found to 'format' from {0} to {1} trying to add {2}", new Object[]{start, end, attrs});
            }
        } else {
            LOG.log(Level.SEVERE, "No parent component found to 'format' from {0} to {1} trying to add {2}", new Object[]{start, end, attrs});
        }
    }

    static void format(OdfElement parentElement, Node targetNode, JSONArray start, JSONArray end, JSONObject attrs, Boolean formatCompleteLine) {
        if (attrs != null && attrs.length() != 0) {
            if (targetNode != null && targetNode instanceof OdfStylableElement) {
                OdfFileDom xmlDoc = (OdfFileDom)((Object)targetNode.getOwnerDocument());
                StyleStyleElement autoStyle = null;
                if (targetNode instanceof TextParagraphElementBase) {
                    TextParagraphElementBase paragraphBaseElement = (TextParagraphElementBase)targetNode;
                    JSONObject paraProps = attrs.optJSONObject("paragraph");
                    if (paraProps != null || attrs.has("styleId")) {
                        TextListElement rootListElement;
                        boolean isNewList = false;
                        boolean hasListLevel = false;
                        boolean hasNewListId = false;
                        if (paraProps != null) {
                            hasListLevel = paraProps.has("listLevel");
                            hasNewListId = paraProps.has("listStyleId");
                        }
                        if (hasListLevel || hasNewListId) {
                            rootListElement = JsonOperationConsumer.isolateListParagraph(paragraphBaseElement);
                            if (rootListElement != null && hasNewListId) {
                                JsonOperationConsumer.modifyListStyleName(attrs, rootListElement);
                            } else {
                                isNewList = true;
                            }
                        }
                        if (paraProps != null) {
                            if (hasListLevel) {
                                int newListLevel;
                                try {
                                    paraProps.put("indentFirstLine", JSONObject.NULL);
                                    paraProps.put("marginLeft", JSONObject.NULL);
                                }
                                catch (JSONException ex) {
                                    LOG.log(Level.SEVERE, null, ex);
                                }
                                autoStyle = JsonOperationConsumer.addStyle(attrs, paragraphBaseElement, xmlDoc);
                                int listLevel = JsonOperationConsumer.getListLevel(paragraphBaseElement);
                                if (paraProps.isNull("listLevel")) {
                                    newListLevel = -1;
                                    if (autoStyle != null) {
                                        autoStyle.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "list-style-name");
                                    }
                                } else {
                                    newListLevel = paraProps.optInt("listLevel", -2);
                                    if (newListLevel == -2) {
                                        newListLevel = listLevel;
                                    }
                                }
                                boolean listLabelHidden = false;
                                if (paraProps.has("listLabelHidden") && !paraProps.get("listLabelHidden").equals(JSONObject.NULL)) {
                                    listLabelHidden = paraProps.optBoolean("listLabelHidden");
                                }
                                String currentListStyleName = null;
                                TextListElement rootListElement2 = JsonOperationConsumer.getListRootElement(paragraphBaseElement);
                                if (rootListElement2 != null) {
                                    currentListStyleName = rootListElement2.getTextStyleNameAttribute();
                                }
                                if (paraProps.has("listStyleId") && !paraProps.get("listStyleId").equals(JSONObject.NULL) && !listLabelHidden) {
                                    String listStyleId = paraProps.optString("listStyleId");
                                    if (autoStyle != null && listStyleId != null && !listStyleId.isEmpty()) {
                                        autoStyle.setStyleListStyleNameAttribute(listStyleId);
                                    }
                                    JsonOperationConsumer.setParagraphListProperties(paragraphBaseElement, paraProps, xmlDoc, listLevel, -1, null);
                                    listLevel = -1;
                                }
                                JsonOperationConsumer.setParagraphListProperties(paragraphBaseElement, paraProps, xmlDoc, listLevel, newListLevel, currentListStyleName);
                            }
                            if (isNewList && hasListLevel) {
                                rootListElement = JsonOperationConsumer.isolateListParagraph(paragraphBaseElement);
                                JsonOperationConsumer.modifyListStyleName(attrs, rootListElement);
                            }
                        }
                        if (attrs.has("styleId") || paraProps.has("outlineLevel")) {
                            String styleId;
                            int outlineLevel = -2;
                            if (paraProps != null && paraProps.has("outlineLevel") && !paraProps.get("outlineLevel").equals(JSONObject.NULL)) {
                                outlineLevel = paraProps.optInt("outlineLevel");
                            } else if (attrs.has("styleId") && !attrs.isNull("styleId") && (styleId = attrs.optString("styleId")) != null && !styleId.isEmpty()) {
                                if (autoStyle == null) {
                                    JsonOperationConsumer.addStyle(attrs, (OdfStylableElement)targetNode, xmlDoc);
                                }
                                outlineLevel = JsonOperationConsumer.getDefaultOutlineLevelFromStyleHierarchy(paragraphBaseElement);
                            }
                            targetNode = JsonOperationConsumer.ensureCorrectParagraphElement(outlineLevel, (TextParagraphElementBase)targetNode, paragraphBaseElement.getComponent());
                        }
                    }
                } else if (targetNode instanceof TableTableElement) {
                    JSONArray tableGrid;
                    TableTableElement tableElement = (TableTableElement)targetNode;
                    autoStyle = JsonOperationConsumer.addStyle(attrs, (OdfStylableElement)targetNode, xmlDoc);
                    JSONObject tableProps = attrs.optJSONObject("table");
                    if (tableProps != null && (tableGrid = tableProps.optJSONArray("tableGrid")) != null) {
                        JsonOperationConsumer.setColumnsWidth(tableElement.getComponent(), start, tableGrid, true);
                    }
                } else if (targetNode instanceof TableTableColumnElement) {
                    JSONObject columnProps;
                    TableTableColumnElement columnElement = (TableTableColumnElement)targetNode;
                    if (attrs.has("column")) {
                        autoStyle = JsonOperationConsumer.addStyle(attrs, (OdfStylableElement)targetNode, xmlDoc);
                    }
                    if (attrs.has("cell")) {
                        autoStyle = JsonOperationConsumer.addStyle(attrs, (OdfStylableElement)targetNode, xmlDoc);
                    }
                    if ((columnProps = attrs.optJSONObject("column")) != null) {
                        boolean changeToVisible = columnProps.optBoolean("visible", true);
                        boolean isVisible = true;
                        if (columnElement.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "visibility")) {
                            isVisible = "visible".equals(columnElement.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "visibility"));
                        }
                        if (isVisible && !changeToVisible || !isVisible && changeToVisible) {
                            if (changeToVisible) {
                                columnElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "visibility");
                            } else {
                                columnElement.setAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "table:visibility", "collapse");
                            }
                        }
                    }
                    if (formatCompleteLine.booleanValue()) {
                        JsonOperationConsumer.setDefaultAttribute(columnElement, attrs);
                    }
                } else if (targetNode instanceof TableTableRowElement) {
                    TableTableRowElement rowElement = (TableTableRowElement)targetNode;
                    autoStyle = JsonOperationConsumer.addStyle(attrs, (OdfStylableElement)targetNode, xmlDoc);
                    JSONObject rowProps = attrs.optJSONObject("row");
                    if (rowProps != null) {
                        boolean changeToVisible = rowProps.optBoolean("visible", true);
                        boolean isVisible = true;
                        if (rowElement.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "visibility")) {
                            isVisible = "visible".equals(rowElement.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "visibility"));
                        }
                        if (isVisible && !changeToVisible || !isVisible && changeToVisible) {
                            if (changeToVisible) {
                                rowElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "visibility");
                            } else {
                                rowElement.setAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "table:visibility", "collapse");
                            }
                        }
                    }
                } else if (targetNode instanceof TableTableCellElementBase) {
                    int span;
                    TableTableCellElementBase cellElement = (TableTableCellElementBase)targetNode;
                    autoStyle = JsonOperationConsumer.addStyle(attrs, (OdfStylableElement)targetNode, xmlDoc);
                    JSONObject cellProps = attrs.optJSONObject("cell");
                    if (cellProps != null && (span = cellProps.optInt("gridSpan", 1)) > 1) {
                        cellElement.setAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "table:number-columns-spanned", Integer.toString(span));
                    }
                } else if (targetNode instanceof DrawFrameElement) {
                    DrawFrameElement frameElement = (DrawFrameElement)targetNode;
                    JsonOperationConsumer.setFrameProperties(frameElement, attrs);
                    NodeList images = frameElement.getElementsByTagName("draw:image");
                    if (images.getLength() > 0) {
                        DrawImageElement imageElement = (DrawImageElement)((Object)images.item(0));
                        JSONObject imageAttrs = attrs.optJSONObject("image");
                        if (imageAttrs != null) {
                            JsonOperationConsumer.setImageProperties(imageElement, imageAttrs);
                        }
                    }
                } else if (targetNode instanceof DrawGElement) {
                    Integer gWidth = (Integer)targetNode.getUserData("groupWidth");
                    Integer gHeight = (Integer)targetNode.getUserData("groupHeight");
                    if (gWidth != null && gHeight != null) {
                        int newWidth = -1;
                        int newHeight = -1;
                        try {
                            JSONObject drawAttr = attrs.getJSONObject("drawing");
                            if (drawAttr.has("width")) {
                                newWidth = attrs.getJSONObject("drawing").getInt("width");
                            }
                            if (drawAttr.has("height")) {
                                newHeight = attrs.getJSONObject("drawing").getInt("height");
                            }
                        }
                        catch (JSONException drawAttr) {
                            // empty catch block
                        }
                        double heightFactor = 1.0;
                        double widthFactor = 1.0;
                        if (newHeight > 0 && newHeight != gHeight) {
                            heightFactor = (double)newHeight / (double)gHeight.intValue();
                            targetNode.setUserData("groupHeight", newHeight, null);
                        }
                        if (newWidth > 0 && newWidth != gWidth) {
                            widthFactor = (double)newWidth / (double)gWidth.intValue();
                            targetNode.setUserData("groupWidth", newHeight, null);
                        }
                        Node child = targetNode.getFirstChild();
                        JsonOperationConsumer.changeDrawingSizeAndPos(child, heightFactor, widthFactor);
                    }
                }
                if (autoStyle == null) {
                    JsonOperationConsumer.addStyle(attrs, (OdfStylableElement)targetNode, xmlDoc);
                }
            } else if (parentElement != null && attrs.has("character")) {
                OdfStylePropertiesBase base;
                int startPos = start.optInt(start.length() - 1);
                int endPos = end == null ? startPos : end.optInt(end.length() - 1);
                OdfStylableElement paraStylable = (OdfStylableElement)parentElement;
                OdfStyle paraAutoStyle = paraStylable.getAutomaticStyle();
                if (paraAutoStyle != null && (base = paraAutoStyle.getOrCreatePropertiesElement(OdfStylePropertiesSet.TextProperties)).getAttributes().getLength() > 0) {
                    HashMap<String, Map<String, String>> allOdfProps = new HashMap<String, Map<String, String>>();
                    Map<String, OdfStylePropertiesSet> familyPropertyGroups = Component.getAllStyleGroupingIdProperties(OdfStyleFamily.Text);
                    MapHelper.getStyleProperties((OdfStyleBase)paraAutoStyle, familyPropertyGroups, allOdfProps);
                    Map<String, Object> mappedFormatting = MapHelper.mapStyleProperties(familyPropertyGroups, allOdfProps);
                    if (mappedFormatting.containsKey("character")) {
                        JSONObject charProps = (JSONObject)mappedFormatting.get("character");
                        JSONObject newAttrs = new JSONObject();
                        try {
                            newAttrs.put("character", (Object)charProps);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        JsonOperationConsumer.applyStyleOnText(parentElement, 0, parentElement.getComponentRoot().componentSize() - 1, newAttrs);
                    }
                    StyleStyleElement newAutoStyle = paraStylable.getOrCreateUnqiueAutomaticStyle();
                    newAutoStyle.removeChild((Node)((Object)newAutoStyle.getOrCreatePropertiesElement(OdfStylePropertiesSet.TextProperties)));
                }
                JsonOperationConsumer.applyStyleOnText(parentElement, startPos, endPos, attrs);
            }
        }
    }

    private static void changeDrawingSizeAndPos(Node child, double heightFactor, double widthFactor) {
        while (child != null) {
            if (child instanceof DrawGElement) {
                JsonOperationConsumer.changeDrawingSizeAndPos(child.getFirstChild(), heightFactor, widthFactor);
            } else {
                DrawShapeElementBase drawElementBase = (DrawShapeElementBase)((Object)child);
                if (heightFactor != 1.0) {
                    OdfAttribute yAttr;
                    OdfAttribute heightAttr = ((DrawShapeElementBase)((Object)child)).getOdfAttribute(OdfGraphicProperties.Height.getName());
                    if (heightAttr != null) {
                        int height = MapHelper.normalizeLength(heightAttr.getValue());
                        height = (int)((double)height * heightFactor);
                        heightAttr.setValue((double)height / 100.0 + "mm");
                    }
                    if ((yAttr = ((DrawShapeElementBase)((Object)child)).getOdfAttribute(OdfGraphicProperties.Y.getName())) != null) {
                        int y = MapHelper.normalizeLength(yAttr.getValue());
                        y = (int)((double)y * heightFactor);
                        yAttr.setValue((double)y / 100.0 + "mm");
                    }
                }
                if (widthFactor != 1.0) {
                    OdfAttribute xAttr;
                    OdfAttribute widthAttr = ((DrawShapeElementBase)((Object)child)).getOdfAttribute(OdfGraphicProperties.Width.getName());
                    if (widthAttr != null) {
                        int width = MapHelper.normalizeLength(widthAttr.getValue());
                        width = (int)((double)width * widthFactor);
                        widthAttr.setValue((double)width / 100.0 + "mm");
                    }
                    if ((xAttr = ((DrawShapeElementBase)((Object)child)).getOdfAttribute(OdfGraphicProperties.X.getName())) != null) {
                        int x = MapHelper.normalizeLength(xAttr.getValue());
                        x = (int)((double)x * widthFactor);
                        xAttr.setValue((double)x / 100.0 + "mm");
                    }
                }
            }
            child = child.getNextSibling();
        }
    }

    private static void setDefaultAttribute(OdfStylableElement lineElement, JSONObject attrs) {
        JSONObject cellProps = attrs.optJSONObject("cell");
        JSONObject characterProps = attrs.optJSONObject("character");
        if (cellProps != null || characterProps != null) {
            if (cellProps != null && cellProps.equals(JSONObject.NULL) && characterProps != null && characterProps.equals(JSONObject.NULL)) {
                lineElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "default-cell-style-name");
            } else {
                String defaultCellTemplateStyleName = null;
                StyleStyleElement autoStyle = null;
                OdfStyle existingDefaultCellStyle = null;
                String defaultCellStyleName = lineElement.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "default-cell-style-name");
                if (defaultCellStyleName != null) {
                    OdfOfficeAutomaticStyles autoStyles = lineElement.getOrCreateAutomaticStyles();
                    existingDefaultCellStyle = autoStyles.getStyle(defaultCellStyleName, OdfStyleFamily.TableCell);
                    if (existingDefaultCellStyle == null) {
                        autoStyle = lineElement.getOrCreateUnqiueAutomaticStyle(false, OdfStyleFamily.TableCell);
                        defaultCellTemplateStyleName = defaultCellStyleName;
                    } else {
                        autoStyle = existingDefaultCellStyle;
                        defaultCellTemplateStyleName = existingDefaultCellStyle.getStyleParentStyleNameAttribute();
                    }
                } else {
                    autoStyle = lineElement.getOrCreateUnqiueAutomaticStyle(false, OdfStyleFamily.TableCell);
                }
                if (defaultCellTemplateStyleName != null && !defaultCellTemplateStyleName.isEmpty()) {
                    autoStyle.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:parent-style-name", defaultCellTemplateStyleName);
                }
                JsonOperationConsumer.mapProperties(OdfStyleFamily.TableCell, attrs, autoStyle, (OdfDocument)((OdfFileDom)((Object)lineElement.getOwnerDocument())).getDocument());
                lineElement.setAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "table:default-cell-style-name", autoStyle.getStyleNameAttribute());
            }
        }
    }

    private static int getDefaultOutlineLevelFromStyleHierarchy(TextParagraphElementBase paragraphBaseElement) {
        int outlineLevel;
        block1: {
            OdfStyle style = paragraphBaseElement.getDocumentStyle();
            outlineLevel = JsonOperationConsumer.getStyleOutlineLevel(style);
            if (style == null || outlineLevel != -2) break block1;
            OdfStyleBase parentStyle = null;
            style.getParentStyle();
            while (outlineLevel == -2 && (outlineLevel = JsonOperationConsumer.getStyleOutlineLevel(parentStyle)) == -2 && parentStyle instanceof OdfStyle && (parentStyle = ((OdfStyle)parentStyle).getParentStyle()) != null) {
            }
        }
        return outlineLevel;
    }

    private static int getStyleOutlineLevel(OdfStyleBase style) {
        String outlineLevelValue;
        int outlineLevel = -2;
        if (style != null && style.hasAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "default-outline-level") && (outlineLevelValue = style.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "default-outline-level")) != null && !outlineLevelValue.isEmpty()) {
            outlineLevel = Integer.parseInt(outlineLevelValue);
        }
        return outlineLevel;
    }

    private static TextParagraphElementBase ensureCorrectParagraphElement(int outlineLevel, TextParagraphElementBase rootElement, Component c) {
        TextParagraphElementBase newElement = null;
        if (outlineLevel > -1) {
            if (!(rootElement instanceof TextHElement)) {
                newElement = new TextHElement((OdfFileDom)((Object)rootElement.getOwnerDocument()));
                ((TextHElement)newElement).setTextOutlineLevelAttribute(outlineLevel);
            } else {
                ((TextHElement)rootElement).setTextOutlineLevelAttribute(outlineLevel);
            }
        } else {
            if (!(rootElement instanceof TextPElement)) {
                newElement = new TextPElement((OdfFileDom)((Object)rootElement.getOwnerDocument()));
            }
            rootElement.removeAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "outline-level");
        }
        if (newElement != null) {
            OdfElement parent = (OdfElement)((Object)rootElement.getParentNode());
            parent.replaceChild((Node)((Object)newElement), (Node)((Object)rootElement));
            OdfElement.cloneNode(rootElement, newElement, true);
            c.setRootElement(newElement);
            newElement.setComponent(c);
        } else {
            rootElement.setComponent(c);
            newElement = rootElement;
        }
        return newElement;
    }

    private static void setParagraphListProperties(TextParagraphElementBase paragraphBaseElement, JSONObject paraProps, OdfFileDom xmlDoc, int listLevel, int newListLevel, String currentListStyleName) {
        Component c = paragraphBaseElement.getComponent();
        if (listLevel != newListLevel) {
            if (listLevel > -1) {
                if (newListLevel > listLevel) {
                    JsonOperationConsumer.addListLevel(paragraphBaseElement, newListLevel - listLevel, paraProps, xmlDoc, currentListStyleName);
                } else {
                    JsonOperationConsumer.removeListLevel(paragraphBaseElement, listLevel - newListLevel, paraProps, currentListStyleName);
                }
            } else {
                JsonOperationConsumer.addListLevel(paragraphBaseElement, newListLevel + 1, paraProps, xmlDoc, currentListStyleName);
            }
        }
        JsonOperationConsumer.addTopListElementAttributes(JsonOperationConsumer.getListRootElement(paragraphBaseElement), paraProps, null, currentListStyleName);
        c.setRootElement(paragraphBaseElement);
    }

    public static int getListLevel(TextParagraphElementBase paragraphBaseElement) {
        return JsonOperationConsumer.getListLevel(paragraphBaseElement, -1);
    }

    private static int getListLevel(OdfElement element, int listLevel) {
        OdfElement parent = (OdfElement)((Object)element.getParentNode());
        if (parent instanceof TextListElement) {
            listLevel = JsonOperationConsumer.getListLevel(parent, listLevel) + 1;
        } else if (parent instanceof TextListItemElement || parent instanceof TextListHeaderElement) {
            listLevel = JsonOperationConsumer.getListLevel(parent, listLevel);
        }
        return listLevel;
    }

    public static TextListElement isolateListParagraph(TextParagraphElementBase paragraphBaseElement) {
        TextListElement rootListElement = null;
        Element parentElement = (Element)paragraphBaseElement.getParentNode();
        if (parentElement instanceof TextListItemElement || parentElement instanceof TextListHeaderElement) {
            int listLevel = JsonOperationConsumer.getListLevel(paragraphBaseElement);
            rootListElement = JsonOperationConsumer.getListRootElement(paragraphBaseElement);
            if (rootListElement != null) {
                String listStyleName = rootListElement.getTextStyleNameAttribute();
                JsonOperationConsumer.removeListLevel(paragraphBaseElement, listLevel + 1, null, null);
                TextListElement newRootListElement = JsonOperationConsumer.addListLevel(paragraphBaseElement, listLevel + 1, null, (OdfFileDom)((Object)paragraphBaseElement.getOwnerDocument()), listStyleName);
                if (newRootListElement != null) {
                    rootListElement = newRootListElement;
                }
            }
        }
        return rootListElement;
    }

    private static void removeListLevel(TextParagraphElementBase paragraphBaseElement, int levelsToDelete, JSONObject paraProps, String currentListStyleName) {
        if (levelsToDelete > 0) {
            boolean hasPrecedingListContent = OdfElement.getPreviousSiblingElement((Node)((Object)paragraphBaseElement)) != null || OdfElement.getPreviousSiblingElement(paragraphBaseElement.getParentNode()) != null;
            boolean hasFollowingListContent = OdfElement.getNextSiblingElement((Node)((Object)paragraphBaseElement)) != null || OdfElement.getNextSiblingElement(paragraphBaseElement.getParentNode()) != null;
            paragraphBaseElement.setAttribute("selectedParagraph", "true");
            OdfElement pContainer = (OdfElement)((Object)paragraphBaseElement.getParentNode());
            if (pContainer instanceof TextListHeaderElement) {
                paragraphBaseElement.setAttribute("hiddenParagraph", "true");
            }
            OdfElement lowestListElement = (OdfElement)((Object)pContainer.getParentNode());
            TextListElement clonedListWithFollowingContent = null;
            if (hasPrecedingListContent) {
                if (hasFollowingListContent) {
                    clonedListWithFollowingContent = (TextListElement)((Object)lowestListElement.cloneNode(true));
                    Component selectedParagraphComponent = paragraphBaseElement.getComponent();
                    int positionOfSelectedParagraph = selectedParagraphComponent.getParent().indexOf(selectedParagraphComponent);
                    JsonOperationConsumer.adjustComponentReferences(-1, positionOfSelectedParagraph, selectedParagraphComponent, (Element)((Object)clonedListWithFollowingContent));
                    JsonOperationConsumer.deleteBeforeAndSelectedParagraph((Element)((Object)clonedListWithFollowingContent));
                }
                JsonOperationConsumer.deleteFromSelectedParagraph((Element)((Object)lowestListElement));
                boolean listLabelHidden = false;
                if (paraProps != null && paraProps.has("listLabelHidden")) {
                    listLabelHidden = paraProps.optBoolean("listLabelHidden", false);
                }
                if (listLabelHidden) {
                    OdfElement elementForInsertion;
                    OdfElement newParentElement;
                    if (hasPrecedingListContent) {
                        newParentElement = (OdfElement)((Object)lowestListElement.getParentNode().getParentNode());
                        TextListHeaderElement newListHeaderElement = new TextListHeaderElement((OdfFileDom)((Object)paragraphBaseElement.getOwnerDocument()));
                        newListHeaderElement.appendChild((Node)((Object)paragraphBaseElement));
                        elementForInsertion = newListHeaderElement;
                    } else {
                        newParentElement = (OdfElement)((Object)lowestListElement.getParentNode());
                        elementForInsertion = paragraphBaseElement;
                    }
                    OdfElement nextListSiblingElement = OdfElement.getNextSiblingElement((Node)((Object)lowestListElement));
                    if (nextListSiblingElement == null) {
                        newParentElement.appendChild((Node)((Object)elementForInsertion));
                        if (clonedListWithFollowingContent != null) {
                            newParentElement.appendChild((Node)((Object)clonedListWithFollowingContent));
                        }
                    } else {
                        newParentElement.insertBefore((Node)((Object)elementForInsertion), (Node)((Object)nextListSiblingElement));
                        if (clonedListWithFollowingContent != null) {
                            newParentElement.insertBefore((Node)((Object)clonedListWithFollowingContent), (Node)((Object)nextListSiblingElement));
                        }
                    }
                } else {
                    OdfElement elementForInsertion;
                    TextListItemElement newListItemElement;
                    OdfElement listItemFollowingSibling;
                    OdfElement newParentElement;
                    boolean isTopLevelList = false;
                    OdfElement listItemPrecedingSibling = (OdfElement)((Object)lowestListElement.getParentNode());
                    if (listItemPrecedingSibling instanceof TextListItemElement || listItemPrecedingSibling instanceof TextListHeaderElement) {
                        newParentElement = (OdfElement)((Object)listItemPrecedingSibling.getParentNode());
                        listItemFollowingSibling = OdfElement.getNextSiblingElement((Node)((Object)listItemPrecedingSibling));
                        newListItemElement = new TextListItemElement((OdfFileDom)((Object)paragraphBaseElement.getOwnerDocument()));
                        newListItemElement.appendChild((Node)((Object)paragraphBaseElement));
                        elementForInsertion = newListItemElement;
                    } else {
                        isTopLevelList = true;
                        elementForInsertion = paragraphBaseElement;
                        newParentElement = listItemPrecedingSibling;
                        listItemFollowingSibling = OdfElement.getNextSiblingElement((Node)((Object)lowestListElement));
                    }
                    if (listItemFollowingSibling == null) {
                        newParentElement.appendChild((Node)((Object)elementForInsertion));
                        if (clonedListWithFollowingContent != null) {
                            newParentElement.appendChild((Node)((Object)clonedListWithFollowingContent));
                        }
                        if (clonedListWithFollowingContent != null) {
                            if (isTopLevelList) {
                                newParentElement.appendChild((Node)((Object)clonedListWithFollowingContent));
                            } else {
                                newListItemElement = new TextListItemElement((OdfFileDom)((Object)paragraphBaseElement.getOwnerDocument()));
                                newListItemElement.appendChild((Node)((Object)clonedListWithFollowingContent));
                                newParentElement.appendChild((Node)((Object)newListItemElement));
                            }
                        }
                    } else {
                        newParentElement.insertBefore((Node)((Object)elementForInsertion), (Node)((Object)listItemFollowingSibling));
                        if (clonedListWithFollowingContent != null) {
                            if (isTopLevelList) {
                                newParentElement.insertBefore((Node)((Object)clonedListWithFollowingContent), (Node)((Object)listItemFollowingSibling));
                            } else {
                                newListItemElement = new TextListItemElement((OdfFileDom)((Object)paragraphBaseElement.getOwnerDocument()));
                                newListItemElement.appendChild((Node)((Object)clonedListWithFollowingContent));
                                newParentElement.insertBefore((Node)((Object)newListItemElement), (Node)((Object)listItemFollowingSibling));
                            }
                        }
                    }
                }
            } else if (hasFollowingListContent) {
                JsonOperationConsumer.deleteBeforeAndSelectedParagraph((Element)((Object)lowestListElement));
                Node listParent = lowestListElement.getParentNode();
                listParent.insertBefore((Node)((Object)paragraphBaseElement), (Node)((Object)lowestListElement));
            } else {
                Node listParent = lowestListElement.getParentNode();
                listParent.replaceChild((Node)((Object)paragraphBaseElement), (Node)((Object)lowestListElement));
                lowestListElement = null;
            }
            if (lowestListElement != null && !(lowestListElement.getParentNode() instanceof TextListItemElement) && !(lowestListElement.getParentNode() instanceof TextListHeaderElement)) {
                OdfElement previousSiblingElement = OdfElement.getPreviousSiblingElement((Node)((Object)lowestListElement));
                String previousListStyleId = null;
                if (previousSiblingElement instanceof TextListElement) {
                    previousListStyleId = ((TextListElement)previousSiblingElement).getTextStyleNameAttribute();
                }
                if (currentListStyleName == null) {
                    currentListStyleName = ((TextListElement)lowestListElement).getTextStyleNameAttribute();
                }
                JsonOperationConsumer.addTopListElementAttributes(JsonOperationConsumer.getListRootElement(paragraphBaseElement), paraProps, previousListStyleId, currentListStyleName);
                if (clonedListWithFollowingContent != null) {
                    JsonOperationConsumer.addTopListElementAttributes(clonedListWithFollowingContent, null, previousListStyleId, currentListStyleName);
                }
            }
            JsonOperationConsumer.removeListLevel(paragraphBaseElement, --levelsToDelete, paraProps, currentListStyleName);
        } else if (paragraphBaseElement.hasAttribute("selectedParagraph")) {
            paragraphBaseElement.removeAttribute("selectedParagraph");
        }
    }

    private static void deleteBeforeAndSelectedParagraph(Element listElement) {
        JsonOperationConsumer.listContentRemoval(listElement, true);
    }

    private static void deleteFromSelectedParagraph(Element listElement) {
        JsonOperationConsumer.listContentRemoval(listElement, false);
    }

    private static void listContentRemoval(Element listElement, boolean deleteBeforeSelection) {
        boolean deleteAfterSelection = !deleteBeforeSelection;
        boolean isAfterSelectedParagraph = false;
        boolean isSelectedParagraph = false;
        NodeList listChildren = ((TextListElement)((Object)listElement)).getChildNodes();
        for (int i = listChildren.getLength() - 1; i >= 0; --i) {
            Node listItem = listChildren.item(i);
            if (listItem instanceof Element) {
                NodeList listItemParagraphs = listItem.getChildNodes();
                for (int j = listItemParagraphs.getLength() - 1; j >= 0; --j) {
                    Node listItemParagraph = listItemParagraphs.item(j);
                    if (listItemParagraph instanceof OdfElement) {
                        if (!isAfterSelectedParagraph) {
                            if (((OdfElement)((Object)listItemParagraph)).hasAttribute("selectedParagraph")) {
                                isAfterSelectedParagraph = true;
                                isSelectedParagraph = true;
                                listItem.removeChild(listItemParagraph);
                                if (deleteBeforeSelection) continue;
                                break;
                            }
                            if (!deleteAfterSelection) continue;
                            listItem.removeChild(listItemParagraph);
                            continue;
                        }
                        if (!deleteBeforeSelection) continue;
                        listItem.removeChild(listItemParagraph);
                        continue;
                    }
                    if (!(listItemParagraph instanceof Text)) continue;
                    listItem.removeChild(listItemParagraph);
                }
                if (isAfterSelectedParagraph && !deleteBeforeSelection) {
                    if (listItem.hasChildNodes()) break;
                    Element parent = (Element)listItem.getParentNode();
                    parent.removeChild(listItem);
                    break;
                }
                if (!isSelectedParagraph) {
                    if (!isAfterSelectedParagraph) {
                        if (deleteAfterSelection) {
                            listElement.removeChild(listItem);
                            continue;
                        }
                        if (listItem.hasChildNodes()) continue;
                        Element parent = (Element)listItem.getParentNode();
                        parent.removeChild(listItem);
                        continue;
                    }
                    if (!deleteBeforeSelection) continue;
                    listElement.removeChild(listItem);
                    continue;
                }
                isSelectedParagraph = false;
                if (listItem.hasChildNodes()) continue;
                Element parent = (Element)listItem.getParentNode();
                parent.removeChild(listItem);
                continue;
            }
            if (!(listItem instanceof Text)) continue;
            listElement.removeChild(listItem);
        }
    }

    private static int adjustComponentReferences(int currentParagraphPosition, int selectedParagraphPosition, Component selectedParagraphComponent, Element clonedListElement) {
        NodeList listChildren = ((TextListElement)((Object)clonedListElement)).getChildNodes();
        for (int i = 0; i < listChildren.getLength(); ++i) {
            Node listItem = listChildren.item(i);
            if (!(listItem instanceof Element)) continue;
            NodeList listItemParagraphs = listItem.getChildNodes();
            for (int j = 0; j < listItemParagraphs.getLength(); ++j) {
                Node listItemParagraph = listItemParagraphs.item(j);
                if (!(listItemParagraph instanceof OdfElement)) continue;
                if (listItemParagraph instanceof TextParagraphElementBase) {
                    if (currentParagraphPosition == -1) {
                        if (!((OdfElement)((Object)listItemParagraph)).hasAttribute("selectedParagraph")) continue;
                        currentParagraphPosition = selectedParagraphPosition + 1;
                        continue;
                    }
                    if (currentParagraphPosition <= selectedParagraphPosition) continue;
                    Component nextComponent = ((OdfElement)((Object)selectedParagraphComponent.getParent().getChildNode(currentParagraphPosition))).getComponent();
                    nextComponent.setRootElement((TextParagraphElementBase)((Object)listItemParagraph));
                    ((TextParagraphElementBase)((Object)listItemParagraph)).setComponent(nextComponent);
                    ++currentParagraphPosition;
                    continue;
                }
                if (!(listItemParagraph instanceof TextListElement)) continue;
                currentParagraphPosition = JsonOperationConsumer.adjustComponentReferences(currentParagraphPosition, selectedParagraphPosition, selectedParagraphComponent, (Element)((Object)((TextListElement)((Object)listItemParagraph))));
            }
        }
        return currentParagraphPosition;
    }

    private static TextListElement getListRootElement(TextParagraphElementBase paragraphBaseElement) {
        OdfElement root = null;
        OdfElement parent = (OdfElement)((Object)paragraphBaseElement.getParentNode());
        while (parent instanceof TextListElement || parent instanceof TextListItemElement || parent instanceof TextListHeaderElement) {
            root = parent;
            parent = (OdfElement)((Object)parent.getParentNode());
        }
        return (TextListElement)root;
    }

    private static TextListElement addListLevel(TextParagraphElementBase paragraphBaseElement, int levelsToCreate, JSONObject paraProps, OdfFileDom xmlDoc, String currentListStyleName) {
        TextListElement newListElement = null;
        if (levelsToCreate > 0) {
            OdfElement parent = (OdfElement)((Object)paragraphBaseElement.getParentNode());
            newListElement = new TextListElement(xmlDoc);
            if (!(parent instanceof TextListItemElement) && !(parent instanceof TextListHeaderElement)) {
                OdfElement previousSiblingElement = OdfElement.getPreviousSiblingElement((Node)((Object)paragraphBaseElement));
                String previousListStyleId = null;
                if (previousSiblingElement instanceof TextListElement) {
                    previousListStyleId = ((TextListElement)previousSiblingElement).getTextStyleNameAttribute();
                }
                JsonOperationConsumer.addTopListElementAttributes(newListElement, paraProps, previousListStyleId, currentListStyleName);
            }
            parent.replaceChild((Node)((Object)newListElement), (Node)((Object)paragraphBaseElement));
            if (--levelsToCreate > 0) {
                TextListItemElement newListItemElement = new TextListItemElement(xmlDoc);
                newListElement.appendChild((Node)((Object)newListItemElement));
                newListItemElement.appendChild((Node)((Object)paragraphBaseElement));
                JsonOperationConsumer.addListLevel(paragraphBaseElement, levelsToCreate, paraProps, xmlDoc, currentListStyleName);
            } else {
                boolean listLabelHidden = false;
                if (paraProps != null && paraProps.has("listLabelHidden") || paragraphBaseElement.hasAttribute("hiddenParagraph")) {
                    listLabelHidden = paraProps != null ? paraProps.optBoolean("listLabelHidden", false) : true;
                    paragraphBaseElement.removeAttribute("hiddenParagraph");
                }
                if (listLabelHidden) {
                    TextListHeaderElement newListHeaderElement = new TextListHeaderElement(xmlDoc);
                    newListElement.appendChild((Node)((Object)newListHeaderElement));
                    newListHeaderElement.appendChild((Node)((Object)paragraphBaseElement));
                } else {
                    TextListItemElement newListItemElement = new TextListItemElement(xmlDoc);
                    newListElement.appendChild((Node)((Object)newListItemElement));
                    newListItemElement.appendChild((Node)((Object)paragraphBaseElement));
                }
            }
        }
        return newListElement;
    }

    private static void addTopListElementAttributes(TextListElement rootListElement, JSONObject paraProps, String previousSiblingListId, String currentListId) {
        if (rootListElement != null) {
            if (paraProps != null && paraProps.length() != 0 && paraProps.has("listXmlId")) {
                String newListXmlId = paraProps.optString("listXmlId", null);
                if (newListXmlId != null) {
                    if (!newListXmlId.isEmpty()) {
                        rootListElement.setXmlIdAttribute(newListXmlId);
                    }
                } else {
                    rootListElement.removeAttributeNS(OdfDocumentNamespace.XML.getUri(), "id");
                }
            }
            if (paraProps != null && paraProps.length() != 0 && paraProps.has("listStyleId")) {
                String newListStyleId = paraProps.optString("listStyleId", null);
                if (newListStyleId != null) {
                    if (!newListStyleId.isEmpty()) {
                        rootListElement.setTextStyleNameAttribute(newListStyleId);
                    } else if (currentListId == null && previousSiblingListId != null && !previousSiblingListId.isEmpty()) {
                        rootListElement.setTextStyleNameAttribute(newListStyleId);
                    }
                } else {
                    rootListElement.removeAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "style-name");
                }
            } else if (currentListId == null && previousSiblingListId != null && !previousSiblingListId.isEmpty()) {
                rootListElement.setTextStyleNameAttribute(previousSiblingListId);
            } else if (currentListId != null && !currentListId.isEmpty()) {
                rootListElement.setTextStyleNameAttribute(currentListId);
            }
            rootListElement.setTextContinueNumberingAttribute(true);
        }
    }

    public static void addListStyle(String listStyleId, JSONObject listDefinition, OdfDocument doc) {
        try {
            OdfOfficeAutomaticStyles autoStyles = doc.getContentDom().getOrCreateAutomaticStyles();
            OdfTextListStyle listStyle = autoStyles.newListStyle(listStyleId);
            JSONObject listLevelDefinition = null;
            for (int i = 0; i < 9; ++i) {
                listLevelDefinition = listDefinition.optJSONObject("listLevel" + i);
                JsonOperationConsumer.addListDefinition(listStyle, listLevelDefinition, i);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private static void addListDefinition(OdfTextListStyle listStyle, JSONObject listLevelDefinition, int listLevel) {
        if (listLevelDefinition != null) {
            TextListLevelStyleElementBase listLevelStyle = null;
            String numberFormat = listLevelDefinition.optString("numberFormat");
            String levelText = listLevelDefinition.optString("levelText");
            String numPrefix = null;
            String numSuffix = null;
            if (numberFormat.equals("bullet")) {
                if (levelText.length() > 1) {
                    numSuffix = levelText.substring(1);
                    levelText = levelText.substring(0, 1);
                }
                String levelPicBulletUri = listLevelDefinition.optString("levelPicBulletUri");
                listLevelStyle = levelText != null ? (levelPicBulletUri != null && !levelPicBulletUri.isEmpty() ? JsonOperationConsumer.createListLevelStyleImage(listStyle, listLevel, levelPicBulletUri) : listStyle.newTextListLevelStyleBulletElement(levelText, listLevel + 1)) : JsonOperationConsumer.createListLevelStyleImage(listStyle, listLevel, levelPicBulletUri);
            } else {
                int listStartValue;
                listLevelStyle = listStyle.newTextListLevelStyleNumberElement(JsonOperationConsumer.getNumFormat(numberFormat), listLevel + 1);
                listLevelStyle.setAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "text:display-levels", Integer.toString(JsonOperationConsumer.countOccurrences(levelText, '%')));
                if (!levelText.startsWith("%")) {
                    int prefixEnd = levelText.indexOf(37);
                    numPrefix = levelText.substring(0, prefixEnd);
                    levelText = levelText.substring(prefixEnd);
                }
                int suffixStart = levelText.lastIndexOf(37) + 2;
                if (levelText.length() >= suffixStart) {
                    numSuffix = levelText.substring(suffixStart);
                }
                if ((listStartValue = listLevelDefinition.optInt("listStartValue", -1)) != -1) {
                    listLevelStyle.setAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "text:start-value", Integer.toString(listStartValue));
                }
            }
            if (numPrefix != null && !numPrefix.isEmpty()) {
                listLevelStyle.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:num-prefix", numPrefix);
            }
            if (numSuffix != null && !numSuffix.isEmpty()) {
                listLevelStyle.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:num-suffix", numSuffix);
            }
            JsonOperationConsumer.addCommonListStyles(listLevelStyle, listLevelDefinition);
        }
    }

    private static TextListLevelStyleElementBase createListLevelStyleImage(OdfTextListStyle listStyle, int listLevel, String levelPicBulletUri) {
        TextListLevelStyleImageElement listLevelStyle = listStyle.newTextListLevelStyleImageElement(listLevel + 1);
        if (levelPicBulletUri != null && !levelPicBulletUri.isEmpty()) {
            listLevelStyle.setAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "xlink:href", levelPicBulletUri);
            TextListLevelStyleImageElement listLevelStyleImage = listLevelStyle;
            listLevelStyleImage.setXlinkActuateAttribute("onLoad");
            listLevelStyleImage.setXlinkShowAttribute("embed");
            listLevelStyleImage.setXlinkTypeAttribute("simple");
        }
        return listLevelStyle;
    }

    private static int countOccurrences(String haystack, char needle) {
        int count = 0;
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++count;
        }
        return count;
    }

    private static void addCommonListStyles(TextListLevelStyleElementBase listLevelStyle, JSONObject listLevelDefinition) {
        StyleListLevelPropertiesElement styleListLevelProperties = listLevelStyle.newStyleListLevelPropertiesElement();
        JsonOperationConsumer.addListLabelAlignment(styleListLevelProperties, listLevelDefinition);
        if (listLevelDefinition.has("height")) {
            styleListLevelProperties.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:height", listLevelDefinition.optInt("height") / 100 + "mm");
        }
        if (listLevelDefinition.has("textAlign")) {
            styleListLevelProperties.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:text-align", listLevelDefinition.optString("textAlign"));
        }
        if (listLevelDefinition.has("width")) {
            styleListLevelProperties.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:width", listLevelDefinition.optInt("width") / 100 + "mm");
        }
        if (listLevelDefinition.has("font-name")) {
            styleListLevelProperties.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-name", listLevelDefinition.optString("fontName"));
        }
        if (listLevelDefinition.has("vertical-pos")) {
            styleListLevelProperties.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:vertical-pos", listLevelDefinition.optString("verticalPos"));
        }
        if (listLevelDefinition.has("vertical-rel")) {
            styleListLevelProperties.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:vertical-rel", listLevelDefinition.optString("verticalRel"));
        }
        if (listLevelDefinition.has("y")) {
            styleListLevelProperties.setAttributeNS(OdfDocumentNamespace.SVG.getUri(), "svg:y", listLevelDefinition.optString("y"));
        }
        if (listLevelDefinition.has("listLevelPositionAndSpaceMode")) {
            styleListLevelProperties.setAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "text:list-level-position-and-space-mode", listLevelDefinition.optString("listLevelPositionAndSpaceMode"));
        }
        if (listLevelDefinition.has("minLabelDistance")) {
            styleListLevelProperties.setAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "text:min-label-distance", listLevelDefinition.optInt("minLabelDistance") / 100 + "mm");
        }
        if (listLevelDefinition.has("minLabelWidth")) {
            styleListLevelProperties.setAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "text:min-label-width", listLevelDefinition.optInt("minLabelWidth") / 100 + "mm");
        }
        if (listLevelDefinition.has("spaceBefore")) {
            styleListLevelProperties.setAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "text:space-before", listLevelDefinition.optInt("spaceBefore") / 100 + "mm");
        }
    }

    private static void addListLabelAlignment(StyleListLevelPropertiesElement styleListLevelProperties, JSONObject listLevelDefinition) {
        if (listLevelDefinition.has("indentLeft") || listLevelDefinition.has("indentFirstLine")) {
            styleListLevelProperties.setAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "text:list-level-position-and-space-mode", "label-alignment");
            String labelFollowedBy = listLevelDefinition.optString("labelFollowedBy", "listtab");
            StyleListLevelLabelAlignmentElement listLevelLabelAlignmentElement = styleListLevelProperties.newStyleListLevelLabelAlignmentElement(labelFollowedBy);
            if (listLevelDefinition.has("indentLeft")) {
                int indentLeft = listLevelDefinition.optInt("indentLeft");
                listLevelLabelAlignmentElement.setFoMarginLeftAttribute((double)indentLeft / 100.0 + "mm");
            }
            if (listLevelDefinition.has("indentFirstLine")) {
                int indentFirstLine = listLevelDefinition.optInt("indentFirstLine");
                listLevelLabelAlignmentElement.setFoTextIndentAttribute((double)indentFirstLine / 100.0 + "mm");
            }
            if (listLevelDefinition.has("tabStopPosition")) {
                int tabStopPosition = listLevelDefinition.optInt("tabStopPosition");
                listLevelLabelAlignmentElement.setTextListTabStopPositionAttribute((double)tabStopPosition / 100.0 + "mm");
                listLevelLabelAlignmentElement.setTextLabelFollowedByAttribute("listtab");
            }
        }
    }

    private static String getNumFormat(String numberFormat) {
        String numFormat = "";
        if (numberFormat.equals("decimal")) {
            numFormat = "1";
        } else if (numberFormat.equals("lowerRoman")) {
            numFormat = "i";
        } else if (numberFormat.equals("upperRoman")) {
            numFormat = "I";
        } else if (numberFormat.equals("lowerLetter")) {
            numFormat = "a";
        } else if (numberFormat.equals("upperLetter")) {
            numFormat = "A";
        }
        return numFormat;
    }

    public static void splitParagraph(Component rootComponent, JSONArray start) throws IndexOutOfBoundsException {
        block5: {
            Component component = rootComponent.getParentOf(start);
            if (component != null) {
                TextParagraphElementBase para = (TextParagraphElementBase)component.getRootElement();
                try {
                    TextParagraphElementBase newSecondPara = (TextParagraphElementBase)para.split(start.getInt(start.length() - 1));
                    Component parentComponent = component.getParent();
                    Node paraParent = component.getRootElement().getParentNode();
                    if (paraParent instanceof TextListItemElement || paraParent instanceof TextListHeaderElement) {
                        OdfElement listItem = (OdfElement)((Object)paraParent);
                        int precedingSiblingsNo = para.countPrecedingSiblingElements() + 1;
                        OdfElement secondListPart = listItem.split(precedingSiblingsNo);
                        Component.createChildComponent(start.getInt(start.length() - 2) + 1, parentComponent, secondListPart.getFirstChildElement());
                        break block5;
                    }
                    Component.createChildComponent(start.getInt(start.length() - 2) + 1, parentComponent, newSecondPara);
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            } else {
                LOG.log(Level.SEVERE, "Could not find paragraph at position: {0}", start);
            }
        }
    }

    private static void deleteText(Component rootComponent, JSONArray start, JSONArray end) throws IndexOutOfBoundsException {
        block6: {
            Component parentComponent = rootComponent.getParentOf(start);
            if (parentComponent != null) {
                try {
                    if (parentComponent instanceof TextContainer) {
                        int startPos = start.getInt(start.length() - 1);
                        int endPos = end != null ? end.getInt(end.length() - 1) : startPos;
                        ((TextContainer)parentComponent).removeText(startPos, endPos);
                        OdfElement grandParentElement = (OdfElement)((Object)parentComponent.mRootElement.getParentNode());
                        if (grandParentElement instanceof TableTableCellElement) {
                            ((TableTableCellElement)grandParentElement).removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "value");
                            ((TableTableCellElement)grandParentElement).removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "value-type");
                        }
                        break block6;
                    }
                    LOG.log(Level.SEVERE, "The parent of the text is not a text component: {0}", parentComponent);
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            } else {
                LOG.log(Level.SEVERE, "Could not find paragraph as parent for position: {0}", start);
            }
        }
    }

    private static void addFontData(OdfDocument doc, String fontName, String[] altNames, String family, String familyGeneric, String pitch, String panose1) {
        try {
            OdfContentDom contentDom = doc.getContentDom();
            StyleFontFaceElement newElement = new StyleFontFaceElement(contentDom);
            newElement.setStyleNameAttribute(fontName);
            if (family != null && !family.isEmpty()) {
                newElement.setSvgFontFamilyAttribute(family);
            }
            if (familyGeneric != null && !familyGeneric.isEmpty()) {
                newElement.setStyleFontFamilyGenericAttribute(familyGeneric);
            }
            if (pitch != null && !pitch.isEmpty()) {
                newElement.setStyleFontPitchAttribute(pitch);
            }
            if (panose1 != null && !panose1.isEmpty()) {
                if (panose1.contains("[")) {
                    panose1 = panose1.substring(1, panose1.length() - 1);
                }
                if (panose1.contains(",")) {
                    panose1 = panose1.replace(',', ' ');
                }
                newElement.setSvgPanose1Attribute(panose1);
            }
            JsonOperationConsumer.addtFontFace(contentDom, newElement);
            OdfStylesDom stylesDom = doc.getStylesDom();
            StyleFontFaceElement newElement2 = (StyleFontFaceElement)((Object)newElement.cloneNode(true));
            newElement2 = (StyleFontFaceElement)((Object)stylesDom.adoptNode((Node)((Object)newElement2)));
            JsonOperationConsumer.addtFontFace(stylesDom, newElement2);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private static void addtFontFace(OdfFileDom fileDom, StyleFontFaceElement fontFaceElement) {
        NodeList fontDecls = fileDom.getElementsByTagName("office:font-face-decls");
        if (fontDecls.getLength() == 0) {
            OdfElement rootElement = fileDom.getRootElement();
            NodeList rootChildren = rootElement.getChildNodes();
            boolean hasInserted = false;
            OfficeFontFaceDeclsElement fontFaceDeclsElement = new OfficeFontFaceDeclsElement(fileDom);
            fontFaceDeclsElement.appendChild((Node)((Object)fontFaceElement));
            for (int i = 0; i < rootChildren.getLength(); ++i) {
                String elementName;
                Node currentNode = rootChildren.item(i);
                if (!(currentNode instanceof Element) || !(elementName = ((Element)currentNode).getNodeName()).equals("office:automatic-styles") && !elementName.equals("office:styles") && !elementName.equals("office:body") && !elementName.equals("office:master-styles")) continue;
                rootElement.insertBefore((Node)((Object)fontFaceDeclsElement), currentNode);
                hasInserted = true;
                break;
            }
            if (!hasInserted) {
                rootElement.appendChild((Node)((Object)fontFaceDeclsElement));
            }
        } else {
            OfficeFontFaceDeclsElement fontFaceDeclsElement = (OfficeFontFaceDeclsElement)((Object)fontDecls.item(0));
            fontFaceDeclsElement.appendChild((Node)((Object)fontFaceElement));
        }
    }

    public static void setFieldAttributes(OdfElement newFieldElement, JSONObject attrs, FieldMap currentMap, OdfContentDom contentDom) {
        if (newFieldElement != null && currentMap != null && attrs != null && attrs.has("field")) {
            try {
                JSONObject fieldAttrs = attrs.getJSONObject("field");
                Object styleName = null;
                if (currentMap.hasDateFormat() && fieldAttrs.has("dateFormat")) {
                    boolean isTime = currentMap.hasTimeStyle();
                    String dateFormat = fieldAttrs.getString("dateFormat");
                    OdfOfficeAutomaticStyles autoStyles = contentDom.getOrCreateAutomaticStyles();
                    Iterator<NumberDataStyleElementBase> styleIter = isTime ? autoStyles.getTimeStyles().iterator() : autoStyles.getDateStyles().iterator();
                    int newStyleIdx = 0;
                    while (styleIter.hasNext()) {
                        String currentName;
                        OdfElement style = styleIter.next();
                        String string = currentName = isTime ? ((OdfNumberTimeStyle)style).getStyleNameAttribute() : ((OdfNumberDateStyle)style).getStyleNameAttribute();
                        if (styleName == null && (isTime ? ((OdfNumberTimeStyle)style).getFormat(true).equals(dateFormat) : ((OdfNumberDateStyle)style).getFormat(true).equals(dateFormat))) {
                            styleName = currentName;
                            break;
                        }
                        if (!currentName.substring(0, 1).equals("N")) continue;
                        String numString = currentName.substring(1, currentName.length());
                        try {
                            int oldIdx = Integer.parseInt(numString);
                            newStyleIdx = Math.max(newStyleIdx, oldIdx);
                        }
                        catch (NumberFormatException e) {
                            LOG.log(Level.INFO, null, e);
                        }
                    }
                    OdfContentDom fileDom = contentDom;
                    if (styleName == null) {
                        autoStyles.getParentNode();
                        styleName = "N" + (newStyleIdx + 1);
                        NumberDataStyleElementBase newStyle = null;
                        newStyle = isTime ? new OdfNumberTimeStyle(fileDom, dateFormat, (String)styleName) : new OdfNumberDateStyle(fileDom, dateFormat, (String)styleName);
                        newStyle.setAttributeNS(OdfDocumentNamespace.NUMBER.getUri(), "number:automatic-order", "true");
                        autoStyles.appendChild((Node)((Object)newStyle));
                    }
                    newFieldElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:data-style-name", (String)styleName);
                }
                newFieldElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:data-style-name", (String)styleName);
                String textUri = OdfDocumentNamespace.TEXT.getUri();
                String officeUri = OdfDocumentNamespace.OFFICE.getUri();
                String styleUri = OdfDocumentNamespace.STYLE.getUri();
                if (currentMap.hasDateValue() && fieldAttrs.has("dateValue")) {
                    newFieldElement.setAttributeNS(textUri, "text:date-value", fieldAttrs.getString("dateValue"));
                }
                if (currentMap.hasFixed() && fieldAttrs.has("fixed")) {
                    newFieldElement.setAttributeNS(textUri, "text:fixed", Boolean.valueOf(fieldAttrs.getBoolean("fixed")).toString());
                }
                if (currentMap.hasdbName() && fieldAttrs.has("dbName")) {
                    newFieldElement.setAttributeNS(textUri, "text:database-name", fieldAttrs.getString("dbName"));
                }
                if (currentMap.hasTableType() && fieldAttrs.has("typeType")) {
                    newFieldElement.setAttributeNS(textUri, "text:table-type", fieldAttrs.getString("tableType"));
                }
                if (currentMap.hasdbTable() && fieldAttrs.has("dbTable")) {
                    newFieldElement.setAttributeNS(textUri, "text:table-name", fieldAttrs.getString("dbTable"));
                }
                if (currentMap.hasdbColumn() && fieldAttrs.has("dbColumn")) {
                    newFieldElement.setAttributeNS(textUri, "text:column-name", fieldAttrs.getString("dbColumn"));
                }
                if (currentMap.hasDisplay() && fieldAttrs.has("display")) {
                    newFieldElement.setAttributeNS(textUri, "text:display", fieldAttrs.getString("display"));
                }
                if (currentMap.hasRefFormat() && fieldAttrs.has("refFormat")) {
                    newFieldElement.setAttributeNS(textUri, "text:reference-format", fieldAttrs.getString("refFormat"));
                }
                if (currentMap.hasRefName() && fieldAttrs.has("refName")) {
                    newFieldElement.setAttributeNS(textUri, "text:ref-name", fieldAttrs.getString("refName"));
                }
                if (currentMap.hasOutlinelevel() && fieldAttrs.has("outlineLevel")) {
                    newFieldElement.setAttributeNS(textUri, "text:outline-level", fieldAttrs.getString("outlineLevel"));
                }
                if (currentMap.hasPageNumFormat() && fieldAttrs.has("pageNumFormat")) {
                    newFieldElement.setAttributeNS(styleUri, "style:num-format", fieldAttrs.getString("pageNumFormat"));
                }
                if (currentMap.hasNumLetterSync() && fieldAttrs.has("numLetterSync")) {
                    newFieldElement.setAttributeNS(styleUri, "style:num-letter-sync", fieldAttrs.getString("numLetterSync"));
                }
                if (currentMap.hasCondition() && fieldAttrs.has("condition")) {
                    newFieldElement.setAttributeNS(textUri, "text:condition", fieldAttrs.getString("condition"));
                }
                if (currentMap.hasCurrentValue() && fieldAttrs.has("currentValue")) {
                    newFieldElement.setAttributeNS(textUri, "text:current-value", fieldAttrs.getString("currentValue"));
                }
                if (currentMap.hasFalseValue() && fieldAttrs.has("falseValue")) {
                    newFieldElement.setAttributeNS(textUri, "text:string-value-if-false", fieldAttrs.getString("falseValue"));
                }
                if (currentMap.hasTrueValue() && fieldAttrs.has("trueValue")) {
                    newFieldElement.setAttributeNS(textUri, "text:string-value-if-true", fieldAttrs.getString("trueValue"));
                }
                if (currentMap.hasConnectionName() && fieldAttrs.has("connectionName")) {
                    newFieldElement.setAttributeNS(textUri, "text:connection-name", fieldAttrs.getString("connectionName"));
                }
                if (currentMap.hasDuration() && fieldAttrs.has("duration")) {
                    newFieldElement.setAttributeNS(textUri, "text-duration", fieldAttrs.getString("duration"));
                }
                if (currentMap.hasName() && fieldAttrs.has("name")) {
                    newFieldElement.setAttributeNS(textUri, "text:name", fieldAttrs.getString("name"));
                }
                if (currentMap.hasBoolValue() && fieldAttrs.has("boolValue")) {
                    newFieldElement.setAttributeNS(officeUri, "office:boolean-value", fieldAttrs.getString("boolValue"));
                }
                if (currentMap.hasCurrency() && fieldAttrs.has("currency")) {
                    newFieldElement.setAttributeNS(officeUri, "office:currency", fieldAttrs.getString("currency"));
                }
                if (currentMap.hasStringValue() && fieldAttrs.has("stringValue")) {
                    newFieldElement.setAttributeNS(officeUri, "office:value", fieldAttrs.getString("stringValue"));
                }
                if (currentMap.hasTimeValue() && fieldAttrs.has("timeValue")) {
                    newFieldElement.setAttributeNS(textUri, "text:time-value", fieldAttrs.getString("timeValue"));
                }
                if (currentMap.hasTValue() && fieldAttrs.has("value")) {
                    newFieldElement.setAttributeNS(officeUri, "text:value", fieldAttrs.getString("value"));
                }
                if (currentMap.hasOValue() && fieldAttrs.has("value")) {
                    newFieldElement.setAttributeNS(officeUri, "office:value", fieldAttrs.getString("value"));
                }
                if (currentMap.hasValueType() && fieldAttrs.has("valueType")) {
                    newFieldElement.setAttributeNS(officeUri, "office:value-type", fieldAttrs.getString("valueType"));
                }
                if (currentMap.hasFormula() && fieldAttrs.has("formula")) {
                    newFieldElement.setAttributeNS(textUri, "text:formula", fieldAttrs.getString("formula"));
                }
                if (currentMap.hasIsHidden() && fieldAttrs.has("isHidden")) {
                    newFieldElement.setAttributeNS(textUri, "text:hidden", fieldAttrs.getString("isHidden"));
                }
                if (currentMap.hasId() && fieldAttrs.has("id")) {
                    newFieldElement.setAttributeNS(OdfDocumentNamespace.XML.getUri(), "xml:id", fieldAttrs.getString("id"));
                }
                if (currentMap.hasDescription() && fieldAttrs.has("description")) {
                    newFieldElement.setAttributeNS(textUri, "text:description", fieldAttrs.getString("description"));
                }
                if (currentMap.hasActive() && fieldAttrs.has("active")) {
                    newFieldElement.setAttributeNS(textUri, "text:active", fieldAttrs.getString("active"));
                }
                if (currentMap.hasHref() && fieldAttrs.has("href")) {
                    newFieldElement.setAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "xlink:href", fieldAttrs.getString("href"));
                }
                if (currentMap.hasPlaceHolderType() && fieldAttrs.has("placeHolderType")) {
                    newFieldElement.setAttributeNS(textUri, "text:placeholder-type", fieldAttrs.getString("placeHolderType"));
                }
                if (currentMap.hasKind() && fieldAttrs.has("kind")) {
                    newFieldElement.setAttributeNS(textUri, "text:kind", fieldAttrs.getString("kind"));
                }
                if (currentMap.hasLanguage() && fieldAttrs.has("language")) {
                    newFieldElement.setAttributeNS(OdfDocumentNamespace.SCRIPT.getUri(), "script:language", fieldAttrs.getString("language"));
                }
                if (currentMap.hasLinkType() && fieldAttrs.has("linkType")) {
                    newFieldElement.setAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "xlink:type", fieldAttrs.getString("linkType"));
                }
                if (currentMap.hasNumFormat() && fieldAttrs.has("numFormat")) {
                    newFieldElement.setAttributeNS(styleUri, "style:num-format", fieldAttrs.getString("numFormat"));
                }
                if (currentMap.hasPageAdjust() && fieldAttrs.has("pageAdjust")) {
                    newFieldElement.setAttributeNS(textUri, "text:page-adjust", fieldAttrs.getString("pageAdjust"));
                }
                if (currentMap.hasRowNumber() && fieldAttrs.has("rowNumber")) {
                    newFieldElement.setAttributeNS(textUri, "text:row-number", fieldAttrs.getString("rowNumber"));
                }
            }
            catch (JSONException e) {
                LOG.log(Level.SEVERE, null, e);
            }
        }
    }

    public static void addField(Component rootComponent, OdfContentDom contentDom, JSONArray start, String type, String representation, JSONObject attrs) {
        Component parentComponent = rootComponent.getParentOf(start);
        if (parentComponent == null) {
            LOG.log(Level.SEVERE, "The parent component of the table should exist at position {0}", start);
        } else {
            OdfFileDom xmlDoc = (OdfFileDom)((Object)parentComponent.getOwnerDocument());
            OdfElement newFieldElement = null;
            FieldMap currentMap = FieldMap.getFieldMap(type);
            if (currentMap != null) {
                try {
                    Class<?> fieldClass = Class.forName(currentMap.getClassName());
                    if (fieldClass != null) {
                        Class[] types = new Class[]{OdfFileDom.class};
                        Constructor<?> constructor = fieldClass.getConstructor(types);
                        newFieldElement = (OdfElement)((Object)constructor.newInstance(xmlDoc));
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    LOG.log(Level.SEVERE, null, e);
                }
                JsonOperationConsumer.setFieldAttributes(newFieldElement, attrs, currentMap, contentDom);
                if (representation != null) {
                    Text text = xmlDoc.createTextNode(representation);
                    newFieldElement.appendChild(text);
                }
                try {
                    JsonOperationConsumer.addElementAsComponent(parentComponent, newFieldElement, start.getInt(start.length() - 1));
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void changeField(Component rootComponent, OdfContentDom contentDom, JSONArray start, String type, String representation, JSONObject attrs) {
        Component parentComponent = rootComponent.getParentOf(start);
        if (parentComponent == null) {
            LOG.log(Level.SEVERE, "The parent component of the table should exist at position {0}", start);
        } else {
            int targetPos = start.optInt(start.length() - 1);
            Node targetNode = parentComponent.getChildNode(targetPos);
            if (targetNode != null) {
                LOG.log(Level.SEVERE, "node found");
                if (representation != null) {
                    targetNode.setTextContent(representation);
                }
                if (type != null) {
                    OdfElement element = (OdfElement)((Object)targetNode);
                    FieldMap currentMap = FieldMap.getFieldMap(type);
                    JsonOperationConsumer.setFieldAttributes(element, attrs, currentMap, contentDom);
                    if (Component.isField(targetNode.getNamespaceURI(), targetNode.getLocalName())) {
                        LOG.log(Level.SEVERE, "field found");
                    }
                } else if (attrs != null) {
                    JsonOperationConsumer.format(rootComponent, start, start, attrs);
                }
            }
        }
    }

    public static void addDrawing(Component rootComponent, JSONArray start, JSONObject attrs, String type, CollabTextDocument opsDoc) throws IndexOutOfBoundsException, JSONException {
        Component parentComponent = rootComponent.getParentOf(start);
        if (parentComponent == null) {
            LOG.log(Level.SEVERE, "The parent component of the table should exist at position {0}", start);
        } else {
            Object imageUrl;
            boolean isImageFrame = type != null && type.equals("image");
            OdfFileDom xmlDoc = (OdfFileDom)((Object)parentComponent.getOwnerDocument());
            DrawShapeElementBase frameElement = null;
            DrawImageElement imageElement = null;
            JSONObject drawingProps = null;
            int alternativeNo = -1;
            if (attrs != null) {
                drawingProps = attrs.optJSONObject("drawing");
                if (drawingProps == null) {
                    drawingProps = new JSONObject();
                    attrs.put("drawing", (Object)drawingProps);
                }
                if (!drawingProps.has("inline")) {
                    drawingProps.put("inline", true);
                }
                if (drawingProps != null && drawingProps.has("viewAlternative")) {
                    try {
                        alternativeNo = drawingProps.optInt("viewAlternative");
                        frameElement = (DrawFrameElement)((Object)parentComponent.getChildNode(start.getInt(start.length() - 1)));
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                } else if (type.equals("group")) {
                    frameElement = new DrawGElement(xmlDoc);
                } else {
                    frameElement = new DrawFrameElement(xmlDoc);
                    if (isImageFrame) {
                        JSONObject imageProps = attrs.optJSONObject("image");
                        imageElement = ((DrawFrameElement)frameElement).newDrawImageElement();
                        imageElement.setXlinkTypeAttribute("simple");
                        imageElement.setXlinkShowAttribute("embed");
                        imageElement.setXlinkActuateAttribute("onLoad");
                        if (imageProps != null) {
                            JsonOperationConsumer.setImageProperties(imageElement, imageProps);
                        }
                    }
                }
                if (frameElement != null) {
                    JsonOperationConsumer.setFrameProperties(frameElement, attrs);
                }
                try {
                    if (!attrs.has("styleId")) {
                        attrs.put("styleId", (Object)"default");
                    }
                }
                catch (JSONException imageProps) {
                    // empty catch block
                }
                JsonOperationConsumer.addStyle(attrs, frameElement, xmlDoc);
            }
            try {
                if (frameElement != null) {
                    if (alternativeNo == -1) {
                        JsonOperationConsumer.addElementAsComponent(parentComponent, frameElement, start.getInt(start.length() - 1));
                        DrawTextBoxElement textBoxElement = new DrawTextBoxElement(xmlDoc);
                        frameElement.insertBefore((Node)((Object)textBoxElement), null);
                    } else if (imageElement != null) {
                        NodeList frameChildren = frameElement.getChildNodes();
                        int imagesFound = 0;
                        Node followingImage = null;
                        for (int i = 0; i < frameChildren.getLength(); ++i) {
                            Node node = frameChildren.item(i);
                            if (node instanceof DrawImageElement) {
                                ++imagesFound;
                            }
                            if (imagesFound <= alternativeNo) continue;
                            followingImage = node;
                            break;
                        }
                        frameElement.insertBefore((Node)((Object)imageElement), followingImage);
                    }
                }
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            String packagePath = null;
            JSONObject imageProps = attrs.optJSONObject("image");
            if (imageProps != null && (imageUrl = imageProps.opt("imageUrl")) != null && imageUrl instanceof String) {
                packagePath = (String)imageUrl;
            }
            if (packagePath != null && imageElement != null && imageElement instanceof OdfDrawImage && packagePath.contains("uid")) {
                int uidStart = packagePath.indexOf("uid") + 3;
                if (uidStart != 3 && uidStart < packagePath.length() && uidStart < packagePath.indexOf(46)) {
                    String uidString = null;
                    uidString = packagePath.contains(".") ? packagePath.substring(uidStart, packagePath.indexOf(46)) : packagePath.substring(uidStart);
                    if (uidString != null) {
                        byte[] fileBytes;
                        long uid = Long.parseLong(uidString, 16);
                        Map<Long, byte[]> resourceMap = opsDoc.getResourceMap();
                        if (resourceMap != null && (fileBytes = resourceMap.get(uid)) != null) {
                            OdfDrawImage image = (OdfDrawImage)imageElement;
                            try {
                                image.newImage(fileBytes, packagePath, OdfFileEntry.getMediaTypeString(packagePath));
                            }
                            catch (Exception ex) {
                                LOG.log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                } else {
                    LOG.severe("No appropriate resource URL found for picture: " + packagePath);
                }
            }
        }
    }

    private static void setImageProperties(DrawImageElement imageElement, JSONObject imageProps) {
        String xmlId;
        String imageData;
        if (imageProps.has("imageUrl")) {
            String href = imageProps.optString("imageUrl");
            if (href != null && !href.isEmpty()) {
                imageElement.setXlinkHrefAttribute(href);
            }
        } else if (imageProps.has("imageData") && (imageData = imageProps.optString("imageData")) != null && !imageData.isEmpty()) {
            String[] header = imageData.split("base64,");
            String suffix = "png";
            String mediaTypeString = "image/png";
            try {
                mediaTypeString = header[0].substring(header[0].indexOf(":") + 1, header[0].indexOf(";"));
                suffix = header[0].substring(header[0].indexOf("/") + 1, header[0].indexOf(";"));
            }
            catch (Throwable t) {
                LOG.finer("BASE64 is not as expected '" + header[0] + "', the exception:" + String.valueOf(t));
            }
            String fileName = "img_" + new Random().nextInt() + "." + suffix;
            Base64Binary base64Binary = Base64Binary.valueOf(header[1]);
            OdfPackage pkg = ((OdfFileDom)((Object)imageElement.getOwnerDocument())).getDocument().getPackage();
            pkg.insert(base64Binary.getBytes(), "Pictures/" + fileName, mediaTypeString);
            imageElement.setXlinkHrefAttribute("Pictures/" + fileName);
        }
        if (imageProps.has("imageXmlId") && (xmlId = imageProps.optString("imageXmlId")) != null && !xmlId.isEmpty()) {
            imageElement.setXmlIdAttribute(xmlId);
        }
    }

    private static void setFrameProperties(DrawShapeElementBase frameElement, JSONObject attrs) {
        JSONObject shapeProps;
        JSONObject drawingProps = attrs.optJSONObject("drawing");
        if (drawingProps != null) {
            String anchorHorBase;
            String name;
            if (drawingProps.has("width")) {
                int width = drawingProps.optInt("width");
                frameElement.setOdfAttributeValue(OdfName.newName(OdfDocumentNamespace.SVG, OdfGraphicProperties.Width.toString()), (double)width / 100.0 + "mm");
            }
            if (drawingProps.has("height")) {
                int height = drawingProps.optInt("height");
                frameElement.setOdfAttributeValue(OdfName.newName(OdfDocumentNamespace.SVG, OdfGraphicProperties.Height.toString()), (double)height / 100.0 + "mm");
            }
            if (drawingProps.has("name") && (name = drawingProps.optString("name")) != null && !name.isEmpty()) {
                frameElement.setDrawNameAttribute(name);
            }
            if (drawingProps.has("anchorHorOffset")) {
                int x = drawingProps.optInt("anchorHorOffset");
                frameElement.setOdfAttributeValue(OdfName.newName(OdfDocumentNamespace.SVG, OdfGraphicProperties.X.toString()), (double)x / 100.0 + "mm");
            }
            if (drawingProps.has("anchorVertOffset")) {
                int y = drawingProps.optInt("anchorVertOffset");
                frameElement.setOdfAttributeValue(OdfName.newName(OdfDocumentNamespace.SVG, OdfGraphicProperties.Y.toString()), (double)y / 100.0 + "mm");
            }
            if (drawingProps.has("inline") && !drawingProps.get("inline").equals(JSONObject.NULL) && drawingProps.optBoolean("inline")) {
                frameElement.setTextAnchorTypeAttribute("as-char");
            } else if (drawingProps.has("anchorHorBase") && drawingProps.has("anchorVertBase")) {
                String anchorHorBase2 = drawingProps.optString("anchorHorBase");
                String anchorVertBase = drawingProps.optString("anchorVertBase");
                if (anchorHorBase2 != null && anchorVertBase != null) {
                    if (anchorHorBase2.equals("page") && anchorVertBase.equals("page")) {
                        frameElement.setTextAnchorTypeAttribute("paragraph");
                    } else if (anchorHorBase2.equals("column") && anchorVertBase.equals("margin")) {
                        frameElement.setTextAnchorTypeAttribute("frame");
                    } else if (anchorHorBase2.equals("column") && anchorVertBase.equals("paragraph")) {
                        frameElement.setTextAnchorTypeAttribute("paragraph");
                        if (!drawingProps.has("textWrapMode") && !drawingProps.has("textWrapSide")) {
                            try {
                                drawingProps.put("textWrapMode", (Object)"topAndBottom");
                            }
                            catch (JSONException jSONException) {}
                        }
                    } else if (anchorHorBase2.equals("character") && anchorVertBase.equals("paragraph")) {
                        frameElement.setTextAnchorTypeAttribute("char");
                    } else {
                        frameElement.setTextAnchorTypeAttribute("as-char");
                    }
                }
            } else if (drawingProps.has("anchorHorBase") && (anchorHorBase = drawingProps.optString("anchorHorBase")) != null) {
                if (anchorHorBase.equals("page")) {
                    frameElement.setTextAnchorTypeAttribute("page");
                } else if (anchorHorBase.equals("column")) {
                    frameElement.setTextAnchorTypeAttribute("paragraph");
                } else if (anchorHorBase.equals("character")) {
                    frameElement.setTextAnchorTypeAttribute("char");
                }
            }
            if (drawingProps.has("anchorLayerOrder")) {
                int anchorLayerOrder = drawingProps.optInt("anchorLayerOrder", 0);
                frameElement.setDrawZIndexAttribute(anchorLayerOrder);
            }
        }
        if ((shapeProps = attrs.optJSONObject("shape")) != null && shapeProps.has("autoResizeHeight") && shapeProps.optBoolean("autoResizeHeight")) {
            frameElement.removeAttribute("height");
        }
    }

    public static void addTable(Component rootComponent, JSONArray start, JSONObject attrs, JSONObject sizeExceeded, String tableName) throws IndexOutOfBoundsException {
        Component parentComponent = rootComponent.getParentOf(start);
        if (parentComponent == null) {
            LOG.log(Level.SEVERE, "The parent component of the table should exist at position {0}", start);
        } else {
            OdfFileDom xmlDoc = (OdfFileDom)((Object)parentComponent.getOwnerDocument());
            if (sizeExceeded == null) {
                TableTableElement newTableElement = new TableTableElement(xmlDoc);
                if (tableName != null && !tableName.isEmpty()) {
                    newTableElement.setTableNameAttribute(tableName);
                }
                if (attrs == null) {
                    attrs = new JSONObject();
                    try {
                        attrs.put("visible", true);
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (attrs != null) {
                    JSONArray tableGrid;
                    JsonOperationConsumer.addStyle(attrs, newTableElement, xmlDoc);
                    JSONObject tableProps = attrs.optJSONObject("table");
                    if (tableProps != null && (tableGrid = tableProps.optJSONArray("tableGrid")) != null) {
                        JsonOperationConsumer.addNewColumns(newTableElement, tableGrid);
                    }
                }
                try {
                    JsonOperationConsumer.addElementAsComponent(parentComponent, newTableElement, start.getInt(start.length() - 1));
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            } else {
                TextPElement newTableElement = new TextPElement(xmlDoc);
                newTableElement.appendChild(xmlDoc.createTextNode("This table was too large!"));
                try {
                    JsonOperationConsumer.addElementAsComponent(parentComponent, newTableElement, start.getInt(start.length() - 1));
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void addAnnotation(Component rootComponent, JSONArray start, JSONObject attrs, String id, String author, String date) {
        Component parentComponent = rootComponent.getParentOf(start);
        if (parentComponent == null) {
            LOG.log(Level.SEVERE, "The parent component of the comment should exist at position {0}", start);
        } else if (!id.startsWith("cmt")) {
            LOG.log(Level.SEVERE, "The comment id should start with cmt", start);
        } else {
            OdfFileDom xmlDoc = (OdfFileDom)((Object)parentComponent.getOwnerDocument());
            OfficeAnnotationElement newCommentElement = new OfficeAnnotationElement(xmlDoc);
            id = id.substring("cmt".length());
            newCommentElement.setOfficeNameAttribute(id);
            try {
                JsonOperationConsumer.addElementAsComponent(parentComponent, newCommentElement, start.getInt(start.length() - 1));
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            if (!author.isEmpty()) {
                DcCreatorElement creatorElement = new DcCreatorElement(xmlDoc);
                creatorElement.setTextContent(author);
                newCommentElement.appendChild((Node)((Object)creatorElement));
            }
            if (!date.isEmpty()) {
                DcDateElement dateElement = new DcDateElement(xmlDoc);
                dateElement.setTextContent(date);
                newCommentElement.appendChild((Node)((Object)dateElement));
            }
            OdfFileDom fileDom = (OdfFileDom)((Object)rootComponent.getOwnerDocument());
            ((OdfDocument)fileDom.getDocument()).addAnnotation(id, newCommentElement);
        }
    }

    public static void addNoteSelection(Component rootComponent, JSONArray start, String type, String position, JSONObject attrs, String id) {
        Component parentComponent = rootComponent.getParentOf(start);
        if (parentComponent == null) {
            LOG.log(Level.SEVERE, "The parent component of the comment should exist at position {0}", start);
        } else if (!id.startsWith("cmt")) {
            LOG.log(Level.SEVERE, "The comment id should start with cmt", start);
        } else if (!type.equals("comment")) {
            LOG.log(Level.SEVERE, "Only ranges of type 'comment' can be inserted", start);
        } else if (position.equals("end")) {
            OdfFileDom xmlDoc = (OdfFileDom)((Object)parentComponent.getOwnerDocument());
            OfficeAnnotationEndElement newCommentEndElement = new OfficeAnnotationEndElement(xmlDoc);
            id = id.substring("cmt".length());
            newCommentEndElement.setOfficeNameAttribute(id);
            try {
                JsonOperationConsumer.addElementAsComponent(parentComponent, newCommentEndElement, start.getInt(start.length() - 1));
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        } else {
            LOG.log(Level.SEVERE, "ODF does not define a comment start range ", start);
        }
    }

    public static void modifyPages(OdfDocument doc, JSONObject attrs) {
        try {
            OdfStylesDom stylesDom = doc.getStylesDom();
            if (stylesDom != null && attrs.has("page")) {
                JSONObject pageAttrs = attrs.getJSONObject("page");
                OfficeMasterStylesElement masterStyles = stylesDom.getOrCreateMasterStyles();
                OdfOfficeAutomaticStyles autoStyles = stylesDom.getOrCreateAutomaticStyles();
                for (StyleMasterPageElement masterPage : masterStyles) {
                    double value;
                    String pageLayoutName = masterPage.getStylePageLayoutNameAttribute();
                    OdfStylePageLayout pageLayout = autoStyles.getPageLayout(pageLayoutName);
                    if (pageAttrs.has("marginLeft")) {
                        value = pageAttrs.getDouble("marginLeft");
                        pageLayout.setProperty(StylePageLayoutPropertiesElement.MarginLeft, Double.toString(value / 100.0) + "mm");
                    }
                    if (pageAttrs.has("marginRight")) {
                        value = pageAttrs.getDouble("marginRight");
                        pageLayout.setProperty(StylePageLayoutPropertiesElement.MarginRight, Double.toString(value / 100.0) + "mm");
                    }
                    if (pageAttrs.has("marginTop")) {
                        value = pageAttrs.getDouble("marginTop");
                        pageLayout.setProperty(StylePageLayoutPropertiesElement.MarginTop, Double.toString(value / 100.0) + "mm");
                    }
                    if (pageAttrs.has("marginBottom")) {
                        value = pageAttrs.getDouble("marginBottom");
                        pageLayout.setProperty(StylePageLayoutPropertiesElement.MarginBottom, Double.toString(value / 100.0) + "mm");
                    }
                    if (pageAttrs.has("width")) {
                        value = pageAttrs.getInt("width");
                        pageLayout.setProperty(StylePageLayoutPropertiesElement.PageWidth, Double.toString(value / 100.0) + "mm");
                    }
                    if (!pageAttrs.has("height")) continue;
                    value = pageAttrs.getInt("height");
                    pageLayout.setProperty(StylePageLayoutPropertiesElement.PageHeight, Double.toString(value / 100.0) + "mm");
                }
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public static void addDeleteHeaderFooter(OdfDocument doc, boolean insert, String id) {
        String masterPageName = "";
        PageArea pageArea = null;
        if (id.startsWith("header")) {
            if (id.startsWith(PageArea.HEADER_DEFAULT.getPageAreaName())) {
                masterPageName = id.substring(PageArea.HEADER_DEFAULT.getPageAreaName().length() + 1, id.length());
                pageArea = PageArea.HEADER_DEFAULT;
            } else if (id.startsWith(PageArea.HEADER_FIRST.getPageAreaName())) {
                masterPageName = id.substring(PageArea.HEADER_FIRST.getPageAreaName().length() + 1, id.length());
                pageArea = PageArea.HEADER_FIRST;
            } else if (id.startsWith(PageArea.HEADER_EVEN.getPageAreaName())) {
                masterPageName = id.substring(PageArea.HEADER_EVEN.getPageAreaName().length() + 1, id.length());
                pageArea = PageArea.HEADER_EVEN;
            }
        } else if (id.startsWith("footer")) {
            if (id.startsWith(PageArea.FOOTER_DEFAULT.getPageAreaName())) {
                masterPageName = id.substring(PageArea.FOOTER_DEFAULT.getPageAreaName().length() + 1, id.length());
                pageArea = PageArea.FOOTER_DEFAULT;
            } else if (id.startsWith(PageArea.FOOTER_FIRST.getPageAreaName())) {
                masterPageName = id.substring(PageArea.FOOTER_FIRST.getPageAreaName().length() + 1, id.length());
                pageArea = PageArea.FOOTER_FIRST;
            } else if (id.startsWith(PageArea.FOOTER_EVEN.getPageAreaName())) {
                masterPageName = id.substring(PageArea.FOOTER_EVEN.getPageAreaName().length() + 1, id.length());
                pageArea = PageArea.FOOTER_EVEN;
            }
        }
        if (pageArea != null) {
            if (insert) {
                OdfStylePageLayout pageLayout;
                String pageUsageAttribute;
                String pageLayoutName;
                OdfElement component = doc.getRootComponentElement(masterPageName, pageArea, true);
                if (!(pageArea != PageArea.HEADER_EVEN && pageArea != PageArea.FOOTER_EVEN || (pageLayoutName = ((StyleMasterPageElement)((Object)component.getParentNode())).getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "page-layout-name")) == null || (pageUsageAttribute = (pageLayout = ((StyleMasterPageElement)((Object)component.getParentNode())).getOrCreateAutomaticStyles().getOrCreatePageLayout(pageLayoutName)).getStylePageUsageAttribute()).isEmpty() || !pageUsageAttribute.equals("right") && !pageUsageAttribute.equals("left"))) {
                    pageLayout.setStylePageUsageAttribute(null);
                }
            } else {
                OdfElement component = doc.getRootComponentElement(masterPageName, pageArea, false);
                if (component != null) {
                    Node parent = component.getParentNode();
                    parent.removeChild((Node)((Object)component));
                }
            }
        } else {
            LOG.log(Level.SEVERE, "Unable to add/delete header/footer for " + id);
        }
    }

    public static void setColumnsWidth(Component tableComponent, JSONArray start, JSONArray tableGrid, boolean isTextTable) {
        if (tableGrid != null) {
            TableTableElement tableElement = (TableTableElement)tableComponent.getRootElement();
            List<TableTableColumnElement> existingColumnList = Table.getTableColumnElements((Element)((Object)tableElement), new ArrayList<TableTableColumnElement>());
            int columnCount = 0;
            for (TableTableColumnElement column : existingColumnList) {
                columnCount += column.getRepetition();
            }
            if (tableGrid.length() != columnCount) {
                ((Table)tableElement.getComponent()).pushTableGrid(tableGrid);
                ((Table)tableElement.getComponent()).requireLaterWidthChange(start);
            } else {
                JsonOperationConsumer.addColumnAndCellElements(tableComponent, start, tableGrid, Integer.MAX_VALUE, INSERT_BEFORE, -1, isTextTable, existingColumnList, true);
            }
        } else {
            LOG.log(Level.SEVERE, "Missing table grid defining the relative column widths for table component at position {0}");
        }
    }

    private static List<String> calcAbsoluteColumnWidths(TableTableElement tableElement, JSONArray tableGrid) {
        ArrayList<CallSite> absColumnWidths = null;
        String tableWidth = tableElement.getProperty(StyleTablePropertiesElement.Width);
        if (tableWidth != null && !tableWidth.isEmpty()) {
            int absTableWidth = MapHelper.normalizeLength(tableWidth);
            double relTableWidth = 0.0;
            int columnCount = tableGrid.length();
            absColumnWidths = new ArrayList<CallSite>(columnCount);
            for (int i = 0; columnCount > i; ++i) {
                relTableWidth += (double)tableGrid.optLong(i);
            }
            if (relTableWidth == 0.0) {
                relTableWidth = 1.0;
            }
            double widthProRel = (double)absTableWidth / relTableWidth;
            for (int i = 0; tableGrid.length() > i; ++i) {
                double absWidth = Math.round((double)tableGrid.optInt(i) * widthProRel);
                absColumnWidths.add((CallSite)((Object)(absWidth / 100.0 + "mm")));
            }
        }
        return absColumnWidths;
    }

    public static void addColumns(Component rootComponent, JSONArray start, JSONArray tableGrid, Integer referenceColumnGridPosition, String insertMode) {
        Component parentComponent = rootComponent.get(start);
        if (parentComponent == null) {
            LOG.log(Level.SEVERE, "The table parent component of the column should exist at position {0}", start);
        } else if (tableGrid != null) {
            TableTableElement tableElement = (TableTableElement)parentComponent.mRootElement;
            if (!((Table)tableElement.getComponent()).isWidthChangeRequired()) {
                Table.stashColumnWidths(tableElement);
            }
            List<TableTableColumnElement> existingColumnList = Table.getTableColumnElements((Element)((Object)parentComponent.getRootElement()), new ArrayList<TableTableColumnElement>());
            JsonOperationConsumer.addColumnAndCellElements(parentComponent, start, tableGrid, referenceColumnGridPosition, insertMode, -1, true, existingColumnList, false);
            if (((Table)tableElement.getComponent()).isWidthChangeRequired()) {
                JsonOperationConsumer.setColumnsWidth(tableElement.getComponent(), ((Table)tableElement.getComponent()).getPosition(), ((Table)tableElement.getComponent()).popTableGrid(), true);
            }
        } else {
            LOG.log(Level.SEVERE, "Missing table grid defining the relative column widths for table component at position {0}", start);
        }
    }

    private static void addColumnAndCellElements(Component tableComponent, JSONArray start, JSONArray tableGrid, Integer referenceColumnGridPosition, String insertMode, int newLastColumnNo, boolean isTextTable, List<TableTableColumnElement> existingColumnList, boolean columnCreationOnly) {
        TableTableElement tableElement = (TableTableElement)tableComponent.getRootElement();
        List<String> newAbsColumnWidthsGrid = null;
        if (tableGrid != null) {
            newAbsColumnWidthsGrid = JsonOperationConsumer.calcAbsoluteColumnWidths(tableElement, tableGrid);
        }
        TableTableColumnElement newColumnElement = null;
        int appendColumnCount = newLastColumnNo + 1 - JsonOperationConsumer.getColumnCount(existingColumnList);
        if (tableGrid != null) {
            Long previousColumnWidth = null;
            Long currentColumnWidth = null;
            int equalColumnsPassed = 0;
            TableTableColumnElement columnElement = null;
            int columnGridNo = 0;
            int columnElementNo = 0;
            while (columnElementNo < existingColumnList.size()) {
                columnElement = existingColumnList.get(columnElementNo);
                JsonOperationConsumer.applyWidth(columnElement, JsonOperationConsumer.getAbsoluteColumnWidth(newAbsColumnWidthsGrid, columnGridNo), tableGrid.optLong(columnGridNo) + "*");
                int repetition = columnElement.getRepetition();
                for (int repeated = 1; repeated <= repetition; ++repeated) {
                    if (repeated > 1) {
                        ++columnGridNo;
                    }
                    currentColumnWidth = tableGrid.optLong(columnGridNo);
                    if (previousColumnWidth != null && equalColumnsPassed > 0 && !currentColumnWidth.equals(previousColumnWidth)) {
                        if (columnElement.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated")) {
                            columnElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
                        }
                        newColumnElement = JsonOperationConsumer.cloneColumnElement(columnElement);
                        OdfElement parent = (OdfElement)((Object)columnElement.getParentNode());
                        parent.insertBefore((Node)((Object)newColumnElement), (Node)((Object)columnElement));
                        if (equalColumnsPassed > 1) {
                            newColumnElement.setAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "table:number-columns-repeated", String.valueOf(equalColumnsPassed));
                        }
                        JsonOperationConsumer.applyWidth(columnElement, JsonOperationConsumer.getAbsoluteColumnWidth(newAbsColumnWidthsGrid, columnGridNo), tableGrid.optLong(columnGridNo) + "*");
                        equalColumnsPassed = 1;
                    } else {
                        ++equalColumnsPassed;
                        if (columnGridNo == referenceColumnGridPosition) {
                            ++equalColumnsPassed;
                            ++columnGridNo;
                        }
                    }
                    previousColumnWidth = currentColumnWidth;
                }
                if (equalColumnsPassed > 1) {
                    columnElement.setAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "table:number-columns-repeated", String.valueOf(equalColumnsPassed));
                } else if (columnElement.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated")) {
                    columnElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
                }
                equalColumnsPassed = 0;
                previousColumnWidth = null;
                ++columnElementNo;
                ++columnGridNo;
            }
            if (columnGridNo == referenceColumnGridPosition) {
                JsonOperationConsumer.addColumnElement(columnElement, insertMode, columnGridNo, newAbsColumnWidthsGrid, tableGrid);
                ++columnGridNo;
            }
        }
        if (!(appendColumnCount <= 0 && newLastColumnNo <= 0 || referenceColumnGridPosition.equals(Integer.MAX_VALUE))) {
            JsonOperationConsumer.appendColumnElement(tableElement, existingColumnList, appendColumnCount);
        }
        if (!columnCreationOnly) {
            if (referenceColumnGridPosition == null) {
                JsonOperationConsumer.addCellsInRows(tableComponent, start, appendColumnCount, insertMode, appendColumnCount, isTextTable);
            } else if (referenceColumnGridPosition != Integer.MAX_VALUE) {
                JsonOperationConsumer.addCellsInRows(tableComponent, start, referenceColumnGridPosition, insertMode, appendColumnCount, isTextTable);
            }
        }
    }

    private static void addColumnElement(TableTableColumnElement columnElement, String insertMode, int columnGridNo, List<String> newAbsColumnWidthsGrid, JSONArray tableGrid) {
        TableTableColumnElement newColumnElement = JsonOperationConsumer.cloneColumnElement(columnElement);
        OdfElement parent = (OdfElement)((Object)columnElement.getParentNode());
        if (insertMode.equals(INSERT_BEFORE)) {
            parent.insertBefore((Node)((Object)newColumnElement), (Node)((Object)columnElement));
            JsonOperationConsumer.applyWidth(columnElement, JsonOperationConsumer.getAbsoluteColumnWidth(newAbsColumnWidthsGrid, columnGridNo), tableGrid.optLong(columnGridNo) + "*");
        } else {
            OdfElement nextSibling = OdfElement.getNextSiblingElement((Node)((Object)columnElement));
            if (nextSibling != null) {
                parent.insertBefore((Node)((Object)newColumnElement), (Node)((Object)nextSibling));
            } else {
                parent.appendChild((Node)((Object)newColumnElement));
            }
            JsonOperationConsumer.applyWidth(newColumnElement, JsonOperationConsumer.getAbsoluteColumnWidth(newAbsColumnWidthsGrid, columnGridNo), tableGrid.optLong(columnGridNo) + "*");
        }
    }

    private static void appendColumnElement(TableTableElement tableElement, List<TableTableColumnElement> existingColumnList, int appendColumnCount) {
        TableTableColumnElement columnElement = existingColumnList.get(existingColumnList.size() - 1);
        TableTableColumnElement newColumnElement = new TableTableColumnElement((OdfFileDom)((Object)tableElement.getOwnerDocument()));
        if (appendColumnCount > 1) {
            newColumnElement.setTableNumberColumnsRepeatedAttribute(appendColumnCount);
        }
        if (columnElement.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "default-cell-style-name")) {
            newColumnElement.setTableDefaultCellStyleNameAttribute(columnElement.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "default-cell-style-name"));
        }
        OdfElement parent = (OdfElement)((Object)columnElement.getParentNode());
        OdfElement nextSibling = OdfElement.getNextSiblingElement((Node)((Object)columnElement));
        if (nextSibling != null) {
            parent.insertBefore((Node)((Object)newColumnElement), (Node)((Object)nextSibling));
        } else {
            parent.appendChild((Node)((Object)newColumnElement));
        }
    }

    private static int getColumnCount(List<TableTableColumnElement> columnList) {
        int columnCount = 0;
        int columnRepeated = 1;
        for (TableTableColumnElement columnElement : columnList) {
            columnRepeated = 1;
            if (columnElement.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated")) {
                columnRepeated = Integer.parseInt(columnElement.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated"));
            }
            columnCount += columnRepeated;
        }
        return columnCount;
    }

    private static void addCellsInRows(Component tableComponent, JSONArray start, Integer referenceColumnGridPosition, String insertMode, int cellRepetition, boolean isTextTable) {
        if (referenceColumnGridPosition != Integer.MAX_VALUE) {
            int newColumnTargetGridPosition = -1;
            newColumnTargetGridPosition = insertMode.equals(INSERT_BEFORE) ? referenceColumnGridPosition : referenceColumnGridPosition + 1;
            JsonOperationConsumer.addNewRowsCells(tableComponent, start, referenceColumnGridPosition, newColumnTargetGridPosition, cellRepetition, isTextTable);
        }
    }

    private static String getAbsoluteColumnWidth(List<String> newAbsColumnWidthsGrid, int columnGridNo) {
        String absoluteWidth = null;
        if (newAbsColumnWidthsGrid != null) {
            absoluteWidth = newAbsColumnWidthsGrid.get(columnGridNo);
        }
        return absoluteWidth;
    }

    private static void applyWidth(TableTableColumnElement columnElement, String absoluteWidth, String relativeWidth) {
        StyleStyleElement columnStyleElement = columnElement.getOrCreateUnqiueAutomaticStyle();
        StyleTableColumnPropertiesElement columnPropsElement = (StyleTableColumnPropertiesElement)columnStyleElement.getOrCreatePropertiesElement(OdfStylePropertiesSet.TableColumnProperties);
        if (columnPropsElement == null) {
            columnPropsElement = columnStyleElement.newStyleTableColumnPropertiesElement();
        }
        if (absoluteWidth != null) {
            columnPropsElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:column-width", absoluteWidth);
            columnPropsElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "rel-column-width");
        } else if (relativeWidth != null) {
            columnPropsElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:rel-column-width", relativeWidth);
        }
    }

    private static TableTableColumnElement cloneColumnElement(TableTableColumnElement origColumnElement) {
        TableTableColumnElement newColumnElement = (TableTableColumnElement)((Object)origColumnElement.cloneNode(true));
        if (newColumnElement.hasAttribute("xml:id")) {
            newColumnElement.removeAttribute("xml:id");
        }
        if (newColumnElement.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated")) {
            newColumnElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
        }
        return newColumnElement;
    }

    private static void addNewRowsCells(Component tableComponent, JSONArray start, Integer cellReferencePosition, Integer cellTargetPosition, int cellRepetition, boolean isTextTable) {
        int currentRowPosition = 0;
        int rowComponentLevel = start.length();
        JSONArray destinationCellPosition = start.put(currentRowPosition).put((Object)cellTargetPosition);
        TableTableCellElement clonedCellElement = null;
        TableTableElement tableElement = (TableTableElement)tableComponent.mRootElement;
        OdfTable table = OdfTable.getInstance(tableElement);
        for (TableTableRowElement rowElement : table.getRowElementList()) {
            Row rowComponent = (Row)rowElement.getComponent();
            if (cellReferencePosition == null || cellReferencePosition == -1) {
                clonedCellElement = new TableTableCellElement((OdfFileDom)((Object)tableComponent.getOwnerDocument()));
                cellReferencePosition = -1;
            } else if (rowComponent.getChildNode(cellReferencePosition) != null) {
                clonedCellElement = (TableTableCellElement)((Object)((TableTableCellElement)((Object)rowComponent.getChildNode(cellReferencePosition))).cloneNode(0));
                clonedCellElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
                clonedCellElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-spanned");
                clonedCellElement.removeAttribute("xml:id");
            }
            if (cellRepetition == -1) {
                cellRepetition = cellTargetPosition - cellReferencePosition;
            }
            JsonOperationConsumer.addCells(tableComponent.getRootComponent(), destinationCellPosition, null, cellRepetition, rowComponent, clonedCellElement, isTextTable);
            try {
                destinationCellPosition.put(rowComponentLevel, currentRowPosition += rowComponent.repetition());
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    private static void addNewColumns(TableTableElement table, JSONArray tableGrid) {
        if (tableGrid != null) {
            int columnLength = Integer.MIN_VALUE;
            int previousColumnLength = Integer.MIN_VALUE;
            int repeated = 1;
            int columnCount = tableGrid.length();
            for (int i = 0; i < columnCount; ++i) {
                try {
                    columnLength = (Integer)tableGrid.get(i);
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
                if (previousColumnLength == columnLength) {
                    ++repeated;
                    continue;
                }
                if (i != 0) {
                    TableTableColumnElement column = table.newTableTableColumnElement();
                    if (repeated != 1) {
                        column.setTableNumberColumnsRepeatedAttribute(repeated);
                    }
                    column.getOrCreateUnqiueAutomaticStyle().newStyleTableColumnPropertiesElement().setStyleRelColumnWidthAttribute(previousColumnLength + "*");
                }
                previousColumnLength = columnLength;
                repeated = 1;
            }
            TableTableColumnElement column = table.newTableTableColumnElement();
            if (repeated != 1) {
                column.setTableNumberColumnsRepeatedAttribute(repeated);
            }
            column.getOrCreateUnqiueAutomaticStyle().newStyleTableColumnPropertiesElement().setStyleRelColumnWidthAttribute(previousColumnLength + "*");
        }
    }

    public static void addRows(Component rootComponent, JSONArray start, JSONObject attrs, int count, boolean addDefaultCells, int referenceRow, boolean isTextTable) throws IndexOutOfBoundsException, JSONException {
        assert (count >= 1) : "Row count is expected to be at least 1";
        Component parentComponent = rootComponent.getParentOf(start);
        OdfElement o = parentComponent.getRootElement();
        if (!(o instanceof TableTableElement)) {
            LOG.severe("Table exceeded the maximum Size: " + String.valueOf((Object)o));
        }
        TableTableElement tableElement = (TableTableElement)parentComponent.getRootElement();
        OdfTable table = OdfTable.getInstance(tableElement);
        if (parentComponent == null) {
            LOG.log(Level.SEVERE, "The parent component of the table should exist at position {0}", start);
        } else {
            TableTableRowElement rowElement;
            OdfFileDom xmlDoc = (OdfFileDom)((Object)parentComponent.getOwnerDocument());
            if (referenceRow > -1) {
                Integer rowsRepeated;
                OdfTableRow row = table.getRowByIndex(referenceRow);
                TableTableRowElement originalRow = row.getOdfElement();
                rowElement = (TableTableRowElement)((Object)originalRow.cloneNode(1));
                if (rowElement.hasAttribute("xml:id")) {
                    rowElement.removeAttribute("xml:id");
                }
                if ((rowsRepeated = rowElement.getTableNumberRowsRepeatedAttribute()) != null && rowsRepeated > 1) {
                    rowElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-repeated");
                }
            } else {
                rowElement = new TableTableRowElement(xmlDoc);
            }
            if (attrs != null) {
                JsonOperationConsumer.addStyle(attrs, rowElement, xmlDoc);
            }
            Component newRowComponent = JsonOperationConsumer.addElementAsComponent(parentComponent, rowElement, start.optInt(start.length() - 1));
            if (addDefaultCells) {
                JsonOperationConsumer.addCells(rootComponent, start, (JSONObject)(isTextTable ? CELL_WITH_BORDER_ATTRS : null), table.getColumnCount(), newRowComponent, null, isTextTable);
            }
            if (count > 1) {
                if (isTextTable) {
                    JsonOperationConsumer.duplicateComponent(newRowComponent, count - 1);
                } else {
                    rowElement.setTableNumberRowsRepeatedAttribute(count);
                }
            }
        }
    }

    public static void addCells(Component rootComponent, JSONArray start, JSONObject attrs, int count, Component parentComponent, OdfElement newCellElement, boolean isTextTable) throws IndexOutOfBoundsException {
        if (parentComponent == null) {
            parentComponent = rootComponent.getParentOf(start);
        }
        int cellPosition = start.optInt(start.length() - 1);
        if (isTextTable) {
            OdfFileDom xmlDoc = (OdfFileDom)((Object)parentComponent.getOwnerDocument());
            if (newCellElement == null) {
                newCellElement = new TableTableCellElement(xmlDoc);
            }
            if (attrs != null) {
                JsonOperationConsumer.addStyle(attrs, (OdfStylableElement)newCellElement, xmlDoc);
                JsonOperationConsumer.addCellAttributes(attrs, (TableTableCellElement)newCellElement);
            }
            Component cellComponent = JsonOperationConsumer.addElementAsComponent(parentComponent, newCellElement, cellPosition);
            JsonOperationConsumer.duplicateComponent(cellComponent, count - 1);
            Component tableComponent = cellComponent.getParent().getParent();
            TableTableElement tableElement = (TableTableElement)tableComponent.mRootElement;
            if (((Table)tableElement.getComponent()).isWidthChangeRequired()) {
                List<TableTableColumnElement> existingColumnList = Table.getTableColumnElements((Element)((Object)tableElement), new ArrayList<TableTableColumnElement>());
                JsonOperationConsumer.addColumnAndCellElements(tableElement.getComponent(), start, ((Table)tableElement.getComponent()).popTableGrid(), cellPosition, INSERT_AFTER, -1, true, existingColumnList, true);
                ((Table)tableElement.getComponent()).hasChangedWidth();
            }
        } else {
            if (newCellElement == null) {
                OdfFileDom xmlDoc = (OdfFileDom)((Object)parentComponent.getOwnerDocument());
                newCellElement = new TableTableCellElement(xmlDoc);
            }
            if (count > 1) {
                newCellElement.setAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "table:number-columns-repeated", String.valueOf(count));
            }
            JsonOperationConsumer.addElementAsComponent(parentComponent, newCellElement, cellPosition);
        }
    }

    private static void addCellAttributes(JSONObject attrs, TableTableCellElement newCellElement) {
        JSONObject props = (JSONObject)attrs.opt("cell");
        if (props != null && props.length() > 0 && props.has("gridSpan")) {
            Integer columnSpan = props.optInt("gridSpan");
            newCellElement.setTableNumberColumnsSpannedAttribute(columnSpan);
        }
    }

    private static void duplicateComponent(Component c, int count) {
        OdfElement newElement = c.mRootElement;
        OdfElement parent = (OdfElement)((Object)c.mRootElement.getParentNode());
        for (int i = 0; i < count; ++i) {
            newElement = (OdfElement)((Object)newElement.cloneNode(true));
            parent.insertBefore((Node)((Object)newElement), (Node)((Object)c.mRootElement));
            JsonOperationConsumer.addElementAsComponent(c.getParent(), newElement, -1);
        }
    }

    public static Component addElementAsComponent(Component parentComponent, OdfElement newElement, int newPosition) {
        Component newComponent = null;
        if (parentComponent != null) {
            Node existingNode = parentComponent.getChildNode(newPosition);
            OdfElement existingElement = null;
            if (existingNode != null && newPosition != -1 && existingNode instanceof OdfElement) {
                OdfElement existingParentElement = (OdfElement)((Object)existingNode.getParentNode());
                if (existingParentElement instanceof TextListItemElement || existingParentElement instanceof TextListHeaderElement) {
                    existingElement = Component.getCorrectStartElementOfChild(parentComponent.getRootElement(), (OdfElement)((Object)existingNode));
                    existingParentElement = parentComponent.getRootElement();
                } else {
                    existingElement = (OdfElement)((Object)existingNode);
                }
                existingParentElement.insertBefore((Node)((Object)newElement), (Node)((Object)existingElement));
                newComponent = Component.createChildComponent(newPosition, parentComponent, newElement);
            } else if (parentComponent instanceof TextContainer && ((TextContainer)parentComponent).getChildNode(newPosition) != null) {
                OdfElement parentElement = parentComponent.getRootElement();
                if (parentElement instanceof OdfElement) {
                    parentElement.insert((Node)((Object)newElement), newPosition);
                    newComponent = Component.createChildComponent(newPosition, parentComponent, newElement);
                } else {
                    LOG.log(Level.WARNING, "The parent element {0} is not of type OdfElement. The new element {1} could not be inserted!", new Object[]{parentElement.getTagName(), newElement.getTagName()});
                }
            } else {
                Node child;
                OdfElement parentElement = parentComponent.getRootElement();
                boolean inserted = false;
                if (parentElement instanceof DrawFrameElement && (child = parentElement.getFirstChild()) != null && child instanceof DrawTextBoxElement) {
                    child.appendChild((Node)((Object)newElement));
                    inserted = true;
                }
                if (!inserted) {
                    parentElement.appendChild((Node)((Object)newElement));
                }
                if ((newComponent = parentComponent.createChildComponent(newElement)) instanceof Row || newComponent instanceof Cell) {
                    OdfElement parent = (OdfElement)((Object)newComponent.mRootElement.getParentNode());
                    if (newComponent instanceof Row) {
                        while (!(parent instanceof TableTableElement)) {
                            parent.getParentNode();
                        }
                        int newCount = newPosition + 1;
                        int existingNumber = parent.countDescendantComponents() - 1;
                        int rowRepeated = newCount - existingNumber;
                        if (rowRepeated > 1) {
                            newElement.setAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "table:number-rows-repeated", String.valueOf(rowRepeated));
                        }
                    }
                }
            }
        } else {
            LOG.severe("The parentComponent should never be null!");
        }
        return newComponent;
    }

    public static void mapProperties(OdfStyleFamily styleFamily, JSONObject attrs, OdfStyleBase style, OdfDocument doc) {
        if (attrs != null && styleFamily != null && style != null) {
            if (styleFamily.getName().equals("table-cell") && attrs.has("cell") && !attrs.get("cell").equals(JSONObject.NULL)) {
                try {
                    JSONObject cellObject = attrs.getJSONObject("cell");
                    if (cellObject.has("alignHor")) {
                        if (!attrs.has("paragraph")) {
                            attrs.put("paragraph", (Object)new JSONObject());
                        }
                        JSONObject paraObject = attrs.getJSONObject("paragraph");
                        paraObject.put("alignment", cellObject.get("alignHor"));
                    }
                }
                catch (JSONException cellObject) {
                    // empty catch block
                }
            }
            Map<String, OdfStylePropertiesSet> familyProperties = Component.getAllStyleGroupingIdProperties(styleFamily);
            Set<String> propTypes = familyProperties.keySet();
            for (String type : propTypes) {
                JSONObject props;
                OdfStylePropertiesBase propsElement;
                if (type.equals("character") && attrs.has("character") && !attrs.get("character").equals(JSONObject.NULL)) {
                    JSONObject textProps = (JSONObject)attrs.opt("character");
                    if (textProps == null || textProps.length() <= 0) continue;
                    propsElement = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.TextProperties);
                    JsonOperationConsumer.mapCharacterProperties(textProps, (StyleTextPropertiesElement)propsElement, doc);
                    continue;
                }
                if (type.equals("paragraph") && attrs.has("paragraph") && !attrs.get("paragraph").equals(JSONObject.NULL)) {
                    JSONObject paraProps = (JSONObject)attrs.opt("paragraph");
                    if (paraProps == null || paraProps.length() <= 0) continue;
                    propsElement = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.ParagraphProperties);
                    JsonOperationConsumer.mapParagraphProperties(paraProps, (StyleParagraphPropertiesElement)propsElement);
                    continue;
                }
                if (type.equals("table")) {
                    if (attrs.has("table") && !attrs.get("table").equals(JSONObject.NULL)) {
                        JSONObject tableProps = (JSONObject)attrs.opt("table");
                        if (tableProps == null || tableProps.length() <= 0) continue;
                        propsElement = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.TableProperties);
                        JsonOperationConsumer.mapTableProperties(tableProps, (StyleTablePropertiesElement)propsElement);
                        continue;
                    }
                    if (attrs.has("sheet") && !attrs.get("sheet").equals(JSONObject.NULL)) {
                        JSONObject sheetProps = (JSONObject)attrs.opt("sheet");
                        if (sheetProps == null || sheetProps.length() <= 0) continue;
                        propsElement = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.TableProperties);
                        JsonOperationConsumer.mapTableProperties(sheetProps, (StyleTablePropertiesElement)propsElement);
                        continue;
                    }
                    OdfStylePropertiesBase propsElement2 = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.TableProperties);
                    JsonOperationConsumer.mapTableProperties(null, (StyleTablePropertiesElement)propsElement2);
                    continue;
                }
                if (type.equals("row") && attrs.has("row") && !attrs.get("row").equals(JSONObject.NULL)) {
                    props = (JSONObject)attrs.opt("row");
                    if (props == null || props.length() <= 0) continue;
                    propsElement = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.TableRowProperties);
                    JsonOperationConsumer.mapRowProperties(props, (StyleTableRowPropertiesElement)propsElement);
                    continue;
                }
                if (type.equals("cell") && attrs.has("cell") && !attrs.get("cell").equals(JSONObject.NULL)) {
                    props = (JSONObject)attrs.opt("cell");
                    if (props == null || props.length() <= 0) continue;
                    propsElement = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.TableCellProperties);
                    JsonOperationConsumer.mapCellProperties(props, (StyleTableCellPropertiesElement)propsElement);
                    continue;
                }
                if (type.equals("column") && attrs.has("column") && !attrs.get("column").equals(JSONObject.NULL)) {
                    props = (JSONObject)attrs.opt("column");
                    if (props == null || props.length() <= 0) continue;
                    propsElement = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.TableColumnProperties);
                    JsonOperationConsumer.mapColumnProperties(props, (StyleTableColumnPropertiesElement)propsElement);
                    continue;
                }
                if (type.equals("list") && attrs.has("list") && !attrs.get("list").equals(JSONObject.NULL)) {
                    props = (JSONObject)attrs.opt("list");
                    if (props == null || props.length() <= 0) continue;
                    propsElement = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.ListLevelProperties);
                    JsonOperationConsumer.mapListProperties(props, (StyleListLevelPropertiesElement)propsElement);
                    continue;
                }
                if (type.equals("section") && attrs.has("section") && !attrs.get("section").equals(JSONObject.NULL)) {
                    props = (JSONObject)attrs.opt("section");
                    if (props == null || props.length() <= 0) continue;
                    propsElement = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.SectionProperties);
                    JsonOperationConsumer.mapSectionProperties(props, (StyleSectionPropertiesElement)propsElement);
                    continue;
                }
                if (type.equals("drawing") || type.equals("presentation")) {
                    if (!attrs.has("drawing") && !attrs.has("shape") && !attrs.has("line") && !attrs.has("fill")) continue;
                    JSONObject allDrawingProperties = new JSONObject();
                    try {
                        String[] subs;
                        for (String sub : subs = new String[]{"shape", "drawing"}) {
                            if (!attrs.has(sub)) continue;
                            JSONObject subAttrs = attrs.getJSONObject(sub);
                            Iterator keyIt = subAttrs.keys();
                            while (keyIt.hasNext()) {
                                String key = (String)keyIt.next();
                                allDrawingProperties.put(key, subAttrs.get(key));
                            }
                        }
                        if (attrs.has("fill")) {
                            allDrawingProperties.put("fill", (Object)attrs.getJSONObject("fill"));
                        }
                        if (attrs.has("line")) {
                            allDrawingProperties.put("line", (Object)attrs.getJSONObject("line"));
                        }
                    }
                    catch (JSONException subs) {
                        // empty catch block
                    }
                    if (allDrawingProperties.length() <= 0) continue;
                    OdfStyleBase parentStyle = style.getParentStyle();
                    OdfStylePropertiesBase propsElement3 = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.GraphicProperties);
                    JsonOperationConsumer.mapGraphicProperties(allDrawingProperties, (StyleGraphicPropertiesElement)propsElement3, parentStyle);
                    continue;
                }
                if (type.equals("chart") || type.equals("chart")) {
                    props = (JSONObject)attrs.opt("chart");
                    if (props == null || props.length() <= 0) continue;
                    propsElement = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.ChartProperties);
                    JsonOperationConsumer.mapChartProperties(props, (StyleChartPropertiesElement)propsElement);
                    continue;
                }
                if (type.equals("page") || type.equals("page")) {
                    props = (JSONObject)attrs.opt("page");
                    if (props == null || props.length() <= 0) continue;
                    propsElement = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.PageLayoutProperties);
                    JsonOperationConsumer.mapPageProperties(props, (StylePageLayoutPropertiesElement)propsElement);
                    continue;
                }
                if (type.equals("ruby") || type.equals("ruby")) {
                    props = (JSONObject)attrs.opt("ruby");
                    if (props == null || props.length() <= 0) continue;
                    propsElement = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.RubyProperties);
                    JsonOperationConsumer.mapRubyProperties(props, (StyleRubyPropertiesElement)propsElement);
                    continue;
                }
                if (!type.equals("headerFooter") && !type.equals("headerFooter") || (props = (JSONObject)attrs.opt("headerFooter")) == null || props.length() <= 0) continue;
                propsElement = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.HeaderFooterProperties);
                JsonOperationConsumer.mapHeaderFooterProperties(props, (StyleHeaderFooterPropertiesElement)propsElement);
            }
        }
    }

    public static void mapCharacterProperties(JSONObject attrs, StyleTextPropertiesElement propertiesElement, OdfDocument doc) {
        if (attrs != null) {
            Object language = null;
            Object noProof = null;
            for (String key : attrs.keySet()) {
                String fontName;
                JSONObject color;
                Boolean isItalic;
                Boolean isBold;
                Object value = attrs.get(key);
                if (key.equals("bold")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "font-weight");
                        continue;
                    }
                    isBold = (Boolean)value;
                    if (isBold.booleanValue()) {
                        propertiesElement.setFoFontWeightAttribute("bold");
                        continue;
                    }
                    propertiesElement.setFoFontWeightAttribute("normal");
                    continue;
                }
                if (key.equals("boldAsian")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "font-weight-asian");
                        continue;
                    }
                    isBold = (Boolean)value;
                    if (isBold.booleanValue()) {
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-weight-asian", "bold");
                        continue;
                    }
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-weight-asian", "normal");
                    continue;
                }
                if (key.equals("boldComplex")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "font-weight-complex");
                        continue;
                    }
                    isBold = (Boolean)value;
                    if (isBold.booleanValue()) {
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-weight-complex", "bold");
                        continue;
                    }
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-weight-complex", "normal");
                    continue;
                }
                if (key.equals("underline")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "text-underline-style");
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "text-underline-width");
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "text-underline-color");
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "text-underline-type");
                        continue;
                    }
                    Boolean isUnderline = (Boolean)value;
                    if (isUnderline.booleanValue()) {
                        propertiesElement.setStyleTextUnderlineStyleAttribute("solid");
                        continue;
                    }
                    propertiesElement.setStyleTextUnderlineStyleAttribute("none");
                    continue;
                }
                if (key.equals("italic")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "font-style");
                        continue;
                    }
                    isItalic = (Boolean)value;
                    if (isItalic.booleanValue()) {
                        propertiesElement.setFoFontStyleAttribute("italic");
                        continue;
                    }
                    propertiesElement.setFoFontStyleAttribute("normal");
                    continue;
                }
                if (key.equals("italicAsian")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "font-style-asian");
                        continue;
                    }
                    isItalic = (Boolean)value;
                    if (isItalic.booleanValue()) {
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-style-asian", "italic");
                        continue;
                    }
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-style-asian", "normal");
                    continue;
                }
                if (key.equals("italicComplex")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "font-style-complex");
                        continue;
                    }
                    isItalic = (Boolean)value;
                    if (isItalic.booleanValue()) {
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-style-complex", "italic");
                        continue;
                    }
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-style-complex", "normal");
                    continue;
                }
                if (key.equals("color")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "color");
                        continue;
                    }
                    color = (JSONObject)value;
                    if (color.has("type") && !color.get("type").equals(JSONObject.NULL)) {
                        String type = color.optString("type", "");
                        if (!type.equals("auto")) {
                            propertiesElement.setFoColorAttribute(JsonOperationConsumer.getColor(color, null));
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "use-window-font-color");
                            continue;
                        }
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:use-window-font-color", "true");
                        continue;
                    }
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:use-window-font-color", "true");
                    continue;
                }
                if (key.equals("fillColor")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "background-color");
                        continue;
                    }
                    color = (JSONObject)value;
                    propertiesElement.setFoBackgroundColorAttribute(JsonOperationConsumer.getColor(color, "transparent"));
                    continue;
                }
                if (key.equals("fontSize")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "font-size");
                        continue;
                    }
                    propertiesElement.setFoFontSizeAttribute(String.valueOf(value) + "pt");
                    continue;
                }
                if (key.equals("fontSizeAsian")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "font-size-asian");
                        continue;
                    }
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-size-asian", String.valueOf(value) + "pt");
                    continue;
                }
                if (key.equals("fontSizeComplex")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "font-size-complex");
                        continue;
                    }
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-size-complex", String.valueOf(value) + "pt");
                    continue;
                }
                if (key.equals("fontName")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "font-name");
                        continue;
                    }
                    fontName = (String)value;
                    propertiesElement.setStyleFontNameAttribute(fontName);
                    JsonOperationConsumer.addFontToDocument(fontName, doc);
                    continue;
                }
                if (key.equals("fontNameAsian")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "font-name-asian");
                        continue;
                    }
                    fontName = (String)value;
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-name-asian", fontName);
                    continue;
                }
                if (key.equals("fontNameComplex")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "font-name-complex");
                        continue;
                    }
                    fontName = (String)value;
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-name-complex", fontName);
                    continue;
                }
                if (key.equals("vertAlign")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "text-position");
                        continue;
                    }
                    String alignment = (String)value;
                    if (alignment.equals("sub")) {
                        propertiesElement.setStyleTextPositionAttribute("sub");
                        continue;
                    }
                    if (alignment.equals("super")) {
                        propertiesElement.setStyleTextPositionAttribute("super");
                        continue;
                    }
                    propertiesElement.setStyleTextPositionAttribute("0% 100%");
                    continue;
                }
                if (key.equals("strike")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "text-position");
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "text-line-through-color");
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "text-line-through-mode");
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "text-line-through-style");
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "text-line-through-text");
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "text-line-through-text-style");
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "text-line-through-type");
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "text-line-through-width");
                        continue;
                    }
                    String strikeType = (String)value;
                    if (strikeType.equals("single")) {
                        propertiesElement.setStyleTextLineThroughTypeAttribute("single");
                        propertiesElement.setStyleTextLineThroughStyleAttribute("solid");
                        propertiesElement.setStyleTextLineThroughModeAttribute("continuous");
                        propertiesElement.setStyleTextUnderlineModeAttribute("continuous");
                        propertiesElement.setStyleTextOverlineModeAttribute("continuous");
                        continue;
                    }
                    if (strikeType.equals("none")) continue;
                    propertiesElement.setStyleTextLineThroughTypeAttribute("double");
                    propertiesElement.setStyleTextLineThroughStyleAttribute("solid");
                    propertiesElement.setStyleTextLineThroughModeAttribute("continuous");
                    propertiesElement.setStyleTextUnderlineModeAttribute("continuous");
                    propertiesElement.setStyleTextOverlineModeAttribute("continuous");
                    continue;
                }
                if (key.equals("language")) {
                    language = value;
                    continue;
                }
                if (key.equals("noProof")) {
                    noProof = value;
                    continue;
                }
                if (key.equals("letterSpacing")) {
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "letter-spacing");
                        continue;
                    }
                    if (value.equals("normal")) {
                        propertiesElement.setFoLetterSpacingAttribute("normal");
                        continue;
                    }
                    propertiesElement.setFoLetterSpacingAttribute((double)JsonOperationConsumer.getSafelyInteger(value) / 100.0 + "mm");
                    continue;
                }
                if (!key.equals("url")) continue;
                if (value == null || value.equals(JSONObject.NULL)) {
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "href");
                    continue;
                }
                propertiesElement.setAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "xlink:href", (String)value);
            }
            if (noProof != null || language != null) {
                Object newLanguage = language;
                if (noProof instanceof Boolean && ((Boolean)noProof).booleanValue() || language instanceof String && ((String)language).equals("none")) {
                    propertiesElement.setFoLanguageAttribute("zxx");
                    propertiesElement.setStyleLanguageAsianAttribute("zxx");
                    propertiesElement.setStyleCountryComplexAttribute("zxx");
                    propertiesElement.setFoCountryAttribute("none");
                    propertiesElement.setStyleCountryAsianAttribute("none");
                    propertiesElement.setStyleCountryComplexAttribute("none");
                } else if (newLanguage == null || newLanguage.equals(JSONObject.NULL)) {
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "country");
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "language");
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "country-asian");
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "language-asian");
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "country-complex");
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "language-complex");
                } else {
                    String locale = (String)newLanguage;
                    if (!locale.isEmpty()) {
                        int delimiterPos = locale.indexOf(45);
                        if (delimiterPos > -1) {
                            propertiesElement.setFoLanguageAttribute(locale.substring(0, delimiterPos));
                            propertiesElement.setFoCountryAttribute(locale.substring(delimiterPos + 1, locale.length()));
                        } else {
                            propertiesElement.setFoLanguageAttribute(locale);
                        }
                    }
                }
            }
        }
    }

    private static void addFontToDocument(String fontName, OdfDocument doc) {
        if (doc != null) {
            Set<String> fontNames = doc.getFontNames();
            if (fontName != null && !fontName.isEmpty() && !fontNames.contains(fontName)) {
                fontNames.add(fontName);
                if (fontName.equals("Andale Mono")) {
                    JsonOperationConsumer.addFontData(doc, "Andale Mono", null, "Andale Mono", null, null, null);
                } else if (fontName.equals("Arial")) {
                    JsonOperationConsumer.addFontData(doc, "Arial", null, "Arial", "swiss", "variable", null);
                } else if (fontName.equals("Book Antiqua")) {
                    JsonOperationConsumer.addFontData(doc, "Book Antiqua", null, "Book Antiqua", "roman", "variable", null);
                } else if (fontName.equals("Calibri")) {
                    JsonOperationConsumer.addFontData(doc, "Calibri", null, "Calibri", "swiss", "variable", "2 15 5 2 2 2 4 3 2 4");
                } else if (fontName.equals("Cambria")) {
                    JsonOperationConsumer.addFontData(doc, "Cambria", null, "Cambria", "roman", "variable", "2 4 5 3 5 4 6 3 2 4");
                } else if (fontName.equals("Consolas")) {
                    JsonOperationConsumer.addFontData(doc, "Consolas", null, "Consolas", "modern", "fixed", null);
                } else if (fontName.equals("Courier New")) {
                    JsonOperationConsumer.addFontData(doc, "Courier New", null, "Courier New", "modern", "fixed", null);
                } else if (fontName.equals("Courier")) {
                    JsonOperationConsumer.addFontData(doc, "Courier", null, "Courier", "modern", "fixed", null);
                } else if (fontName.equals("Georgia")) {
                    JsonOperationConsumer.addFontData(doc, "Georgia", null, "Georgia", "roman", "variable", null);
                } else if (fontName.equals("Helvetica")) {
                    JsonOperationConsumer.addFontData(doc, "Helvetica", null, "Helvetica", "swiss", null, null);
                } else if (fontName.equals("Impact")) {
                    JsonOperationConsumer.addFontData(doc, "Impact", null, "Impact", "swiss", "variable", null);
                } else if (fontName.equals("Mangal")) {
                    JsonOperationConsumer.addFontData(doc, "Mangal", null, "Mangal", "system", "variable", null);
                } else if (fontName.equals("Mangal1")) {
                    JsonOperationConsumer.addFontData(doc, "Mangal1", null, "Mangal", null, null, null);
                } else if (fontName.equals("Microsoft YaHei")) {
                    JsonOperationConsumer.addFontData(doc, "Microsoft YaHei", null, "Microsoft YaHei", "system", "variable", null);
                } else if (fontName.equals("MS Gothic")) {
                    JsonOperationConsumer.addFontData(doc, "MS Gothic", null, "MS Gothic", "modern", "fixed", "2 11 6 9 7 2 5 8 2 4");
                } else if (fontName.equals("MS Mincho")) {
                    JsonOperationConsumer.addFontData(doc, "MS Mincho", null, "MS Mincho", "modern", "fixed", "2 2 6 9 4 2 5 8 3 4");
                } else if (fontName.equals("Palatino")) {
                    JsonOperationConsumer.addFontData(doc, "Palatino", null, "Palatino", "roman", null, null);
                } else if (fontName.equals("SimSun")) {
                    JsonOperationConsumer.addFontData(doc, "SimSun", null, "SimSun", "system", "variable", null);
                } else if (fontName.equals("Tahoma")) {
                    JsonOperationConsumer.addFontData(doc, "Tahoma", null, "Tahoma", "swiss", "variable", null);
                } else if (fontName.equals("Times New Roman")) {
                    JsonOperationConsumer.addFontData(doc, "Times New Roman", null, "Times New Roman", "roman", "variable", "2 2 6 3 5 4 5 2 3 4");
                } else if (fontName.equals("Times")) {
                    JsonOperationConsumer.addFontData(doc, "Times", null, "Times", "roman", null, null);
                } else if (fontName.equals("Verdana")) {
                    JsonOperationConsumer.addFontData(doc, "Verdana", null, "Verdana", "swiss", "variable", null);
                }
            }
        }
    }

    public static void mapParagraphProperties(JSONObject attrs, StyleParagraphPropertiesElement propertiesElement) {
        if (attrs != null) {
            Set propKeys = attrs.keySet();
            for (String key : propKeys) {
                Object value;
                JsonOperationConsumer.addBorderProperties(key, attrs, propertiesElement, null);
                JsonOperationConsumer.addPaddingProperties(key, attrs, propertiesElement);
                JsonOperationConsumer.addMarginProperties(key, attrs, propertiesElement);
                if (key.equals("fillColor")) {
                    try {
                        value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "background-color");
                            continue;
                        }
                        JSONObject color = (JSONObject)value;
                        propertiesElement.setFoBackgroundColorAttribute(JsonOperationConsumer.getColor(color, "transparent"));
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("lineHeight")) {
                    try {
                        value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "line-height");
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "line-height-at-least");
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "line-spacing");
                            continue;
                        }
                        JSONObject lineHeight = (JSONObject)value;
                        JsonOperationConsumer.setLineHeight(lineHeight, propertiesElement);
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("alignment")) {
                    try {
                        value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "text-align");
                            continue;
                        }
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:text-align", (String)value);
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("indentFirstLine")) {
                    try {
                        value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "text-indent");
                            continue;
                        }
                        int indent = JsonOperationConsumer.getSafelyInteger(value);
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:text-indent", (double)indent / 100.0 + "mm");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("pageBreakBefore")) {
                    try {
                        value = attrs.get(key);
                        if (value != JSONObject.NULL && value.equals(Boolean.TRUE)) {
                            propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:break-before", "page");
                        } else {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "break-before");
                        }
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "break-after");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("pageBreakAfter")) {
                    try {
                        value = attrs.get(key);
                        if (value != JSONObject.NULL && value.equals(Boolean.TRUE)) {
                            propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:break-after", "page");
                        } else {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "break-after");
                        }
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "break-before");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (!key.equals("tabStops")) continue;
                try {
                    value = attrs.get(key);
                    StyleTabStopsElement tabsElement = OdfElement.findFirstChildNode(StyleTabStopsElement.class, (Node)((Object)propertiesElement));
                    if (tabsElement != null) {
                        propertiesElement.removeChild((Node)((Object)tabsElement));
                    }
                    if (value == null || value.equals(JSONObject.NULL)) continue;
                    JSONArray tabsValue = (JSONArray)value;
                    OdfFileDom fileDom = (OdfFileDom)((Object)propertiesElement.getOwnerDocument());
                    tabsElement = new StyleTabStopsElement(fileDom);
                    for (int idx = 0; idx < tabsValue.length(); ++idx) {
                        JSONObject tab = tabsValue.getJSONObject(idx);
                        StyleTabStopElement tabElement = new StyleTabStopElement(fileDom);
                        if (tab.has("pos")) {
                            int tabPos = tab.getInt("pos");
                            tabElement.setStylePositionAttribute((float)tabPos / 1000.0f + "cm");
                        }
                        if (tab.has("value")) {
                            String tabValue = tab.getString("value");
                            if (tabValue.equals("decimal")) {
                                tabValue = "char";
                            } else if (tabValue.equals("bar")) {
                                tabValue = "left";
                            } else if (tabValue.equals("clear")) continue;
                            tabElement.setStyleTypeAttribute(tabValue);
                        }
                        tabsElement.insertBefore((Node)((Object)tabElement), null);
                    }
                    propertiesElement.insertBefore((Node)((Object)tabsElement), null);
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void mapTableProperties(JSONObject attrs, StyleTablePropertiesElement propertiesElement) {
        if (attrs != null) {
            Set propKeys = attrs.keySet();
            boolean isTableWidthGiven = false;
            for (String key : propKeys) {
                Object value;
                JsonOperationConsumer.addMarginProperties(key, attrs, propertiesElement);
                if (key.equals("width")) {
                    value = null;
                    try {
                        value = attrs.get(key);
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "width");
                        continue;
                    }
                    Object width = value;
                    if (width == null || width.equals("auto")) continue;
                    isTableWidthGiven = true;
                    if (width instanceof Integer) {
                        propertiesElement.setStyleWidthAttribute((double)((Integer)width).intValue() / 1000.0 + "cm");
                    } else if (width instanceof String) {
                        propertiesElement.setStyleWidthAttribute((double)Integer.parseInt((String)width) / 1000.0 + "cm");
                    }
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "rel-width");
                    if (propertiesElement.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "align") && !propertiesElement.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "align").equalsIgnoreCase("margins")) continue;
                    propertiesElement.setTableAlignAttribute("left");
                    continue;
                }
                if (key.equals("fillColor")) {
                    try {
                        value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "background-color");
                            continue;
                        }
                        JSONObject color = (JSONObject)value;
                        propertiesElement.setFoBackgroundColorAttribute(JsonOperationConsumer.getColor(color, "transparent"));
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (!key.equals("visible")) continue;
                try {
                    value = attrs.get(key);
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "display");
                        continue;
                    }
                    propertiesElement.setTableDisplayAttribute((Boolean)value);
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
            if (!isTableWidthGiven) {
                propertiesElement.setStyleRelWidthAttribute(HUNDRED_PERCENT);
            }
        } else if (propertiesElement != null) {
            propertiesElement.setStyleRelWidthAttribute(HUNDRED_PERCENT);
        }
    }

    public static void mapPageProperties(JSONObject attrs, StylePageLayoutPropertiesElement propertiesElement) {
        if (attrs != null) {
            Set propKeys = attrs.keySet();
            for (String key : propKeys) {
                JsonOperationConsumer.addBorderProperties(key, attrs, propertiesElement, null);
                JsonOperationConsumer.addPaddingProperties(key, attrs, propertiesElement);
                JsonOperationConsumer.addMarginProperties(key, attrs, propertiesElement);
                if (!key.equals("fillColor")) continue;
                try {
                    Object value = attrs.get(key);
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "background-color");
                        continue;
                    }
                    JSONObject color = (JSONObject)value;
                    propertiesElement.setFoBackgroundColorAttribute(JsonOperationConsumer.getColor(color, "transparent"));
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void mapRowProperties(JSONObject attrs, StyleTableRowPropertiesElement propertiesElement) {
        if (attrs != null) {
            Set propKeys = attrs.keySet();
            for (String key : propKeys) {
                Object value;
                if (key.equals("fillColor")) {
                    try {
                        value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "background-color");
                            continue;
                        }
                        JSONObject color = (JSONObject)value;
                        propertiesElement.setFoBackgroundColorAttribute(JsonOperationConsumer.getColor(color, "transparent"));
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("height")) {
                    try {
                        value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "row-height");
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "min-row-height");
                            continue;
                        }
                        int rowHeight = JsonOperationConsumer.getSafelyInteger(value);
                        propertiesElement.setStyleRowHeightAttribute((double)rowHeight / 100.0 + "mm");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (!key.equals("customHeight")) continue;
                try {
                    value = attrs.get(key);
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "use-optimal-row-height");
                        continue;
                    }
                    propertiesElement.setStyleUseOptimalRowHeightAttribute((Boolean)value == false);
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void mapCellProperties(JSONObject attrs, StyleTableCellPropertiesElement propertiesElement) {
        if (attrs != null) {
            Set propKeys = attrs.keySet();
            for (String key : propKeys) {
                Object value;
                JsonOperationConsumer.addBorderProperties(key, attrs, propertiesElement, null);
                JsonOperationConsumer.addPaddingProperties(key, attrs, propertiesElement);
                if (key.equals("fillColor")) {
                    try {
                        value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "background-color");
                            continue;
                        }
                        JSONObject color = (JSONObject)value;
                        propertiesElement.setFoBackgroundColorAttribute(JsonOperationConsumer.getColor(color, "transparent"));
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (!key.equals("alignVert")) continue;
                try {
                    value = attrs.get(key);
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "vertical-align");
                        continue;
                    }
                    String align = (String)value;
                    propertiesElement.setStyleVerticalAlignAttribute(align);
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void mapColumnProperties(JSONObject attrs, StyleTableColumnPropertiesElement propertiesElement) {
        if (attrs != null) {
            Set propKeys = attrs.keySet();
            for (String key : propKeys) {
                Object value;
                if (key.equals("width")) {
                    try {
                        value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "column-width");
                            continue;
                        }
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:column-width", (double)JsonOperationConsumer.getSafelyInteger(value) / 100.0 + "mm");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (!key.equals("customWidth")) continue;
                try {
                    value = attrs.get(key);
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "use-optimal-column-width");
                        continue;
                    }
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:use-optimal-column-width", value.toString());
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void mapListProperties(JSONObject attrs, StyleListLevelPropertiesElement propertiesElement) {
        if (attrs != null) {
            Set propKeys = attrs.keySet();
            for (String key : propKeys) {
                String fontName;
                Object value;
                if (key.equals("fontName")) {
                    try {
                        value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "font-name");
                            continue;
                        }
                        fontName = (String)value;
                        propertiesElement.setStyleFontNameAttribute(fontName);
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("fontNameAsian")) {
                    try {
                        value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "font-name-asian");
                            continue;
                        }
                        fontName = (String)value;
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-name-asian", fontName);
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (!key.equals("fontNameComplex")) continue;
                try {
                    value = attrs.get(key);
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "font-name-complex");
                        continue;
                    }
                    fontName = (String)value;
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:font-name-complex", fontName);
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void mapSectionProperties(JSONObject attrs, StyleSectionPropertiesElement propertiesElement) {
        if (attrs != null) {
            Set propKeys = attrs.keySet();
            for (String key : propKeys) {
                JsonOperationConsumer.addBorderProperties(key, attrs, propertiesElement, null);
                JsonOperationConsumer.addPaddingProperties(key, attrs, propertiesElement);
                if (!key.equals("fillColor")) continue;
                try {
                    Object value = attrs.get(key);
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "background-color");
                        continue;
                    }
                    JSONObject color = (JSONObject)value;
                    propertiesElement.setFoBackgroundColorAttribute(JsonOperationConsumer.getColor(color, "transparent"));
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void mapGraphicProperties(JSONObject attrs, StyleGraphicPropertiesElement propertiesElement, OdfStyleBase frameParentStyle) {
        if (attrs != null) {
            boolean isMirroredHorizontalRemoved = false;
            boolean isMirroredHorizontal = false;
            boolean isMirroredVerticalRemoved = false;
            boolean isMirroredVertical = false;
            Set propKeys = attrs.keySet();
            for (String key : propKeys) {
                String odfValue;
                HashMap<String, String> relMap;
                JsonOperationConsumer.addBorderProperties(key, attrs, propertiesElement, frameParentStyle);
                JsonOperationConsumer.addPaddingProperties(key, attrs, propertiesElement);
                JsonOperationConsumer.addMarginProperties(key, attrs, propertiesElement);
                if (key.equals("fill")) {
                    try {
                        boolean flyFrame;
                        JSONObject value = (JSONObject)attrs.get(key);
                        boolean bl = flyFrame = frameParentStyle != null && !(frameParentStyle instanceof OdfDefaultStyle);
                        if (value == null || value.equals(JSONObject.NULL) || value.has("type") && (value.isNull("type") || value.getString("type").equals("none"))) {
                            if (flyFrame) {
                                propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "background-color");
                                continue;
                            }
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "fill-color");
                            propertiesElement.setAttributeNS(OdfDocumentNamespace.DRAW.getUri(), "draw:fill", "none");
                            continue;
                        }
                        String colorAttr = null;
                        Object color = value.get("color");
                        colorAttr = color instanceof JSONObject ? JsonOperationConsumer.getColor((JSONObject)color, "transparent") : (String)color;
                        if (flyFrame) {
                            propertiesElement.setFoBackgroundColorAttribute(colorAttr);
                            continue;
                        }
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.DRAW.getUri(), "draw:fill-color", colorAttr);
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.DRAW.getUri(), "draw:fill", "solid");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("flipH")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            isMirroredHorizontalRemoved = true;
                            continue;
                        }
                        if (!((Boolean)value).booleanValue()) continue;
                        isMirroredHorizontal = true;
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("flipV")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            isMirroredVerticalRemoved = true;
                            continue;
                        }
                        if (!((Boolean)value).booleanValue()) continue;
                        isMirroredVertical = true;
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("anchorHorBase")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) continue;
                        String horBase = (String)value;
                        relMap = new HashMap<String, String>();
                        relMap.put("margin", "page-start-margin");
                        relMap.put("page", "page");
                        relMap.put("column", "paragraph");
                        relMap.put("character", "char");
                        relMap.put("leftMargin", "page-start-margin");
                        relMap.put("rightMargin", "page-end-margin");
                        relMap.put("insideMargin", "page-start-margin");
                        relMap.put("outsideMargin", "page-start-margin");
                        odfValue = (String)relMap.get(horBase);
                        if (odfValue == null) continue;
                        propertiesElement.setStyleHorizontalRelAttribute(odfValue);
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("anchorVertBase")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) continue;
                        String horBase = (String)value;
                        relMap = new HashMap();
                        relMap.put("margin", "page-content");
                        relMap.put("page", "page");
                        relMap.put("paragraph", "paragraph");
                        relMap.put("line", "line");
                        relMap.put("topMargin", "page-content");
                        relMap.put("bottomMargin", "page-content");
                        odfValue = (String)relMap.get(horBase);
                        if (odfValue == null) continue;
                        propertiesElement.setStyleVerticalRelAttribute(odfValue);
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("textWrapMode")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "wrap");
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "wrap-contour");
                            continue;
                        }
                        String textWrapMode = (String)value;
                        if (textWrapMode.equals("topAndBottom")) {
                            propertiesElement.setStyleWrapAttribute("none");
                            propertiesElement.setStyleWrapContourAttribute(false);
                            continue;
                        }
                        String textWrapSide = attrs.optString("textWrapSide");
                        if (textWrapSide == null) continue;
                        if (textWrapMode.equals("square")) {
                            if (textWrapSide.equals("largest")) {
                                propertiesElement.setStyleWrapAttribute("biggest");
                            } else if (textWrapSide.equals("left")) {
                                propertiesElement.setStyleWrapAttribute("left");
                            } else if (textWrapSide.equals("both")) {
                                propertiesElement.setStyleWrapAttribute("parallel");
                            } else if (textWrapSide.equals("right")) {
                                propertiesElement.setStyleWrapAttribute("right");
                            }
                            propertiesElement.setStyleWrapContourAttribute(false);
                            continue;
                        }
                        if (!textWrapMode.equals("through")) continue;
                        propertiesElement.setStyleWrapAttribute("run-through");
                        propertiesElement.setStyleWrapContourAttribute(false);
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("anchorHorAlign")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "horizontal-pos");
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "horizontal-rel");
                            continue;
                        }
                        String anchorHorAlign = (String)value;
                        if (anchorHorAlign.equals("center")) {
                            propertiesElement.setStyleHorizontalPosAttribute("center");
                            continue;
                        }
                        if (anchorHorAlign.equals("offset")) {
                            propertiesElement.setStyleHorizontalPosAttribute("from-left");
                            continue;
                        }
                        if (anchorHorAlign.equals("left")) {
                            propertiesElement.setStyleHorizontalPosAttribute("left");
                            continue;
                        }
                        if (anchorHorAlign.equals("right")) {
                            propertiesElement.setStyleHorizontalPosAttribute("right");
                            continue;
                        }
                        if (anchorHorAlign.equals("inside")) {
                            propertiesElement.setStyleHorizontalPosAttribute("inside");
                            continue;
                        }
                        if (!anchorHorAlign.equals("outside")) continue;
                        propertiesElement.setStyleHorizontalPosAttribute("outside");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("anchorHorOffset")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.SVG.getUri(), "x");
                            continue;
                        }
                        int x = JsonOperationConsumer.getSafelyInteger(value);
                        propertiesElement.setSvgXAttribute((double)x / 100.0 + "mm");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("anchorVertAlign")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "vertical-pos");
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "vertical-rel");
                            continue;
                        }
                        String anchorVertAlign = (String)value;
                        if (anchorVertAlign.equals("center")) {
                            propertiesElement.setStyleVerticalPosAttribute("center");
                            continue;
                        }
                        if (anchorVertAlign.equals("offset")) {
                            propertiesElement.setStyleVerticalPosAttribute("from-top");
                            continue;
                        }
                        if (anchorVertAlign.equals("bottom")) {
                            propertiesElement.setStyleVerticalPosAttribute("bottom");
                            continue;
                        }
                        if (anchorVertAlign.equals("top")) {
                            propertiesElement.setStyleVerticalPosAttribute("top");
                            continue;
                        }
                        if (anchorVertAlign.equals("inside")) {
                            propertiesElement.setStyleVerticalPosAttribute("inside");
                            continue;
                        }
                        if (!anchorVertAlign.equals("outside")) continue;
                        propertiesElement.setStyleVerticalPosAttribute("outside");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (key.equals("anchorVertOffset")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.SVG.getUri(), "y");
                            continue;
                        }
                        int y = JsonOperationConsumer.getSafelyInteger(value);
                        propertiesElement.setSvgYAttribute((double)y / 100.0 + "mm");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (!key.equals("anchorBehindDoc")) continue;
                boolean anchorBehindDoc = attrs.optBoolean(key, false);
                StyleRunThroughAttribute.Value attr = null;
                attr = anchorBehindDoc ? StyleRunThroughAttribute.Value.BACKGROUND : StyleRunThroughAttribute.Value.FOREGROUND;
                propertiesElement.setStyleRunThroughAttribute(attr.toString());
            }
            if (isMirroredHorizontalRemoved && isMirroredVerticalRemoved) {
                propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "mirror");
            } else if (isMirroredHorizontal && isMirroredVertical) {
                propertiesElement.setStyleMirrorAttribute("horizontal vertical");
            } else if (isMirroredVertical) {
                propertiesElement.setStyleMirrorAttribute("vertical");
            } else if (isMirroredHorizontal) {
                propertiesElement.setStyleMirrorAttribute("horizontal");
            }
        }
    }

    public static void mapChartProperties(JSONObject attrs, StyleChartPropertiesElement propertiesElement) {
    }

    public static void mapDrawingProperties(JSONObject attrs, StyleDrawingPagePropertiesElement propertiesElement) {
    }

    public static void mapRubyProperties(JSONObject attrs, StyleRubyPropertiesElement propertiesElement) {
    }

    public static void mapHeaderFooterProperties(JSONObject attrs, StyleHeaderFooterPropertiesElement propertiesElement) {
        if (attrs != null) {
            Set propKeys = attrs.keySet();
            for (String key : propKeys) {
                JsonOperationConsumer.addMarginProperties(key, attrs, propertiesElement);
                if (!key.equals("fillColor")) continue;
                try {
                    Object value = attrs.get(key);
                    if (value == null || value.equals(JSONObject.NULL)) {
                        propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "background-color");
                        continue;
                    }
                    JSONObject color = (JSONObject)value;
                    propertiesElement.setFoBackgroundColorAttribute(JsonOperationConsumer.getColor(color, "transparent"));
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private static String getBorder(JSONObject border) {
        String style = null;
        Object borderValue = "";
        if (border.has("style") && !border.get("style").equals(JSONObject.NULL)) {
            style = border.optString("style");
            if (style.equals("none")) {
                borderValue = "none";
            } else {
                if (border.has("width") && !border.get("width").equals(JSONObject.NULL)) {
                    double width = (double)border.optInt("width") / 100.0;
                    borderValue = width + "mm ";
                } else {
                    borderValue = "0.02mm ";
                }
                borderValue = border.has("style") && !border.get("style").equals(JSONObject.NULL) ? ((style = border.optString("style")).equals("single") ? ((String)borderValue).concat("solid ") : ((String)borderValue).concat(style + " ")) : ((String)borderValue).concat("solid ");
                if (border.has("color") && !border.get("color").equals(JSONObject.NULL)) {
                    JSONObject color = border.optJSONObject("color");
                    borderValue = ((String)borderValue).concat(JsonOperationConsumer.getColor(color, "#000000"));
                } else {
                    borderValue = ((String)borderValue).concat("#000000");
                }
            }
        }
        return borderValue;
    }

    private static void setLineHeight(JSONObject lineHeight, StyleParagraphPropertiesElement propertiesElement) {
        Object lineHeightValue = null;
        try {
            String type = lineHeight.getString("type");
            if (type.equals("percent")) {
                String value = lineHeight.optString("value");
                if (value != null && !value.isEmpty()) {
                    lineHeightValue = value.concat("%");
                    propertiesElement.setFoLineHeightAttribute((String)lineHeightValue);
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "line-height-at-least");
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "line-spacing");
                }
            } else if (type.equals("fixed")) {
                double value = (double)lineHeight.optInt("value") / 100.0;
                lineHeightValue = value + "mm";
                propertiesElement.setFoLineHeightAttribute((String)lineHeightValue);
                propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "line-height-at-least");
                propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "line-spacing");
            } else if (type.equals("atLeast")) {
                double value = (double)lineHeight.optInt("value") / 100.0;
                lineHeightValue = value + "mm";
                propertiesElement.setStyleLineHeightAtLeastAttribute((String)lineHeightValue);
                propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "line-height");
                propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "line-spacing");
            } else if (type.equals("leading")) {
                double value = (double)lineHeight.optInt("value") / 100.0;
                lineHeightValue = value + "mm";
                propertiesElement.setStyleLineSpacingAttribute((String)lineHeightValue);
                propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "line-height");
                propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "line-height-at-least");
            } else if (type.equals("normal")) {
                lineHeightValue = "normal";
                propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "line-height-at-least");
                propertiesElement.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "line-spacing");
            }
        }
        catch (JSONException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public static String getColor(JSONObject color, String autoColor) {
        Object colorValue = "";
        try {
            if (color != null) {
                String type = color.getString("type");
                if (type.equals("auto")) {
                    colorValue = autoColor;
                } else if (type.equals("rgb")) {
                    colorValue = "#" + color.getString("value");
                } else if (color.has("fallbackValue")) {
                    colorValue = "#" + color.getString("fallbackValue");
                } else {
                    LOG.warning("Unmappable color: " + String.valueOf(color));
                }
            }
        }
        catch (JSONException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return colorValue;
    }

    public static void addBorderProperties(String key, JSONObject attrs, OdfStylePropertiesBase propertiesElement, OdfStyleBase frameParentStyle) {
        JSONObject border;
        boolean putBorders = false;
        if (frameParentStyle != null && attrs.has("line") && !attrs.get("line").equals(JSONObject.NULL)) {
            try {
                boolean lineStyleIsNull;
                boolean useOneBorder;
                boolean isEmptyBorder = true;
                String allBorderString = propertiesElement.getAttribute("fo:border");
                String leftBorderString = propertiesElement.getAttribute("fo:border-left");
                String rightBorderString = propertiesElement.getAttribute("fo:border-right");
                String topBorderString = propertiesElement.getAttribute("fo:border-top");
                String bottomBorderString = propertiesElement.getAttribute("fo:border-bottom");
                boolean bl = useOneBorder = allBorderString.length() > 0;
                if (!useOneBorder) {
                    OdfStylePropertiesBase propsElement = frameParentStyle.getOrCreatePropertiesElement(OdfStylePropertiesSet.GraphicProperties);
                    String styleAllBorderString = propsElement.getAttribute("fo:border");
                    if (leftBorderString.length() == 0) {
                        leftBorderString = propsElement.getAttribute("fo:border-left");
                    }
                    if (rightBorderString.length() == 0) {
                        rightBorderString = propsElement.getAttribute("fo:border-right");
                    }
                    if (topBorderString.length() == 0) {
                        topBorderString = propsElement.getAttribute("fo:border-top");
                    }
                    if (bottomBorderString.length() == 0) {
                        bottomBorderString = propsElement.getAttribute("fo:border-bottom");
                    }
                    if (styleAllBorderString.length() > 0 && leftBorderString.length() == 0 && rightBorderString.length() == 0 && topBorderString.length() == 0 && bottomBorderString.length() == 0) {
                        allBorderString = styleAllBorderString;
                        useOneBorder = true;
                    } else {
                        useOneBorder = false;
                    }
                }
                JSONObject allBorder = MapHelper.createBorderMap(allBorderString);
                JSONObject oldLeftBorder = MapHelper.createBorderMap(leftBorderString);
                JSONObject oldRightBorder = MapHelper.createBorderMap(rightBorderString);
                JSONObject oldTopBorder = MapHelper.createBorderMap(topBorderString);
                JSONObject oldBottomBorder = MapHelper.createBorderMap(bottomBorderString);
                isEmptyBorder = useOneBorder ? !allBorder.has("width") || !allBorder.has("style") : !oldTopBorder.has("width") || !oldTopBorder.has("style");
                JSONObject line = attrs.getJSONObject("line");
                JSONObject lineColor = line.optJSONObject("color");
                boolean lineColorIsNull = line.has("color") && line.isNull("color");
                boolean lineTypeIsNull = line.has("type") && line.isNull("type");
                boolean lineWidthIsNull = line.has("width") && line.isNull("width");
                boolean bl2 = lineStyleIsNull = line.has("style") && line.isNull("style");
                if (lineStyleIsNull && lineTypeIsNull && lineWidthIsNull) {
                    putBorders = true;
                    useOneBorder = true;
                    for (String borderKey : allBorder.keySet()) {
                        allBorder.remove(borderKey);
                    }
                } else {
                    String lineType = line.optString("type");
                    String lineStyle = line.optString("style");
                    int width = line.optInt("width");
                    if (lineColor != null) {
                        if (useOneBorder) {
                            allBorder.put("color", (Object)lineColor);
                        } else {
                            oldLeftBorder.put("color", (Object)lineColor);
                            oldRightBorder.put("color", (Object)lineColor);
                            oldTopBorder.put("color", (Object)lineColor);
                            oldBottomBorder.put("color", (Object)lineColor);
                        }
                        putBorders = true;
                        if (isEmptyBorder) {
                            if (lineStyle.isEmpty()) {
                                lineStyle = "solid";
                            }
                            if (width == 0) {
                                width = 1;
                            }
                        }
                    } else if (lineColorIsNull) {
                        if (useOneBorder) {
                            allBorder.remove("color");
                        } else {
                            oldLeftBorder.remove("color");
                            oldRightBorder.remove("color");
                            oldTopBorder.remove("color");
                            oldBottomBorder.remove("color");
                        }
                        putBorders = true;
                    }
                    if (lineType != null && lineStyle != null && (lineStyle.length() > 0 || lineType.equals("none"))) {
                        String newStyle = lineStyle;
                        if (lineType.equals("none")) {
                            newStyle = "none";
                        } else if (lineStyle.equals("solid")) {
                            newStyle = "single";
                        }
                        if (useOneBorder) {
                            allBorder.put("style", (Object)newStyle);
                        } else {
                            oldLeftBorder.put("style", (Object)newStyle);
                            oldRightBorder.put("style", (Object)newStyle);
                            oldTopBorder.put("style", (Object)newStyle);
                            oldBottomBorder.put("style", (Object)newStyle);
                        }
                        if (isEmptyBorder && width == 0 && !newStyle.equals("none")) {
                            width = 1;
                        }
                        putBorders = true;
                    }
                    if (width > 0) {
                        if (useOneBorder) {
                            allBorder.put("width", width);
                        } else {
                            oldLeftBorder.put("width", width);
                            oldRightBorder.put("width", width);
                            oldTopBorder.put("width", width);
                            oldBottomBorder.put("width", width);
                        }
                        putBorders = true;
                    }
                }
                if (putBorders) {
                    JSONObject copyAttrs = new JSONObject((Object)attrs);
                    copyAttrs.put("borderLeft", (Object)(useOneBorder ? allBorder : oldLeftBorder));
                    copyAttrs.put("borderRight", (Object)(useOneBorder ? allBorder : oldRightBorder));
                    copyAttrs.put("borderTop", (Object)(useOneBorder ? allBorder : oldTopBorder));
                    copyAttrs.put("borderBottom", (Object)(useOneBorder ? allBorder : oldBottomBorder));
                    attrs = copyAttrs;
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "border");
                }
            }
            catch (JSONException isEmptyBorder) {
                // empty catch block
            }
        }
        if (putBorders || key.equals("borderLeft")) {
            try {
                Object value = attrs.get("borderLeft");
                if (value == null || value.equals(JSONObject.NULL)) {
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "border-left");
                } else {
                    border = (JSONObject)value;
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-left", JsonOperationConsumer.getBorder(border));
                    if (border.has("space") && !border.get("space").equals(JSONObject.NULL)) {
                        double padding = (double)border.optInt("space") / 100.0;
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:padding-left", padding + "mm");
                    }
                }
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        if (putBorders || key.equals("borderRight")) {
            try {
                Object value = attrs.get("borderRight");
                if (value == null || value.equals(JSONObject.NULL)) {
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "border-right");
                } else {
                    border = (JSONObject)value;
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-right", JsonOperationConsumer.getBorder(border));
                    if (border.has("space") && !border.get("space").equals(JSONObject.NULL)) {
                        double padding = (double)border.optInt("space") / 100.0;
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:padding-right", padding + "mm");
                    }
                }
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        if (putBorders || key.equals("borderTop")) {
            try {
                Object value = attrs.get("borderTop");
                if (value == null || value.equals(JSONObject.NULL)) {
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "border-top");
                } else {
                    border = (JSONObject)value;
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-top", JsonOperationConsumer.getBorder(border));
                    if (border.has("space") && !border.get("space").equals(JSONObject.NULL)) {
                        double padding = (double)border.optInt("space") / 100.0;
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:padding-top", padding + "mm");
                    }
                }
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        if (putBorders || key.equals("borderBottom")) {
            try {
                Object value = attrs.get("borderBottom");
                if (value == null || value.equals(JSONObject.NULL)) {
                    propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "border-bottom");
                } else {
                    border = (JSONObject)value;
                    propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-bottom", JsonOperationConsumer.getBorder(border));
                    if (border.has("space") && !border.get("space").equals(JSONObject.NULL)) {
                        double padding = (double)border.optInt("space") / 100.0;
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:padding-bottom", padding + "mm");
                    }
                }
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    private static void addMarginProperties(String key, JSONObject attrs, OdfStylePropertiesBase propertiesElement) {
        block21: {
            if (key.contains("margin") || key.contains("indent")) {
                if (key.equals("marginBottom")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "margin-bottom");
                            break block21;
                        }
                        int width = JsonOperationConsumer.getSafelyInteger(value);
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:margin-bottom", (double)width / 100.0 + "mm");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                } else if (key.equals("marginLeft") || key.equals("indentLeft")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "margin-left");
                            break block21;
                        }
                        int width = JsonOperationConsumer.getSafelyInteger(value);
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:margin-left", (double)width / 100.0 + "mm");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                } else if (key.equals("marginRight") || key.equals("indentRight")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "margin-right");
                            break block21;
                        }
                        int width = JsonOperationConsumer.getSafelyInteger(value);
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:margin-right", (double)width / 100.0 + "mm");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                } else if (key.equals("marginTop")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "margin-top");
                        } else {
                            int width = JsonOperationConsumer.getSafelyInteger(value);
                            propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:margin-top", (double)width / 100.0 + "mm");
                        }
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    public static void addPaddingProperties(String key, JSONObject attrs, OdfStylePropertiesBase propertiesElement) {
        block21: {
            if (key.contains("padding")) {
                if (key.equals("paddingBottom")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "padding-bottom");
                            break block21;
                        }
                        int width = JsonOperationConsumer.getSafelyInteger(value);
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:padding-bottom", (double)width / 100.0 + "mm");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                } else if (key.equals("paddingLeft")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "padding-left");
                            break block21;
                        }
                        int width = JsonOperationConsumer.getSafelyInteger(value);
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:padding-left", (double)width / 100.0 + "mm");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                } else if (key.equals("paddingRight")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "padding-right");
                            break block21;
                        }
                        int width = JsonOperationConsumer.getSafelyInteger(value);
                        propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:padding-right", (double)width / 100.0 + "mm");
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                } else if (key.equals("paddingTop")) {
                    try {
                        Object value = attrs.get(key);
                        if (value == null || value.equals(JSONObject.NULL)) {
                            propertiesElement.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "padding-top");
                        } else {
                            int width = JsonOperationConsumer.getSafelyInteger(value);
                            propertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:padding-top", (double)width / 100.0 + "mm");
                        }
                    }
                    catch (JSONException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    private static int getSafelyInteger(Object value) {
        int i;
        if (value instanceof Double) {
            i = (int)Math.round((Double)value);
            LOG.log(Level.SEVERE, "The value should be an Integer, not a Double: {0}", value);
        } else if (value instanceof Float) {
            i = Math.round(((Float)value).floatValue());
            LOG.log(Level.SEVERE, "The value should be an Integer, not a Float: {0}", value);
        } else {
            i = (Integer)value;
        }
        return i;
    }

    private static final JSONArray decrementAll(JSONArray position) {
        if (position != null) {
            for (int i = 0; i < position.length(); ++i) {
                position.put(i, (Integer)position.get(i) - 1);
            }
        }
        return position;
    }

    static {
        try {
            CELL_WITH_BORDER_ATTRS = new JSONObject("{\"cell\":{\"padding\":97,\"borderLeft\":{\"width\":2,\"style\":\"solid\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"}},\"borderBottom\":{\"width\":2,\"style\":\"solid\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"}},\"borderTop\":{\"width\":2,\"style\":\"solid\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"}},\"borderRight\":{\"width\":2,\"style\":\"solid\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"}}}}");
        }
        catch (JSONException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }
}

