/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.odftoolkit.odfdom.changes.JsonOperationConsumer;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.xml.sax.SAXException;

public class CollabTextDocument
implements Closeable {
    private static final Logger LOG = Logger.getLogger(CollabTextDocument.class.getName());
    static final String OPERATION_REVISON_FILE = "debug/revision.txt";
    static final String OPERATION_TEXT_FILE_PREFIX = "debug/operationUpdates_";
    static final String ORIGNAL_ODT_FILE = "debug/original.odt";
    private static final String OPERATION_DEBUG_OUTPUT_FILE = System.getProperty("java.io.tmpdir") + File.separatorChar + "odf-operations.txt";
    private OdfTextDocument mTextDocument;
    private OdfPackage mPackage;
    private Map<Long, byte[]> mResourceMap;
    private boolean mSaveDebugOperations;
    private int mMaxTableColumnCount;
    private int mMaxTableRowCount;
    private int mMaxTableCellCount;
    private int mMaxSheetCount;
    private boolean isMetadataUpdated = false;
    private int appliedChangesCount = 0;

    private CollabTextDocument() {
    }

    public OdfFileDom getOwnerDocument() throws SAXException, IOException {
        return this.getDocument().getContentDom();
    }

    public static CollabTextDocument newTextCollabDocument() throws Exception {
        CollabTextDocument odt = new CollabTextDocument();
        odt.mTextDocument = OdfTextDocument.newTextDocument(Boolean.TRUE);
        return odt;
    }

    public CollabTextDocument(InputStream inputStream) throws Exception {
        this.mTextDocument = OdfTextDocument.loadDocument(inputStream, Boolean.TRUE);
    }

    public CollabTextDocument(InputStream documentStream, Map<String, Object> configuration) throws Exception {
        this(documentStream, null, configuration);
    }

    public CollabTextDocument(InputStream inputStream, Map<Long, byte[]> resourceManager, Map<String, Object> configuration) throws Exception {
        this.mTextDocument = OdfTextDocument.loadDocument(inputStream, configuration, Boolean.TRUE);
        this.mPackage = this.getDocument().getPackage();
        this.mResourceMap = resourceManager;
        if (configuration != null) {
            if (configuration.containsKey("debugoperations")) {
                this.mSaveDebugOperations = (Boolean)configuration.get("debugoperations");
            }
            if (configuration.containsKey("maxTableColumns")) {
                this.mMaxTableColumnCount = (Integer)configuration.get("maxTableColumns");
            }
            if (configuration.containsKey("maxTableRows")) {
                this.mMaxTableRowCount = (Integer)configuration.get("maxTableRows");
            }
            if (configuration.containsKey("maxTableCells")) {
                this.mMaxTableCellCount = (Integer)configuration.get("maxTableCells");
            }
            if (configuration.containsKey("maxSheets")) {
                this.mMaxSheetCount = (Integer)configuration.get("maxSheets");
            }
        }
    }

    public JSONObject getDocumentAsChanges() throws SAXException, JSONException, IOException {
        JSONObject ops = this.mTextDocument.getOperations(this);
        if (ops != null && ops.length() > 0) {
            LOG.log(Level.FINE, "\n\n*** ALL OPERATIONS:\n{0}", ops);
        } else {
            LOG.log(Level.FINE, "\n\n*** ALL OPERATIONS:\nNo Operation have been extracted!");
        }
        return ops;
    }

    public int applyChanges(String operationString) throws Exception {
        JSONObject operations = new JSONObject(operationString);
        int operationsCount = this.applyChanges(operations);
        if (operationsCount > 0) {
            this.removeCachedView();
        }
        return operationsCount;
    }

    public int applyChanges(JSONObject operations) throws Exception {
        LOG.log(Level.FINE, "\n*** EDIT OPERATIONS:\n{0}", operations);
        JSONArray ops = operations.getJSONArray("changes");
        if (this.mSaveDebugOperations) {
            this.addOriginalOdfAsDebug();
            this.addOperationFileAsDebug(ops);
        }
        CollabTextDocument.saveLocalDebug(ops);
        int operationCount = JsonOperationConsumer.applyOperations(this, ops);
        if (operationCount > 0) {
            this.removeCachedView();
            if (!this.isMetadataUpdated) {
                this.mTextDocument.updateMetaData();
                this.isMetadataUpdated = true;
            }
        }
        return operationCount;
    }

    private static void saveLocalDebug(JSONArray ops) {
        String unitTest = System.getProperty("test");
        if (unitTest != null && unitTest.equals("org.odftoolkit.odfdom.component.MyLatestTest")) {
            CollabTextDocument.saveOperationAsDebugFile(ops, OPERATION_DEBUG_OUTPUT_FILE);
        }
    }

    private void removeCachedView() {
        if (this.mPackage == null) {
            this.mPackage = this.getDocument().getPackage();
        }
        this.mPackage.remove("Thumbnails/thumbnail.png");
    }

    private void addOriginalOdfAsDebug() throws SAXException {
        OdfPackage pkg = this.mTextDocument.getPackage();
        if (!pkg.contains(ORIGNAL_ODT_FILE)) {
            LOG.log(Level.FINE, "Adding original ODT document as debug within the zip at {0}", ORIGNAL_ODT_FILE);
            try {
                pkg.insert(pkg.getInputStream(), ORIGNAL_ODT_FILE, "application/vnd.oasis.opendocument.text");
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    private static void saveStringToFile(File file, String data) {
        CollabTextDocument.saveStringToFile(file, Charset.forName("UTF-8"), data);
    }

    private static void saveStringToFile(File file, Charset charset, String inputData) {
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));){
            out.write(inputData);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private static void saveOperationAsDebugFile(JSONArray operations, String debugFilePath) {
        if (debugFilePath != null && !debugFilePath.isEmpty()) {
            CollabTextDocument.saveStringToFile(new File(debugFilePath), operations.toString());
        }
    }

    private void addOperationFileAsDebug(JSONArray operations) {
        try {
            OdfPackage pkg = this.mTextDocument.getPackage();
            int revisionNo = 0;
            if (pkg.contains(OPERATION_REVISON_FILE)) {
                byte[] revisionByteArray = pkg.getBytes(OPERATION_REVISON_FILE);
                if (revisionByteArray != null && revisionByteArray.length != 0) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(revisionByteArray)));
                    String firstLine = reader.readLine();
                    revisionNo = Integer.parseInt(firstLine);
                    LOG.log(Level.FINE, "Found an existing revision number:{0}", revisionNo);
                }
            } else {
                LOG.log(Level.FINE, "Created a new revision number: 1");
            }
            pkg.insert(operations.toString().getBytes(), OPERATION_TEXT_FILE_PREFIX + ++revisionNo + ".txt", "text/plain");
            pkg.insert(Integer.toString(revisionNo).getBytes(), OPERATION_REVISON_FILE, "text/plain");
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public long getContentSize() {
        if (this.mPackage == null && this.mTextDocument != null) {
            this.mPackage = this.mTextDocument.getPackage();
        }
        if (this.mPackage != null) {
            return this.mPackage.getSize(OdfSchemaDocument.OdfXMLFile.CONTENT.getFileName());
        }
        return 0L;
    }

    public OdfTextDocument getDocument() {
        return this.mTextDocument;
    }

    public OdfPackage getPackage() {
        if (this.mPackage == null && this.mTextDocument != null) {
            this.mPackage = this.mTextDocument.getPackage();
        }
        return this.mPackage;
    }

    @Override
    public void close() {
        this.mTextDocument.close();
    }

    void setAppliedChangesCount(int opCount) {
        this.appliedChangesCount = opCount;
    }

    public int countAppliedChanges() {
        return this.appliedChangesCount;
    }

    public int getMaxTableColumnsCount() {
        return this.mMaxTableColumnCount;
    }

    public int getMaxTableRowsCount() {
        return this.mMaxTableRowCount;
    }

    public int getMaxTableCellCount() {
        return this.mMaxTableCellCount;
    }

    public int getMaxSheetCount() {
        return this.mMaxSheetCount;
    }

    public Map<Long, byte[]> getResourceMap() {
        if (this.mResourceMap != null) {
            return this.mResourceMap;
        }
        return null;
    }
}

