/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.number;

import org.odftoolkit.odfdom.dom.element.number.NumberTextContentElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMapElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class OdfNumberTextStyle
extends NumberTextStyleElement {
    private static final String BOOLEAN = "BOOLEAN";

    public OdfNumberTextStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfNumberTextStyle(OdfFileDom ownerDoc, String format, String styleName) {
        super(ownerDoc);
        this.setStyleNameAttribute(styleName);
        this.setFormat(format);
    }

    @Override
    public void setFormat(String format) {
        while (!format.isEmpty()) {
            int atPos = format.indexOf("@");
            if (atPos == 0) {
                this.newNumberTextContentElement();
            } else {
                NumberTextElement newSubElement = this.newNumberTextElement();
                newSubElement.setTextContent(atPos < 0 ? format : format.substring(0, atPos));
                if (atPos < 0) break;
                this.newNumberTextContentElement();
            }
            format = format.substring(atPos + 1);
        }
    }

    @Override
    public String getFormat(boolean caps) {
        Object mappedResult = "";
        Object result = "";
        for (Node m = this.getFirstChild(); m != null; m = m.getNextSibling()) {
            if (m instanceof NumberTextElement) {
                String textcontent = m.getTextContent();
                if (textcontent == null || textcontent.length() == 0) {
                    textcontent = " ";
                }
                result = (String)result + textcontent;
                continue;
            }
            if (m instanceof NumberTextContentElement) {
                result = (String)result + "@";
                continue;
            }
            if (!(m instanceof StyleMapElement)) continue;
            mappedResult = (String)mappedResult + this.getMapping((StyleMapElement)((Object)m));
            mappedResult = (String)mappedResult + ";";
        }
        if (!((String)mappedResult).isEmpty()) {
            result = (String)mappedResult + (String)result;
        }
        return result;
    }
}

