/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.pkg.OdfAlienAttribute;
import org.odftoolkit.odfdom.pkg.OdfAlienElement;
import org.odftoolkit.odfdom.pkg.OdfAttribute;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfNamespace;
import org.w3c.dom.DOMException;

public class OdfXMLFactory {
    private static Map<OdfName, Class> mElementTypes = new HashMap<OdfName, Class>();
    private static Map<OdfName, Class> mAttributeTypes = new HashMap<OdfName, Class>();
    private static Map<String, String> mElementRenames = new HashMap<String, String>();
    private static Set<String> mHandwrittenElementClasses = new HashSet<String>();
    private static final String LOCAL_NAME_DELIMITER = "-";
    private static final String ELEMENT_NAME_DELIMITER = ":";
    private static final String ELEMENT_PACKAGE_NAME = "element";
    private static final String ATTRIBUTE_PACKAGE_NAME = "attribute";

    private static Class getOdfAttributeClass(OdfName odfName) {
        return OdfXMLFactory.getOdfNodeClass(odfName, ATTRIBUTE_PACKAGE_NAME, mAttributeTypes);
    }

    private static Class getOdfElementClass(OdfName odfName) {
        return OdfXMLFactory.getOdfNodeClass(odfName, ELEMENT_PACKAGE_NAME, mElementTypes);
    }

    private static Class getOdfNodeClass(OdfName odfName, String nodeType, Map<OdfName, Class> classCache) {
        String prefix;
        Class<?> c = null;
        String className = "";
        c = classCache.get(odfName);
        if (!(c != null || (prefix = odfName.getPrefix()) == null || nodeType.equals(ATTRIBUTE_PACKAGE_NAME) && prefix.equals("xmlns"))) {
            String qName = odfName.getQName();
            String localName = odfName.getLocalName();
            if (mHandwrittenElementClasses.contains(qName)) {
                if (mElementRenames.containsKey(qName)) {
                    String renameName = mElementRenames.get(qName);
                    StringTokenizer stok = new StringTokenizer(renameName, ELEMENT_NAME_DELIMITER);
                    prefix = stok.nextToken();
                    localName = stok.nextToken();
                }
                className = OdfXMLFactory.getOdfIncubatorNodeClassName(prefix, localName);
            } else {
                className = "manifest".equals(prefix) ? OdfXMLFactory.getOdfPKGNodeClassName(prefix, localName, nodeType) : OdfXMLFactory.getOdfDOMNodeClassName(prefix, localName, nodeType);
            }
            try {
                c = Class.forName(className);
                classCache.put(odfName, c);
            }
            catch (ClassNotFoundException renameName) {
            }
            catch (NoClassDefFoundError dex) {
                Logger.getLogger(OdfXMLFactory.class.getName()).log(Level.FINER, "NoClassDefFoundError: " + className, dex.getMessage());
            }
        }
        return c;
    }

    private static String getOdfIncubatorNodeClassName(String prefix, String localName) {
        boolean contains = false;
        StringBuilder className = new StringBuilder();
        if (localName.indexOf(LOCAL_NAME_DELIMITER) != -1) {
            StringTokenizer stok = new StringTokenizer(localName, LOCAL_NAME_DELIMITER);
            while (stok.hasMoreElements()) {
                String substr = stok.nextToken();
                if (substr.equals(prefix)) {
                    contains = true;
                }
                className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(substr));
            }
        } else {
            className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(localName));
        }
        if (!(contains && !localName.endsWith("table") || localName.equals(prefix) || localName.startsWith(prefix) && prefix.equals("anim"))) {
            className = className.insert(0, OdfXMLFactory.toUpperCaseFirstCharacter(prefix));
        }
        className = className.insert(0, "org.odftoolkit.odfdom.incubator.doc." + prefix + ".Odf");
        return className.toString();
    }

    private static String getOdfPKGNodeClassName(String prefix, String localName, String nodeType) {
        StringBuilder className = new StringBuilder("org.odftoolkit.odfdom.pkg." + prefix + ".");
        if (localName.indexOf(LOCAL_NAME_DELIMITER) != -1) {
            StringTokenizer stok = new StringTokenizer(localName, LOCAL_NAME_DELIMITER);
            while (stok.hasMoreElements()) {
                className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(stok.nextToken()));
            }
        } else {
            className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(localName));
        }
        className.append(OdfXMLFactory.toUpperCaseFirstCharacter(nodeType));
        return className.toString();
    }

    private static String getOdfDOMNodeClassName(String prefix, String localName, String nodeType) {
        StringBuilder className = new StringBuilder("org.odftoolkit.odfdom.dom." + nodeType + "." + prefix + ".");
        className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(prefix));
        if (localName.indexOf(LOCAL_NAME_DELIMITER) != -1) {
            StringTokenizer stok = new StringTokenizer(localName, LOCAL_NAME_DELIMITER);
            while (stok.hasMoreElements()) {
                className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(stok.nextToken()));
            }
        } else {
            className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(localName));
        }
        className.append(OdfXMLFactory.toUpperCaseFirstCharacter(nodeType));
        return className.toString();
    }

    private static String toUpperCaseFirstCharacter(String token) {
        return token.substring(0, 1).toUpperCase() + token.substring(1);
    }

    public static OdfElement newOdfElement(OdfFileDom dom, OdfName name) throws DOMException {
        OdfElement element = null;
        Class elementClass = OdfXMLFactory.getOdfElementClass(name);
        if (elementClass != null) {
            element = (OdfElement)((Object)OdfXMLFactory.getNodeFromClass(dom, elementClass));
        } else {
            String oldPrefix = name.getPrefix();
            if (oldPrefix != null) {
                OdfName adaptedName = OdfXMLFactory.addNamespaceToDom(name, dom);
                String newPrefix = adaptedName.getPrefix();
                if (oldPrefix != null && !oldPrefix.equals(newPrefix) && newPrefix.indexOf("__") == -1) {
                    element = OdfXMLFactory.newOdfElement(dom, adaptedName);
                } else {
                    element = new OdfAlienElement(dom, adaptedName);
                    Logger.getLogger(OdfXMLFactory.class.getName()).log(Level.FINER, "None-ODF element created for {0}", adaptedName.getQName());
                }
            } else {
                element = new OdfAlienElement(dom, name);
                Logger.getLogger(OdfXMLFactory.class.getName()).log(Level.FINER, "None-ODF element created for {0}", name.getQName());
            }
        }
        return element;
    }

    public static OdfAttribute newOdfAttribute(OdfFileDom dom, OdfName name) throws DOMException {
        Object node;
        OdfAttribute attr = null;
        Class attributeClass = OdfXMLFactory.getOdfAttributeClass(name);
        if (attributeClass != null && (node = OdfXMLFactory.getNodeFromClass(dom, attributeClass)) instanceof OdfAttribute) {
            return (OdfAttribute)((Object)node);
        }
        String prefix = name.getPrefix();
        if (prefix != null && !prefix.equals("xmlns")) {
            OdfName adaptedName = OdfXMLFactory.addNamespaceToDom(name, dom);
            String newPrefix = adaptedName.getPrefix();
            if (!prefix.equals(newPrefix) && newPrefix.indexOf("__") == -1) {
                attr = OdfXMLFactory.newOdfAttribute(dom, adaptedName);
            } else {
                attr = new OdfAlienAttribute(dom, name);
                Logger.getLogger(OdfXMLFactory.class.getName()).log(Level.FINER, "None-ODF attribute created for {0}", adaptedName.getQName());
            }
        } else {
            attr = new OdfAlienAttribute(dom, name);
        }
        return attr;
    }

    private static OdfName addNamespaceToDom(OdfName name, OdfFileDom dom) {
        OdfNamespace newNS = dom.setNamespace(name.getPrefix(), name.getUri());
        return OdfName.newName(newNS, name.getLocalName());
    }

    static Object getNodeFromClass(OdfFileDom dom, Class nodeClass) {
        Object o = null;
        try {
            Constructor ctor = nodeClass.getConstructor(OdfFileDom.class);
            o = ctor.newInstance(dom);
        }
        catch (Exception cause) {
            throw new Error("ODF DOM error in attribute factory", cause);
        }
        return o;
    }

    static {
        mElementRenames.put("text:h", "text:heading");
        mElementRenames.put("text:p", "text:paragraph");
        mHandwrittenElementClasses.add("draw:frame");
        mHandwrittenElementClasses.add("draw:image");
        mHandwrittenElementClasses.add("number:currency-style");
        mHandwrittenElementClasses.add("number:date-style");
        mHandwrittenElementClasses.add("number:percentage-style");
        mHandwrittenElementClasses.add("number:number-style");
        mHandwrittenElementClasses.add("number:time-style");
        mHandwrittenElementClasses.add("style:default-style");
        mHandwrittenElementClasses.add("style:style");
        mHandwrittenElementClasses.add("style:page-layout");
        mHandwrittenElementClasses.add("text:h");
        mHandwrittenElementClasses.add("text:list");
        mHandwrittenElementClasses.add("text:list-level-style-bullet");
        mHandwrittenElementClasses.add("text:list-level-style-image");
        mHandwrittenElementClasses.add("text:list-level-style-number");
        mHandwrittenElementClasses.add("text:list-style");
        mHandwrittenElementClasses.add("text:outline-level-style");
        mHandwrittenElementClasses.add("text:outline-style");
        mHandwrittenElementClasses.add("text:p");
        mHandwrittenElementClasses.add("text:span");
    }
}

