/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.search;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.incubator.doc.text.OdfWhitespaceProcessor;
import org.odftoolkit.odfdom.incubator.search.Navigation;
import org.odftoolkit.odfdom.incubator.search.Selection;
import org.odftoolkit.odfdom.incubator.search.TextSelection;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextNavigation
extends Navigation {
    private static final String mMatchedElementName = "text:p,text:h";
    private final Pattern mPattern;
    private final OdfTextDocument mTextDocument;
    private TextSelection mCurrentSelectedItem;
    private String mCurrentText;
    private int mCurrentIndex;
    private boolean mbFinishFindInHeaderFooter;

    public TextNavigation(String pattern, OdfTextDocument doc) {
        this(Pattern.compile(pattern), doc);
    }

    public TextNavigation(Pattern pattern, OdfTextDocument doc) {
        this.mPattern = pattern;
        this.mTextDocument = doc;
        this.mCurrentSelectedItem = null;
        this.mbFinishFindInHeaderFooter = false;
    }

    private TextSelection findInHeaderFooter(TextSelection selected) {
        int nextIndex;
        OdfStylesDom styledom = null;
        OdfOfficeMasterStyles masterpage = null;
        OdfElement element = null;
        if (selected != null && (nextIndex = this.setCurrentTextAndGetIndex(selected)) != -1) {
            TextSelection item = new TextSelection(this.mCurrentText, selected.getContainerElement(), nextIndex);
            return item;
        }
        try {
            styledom = this.mTextDocument.getStylesDom();
            NodeList list = styledom.getElementsByTagName("office:master-styles");
            if (styledom == null) {
                return null;
            }
            if (list.getLength() <= 0) {
                return null;
            }
            masterpage = (OdfOfficeMasterStyles)((Object)list.item(0));
            element = selected == null ? (OdfElement)((Object)this.getNextMatchElementInTree((Node)((Object)masterpage), (Node)((Object)masterpage))) : (OdfElement)((Object)this.getNextMatchElementInTree((Node)((Object)selected.getContainerElement()), (Node)((Object)masterpage)));
            if (element != null) {
                TextSelection item = new TextSelection(this.mCurrentText, element, this.mCurrentIndex);
                return item;
            }
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(TextNavigation.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    private TextSelection findnext(TextSelection selected) {
        if (!this.mbFinishFindInHeaderFooter) {
            TextSelection styleselected = this.findInHeaderFooter(selected);
            if (styleselected != null) {
                return styleselected;
            }
            selected = null;
            this.mbFinishFindInHeaderFooter = true;
        }
        if (selected == null) {
            OdfElement element = null;
            try {
                element = (OdfElement)((Object)this.getNextMatchElement((Node)((Object)this.mTextDocument.getContentRoot())));
            }
            catch (Exception ex) {
                Logger.getLogger(TextNavigation.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
            if (element != null) {
                return new TextSelection(this.mCurrentText, element, this.mCurrentIndex);
            }
            return null;
        }
        OdfElement containerElement = selected.getContainerElement();
        int nextIndex = this.setCurrentTextAndGetIndex(selected);
        if (nextIndex != -1) {
            TextSelection item = new TextSelection(this.mCurrentText, containerElement, nextIndex);
            return item;
        }
        OdfElement element = (OdfElement)((Object)this.getNextMatchElement((Node)((Object)containerElement)));
        if (element != null) {
            TextSelection item = new TextSelection(this.mCurrentText, element, this.mCurrentIndex);
            return item;
        }
        return null;
    }

    private int setCurrentTextAndGetIndex(TextSelection selected) {
        int index = selected.getIndex();
        OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
        String content = textProcessor.getText((Node)((Object)selected.getContainerElement()));
        int nextIndex = -1;
        Matcher matcher = this.mPattern.matcher(content);
        if (matcher.find(index + selected.getText().length())) {
            nextIndex = matcher.start();
            int eIndex = matcher.end();
            this.mCurrentText = content.substring(nextIndex, eIndex);
        }
        return nextIndex;
    }

    @Override
    public Selection getCurrentItem() {
        Selection.SelectionManager.registerItem(this.mCurrentSelectedItem);
        return this.mCurrentSelectedItem;
    }

    @Override
    public boolean hasNext() {
        this.mCurrentSelectedItem = this.findnext(this.mCurrentSelectedItem);
        return this.mCurrentSelectedItem != null;
    }

    @Override
    public boolean match(Node element) {
        OdfWhitespaceProcessor textProcessor;
        String content;
        Matcher matcher;
        if (element instanceof OdfElement && mMatchedElementName.contains(element.getNodeName()) && (matcher = this.mPattern.matcher(content = (textProcessor = new OdfWhitespaceProcessor()).getText(element))).find()) {
            this.mCurrentIndex = matcher.start();
            int eIndex = matcher.end();
            this.mCurrentText = content.substring(this.mCurrentIndex, eIndex);
            return true;
        }
        return false;
    }
}

