/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.number;

import java.util.ArrayList;
import java.util.List;
import org.odftoolkit.odfdom.changes.MapHelper;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.number.NumberCurrencySymbolElement;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMapElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Node;

public abstract class DataStyleElement
extends OdfElement {
    DataStyleElement(OdfFileDom ownerDoc, OdfName elementName) {
        super(ownerDoc, elementName);
    }

    protected String getMapping(StyleMapElement mapElement) {
        Object mappedResult = "";
        String condition = mapElement.getStyleConditionAttribute();
        String applyStyleName = mapElement.getStyleApplyStyleNameAttribute();
        Node parent = this.getParentNode();
        if (applyStyleName != null) {
            DataStyleElement applyStyle = null;
            applyStyle = parent instanceof OdfOfficeStyles ? ((OdfOfficeStyles)((Object)parent)).getAllDataStyles().get(applyStyleName) : ((OdfOfficeAutomaticStyles)((Object)parent)).getAllDataStyles().get(applyStyleName);
            if (applyStyle != null) {
                String localFormat = applyStyle.getFormat(true);
                if (condition != null && condition.length() >= 9 && condition.startsWith("value()")) {
                    String operator2 = condition.substring(8, 9);
                    int opLength = 1;
                    if (operator2.equals("=") || operator2.equals("<") || operator2.equals(">")) {
                        opLength = 2;
                    }
                    try {
                        double opValue = Double.parseDouble(condition.substring(7 + opLength));
                        if (opValue != 0.0) {
                            mappedResult = (String)mappedResult + "[";
                            mappedResult = (String)mappedResult + condition.substring(7, 7 + opLength);
                            mappedResult = (String)mappedResult + Double.toString(opValue);
                            mappedResult = (String)mappedResult + "]";
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                mappedResult = (String)mappedResult + localFormat;
            }
        }
        return mappedResult;
    }

    public String getColorFromElement(StyleTextPropertiesElement e) {
        String ret = "";
        String color = e.getAttributeNS(OdfDocumentNamespace.FO.getUri(), "color");
        if (color != null) {
            if (color.equalsIgnoreCase("#0000ff")) {
                ret = "[BLUE]";
            } else if (color.equalsIgnoreCase("#00FF00")) {
                ret = "[GREEN]";
            } else if (color.equalsIgnoreCase("#FF0000")) {
                ret = "[RED]";
            } else if (color.equalsIgnoreCase("#FFFFFF")) {
                ret = "[WHITE]";
            } else if (color.equalsIgnoreCase("#FF00FF")) {
                ret = "[MAGENTA]";
            } else if (color.equalsIgnoreCase("#FFFF00")) {
                ret = "[YELLOW]";
            } else if (color.equalsIgnoreCase("#00FFFF")) {
                ret = "[CYAN]";
            } else if (color.equalsIgnoreCase("#000000")) {
                ret = "[BLACK]";
            }
        }
        return ret;
    }

    protected static String getColorElement(String colorToken) {
        String ret = "";
        if (colorToken.equalsIgnoreCase("RED")) {
            ret = "#ff0000";
        } else if (colorToken.equalsIgnoreCase("BLUE")) {
            ret = "#0000ff";
        } else if (colorToken.equalsIgnoreCase("GREEN")) {
            ret = "#00ff00";
        } else if (colorToken.equalsIgnoreCase("WHITE")) {
            ret = "#ffffff";
        } else if (colorToken.equalsIgnoreCase("MAGENTA")) {
            ret = "#ff00ff";
        } else if (colorToken.equalsIgnoreCase("YELLOW")) {
            ret = "#ffff00";
        } else if (colorToken.equalsIgnoreCase("CYAN")) {
            ret = "#00ffff";
        } else if (colorToken.equalsIgnoreCase("BLACK")) {
            ret = "#000000";
        }
        return ret;
    }

    protected static List<StringToken> tokenize(String format, NumberFormatType type) {
        ArrayList<StringToken> tokens = new ArrayList<StringToken>();
        boolean hasNumber = false;
        Object currentTextToken = "";
        block0: for (int pos = 0; pos < format.length(); ++pos) {
            char c = format.charAt(pos);
            if (c == '\"') {
                currentTextToken = (String)currentTextToken + c;
                while (pos < format.length() - 1) {
                    c = format.charAt(pos + 1);
                    if (c == '\\') {
                        currentTextToken = (String)currentTextToken + c;
                        if (pos > format.length() - 2) continue block0;
                        currentTextToken = (String)currentTextToken + c;
                        currentTextToken = (String)currentTextToken + format.charAt(pos + 2);
                        ++pos;
                    } else {
                        if (c == '\"') {
                            currentTextToken = (String)currentTextToken + c;
                            ++pos;
                            continue block0;
                        }
                        currentTextToken = (String)currentTextToken + c;
                    }
                    ++pos;
                }
                continue;
            }
            if (c == '[') {
                int closePos;
                if (!((String)currentTextToken).isEmpty()) {
                    tokens.add(new StringToken((String)currentTextToken, TokenType.TOKEN_TEXT));
                    currentTextToken = "";
                }
                if ((closePos = format.indexOf(93, pos)) < 0 || closePos < pos + 2) break;
                String bracketToken = format.substring(pos, closePos + 1);
                if (tokens.isEmpty() && !DataStyleElement.getColorElement(bracketToken.substring(1, bracketToken.length() - 1)).isEmpty()) {
                    tokens.add(new StringToken(bracketToken, TokenType.TOKEN_COLOR));
                } else {
                    if (bracketToken.charAt(1) != '$') break;
                    tokens.add(new StringToken(bracketToken, TokenType.TOKEN_CURRENCY));
                }
                pos = closePos;
                continue;
            }
            if (!(hasNumber || c != '#' && c != '0' && c != '.')) {
                if (!((String)currentTextToken).isEmpty()) {
                    tokens.add(new StringToken((String)currentTextToken, TokenType.TOKEN_TEXT));
                    currentTextToken = "";
                }
                int numPos = pos;
                while (++pos < format.length()) {
                    c = format.charAt(pos);
                    if ((c == '#' || c == '.' || c == ',' || c == '0') && pos != format.length() - 1) continue;
                    Object numberToken = format.substring(numPos, pos + 1);
                    if (((String)numberToken).charAt(((String)numberToken).length() - 1) == '.') {
                        int spacePos = format.indexOf(32, pos - 1);
                        int bracketPos = format.indexOf(91, pos - 1);
                        if (spacePos < 0) {
                            spacePos = bracketPos;
                        } else if (bracketPos < 0) {
                            bracketPos = spacePos;
                        }
                        spacePos = Math.min(spacePos, bracketPos);
                        if (spacePos < 0) {
                            spacePos = format.length();
                        }
                        if (spacePos > 0) {
                            numberToken = (String)numberToken + format.substring(pos, spacePos);
                            pos = spacePos;
                        }
                    }
                    tokens.add(new StringToken((String)numberToken, TokenType.TOKEN_NUMBER));
                    continue block0;
                }
                continue;
            }
            if (c == '\\') {
                currentTextToken = (String)currentTextToken + c;
                if (pos > format.length() - 2) break;
                currentTextToken = (String)currentTextToken + format.charAt(pos + 1);
                ++pos;
                continue;
            }
            currentTextToken = (String)currentTextToken + c;
        }
        if (!((String)currentTextToken).isEmpty()) {
            tokens.add(new StringToken((String)currentTextToken, TokenType.TOKEN_TEXT));
        }
        return tokens;
    }

    protected void emitTokens(List<StringToken> tokens, NumberFormatType type) {
        for (StringToken token : tokens) {
            switch (token.type) {
                case TOKEN_CURRENCY: {
                    if (NumberFormatType.FORMAT_CURRENCY == type) {
                        this.emitCurrency(token.text);
                        break;
                    }
                    this.emitText(token.text);
                    break;
                }
                case TOKEN_TEXT: {
                    this.emitText(token.text);
                    break;
                }
                case TOKEN_COLOR: {
                    this.emitColor(token.text);
                    break;
                }
                case TOKEN_NUMBER: {
                    if (NumberFormatType.FORMAT_PERCENT == type && token.text.endsWith("%")) {
                        this.emitNumber(token.text.substring(0, token.text.length() - 1), true);
                        NumberTextElement numberText = new NumberTextElement((OdfFileDom)((Object)this.getOwnerDocument()));
                        numberText.setTextContent("%");
                        this.appendChild((Node)((Object)numberText));
                        break;
                    }
                    if (NumberFormatType.FORMAT_CURRENCY == type) {
                        this.emitNumber(token.text, true);
                        break;
                    }
                    this.emitNumber(token.text, false);
                }
            }
        }
    }

    protected void emitCurrency(String currencyToken) {
        String innerText = currencyToken.substring(1, currencyToken.length() - 1);
        String currencySymbol = "";
        String languageCode = "";
        if (innerText.startsWith("$") && innerText.length() > 1) {
            int dashPos = innerText.indexOf("-");
            currencySymbol = innerText.substring(1, dashPos);
            if (dashPos > 0) {
                languageCode = innerText.substring(dashPos + 1);
            }
        }
        if (!currencySymbol.isEmpty()) {
            OdfFileDom dom = (OdfFileDom)((Object)this.getOwnerDocument());
            NumberCurrencySymbolElement cSymbol = new NumberCurrencySymbolElement(dom);
            String locale = MapHelper.getLocaleFromLangCode(languageCode);
            if (!locale.isEmpty()) {
                int dashPos = locale.indexOf("-");
                cSymbol.setAttributeNS(OdfDocumentNamespace.NUMBER.getUri(), "number:language", locale.substring(0, dashPos));
                if (dashPos > 0) {
                    cSymbol.setAttributeNS(OdfDocumentNamespace.NUMBER.getUri(), "number:country", locale.substring(dashPos + 1));
                }
            }
            cSymbol.setTextContent(currencySymbol);
            this.appendChild((Node)((Object)cSymbol));
        }
    }

    protected void emitColor(String colorToken) {
        String color = DataStyleElement.getColorElement(colorToken.substring(1, colorToken.length() - 1));
        if (!color.isEmpty()) {
            OdfFileDom dom = (OdfFileDom)((Object)this.getOwnerDocument());
            StyleTextPropertiesElement cProperties = new StyleTextPropertiesElement(dom);
            cProperties.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:color", color);
            this.appendChild((Node)((Object)cProperties));
        }
    }

    protected void emitNumber(String numberToken, boolean forceCreateDecimalPlaces) {
        char ch;
        int pos;
        OdfFileDom dom = (OdfFileDom)((Object)this.getOwnerDocument());
        NumberNumberElement number = new NumberNumberElement(dom);
        int nDigits = 0;
        for (pos = 0; pos < numberToken.length() && (ch = numberToken.charAt(pos)) != '.'; ++pos) {
            if (ch == ',') {
                number.setNumberGroupingAttribute(true);
                continue;
            }
            if (ch != '0') continue;
            ++nDigits;
        }
        number.setNumberMinIntegerDigitsAttribute(nDigits);
        if (pos < numberToken.length()) {
            number.setNumberDecimalPlacesAttribute(numberToken.length() - (pos + 1));
            if (pos < numberToken.length() - 1 && numberToken.charAt(pos + 1) != '0') {
                number.setNumberDecimalReplacementAttribute(numberToken.substring(pos + 1));
            }
        } else if (forceCreateDecimalPlaces) {
            number.setNumberDecimalPlacesAttribute(0);
        }
        this.appendChild((Node)((Object)number));
    }

    protected void emitText(String textBuffer) {
        if (!textBuffer.equals("")) {
            NumberTextElement textElement = new NumberTextElement((OdfFileDom)((Object)this.getOwnerDocument()));
            textElement.setTextContent(textBuffer);
            this.appendChild((Node)((Object)textElement));
        }
    }

    public String getNumberFormat() {
        int i;
        Object result = "";
        NumberNumberElement number = OdfElement.findFirstChildNode(NumberNumberElement.class, (Node)((Object)this));
        boolean isGroup = number.getNumberGroupingAttribute();
        int decimalPos = number.getNumberDecimalPlacesAttribute() == null ? 0 : number.getNumberDecimalPlacesAttribute();
        int minInt = number.getNumberMinIntegerDigitsAttribute() == null ? 0 : number.getNumberMinIntegerDigitsAttribute();
        String decimalReplacement = number.getNumberDecimalReplacementAttribute();
        if (minInt == 0) {
            result = "#";
        }
        for (i = 0; i < minInt; ++i) {
            result = (i + 1) % 3 == 0 && isGroup ? ",0" + (String)result : "0" + (String)result;
        }
        while (isGroup && ((String)result).indexOf(44) == -1) {
            result = (i + 1) % 3 == 0 && isGroup ? "#,#" + (String)result : "#" + (String)result;
            ++i;
        }
        if (decimalReplacement != null) {
            result = (String)result + "." + decimalReplacement;
        } else if (decimalPos > 0) {
            result = (String)result + ".";
            for (i = 0; i < decimalPos; ++i) {
                result = (String)result + "0";
            }
        }
        return result;
    }

    public abstract String getFormat(boolean var1);

    public String getFormat() {
        return this.getFormat(Boolean.FALSE);
    }

    public abstract void setFormat(String var1);

    public static class StringToken {
        public TokenType type;
        public String text;

        StringToken(String tx, TokenType t) {
            this.text = tx;
            this.type = t;
        }
    }

    public static enum NumberFormatType {
        FORMAT_CURRENCY,
        FORMAT_TEXT,
        FORMAT_PERCENT,
        FORMAT_DATE,
        FORMAT_TIME,
        FORMAT_NUMBER;

    }

    public static enum TokenType {
        TOKEN_TEXT,
        TOKEN_NUMBER,
        TOKEN_COLOR,
        TOKEN_CURRENCY;

    }
}

