/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDisplayNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextConsecutiveNumberingAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element text:list-style}. */
public class TextListStyleElement extends OdfStyleBase {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.TEXT, "list-style");

  /**
   * Create the instance of <code>TextListStyleElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public TextListStyleElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element text:list-style}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleDisplayNameAttribute
   * </code> , See {@odf.attribute style:display-name}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleDisplayNameAttribute() {
    StyleDisplayNameAttribute attr =
        (StyleDisplayNameAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "display-name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleDisplayNameAttribute</code> , See
   * {@odf.attribute style:display-name}
   *
   * @param styleDisplayNameValue The type is <code>String</code>
   */
  public void setStyleDisplayNameAttribute(String styleDisplayNameValue) {
    StyleDisplayNameAttribute attr = new StyleDisplayNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleDisplayNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleNameAttribute</code> , See
   * {@odf.attribute style:name}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleNameAttribute() {
    StyleNameAttribute attr =
        (StyleNameAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleNameAttribute</code> , See
   * {@odf.attribute style:name}
   *
   * @param styleNameValue The type is <code>String</code>
   */
  public void setStyleNameAttribute(String styleNameValue) {
    StyleNameAttribute attr = new StyleNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * TextConsecutiveNumberingAttribute</code> , See {@odf.attribute text:consecutive-numbering}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getTextConsecutiveNumberingAttribute() {
    TextConsecutiveNumberingAttribute attr =
        (TextConsecutiveNumberingAttribute)
            getOdfAttribute(OdfDocumentNamespace.TEXT, "consecutive-numbering");
    if (attr != null) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(TextConsecutiveNumberingAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextConsecutiveNumberingAttribute
   * </code> , See {@odf.attribute text:consecutive-numbering}
   *
   * @param textConsecutiveNumberingValue The type is <code>Boolean</code>
   */
  public void setTextConsecutiveNumberingAttribute(Boolean textConsecutiveNumberingValue) {
    TextConsecutiveNumberingAttribute attr =
        new TextConsecutiveNumberingAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(textConsecutiveNumberingValue.booleanValue());
  }

  /**
   * Create child element {@odf.element text:list-level-style-bullet}.
   *
   * @param textBulletCharValue the <code>String</code> value of <code>TextBulletCharAttribute
   *     </code>, see {@odf.attribute text:bullet-char} at specification
   * @param textLevelValue the <code>Integer</code> value of <code>TextLevelAttribute</code>, see
   *     {@odf.attribute text:level} at specification
   * @return the element {@odf.element text:list-level-style-bullet}
   */
  public TextListLevelStyleBulletElement newTextListLevelStyleBulletElement(
      String textBulletCharValue, int textLevelValue) {
    TextListLevelStyleBulletElement textListLevelStyleBullet =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextListLevelStyleBulletElement.class);
    textListLevelStyleBullet.setTextBulletCharAttribute(textBulletCharValue);
    textListLevelStyleBullet.setTextLevelAttribute(textLevelValue);
    this.appendChild(textListLevelStyleBullet);
    return textListLevelStyleBullet;
  }

  /**
   * Create child element {@odf.element text:list-level-style-image}.
   *
   * @param textLevelValue the <code>Integer</code> value of <code>TextLevelAttribute</code>, see
   *     {@odf.attribute text:level} at specification
   * @return the element {@odf.element text:list-level-style-image}
   */
  public TextListLevelStyleImageElement newTextListLevelStyleImageElement(int textLevelValue) {
    TextListLevelStyleImageElement textListLevelStyleImage =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextListLevelStyleImageElement.class);
    textListLevelStyleImage.setTextLevelAttribute(textLevelValue);
    this.appendChild(textListLevelStyleImage);
    return textListLevelStyleImage;
  }

  /**
   * Create child element {@odf.element text:list-level-style-number}.
   *
   * @param styleNumFormatValue the <code>String</code> value of <code>StyleNumFormatAttribute
   *     </code>, see {@odf.attribute style:num-format} at specification
   * @param textLevelValue the <code>Integer</code> value of <code>TextLevelAttribute</code>, see
   *     {@odf.attribute text:level} at specification
   * @return the element {@odf.element text:list-level-style-number}
   */
  public TextListLevelStyleNumberElement newTextListLevelStyleNumberElement(
      String styleNumFormatValue, int textLevelValue) {
    TextListLevelStyleNumberElement textListLevelStyleNumber =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextListLevelStyleNumberElement.class);
    textListLevelStyleNumber.setStyleNumFormatAttribute(styleNumFormatValue);
    textListLevelStyleNumber.setTextLevelAttribute(textLevelValue);
    this.appendChild(textListLevelStyleNumber);
    return textListLevelStyleNumber;
  }

  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
