/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces.config;

import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.Retrieval;
import org.ocpsoft.rewrite.bind.Submission;
import org.ocpsoft.rewrite.config.Invoke;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Flow;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.faces.config.PhaseOperation;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.event.ServletRewrite;
import org.ocpsoft.rewrite.servlet.event.SubflowTask;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.spi.InvocationResultHandler;

public abstract class PhaseAction
extends PhaseOperation<PhaseAction> {
    private static final Logger log = Logger.getLogger(Invoke.class);
    private final Submission submission;
    private final Retrieval retrieval;

    public static PhaseAction retrieveFrom(final Retrieval retrieval) {
        return (PhaseAction)((Object)new PhaseAction(null, retrieval){

            public String toString() {
                return "PhaseAction.retrieveFrom(" + retrieval + ")";
            }
        }.after(PhaseId.RESTORE_VIEW));
    }

    public static PhaseAction submitTo(final Submission to, final Retrieval from) {
        return (PhaseAction)((Object)new PhaseAction(to, from){

            public String toString() {
                return "PhaseAction.submitTo(" + to + ", " + from + ")";
            }
        }.after(PhaseId.RESTORE_VIEW));
    }

    public int priority() {
        return 0;
    }

    private PhaseAction(Submission submission, Retrieval retrieval) {
        this.submission = submission;
        this.retrieval = retrieval;
    }

    @Override
    public void performOperation(HttpServletRewrite event, EvaluationContext context) {
        SubflowTask.perform((ServletRewrite)event, (EvaluationContext)context, (Flow)BaseRewrite.ServletRewriteFlow.UN_HANDLED, (SubflowTask)new SubflowTask(){

            public void performInSubflow(ServletRewrite<?, ?> event, EvaluationContext context) {
                Object result = null;
                if (PhaseAction.this.retrieval != null) {
                    result = PhaseAction.this.retrieval.retrieve(event, context);
                    log.debug("Invoked binding [" + PhaseAction.this.submission + "] returned value [" + result + "]");
                }
                if (PhaseAction.this.submission != null) {
                    result = PhaseAction.this.submission.submit(event, context, result);
                    log.debug("Invoked binding [" + PhaseAction.this.retrieval + "] returned value [" + result + "]");
                }
                if (PhaseAction.this.retrieval == null && PhaseAction.this.submission == null) {
                    log.warn("No binding specified for Invocation.");
                }
                if (result instanceof Operation) {
                    ((Operation)result).perform(event, context);
                } else if (result != null) {
                    ServiceLoader providers = ServiceLoader.load(InvocationResultHandler.class);
                    if (!providers.iterator().hasNext()) {
                        log.debug("No instances of [" + InvocationResultHandler.class.getName() + "] were registered to handing binding invocation result [" + result + "]");
                    }
                    for (InvocationResultHandler handler : providers) {
                        handler.handle(event, context, result);
                    }
                }
                if (result != null) {
                    try {
                        if (event.getFlow().is((Flow)BaseRewrite.ServletRewriteFlow.ABORT_REQUEST)) {
                            FacesContext facesContext = FacesContext.getCurrentInstance();
                            if (event.getFlow().is((Flow)BaseRewrite.ServletRewriteFlow.FORWARD)) {
                                String dispatchResource = ((HttpInboundServletRewrite)event).getDispatchResource();
                                facesContext.getExternalContext().dispatch(dispatchResource);
                            }
                            facesContext.responseComplete();
                        } else if (event.getFlow().is((Flow)BaseRewrite.ServletRewriteFlow.INCLUDE)) {
                            throw new IllegalStateException("Cannot issue INCLUDE directive within JSF lifecycle. Not supported.");
                        }
                    }
                    catch (Exception e) {
                        throw new RewriteException("", (Throwable)e);
                    }
                }
            }
        });
    }
}

