/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces;

import jakarta.faces.application.NavigationHandler;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Flow;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.faces.NavigatingInvocationResultHandler;
import org.ocpsoft.rewrite.faces.config.PhaseAction;
import org.ocpsoft.rewrite.faces.config.PhaseOperation;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.event.ServletRewrite;
import org.ocpsoft.rewrite.servlet.event.SubflowTask;
import org.ocpsoft.rewrite.servlet.http.HttpRewriteLifecycleContext;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.spi.RewriteResultHandler;

public class RewritePhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 6706075446314218089L;
    private static Logger log = Logger.getLogger(RewritePhaseListener.class);

    public RewritePhaseListener() {
        log.info(RewritePhaseListener.class.getSimpleName() + " starting up.");
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        if (!PhaseId.RESTORE_VIEW.equals(event.getPhaseId())) {
            this.handleBeforePhaseOperations(event);
        }
        if (PhaseId.RENDER_RESPONSE.equals(event.getPhaseId())) {
            this.handleNavigation(event);
        }
    }

    public void afterPhase(PhaseEvent event) {
        if (!PhaseId.RENDER_RESPONSE.equals(event.getPhaseId())) {
            this.handleAfterPhaseOperations(event);
            this.handleNavigation(event);
        }
    }

    private void handleBeforePhaseOperations(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        ArrayList<PhaseOperation.DeferredOperation> operations = PhaseOperation.getSortedPhaseOperations(request);
        if (operations != null) {
            for (PhaseOperation.DeferredOperation deferredOperation : operations) {
                PhaseOperation<?> operation = deferredOperation.getOperation();
                if (!operation.getBeforePhases().contains(event.getPhaseId()) && !operation.getBeforePhases().contains(PhaseId.ANY_PHASE)) continue;
                Flow flow = this.handlePhaseOperation(deferredOperation);
                if (flow.is((Flow)BaseRewrite.ServletRewriteFlow.ABORT_REQUEST)) {
                    event.getFacesContext().responseComplete();
                }
                if (!flow.is((Flow)BaseRewrite.ServletRewriteFlow.HANDLED)) continue;
                break;
            }
        }
    }

    private void handleAfterPhaseOperations(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        ArrayList<PhaseOperation.DeferredOperation> operations = PhaseOperation.getSortedPhaseOperations(request);
        if (operations != null) {
            for (PhaseOperation.DeferredOperation deferredOperation : operations) {
                PhaseOperation<?> operation = deferredOperation.getOperation();
                if (!operation.getAfterPhases().contains(event.getPhaseId()) && !operation.getAfterPhases().contains(PhaseId.ANY_PHASE)) continue;
                Flow flow = this.handlePhaseOperation(deferredOperation);
                if (flow.is((Flow)BaseRewrite.ServletRewriteFlow.ABORT_REQUEST)) {
                    event.getFacesContext().responseComplete();
                }
                if (!flow.is((Flow)BaseRewrite.ServletRewriteFlow.HANDLED)) continue;
                break;
            }
        }
    }

    private Flow handlePhaseOperation(final PhaseOperation.DeferredOperation operation) {
        Flow flow = SubflowTask.perform((ServletRewrite)operation.getEvent(), (EvaluationContext)operation.getContext(), (Flow)BaseRewrite.ServletRewriteFlow.UN_HANDLED, (SubflowTask)new SubflowTask(){

            public void performInSubflow(ServletRewrite<?, ?> rewriteEvent, EvaluationContext context) {
                try {
                    operation.getOperation().performOperation((HttpServletRewrite)rewriteEvent, context);
                    List resultHandlers = ((HttpRewriteLifecycleContext)((HttpServletRequest)((HttpServletRewrite)rewriteEvent).getRequest()).getAttribute("_com.ocpsoft.rewrite.RequestContext")).getResultHandlers();
                    int handlerCount = resultHandlers.size();
                    for (int i = 0; i < handlerCount; ++i) {
                        RewriteResultHandler handler = (RewriteResultHandler)resultHandlers.get(i);
                        if (!handler.handles((Object)operation.getEvent())) continue;
                        handler.handleResult((Rewrite)operation.getEvent());
                    }
                }
                catch (Exception e) {
                    throw new RewriteException("Failed to handle PhaseOperation [" + operation + "]", (Throwable)e);
                }
            }
        });
        return flow;
    }

    public void handleNavigation(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        String navigationCase = (String)request.getAttribute(NavigatingInvocationResultHandler.QUEUED_NAVIGATION);
        if (navigationCase != null) {
            request.setAttribute(NavigatingInvocationResultHandler.QUEUED_NAVIGATION, null);
            NavigationHandler navigationHandler = facesContext.getApplication().getNavigationHandler();
            log.debug("Passing queued " + PhaseAction.class.getName() + " result [" + navigationCase + "] to NavigationHandler.handleNavigation()");
            navigationHandler.handleNavigation(facesContext, "", navigationCase);
        }
    }
}

