/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.jsf;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.ocpsoft.prettytime.PrettyTime;

public class PrettyTimeConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 7690470362440868260L;
    private static final int MAX_CACHE_SIZE = 20;
    private static final Map<Locale, PrettyTime> PRETTY_TIME_LOCALE_MAP = new LinkedHashMap<Locale, PrettyTime>(21, 1.1f, true){
        private static final long serialVersionUID = 5093634937930600141L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Locale, PrettyTime> eldest) {
            return this.size() > 20;
        }
    };

    public Object getAsObject(FacesContext context, UIComponent comp, String value) {
        throw new ConverterException("Does not yet support converting String to Date");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAsString(FacesContext context, UIComponent comp, Object value) {
        if (value instanceof Date) {
            PrettyTime prettyTime;
            Locale locale = context.getViewRoot().getLocale();
            Map<Locale, PrettyTime> map = PRETTY_TIME_LOCALE_MAP;
            synchronized (map) {
                prettyTime = PRETTY_TIME_LOCALE_MAP.get(locale);
                if (prettyTime == null) {
                    prettyTime = new PrettyTime(locale);
                    PRETTY_TIME_LOCALE_MAP.put(locale, prettyTime);
                }
            }
            return prettyTime.format((Date)value);
        }
        throw new ConverterException("May only be used to convert java.util.Date objects. Got: " + (value != null ? value.getClass() : "null"));
    }
}

