/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.Utils;

public class PathAnalyzer {
    private static boolean caseSensitive = true;
    private static final Map<String, PathAnalyzer> cached = new LinkedHashMap<String, PathAnalyzer>();
    private Pattern pattern;
    private Pattern patternNoStart;

    public static void setCaseSensitive(boolean caseSensitive) {
        PathAnalyzer.caseSensitive = caseSensitive;
    }

    public static PathAnalyzer get(String expr) {
        PathAnalyzer pa = cached.get(expr);
        if (pa == null) {
            Utils.locker().lock();
            try {
                pa = cached.get(expr);
                if (pa == null) {
                    pa = new PathAnalyzer(expr);
                    cached.put(expr, pa);
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
        return pa;
    }

    private PathAnalyzer(String expr) {
        if (caseSensitive) {
            this.pattern = Pattern.compile(PathAnalyzer.exprCompile(expr, true));
            if (expr.contains("{")) {
                this.patternNoStart = Pattern.compile(PathAnalyzer.exprCompile(expr, false));
            }
        } else {
            this.pattern = Pattern.compile(PathAnalyzer.exprCompile(expr, true), 2);
            if (expr.contains("{")) {
                this.patternNoStart = Pattern.compile(PathAnalyzer.exprCompile(expr, false), 2);
            }
        }
    }

    public Matcher matcher(String uri) {
        if (this.patternNoStart != null) {
            return this.patternNoStart.matcher(uri);
        }
        return this.pattern.matcher(uri);
    }

    public boolean matches(String uri) {
        return this.pattern.matcher(uri).find();
    }

    private static String exprCompile(String expr, boolean fixedStart) {
        String p = expr;
        p = p.replace(".", "\\.");
        p = p.replace("$", "\\$");
        p = p.replace("**", ".[]");
        if ((p = p.replace("*", "[^/]*")).indexOf("{") >= 0) {
            if (p.indexOf("_}") > 0) {
                p = p.replaceAll("\\{[^\\}]+?\\_\\}", "(.+)");
            }
            p = p.replaceAll("\\{[^\\}]+?\\}", "([^/]+)");
        }
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        p = p.replace(".[]", ".*");
        if (fixedStart) {
            return "^" + p + "$";
        }
        return p + "$";
    }
}

