/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.DownloadedFile;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.LogUtil;

public class RangeUtil {
    private static RangeUtil global = new RangeUtil();

    public static RangeUtil global() {
        return global;
    }

    public static void globalSet(RangeUtil instance) {
        if (instance != null) {
            global = instance;
        }
    }

    public void outputFile(Context ctx, DownloadedFile file, boolean asAttachment) throws IOException {
        if (Utils.isNotEmpty(file.getName())) {
            String fileName = URLEncoder.encode(file.getName(), Solon.encoding());
            if (asAttachment) {
                ctx.headerSet("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            } else {
                ctx.headerSet("Content-Disposition", "filename=\"" + fileName + "\"");
            }
        }
        if (Utils.isNotEmpty(file.getContentType())) {
            ctx.contentType(file.getContentType());
        }
        try (InputStream ins = file.getContent();){
            RangeUtil.global().outputStream(ctx, ins, file.getContentSize());
        }
    }

    public void outputFile(Context ctx, File file, boolean asAttachment) throws IOException {
        String contentType;
        if (Utils.isNotEmpty(file.getName())) {
            String fileName = URLEncoder.encode(file.getName(), Solon.encoding());
            if (asAttachment) {
                ctx.headerSet("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            } else {
                ctx.headerSet("Content-Disposition", "filename=\"" + fileName + "\"");
            }
        }
        if (Utils.isNotEmpty(contentType = Utils.mime(file.getName()))) {
            ctx.contentType(contentType);
        }
        try (FileInputStream ins = new FileInputStream(file);){
            RangeUtil.global().outputStream(ctx, ins, file.length());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void outputStream(Context ctx, InputStream stream, long streamSize) throws IOException {
        if (streamSize <= 0L) {
            ctx.status(200);
            ctx.output(stream);
            return;
        }
        ctx.headerSet("Accept-Ranges", "bytes");
        if ("HEAD".equals(ctx.method())) {
            ctx.contentLength(streamSize);
            ctx.status(200);
            return;
        }
        String range = ctx.header("Range");
        long start = 0L;
        long end = 0L;
        long size = 0L;
        if (Utils.isEmpty(range)) {
            ctx.contentLength(streamSize);
            ctx.status(200);
            ctx.output(stream);
            return;
        }
        String[] ss1 = range.split("=");
        if (ss1.length != 2) {
            ctx.status(416);
            return;
        }
        String unit = ss1[0];
        String[] ss2 = ss1[1].split("-");
        if (!"bytes".equals(unit)) {
            ctx.status(416);
            return;
        }
        if (ss2.length == 2) {
            start = this.getLong(ss2[0]);
            end = this.getLong(ss2[1]);
        } else {
            if (ss2.length != 1) {
                ctx.status(416);
                return;
            }
            start = this.getLong(ss2[0]);
            end = streamSize - 1L;
        }
        if (end > 0L) {
            size = end - start + 1L;
        } else {
            end = streamSize - 1L;
            size = end - start + 1L;
        }
        if (end < 1L || size < 0L) {
            ctx.status(416);
            return;
        }
        if (size > streamSize - start) {
            ctx.status(416);
            return;
        }
        ctx.contentLength(size);
        ctx.status(206);
        ctx.headerSet("Connection", "keep-alive");
        ctx.headerSet("Content-Range", "bytes " + start + "-" + end + "/" + streamSize);
        try {
            IoUtil.transferTo(stream, ctx.outputStream(), start, size);
            return;
        }
        catch (IOException e) {
            LogUtil.global().warn("The http range output is abnormal: " + e.getMessage());
        }
    }

    protected long getLong(String str) {
        if (Utils.isEmpty(str)) {
            return 0L;
        }
        return Long.parseLong(str);
    }
}

