/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.convert;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.core.util.GenericUtil;

public class ConverterManager {
    Map<Type, Map<Type, Converter>> converters = new HashMap<Type, Map<Type, Converter>>();

    public <S, T> void register(Converter<S, T> converter) {
        Map<Type, Converter> tmp;
        Map<String, Type> genericInfo = GenericUtil.getGenericInfo(converter.getClass());
        Object sourceType = null;
        Object tagertType = null;
        if (genericInfo != null) {
            sourceType = genericInfo.get("S");
            tagertType = genericInfo.get("T");
        }
        if (sourceType == null) {
            sourceType = Object.class;
        }
        if (tagertType == null) {
            tagertType = Object.class;
        }
        if ((tmp = this.converters.get(sourceType)) == null) {
            tmp = new HashMap<Type, Converter>();
            this.converters.put((Type)sourceType, tmp);
        }
        tmp.put((Type)tagertType, converter);
    }

    public <S, T> Converter<S, T> find(Class<S> sourceType, Class<T> tagertType) {
        Map<Type, Converter> tmp = this.converters.get(sourceType);
        if (tmp == null) {
            return null;
        }
        return tmp.get(tagertType);
    }
}

