/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.VarHolder;

public class VarHolderOfParam
implements VarHolder {
    private final Parameter p;
    private final ParameterizedType genericType;
    private final AopContext ctx;
    protected Object val;
    protected boolean done;
    protected Runnable onDone;

    public VarHolderOfParam(AopContext ctx, Parameter p, Runnable onDone) {
        this.ctx = ctx;
        this.p = p;
        this.onDone = onDone;
        Type tmp = p.getParameterizedType();
        this.genericType = tmp instanceof ParameterizedType ? (ParameterizedType)tmp : null;
    }

    @Override
    public AopContext context() {
        return this.ctx;
    }

    @Override
    public ParameterizedType getGenericType() {
        return this.genericType;
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public Class<?> getType() {
        return this.p.getType();
    }

    @Override
    public Annotation[] getAnnoS() {
        return this.p.getAnnotations();
    }

    @Override
    public String getFullName() {
        Executable e = this.p.getDeclaringExecutable();
        return e.getDeclaringClass().getName() + "::" + e.getName();
    }

    @Override
    public void setValue(Object val) {
        this.val = val;
        this.done = true;
        if (this.onDone != null) {
            this.onDone.run();
        }
    }

    @Override
    public Object getValue() {
        return this.val;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }
}

